/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metric;

import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.cache.CacheException;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCancelledException;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.metric.SqlStatisticsAbstractTest;
import org.apache.ignite.internal.metric.UserQueriesTestBase;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.transactions.TransactionDuplicateKeyException;
import org.junit.Test;

public class SqlStatisticsUserQueriesFastTest
extends UserQueriesTestBase {
    private static final String CSV_FILE_SUBDIR = "/modules/indexing/src/test/resources/";
    private static final String COPY_CMD_BAD_FORMATED_FILE = Objects.requireNonNull(IgniteUtils.resolveIgnitePath((String)"/modules/indexing/src/test/resources/bulkload_bad.csv")).getAbsolutePath();
    private static final String COPY_CMD_OK_FORMATED_FILE = Objects.requireNonNull(IgniteUtils.resolveIgnitePath((String)"/modules/indexing/src/test/resources/bulkload_ok.csv")).getAbsolutePath();
    private static IgniteCache cache;

    protected void beforeTestsStarted() throws Exception {
        this.startGrids(2);
        cache = this.createCacheFrom((Ignite)this.grid(0));
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        SqlStatisticsAbstractTest.SuspendQuerySqlFunctions.refresh();
    }

    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
    }

    @Test
    public void testSanitySelectSuccess() {
        this.assertMetricsIncrementedOnlyOnReducer(() -> cache.query(new SqlFieldsQuery("SELECT * FROM TAB")).getAll(), "success");
        this.assertMetricsIncrementedOnlyOnReducer(() -> cache.query(new SqlFieldsQuery("SELECT * FROM TAB WHERE ID = (SELECT AVG(ID) FROM TAB WHERE ID < 20)")).getAll(), "success");
    }

    @Test
    public void testDdlSuccess() {
        this.assertMetricsIncrementedOnlyOnReducer(() -> cache.query(new SqlFieldsQuery("CREATE INDEX myidx ON TAB(ID)")).getAll(), "success");
        this.assertMetricsIncrementedOnlyOnReducer(() -> {
            CacheException cfr_ignored_0 = (CacheException)GridTestUtils.assertThrows((IgniteLogger)log, () -> cache.query(new SqlFieldsQuery("CREATE INDEX myidx ON TAB(ID)")).getAll(), CacheException.class, (String)"Index already exists");
        }, "failed");
        this.assertMetricsIncrementedOnlyOnReducer(() -> cache.query(new SqlFieldsQuery("DROP INDEX myidx")).getAll(), "success");
        this.assertMetricsIncrementedOnlyOnReducer(() -> cache.query(new SqlFieldsQuery("CREATE TABLE ANOTHER_TAB (ID INT PRIMARY KEY, VAL VARCHAR)").setSchema("PUBLIC")).getAll(), "success");
        this.assertMetricsIncrementedOnlyOnReducer(() -> {
            CacheException cfr_ignored_0 = (CacheException)GridTestUtils.assertThrows((IgniteLogger)log, () -> cache.query(new SqlFieldsQuery("CREATE TABLE ANOTHER_TAB (ID INT PRIMARY KEY, VAL VARCHAR)").setSchema("PUBLIC")).getAll(), CacheException.class, (String)"Table already exists");
        }, "failed");
    }

    @Test
    public void testDmlSuccess() {
        this.assertMetricsIncrementedOnlyOnReducer(() -> cache.query(new SqlFieldsQuery("DELETE FROM TAB WHERE ID = 5")).getAll(), "success");
        this.assertMetricsIncrementedOnlyOnReducer(() -> cache.query(new SqlFieldsQuery("DELETE FROM TAB WHERE ID < (SELECT AVG(ID) FROM TAB WHERE ID < 20)")).getAll(), "success");
        this.assertMetricsIncrementedOnlyOnReducer(() -> cache.query(new SqlFieldsQuery("INSERT INTO TAB VALUES(5, 'Name')")).getAll(), "success");
        this.assertMetricsIncrementedOnlyOnReducer(() -> cache.query(new SqlFieldsQuery("MERGE INTO TAB(ID, NAME) VALUES(5, 'NewerName')")).getAll(), "success");
        this.assertMetricsIncrementedOnlyOnReducer(() -> GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, () -> cache.query(new SqlFieldsQuery("INSERT INTO TAB VALUES(5, 'I will NOT be inserted')")).getAll(), TransactionDuplicateKeyException.class, (String)"Duplicate key during INSERT"), "failed");
    }

    @Test
    public void testStreaming() {
        Integer okId = 42;
        Integer badId = null;
        cache.query(new SqlFieldsQuery("DELETE FROM TAB WHERE ID = ?").setArgs(new Object[]{okId})).getAll();
        this.assertMetricsIncrementedOnlyOnReducer(() -> this.insertWithStreaming(okId, "Succesfully inserted name"), "success", "success");
        this.assertMetricsIncrementedOnlyOnReducer(() -> GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, () -> this.insertWithStreaming(badId, "I will NOT be inserted"), BatchUpdateException.class, (String)"Null value is not allowed for column"), "success", "failed");
    }

    /*
     * Exception decompiling
     */
    private int insertWithStreaming(Integer id, String name) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Test
    public void testCopyComand() {
        cache.query(new SqlFieldsQuery("DELETE FROM TAB WHERE ID = 1 or ID = 2 ")).getAll();
        this.assertMetricsIncrementedOnlyOnReducer(() -> this.doCopyCommand(COPY_CMD_OK_FORMATED_FILE), "success");
        this.assertMetricsIncrementedOnlyOnReducer(() -> GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, () -> this.doCopyCommand(COPY_CMD_BAD_FORMATED_FILE), SQLException.class, (String)"Value conversion failed"), "failed");
    }

    /*
     * Exception decompiling
     */
    private int doCopyCommand(String pathToCsv) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Test
    public void testSanityDeprecatedSqlQueryMetrics() throws Exception {
        this.assertMetricsIncrementedOnlyOnReducer(() -> cache.query((Query)new SqlQuery(String.class, "ID < 5").setLocal(false)).getAll(), "success");
        this.assertMetricsIncrementedOnlyOnReducer(() -> cache.query((Query)new SqlQuery(String.class, "ID < 5").setLocal(true)).getAll(), "success");
    }

    @Test
    public void testUnparseableQueriesAreNotCounted() throws Exception {
        this.assertMetricsRemainTheSame(() -> GridTestUtils.assertThrows((IgniteLogger)log, () -> cache.query(new SqlFieldsQuery("THIS IS NOT A SQL STATEMENT")).getAll(), CacheException.class, (String)"Failed to parse query"));
    }

    @Test
    public void testLocalSelectSuccess() {
        this.assertMetricsIncrementedOnlyOnReducer(() -> cache.query(new SqlFieldsQuery("SELECT * FROM TAB WHERE ID < 100").setLocal(true)).getAll(), "success");
    }

    @Test
    public void testLocalSelectFailed() {
        this.assertMetricsIncrementedOnlyOnReducer(() -> {
            try {
                cache.query(new SqlFieldsQuery("SELECT * FROM TAB WHERE ID = failFunction()").setLocal(true)).getAll();
                SqlStatisticsUserQueriesFastTest.fail((String)"Exception must be thrown");
            }
            catch (CacheException | IgniteSQLException throwable) {
                // empty catch block
            }
        }, "failed");
    }

    @Test
    public void testLocalLazySelectFailedOnIterator() {
        this.assertMetricsIncrementedOnlyOnReducer(() -> {
            try (FieldsQueryCursor cur = cache.query(new SqlFieldsQuery("SELECT * FROM TAB WHERE ID = failFunction()").setLocal(true).setLazy(true));){
                Iterator it = cur.iterator();
                it.next();
                SqlStatisticsUserQueriesFastTest.fail((String)"Exception must be thrown");
            }
            catch (CacheException | IgniteSQLException throwable) {
                // empty catch block
            }
        }, "failed");
    }

    @Test
    public void testLocalSelectCanceled() {
        this.assertMetricsIncrementedOnlyOnReducer(() -> this.startAndKillQuery(new SqlFieldsQuery("SELECT * FROM TAB WHERE ID <> suspendHook(ID)").setLocal(true)), "success", "failed", "canceled");
    }

    @Test
    public void testLocalLazySelectCanceledOnIterator() {
        this.assertMetricsIncrementedOnlyOnReducer(() -> {
            IgniteInternalFuture qryCanceled = this.runAsyncX(() -> GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, () -> {
                Iterator it = this.jcache(0).query(new SqlFieldsQuery("SELECT * FROM TAB WHERE ID <> suspendHook(ID)").setLocal(true).setLazy(true)).iterator();
                while (it.hasNext()) {
                    it.next();
                }
                return null;
            }, QueryCancelledException.class, null));
            try {
                SqlStatisticsAbstractTest.SuspendQuerySqlFunctions.awaitQueryStopsInTheMiddle();
                this.killAsyncAllQueriesOn(0);
                TimeUnit.SECONDS.sleep(1L);
                SqlStatisticsAbstractTest.SuspendQuerySqlFunctions.resumeQueryExecution();
                qryCanceled.get(15L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, "success", "failed", "canceled");
    }
}

