/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metric;

import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectName;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.annotations.QuerySqlFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.SqlConfiguration;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;

public class SqlStatisticsAbstractTest
extends GridCommonAbstractTest {
    public static final long WAIT_OP_TIMEOUT_SEC = 15L;
    public static final int TABLE_SIZE = 10000;
    protected static final MemValidator MEMORY_IS_USED = (freeMem, maxMem) -> {
        if (freeMem == maxMem) {
            SqlStatisticsAbstractTest.fail((String)"Expected some memory reserved.");
        }
    };
    protected static final MemValidator MEMORY_IS_FREE = (freeMem, maxMem) -> {
        if (freeMem < maxMem) {
            SqlStatisticsAbstractTest.fail((String)String.format("Expected no memory reserved: [freeMem=%d, maxMem=%d]", freeMem, maxMem));
        }
    };

    protected void startGridWithMaxMem(int nodeIdx, long maxMem) throws Exception {
        this.startGridWithMaxMem(nodeIdx, maxMem, false);
    }

    protected void startGridWithMaxMem(int nodeIdx, long maxMem, boolean client) throws Exception {
        String name = this.getTestIgniteInstanceName(nodeIdx);
        this.startGrid(name, this.getConfiguration(name).setClientMode(client).setSqlConfiguration(new SqlConfiguration().setSqlGlobalMemoryQuota(Long.toString(maxMem))));
    }

    protected IgniteCache createCacheFrom(Ignite node) {
        CacheConfiguration ccfg = new CacheConfiguration("default").setSqlFunctionClasses(new Class[]{SuspendQuerySqlFunctions.class}).setQueryEntities(Collections.singleton(new QueryEntity(Integer.class.getName(), String.class.getName()).setTableName("TAB").addQueryField("id", Integer.class.getName(), null).addQueryField("name", String.class.getName(), null).setKeyFieldName("id").setValueFieldName("name")));
        IgniteCache cache = node.createCache(ccfg);
        try (IgniteDataStreamer ds = node.dataStreamer("default");){
            for (int i = 0; i < 10000; ++i) {
                ds.addData((Object)i, (Object)UUID.randomUUID().toString());
            }
        }
        return cache;
    }

    protected IgniteInternalFuture runAsyncX(Runnable act) {
        return GridTestUtils.runAsync(() -> {
            try {
                act.run();
            }
            catch (Throwable th) {
                log.error("Failed to perform async action. Probably test is broken.", th);
            }
        });
    }

    protected long getValue(String gridName, String grp, String name, String attributeName) throws Exception {
        ObjectName mBeanName = IgniteUtils.makeMBeanName((String)gridName, (String)grp, (String)name);
        Object attributeVal = this.grid(gridName).configuration().getMBeanServer().getAttribute(mBeanName, attributeName);
        return (Long)attributeVal;
    }

    protected static interface MemValidator {
        public void validate(long var1, long var3);
    }

    public static class SuspendQuerySqlFunctions {
        private static final int DFLT_PROCESS_ROWS_TO_SUSPEND = 2500;
        public static volatile CountDownLatch qryIsInTheMiddle;
        private static volatile CountDownLatch resumeQryExec;

        public static void refresh() {
            if (qryIsInTheMiddle != null) {
                int i = 0;
                while ((long)i < qryIsInTheMiddle.getCount()) {
                    qryIsInTheMiddle.countDown();
                    ++i;
                }
            }
            if (resumeQryExec != null) {
                resumeQryExec.countDown();
            }
            qryIsInTheMiddle = new CountDownLatch(2500);
            resumeQryExec = new CountDownLatch(1);
        }

        public static void awaitQueryStopsInTheMiddle() throws InterruptedException {
            boolean reached = qryIsInTheMiddle.await(15L, TimeUnit.SECONDS);
            if (!reached) {
                throw new IllegalStateException("Unable to wait when query starts. Test is broken.");
            }
        }

        public static void resumeQueryExecution() {
            resumeQryExec.countDown();
        }

        public static void setProcessRowsToSuspend(int rows) {
            qryIsInTheMiddle = new CountDownLatch(rows);
        }

        @QuerySqlFunction
        public static long suspendHook(long ret) throws InterruptedException {
            boolean reached;
            qryIsInTheMiddle.countDown();
            if (qryIsInTheMiddle.getCount() == 0L && !(reached = resumeQryExec.await(15L, TimeUnit.SECONDS))) {
                IllegalStateException exc = new IllegalStateException("Unable to wait when to continue the query. Test is broken.");
                log.error("Test exception.", (Throwable)exc);
                throw exc;
            }
            return ret;
        }

        @QuerySqlFunction
        public static long failFunction() {
            throw new RuntimeException("Fail the query.");
        }

        @QuerySqlFunction
        public static long failFunction(long dummy) {
            throw new RuntimeException("Fail the query.");
        }

        static {
            SuspendQuerySqlFunctions.refresh();
        }
    }
}

