/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metric;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.client.Person;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.failure.FailureHandler;
import org.apache.ignite.failure.StopNodeFailureHandler;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.metric.IndexPageCounter;
import org.apache.ignite.internal.processors.cache.GridCacheProcessor;
import org.apache.ignite.internal.processors.cache.persistence.DataRegion;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class AbstractIndexPageMetricsTest
extends GridCommonAbstractTest {
    private IgniteEx grid;
    private List<IgniteCache<Integer, Person>> caches;
    IndexPageCounter indexPageCounter;
    @Parameterized.Parameter
    public int numCaches;

    @Parameterized.Parameters(name="numCaches = {0}")
    public static Object[] data() {
        return new Object[]{1, 3};
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.grid = this.startGrid();
        this.grid.cluster().state(ClusterState.ACTIVE);
        this.caches = IntStream.range(0, this.numCaches).mapToObj(i -> "cache " + i).map(this::createCache).collect(Collectors.toList());
        this.indexPageCounter = new IndexPageCounter(this.grid, this.isPersistenceEnabled());
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.grid.close();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setFailureHandler((FailureHandler)new StopNodeFailureHandler()).setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(this.isPersistenceEnabled())));
    }

    abstract boolean isPersistenceEnabled();

    abstract void validateIdxPagesCnt() throws IgniteCheckedException;

    @Test
    public void testStoreAndDeleteEntries() throws Exception {
        this.validateIdxPagesCnt();
        this.fillData(1);
        this.validateIdxPagesCnt();
        this.fillData(100);
        this.validateIdxPagesCnt();
        this.clearData();
        this.validateIdxPagesCnt();
    }

    @Test
    public void testStoreAndDeleteCacheGrp() throws Exception {
        this.fillData(100);
        this.validateIdxPagesCnt();
        this.caches.get(0).destroy();
        this.validateIdxPagesCnt();
    }

    @Test
    public void testStoreAndRemoveSomeEntries() throws Exception {
        this.fillData(100);
        this.validateIdxPagesCnt();
        IntStream.range(0, 50).map(i -> (int)(Math.random() * 100.0)).forEach(arg_0 -> this.caches.get(0).remove(arg_0));
        this.validateIdxPagesCnt();
    }

    GridCacheProcessor gridCacheProcessor() {
        return this.grid.context().cache();
    }

    DataRegion defaultDataRegion() throws IgniteCheckedException {
        return Objects.requireNonNull(this.gridCacheProcessor().context().database().dataRegion(null));
    }

    private IgniteCache<Integer, Person> createCache(String cacheName) {
        CacheConfiguration cacheConfiguration = new CacheConfiguration(cacheName).setIndexedTypes(new Class[]{Integer.class, Person.class});
        return this.grid.createCache(cacheConfiguration);
    }

    private void fillData(int numEntries) {
        IntStream.range(0, numEntries).mapToObj(i -> new Person(Integer.valueOf(i), "foobar")).forEach(person -> this.caches.forEach(cache -> cache.put((Object)person.getId(), person)));
    }

    private void clearData() {
        this.caches.forEach(IgniteCache::clear);
    }
}

