/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.events;

import java.io.Serializable;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.events.QueryExecutionFinishedEvent;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class QueryExecutionFinishedEventTest
extends GridCommonAbstractTest {
    private static final int NODES_CNT = 2;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setIncludeEventTypes(new int[]{166});
    }

    protected void beforeTestsStarted() throws Exception {
        this.startGrids(2);
    }

    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
    }

    @Test
    public void testQueryFinishEvents() throws IgniteInterruptedCheckedException {
        IgniteEx ignite = this.grid(0);
        String sql = "select 1";
        AtomicInteger eventTriggered = new AtomicInteger();
        ignite.events().localListen((IgnitePredicate & Serializable)event -> {
            QueryExecutionFinishedEventTest.assertTrue((boolean)(event instanceof QueryExecutionFinishedEvent));
            QueryExecutionFinishedEvent event0 = (QueryExecutionFinishedEvent)event;
            event0.status().query().toUpperCase(Locale.ROOT).equals(sql.toUpperCase(Locale.ROOT));
            eventTriggered.incrementAndGet();
            return true;
        }, new int[]{166});
        ignite.events(ignite.cluster().forRemotes()).remoteListen((IgniteBiPredicate & Serializable)(id, event) -> {
            QueryExecutionFinishedEventTest.assertTrue((boolean)(event instanceof QueryExecutionFinishedEvent));
            QueryExecutionFinishedEvent event0 = (QueryExecutionFinishedEvent)event;
            event0.status().query().toUpperCase(Locale.ROOT).equals(sql.toUpperCase(Locale.ROOT));
            eventTriggered.incrementAndGet();
            return true;
        }, (IgnitePredicate & Serializable)f -> true, new int[]{166});
        this.grid(0).getOrCreateCache("default").query(new SqlFieldsQuery("select 1")).getAll();
        this.grid(1).getOrCreateCache("default").query(new SqlFieldsQuery("select 1")).getAll();
        QueryExecutionFinishedEventTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> eventTriggered.get() == 2, (long)5000L));
    }
}

