/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.query;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.cache.Cache;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.Ignition;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.query.IndexQuery;
import org.apache.ignite.cache.query.IndexQueryAllTypesTest;
import org.apache.ignite.cache.query.IndexQueryCriteriaBuilder;
import org.apache.ignite.cache.query.IndexQueryCriterion;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.client.ClientCache;
import org.apache.ignite.client.ClientException;
import org.apache.ignite.client.ClientFeatureNotSupportedByServerException;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.ClientConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.TestRecordingCommunicationSpi;
import org.apache.ignite.internal.client.thin.ProtocolBitmaskFeature;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryNextPageRequest;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ThinClientIndexQueryTest
extends GridCommonAbstractTest {
    private static final int CNT = 10000;
    private static final int NULLS_CNT = -10;
    private static final int NODES = 2;
    private static final String IDX_FLD1 = "IDX_FLD1";
    private static final String IDX_FLD1_FLD2 = "IDX_FLD1_FLD2";
    private static final String IDX_FLD3 = "IDX_FLD3";
    @Parameterized.Parameter
    public boolean keepBinary;

    @Parameterized.Parameters(name="keepBinary={0}")
    public static Object[] params() {
        return new Object[]{false, true};
    }

    protected IgniteConfiguration getConfiguration(String instanceName) throws Exception {
        IgniteConfiguration ccfg = super.getConfiguration(instanceName);
        ccfg.setCommunicationSpi((CommunicationSpi)new TestRecordingCommunicationSpi());
        return ccfg;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        IgniteEx crd = this.startGrids(2);
        crd.getOrCreateCache(new CacheConfiguration().setName("CACHE").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setIndexedTypes(new Class[]{Integer.class, Person.class}));
        try (IgniteDataStreamer stream = this.grid(0).dataStreamer("CACHE");){
            int i;
            for (i = 0; i < 10000; ++i) {
                stream.addData((Object)i, (Object)new Person(i, i, new IndexQueryAllTypesTest.PojoField(i)));
            }
            for (i = -10; i < 0; ++i) {
                stream.addData((Object)i, (Object)new Person(null, null, null));
            }
        }
    }

    @Test
    public void testValidRanges() {
        Random rnd = new Random();
        int left = rnd.nextInt(5000);
        int right = 5000 + rnd.nextInt(2500) + 1;
        for (String idxName : F.asList((Object[])new String[]{IDX_FLD1, IDX_FLD1_FLD2, null})) {
            this.withClientCache(cache -> {
                this.assertClientQuery((ClientCache<Integer, Person>)cache, -10, 10000, idxName, new IndexQueryCriterion[0]);
                this.assertClientQuery((ClientCache<Integer, Person>)cache, left + 1, 10000, idxName, IndexQueryCriteriaBuilder.gt((String)"fld1", (Object)left));
                this.assertClientQuery((ClientCache<Integer, Person>)cache, left, 10000, idxName, IndexQueryCriteriaBuilder.gte((String)"fld1", (Object)left));
                this.assertClientQuery((ClientCache<Integer, Person>)cache, 0, left, idxName, IndexQueryCriteriaBuilder.lt((String)"fld1", (Object)left));
                this.assertClientQuery((ClientCache<Integer, Person>)cache, 0, left + 1, idxName, IndexQueryCriteriaBuilder.lte((String)"fld1", (Object)left));
                this.assertClientQuery((ClientCache<Integer, Person>)cache, left, left + 1, idxName, IndexQueryCriteriaBuilder.eq((String)"fld1", (Object)left));
                this.assertClientQuery((ClientCache<Integer, Person>)cache, left, right + 1, idxName, IndexQueryCriteriaBuilder.between((String)"fld1", (Object)left, (Object)right));
                this.assertClientQuery((ClientCache<Integer, Person>)cache, left, left + 1, idxName, IndexQueryCriteriaBuilder.in((String)"fld1", Collections.singleton(left)));
                this.assertClientQuery((ClientCache<Integer, Person>)cache, left, right + 1, idxName, IndexQueryCriteriaBuilder.gte((String)"fld1", (Object)left), IndexQueryCriteriaBuilder.lte((String)"fld1", (Object)right));
                this.assertClientQuery((ClientCache<Integer, Person>)cache, left + 1, right + 1, idxName, IndexQueryCriteriaBuilder.gt((String)"fld1", (Object)left), IndexQueryCriteriaBuilder.lte((String)"fld1", (Object)right));
                this.assertClientQuery((ClientCache<Integer, Person>)cache, left, right, idxName, IndexQueryCriteriaBuilder.gte((String)"fld1", (Object)left), IndexQueryCriteriaBuilder.lt((String)"fld1", (Object)right));
                this.assertClientQuery((ClientCache<Integer, Person>)cache, left + 1, right, idxName, IndexQueryCriteriaBuilder.gt((String)"fld1", (Object)left), IndexQueryCriteriaBuilder.lt((String)"fld1", (Object)right));
                this.assertClientQuery((ClientCache<Integer, Person>)cache, right, right + 1, idxName, IndexQueryCriteriaBuilder.gte((String)"fld1", (Object)left), IndexQueryCriteriaBuilder.in((String)"fld1", Collections.singleton(right)));
                this.assertClientQuery((ClientCache<Integer, Person>)cache, -10, 0, idxName, IndexQueryCriteriaBuilder.in((String)"fld1", Collections.singleton(null)));
                this.assertClientQuery((ClientCache<Integer, Person>)cache, -10, 0, idxName, IndexQueryCriteriaBuilder.eq((String)"fld1", null));
            });
        }
        for (String idxName : F.asList((Object[])new String[]{IDX_FLD1_FLD2, null})) {
            this.withClientCache(cache -> {
                this.assertClientQuery((ClientCache<Integer, Person>)cache, left + 1, right, idxName, IndexQueryCriteriaBuilder.gt((String)"fld1", (Object)left), IndexQueryCriteriaBuilder.lt((String)"fld2", (Object)right));
                this.assertClientQuery((ClientCache<Integer, Person>)cache, right, right + 1, idxName, IndexQueryCriteriaBuilder.gt((String)"fld1", (Object)left), IndexQueryCriteriaBuilder.in((String)"fld2", Collections.singleton(right)));
            });
        }
    }

    @Test
    public void testPojoIndex() {
        this.withClientCache(cache -> {
            IndexQueryAllTypesTest.PojoField pojo = new IndexQueryAllTypesTest.PojoField(100);
            for (IndexQueryCriterion[] criteria : F.asList((Object[])new IndexQueryCriterion[][]{{IndexQueryCriteriaBuilder.eq((String)"fld3", (Object)pojo)}, {IndexQueryCriteriaBuilder.in((String)"fld3", Collections.singleton(pojo))}})) {
                IndexQuery idxQry = new IndexQuery(Person.class, IDX_FLD3).setCriteria(criteria);
                List result = cache.query((Query)idxQry).getAll();
                ThinClientIndexQueryTest.assertEquals((int)1, (int)result.size());
                ThinClientIndexQueryTest.assertEquals((int)100, (int)((Integer)((Cache.Entry)result.get(0)).getKey()));
                if (this.keepBinary) {
                    ThinClientIndexQueryTest.assertEquals((Object)pojo, (Object)((BinaryObject)((Cache.Entry)result.get(0)).getValue()).field("fld3"));
                    continue;
                }
                ThinClientIndexQueryTest.assertEquals((int)100, (int)((Integer)((Cache.Entry)result.get(0)).getKey()));
            }
        });
    }

    @Test
    public void testIndexNameMismatchCriteria() {
        this.withClientCache(cache -> {
            for (IndexQueryCriterion[] criteria : F.asList((Object[])new IndexQueryCriterion[][]{{IndexQueryCriteriaBuilder.lt((String)"fld1", (Object)100), IndexQueryCriteriaBuilder.lt((String)"fld2", (Object)100)}, {IndexQueryCriteriaBuilder.lt((String)"fld2", (Object)100)}})) {
                IndexQuery idxQry = new IndexQuery(Person.class, IDX_FLD1).setCriteria(criteria);
                cache.query((Query)idxQry).getAll();
            }
        });
    }

    @Test
    public void testPageSize() {
        IndexQuery idxQry = new IndexQuery(Person.class, "_key_PK");
        this.withClientCache(cache -> {
            int pageSize;
            Iterator iterator = F.asList((Object[])new Integer[]{1, 10, 100, 1000, 10000}).iterator();
            while (iterator.hasNext()) {
                pageSize = (Integer)iterator.next();
                idxQry.setPageSize(pageSize);
                TestRecordingCommunicationSpi.spi((Ignite)this.grid(0)).record(new Class[]{GridQueryNextPageRequest.class});
                this.assertClientQuery((ClientCache<Integer, Person>)cache, -10, 10000, idxQry);
                List reqs = TestRecordingCommunicationSpi.spi((Ignite)this.grid(0)).recordedMessages(true);
                for (Object r : reqs) {
                    ThinClientIndexQueryTest.assertEquals((int)pageSize, (int)((GridQueryNextPageRequest)r).pageSize());
                }
            }
            iterator = F.asList((Object[])new Integer[]{-10, -1, 0}).iterator();
            while (iterator.hasNext()) {
                pageSize = (Integer)iterator.next();
                GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, () -> idxQry.setPageSize(pageSize), IllegalArgumentException.class, (String)"Page size must be above zero");
            }
        });
    }

    @Test
    public void testLocal() {
        this.withClientCache(cache -> {
            IndexQuery idxQry = new IndexQuery(Person.class, "_key_PK");
            idxQry.setLocal(true);
            TestRecordingCommunicationSpi.spi((Ignite)this.grid(0)).record(new Class[]{GridQueryNextPageRequest.class});
            ThinClientIndexQueryTest.assertTrue((cache.query((Query)idxQry).getAll().size() < 10000 ? 1 : 0) != 0);
            List reqs = TestRecordingCommunicationSpi.spi((Ignite)this.grid(0)).recordedMessages(true);
            ThinClientIndexQueryTest.assertTrue((boolean)reqs.isEmpty());
        });
    }

    @Test
    public void testFilter() {
        IndexQuery idxQry = new IndexQuery(Person.class, "_key_PK");
        idxQry.setFilter((IgniteBiPredicate & Serializable)(k, v) -> (Integer)k >= 0 && (Integer)k < 1000);
        this.withClientCache(cache -> this.assertClientQuery((ClientCache<Integer, Person>)cache, 0, 1000, idxQry));
    }

    @Test
    public void testPartition() {
        this.withClientCache(cache -> {
            IndexQuery idxQry = new IndexQuery(Person.class);
            for (int p = 0; p < 1024; ++p) {
                idxQry.setPartition(Integer.valueOf(p));
                for (int i = 0; i < 2; ++i) {
                    TestRecordingCommunicationSpi.spi((Ignite)this.grid(i)).record(new Class[]{GridQueryNextPageRequest.class});
                }
                List result = cache.query((Query)idxQry).getAll();
                ThinClientIndexQueryTest.assertTrue((result.size() < 10000 ? 1 : 0) != 0);
                for (Cache.Entry e : result) {
                    ThinClientIndexQueryTest.assertEquals((int)p, (int)this.grid(0).affinity("CACHE").partition(e.getKey()));
                }
                for (int i = 0; i < 2; ++i) {
                    List reqs = TestRecordingCommunicationSpi.spi((Ignite)this.grid(0)).recordedMessages(true);
                    ThinClientIndexQueryTest.assertTrue((boolean)reqs.isEmpty());
                }
            }
            Iterator iterator = F.asList((Object[])new Integer[]{-10, -1}).iterator();
            while (iterator.hasNext()) {
                int part = (Integer)iterator.next();
                GridTestUtils.assertThrows((IgniteLogger)log, () -> idxQry.setPartition(Integer.valueOf(part)), IllegalArgumentException.class, (String)"Specified partition must be in the range");
            }
            GridTestUtils.assertThrows((IgniteLogger)log, () -> {
                idxQry.setPartition(Integer.valueOf(5000));
                return cache.query((Query)idxQry).getAll();
            }, ClientException.class, (String)"Specified partition must be in the range");
        });
    }

    @Test
    public void testWrongIndexQueryCriterion() {
        this.withClientCache(cache -> {
            IndexQuery idxQry = new IndexQuery(Person.class);
            idxQry.setCriteria(new IndexQueryCriterion[]{new IndexQueryCriterion(){

                public String field() {
                    return null;
                }
            }});
            GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, () -> cache.query((Query)idxQry).getAll(), IllegalArgumentException.class, (String)"Unknown IndexQuery criterion type");
        });
    }

    private void assertClientQuery(ClientCache<Integer, Person> cache, int left, int right, @Nullable String idxName, IndexQueryCriterion ... crit) {
        IndexQuery idxQry = new IndexQuery(Person.class, idxName).setCriteria(crit);
        this.assertClientQuery(cache, left, right, idxQry);
        if (left < right) {
            Random r = new Random();
            int limit = 1 + r.nextInt(right - left);
            idxQry = new IndexQuery(Person.class, idxName).setCriteria(crit).setLimit(limit);
            this.assertClientQuery(cache, left, left + limit, idxQry);
            limit = right - left + r.nextInt(right - left);
            idxQry = new IndexQuery(Person.class, idxName).setCriteria(crit).setLimit(limit);
            this.assertClientQuery(cache, left, right, idxQry);
        }
    }

    private void assertClientQuery(ClientCache<Integer, Person> cache, int left, int right, IndexQuery idxQry) {
        List result = cache.query((Query)idxQry).getAll();
        ThinClientIndexQueryTest.assertEquals((int)(right - left), (int)result.size());
        if (idxQry.getIndexName() == null) {
            if (idxQry.getLimit() > 0) {
                return;
            }
            result.sort(Comparator.comparingLong(Cache.Entry::getKey));
        }
        Function<Cache.Entry, Object> fldOneVal = e -> this.keepBinary ? ((BinaryObject)e.getValue()).field("fld1") : ((Person)e.getValue()).fld1;
        for (int i = 0; i < result.size(); ++i) {
            Cache.Entry e2 = (Cache.Entry)result.get(i);
            int key = left + i;
            if (key >= 0) {
                ThinClientIndexQueryTest.assertEquals((int)key, (int)((Integer)e2.getKey()));
                ThinClientIndexQueryTest.assertEquals((int)key, (int)((Integer)fldOneVal.apply(e2)));
                continue;
            }
            ThinClientIndexQueryTest.assertEquals(null, (Object)fldOneVal.apply(e2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIndexQueryLimitOnOlderProtocolVersion() throws Exception {
        Class<?> clazz = Class.forName("org.apache.ignite.internal.client.thin.ProtocolBitmaskFeature");
        Field field = clazz.getDeclaredField("ALL_FEATURES_AS_ENUM_SET");
        field.setAccessible(true);
        EnumSet allFeaturesEnumSet = (EnumSet)field.get(null);
        allFeaturesEnumSet.remove(ProtocolBitmaskFeature.INDEX_QUERY_LIMIT);
        try {
            this.withClientCache(cache -> {
                IndexQuery idxQry = new IndexQuery(Person.class, IDX_FLD1);
                this.assertClientQuery((ClientCache<Integer, Person>)cache, -10, 10000, idxQry);
                IndexQuery idxQryWithLImit = new IndexQuery(Person.class, IDX_FLD1).setLimit(10);
                GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, () -> {
                    cache.query((Query)idxQryWithLImit).getAll();
                    return null;
                }, ClientFeatureNotSupportedByServerException.class, (String)"Feature INDEX_QUERY_LIMIT is not supported by the server");
            });
        }
        finally {
            allFeaturesEnumSet.add(ProtocolBitmaskFeature.INDEX_QUERY_LIMIT);
        }
    }

    private void withClientCache(Consumer<ClientCache<Integer, Person>> consumer) {
        ClientConfiguration clnCfg = new ClientConfiguration().setAddresses(new String[]{"127.0.0.1:10800"});
        try (IgniteClient cln = Ignition.startClient((ClientConfiguration)clnCfg);){
            ClientCache cache = cln.cache("CACHE");
            if (this.keepBinary) {
                cache = cache.withKeepBinary();
            }
            consumer.accept((ClientCache<Integer, Person>)cache);
        }
    }

    private static class Person {
        @GridToStringInclude
        @QuerySqlField(orderedGroups={@QuerySqlField.Group(name="IDX_FLD1", order=0), @QuerySqlField.Group(name="IDX_FLD1_FLD2", order=0)})
        final Integer fld1;
        @GridToStringInclude
        @QuerySqlField(orderedGroups={@QuerySqlField.Group(name="IDX_FLD1_FLD2", order=1)})
        final Integer fld2;
        @QuerySqlField(orderedGroups={@QuerySqlField.Group(name="IDX_FLD3", order=0)})
        IndexQueryAllTypesTest.PojoField fld3;

        Person(Integer fld1, Integer fld2, IndexQueryAllTypesTest.PojoField fld3) {
            this.fld1 = fld1;
            this.fld2 = fld2;
            this.fld3 = fld3;
        }

        public String toString() {
            return S.toString(Person.class, (Object)this);
        }
    }
}

