/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.query;

import java.util.List;
import java.util.stream.Collectors;
import javax.cache.Cache;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.query.IndexQuery;
import org.apache.ignite.cache.query.IndexQueryCriteriaBuilder;
import org.apache.ignite.cache.query.IndexQueryCriterion;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class IndexQueryWrongIndexTest
extends GridCommonAbstractTest {
    private static final String ID_IDX = "ID_IDX";
    private static final String DESC_ID_IDX = "DESC_ID_IDX";
    private static IgniteCache<Integer, Person> cache;

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        IgniteEx crd = this.startGrids(2);
        cache = crd.getOrCreateCache(new CacheConfiguration().setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setName("CACHE").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setIndexedTypes(new Class[]{Integer.class, Person.class}));
    }

    @Test
    public void testNonIndexedFields() {
        IndexQuery qry1 = new IndexQuery(Person.class, DESC_ID_IDX).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"id", (Object)Integer.MAX_VALUE)});
        cache.query((Query)qry1).getAll();
        IndexQuery qry2 = new IndexQuery(Person.class, ID_IDX).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"descId", (Object)Integer.MAX_VALUE)});
        cache.query((Query)qry2).getAll();
    }

    @Test
    public void testSimilarIndexName() {
        cache.query(new SqlFieldsQuery("create index \"aA\" on Person (descId);")).getAll();
        cache.query(new SqlFieldsQuery("create index \"AA\" on Person (id);")).getAll();
        cache.query(new SqlFieldsQuery("create index \"Aa\" on Person (descId desc);")).getAll();
        cache.query(new SqlFieldsQuery("insert into Person (_KEY, id, descId) values (1, 2, 1);")).getAll();
        cache.query(new SqlFieldsQuery("insert into Person (_KEY, id, descId) values (2, 1, 2);")).getAll();
        cache.query(new SqlFieldsQuery("insert into Person (_KEY, id, descId) values (3, 3, 3);")).getAll();
        this.checkIndex("aA", "descId", F.asList((Object[])new Integer[]{1, 2, 3}));
        this.checkIndex("AA", "id", F.asList((Object[])new Integer[]{2, 1, 3}));
        this.checkIndex("Aa", "descId", F.asList((Object[])new Integer[]{3, 2, 1}));
        this.checkIndex("aa", "id", F.asList((Object[])new Integer[]{2, 1, 3}));
    }

    private void checkIndex(String idxName, String fldName, List<Integer> expectedKeys) {
        IndexQuery qry = new IndexQuery(Person.class, idxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lte((String)fldName, (Object)Integer.MAX_VALUE)});
        IndexQueryWrongIndexTest.assertEquals(expectedKeys, cache.query((Query)qry).getAll().stream().map(Cache.Entry::getKey).collect(Collectors.toList()));
    }

    private static class Person {
        @QuerySqlField(orderedGroups={@QuerySqlField.Group(name="ID_IDX", order=0)})
        final int id;
        @QuerySqlField(orderedGroups={@QuerySqlField.Group(name="DESC_ID_IDX", order=0)})
        final int descId;

        Person(int id) {
            this.id = id;
            this.descId = id;
        }
    }
}

