/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.query;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.cache.Cache;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.query.IndexQuery;
import org.apache.ignite.cache.query.IndexQueryCriteriaBuilder;
import org.apache.ignite.cache.query.IndexQueryCriterion;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IndexQueryFilterTest
extends GridCommonAbstractTest {
    private static final String CACHE = "TEST_CACHE";
    private static final String IDX = "IDX";
    private static final int CNT = 10000;
    private static final int MAX_AGE = 100;
    @Parameterized.Parameter
    public String idxName;
    private static IgniteCache<Integer, Person> cache;
    private static final Map<Integer, Person> persons;

    @Parameterized.Parameters(name="idxName={0}")
    public static List<String> params() {
        return F.asList((Object[])new String[]{null, IDX});
    }

    protected void beforeTestsStarted() throws Exception {
        IgniteEx crd = this.startGrids(2);
        cache = crd.cache(CACHE);
        Random r = new Random();
        for (int i = 0; i < 10000; ++i) {
            Person p = new Person(i, r.nextInt(100), "name_" + i);
            persons.put(i, p);
            cache.put((Object)i, (Object)p);
        }
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheConfiguration ccfg1 = new CacheConfiguration().setName(CACHE).setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setIndexedTypes(new Class[]{Integer.class, Person.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg1});
        return cfg;
    }

    @Test
    public void testNonIndexedFieldFilter() {
        IgniteBiPredicate & Serializable nameFilter = (IgniteBiPredicate & Serializable)(k, v) -> v.name.contains("0");
        IndexQuery qry = new IndexQuery(Person.class, this.idxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"age", (Object)100)}).setFilter((IgniteBiPredicate)nameFilter);
        this.check((IndexQuery<Integer, Person>)qry, (IgniteBiPredicate<Integer, Person>)nameFilter);
        qry = new IndexQuery(Person.class, this.idxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"age", (Object)18)}).setFilter((IgniteBiPredicate)nameFilter);
        this.check((IndexQuery<Integer, Person>)qry, (IgniteBiPredicate<Integer, Person>)(IgniteBiPredicate & Serializable)(k, v) -> v.age < 18 && nameFilter.apply(k, v));
        qry = new IndexQuery(Person.class, "_key_PK").setFilter((IgniteBiPredicate)nameFilter);
        this.check((IndexQuery<Integer, Person>)qry, (IgniteBiPredicate<Integer, Person>)nameFilter);
    }

    @Test
    public void testIndexedFieldFilter() {
        IgniteBiPredicate & Serializable ageFilter = (IgniteBiPredicate & Serializable)(k, v) -> v.age > 18;
        IndexQuery qry = new IndexQuery(Person.class, this.idxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"age", (Object)100)}).setFilter((IgniteBiPredicate)ageFilter);
        this.check((IndexQuery<Integer, Person>)qry, (IgniteBiPredicate<Integer, Person>)ageFilter);
        qry = new IndexQuery(Person.class, this.idxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"age", (Object)18)}).setFilter((IgniteBiPredicate)ageFilter);
        IndexQueryFilterTest.assertTrue((boolean)cache.query((Query)qry).getAll().isEmpty());
        qry = new IndexQuery(Person.class, this.idxName).setFilter((IgniteBiPredicate)ageFilter);
        this.check((IndexQuery<Integer, Person>)qry, (IgniteBiPredicate<Integer, Person>)ageFilter);
    }

    @Test
    public void testKeyFilter() {
        IgniteBiPredicate & Serializable keyFilter = (IgniteBiPredicate & Serializable)(k, v) -> k > 5000;
        IndexQuery qry = new IndexQuery(Person.class, this.idxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"age", (Object)100)}).setFilter((IgniteBiPredicate)keyFilter);
        this.check((IndexQuery<Integer, Person>)qry, (IgniteBiPredicate<Integer, Person>)keyFilter);
        qry = new IndexQuery(Person.class, this.idxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"age", (Object)18)}).setFilter((IgniteBiPredicate)keyFilter);
        this.check((IndexQuery<Integer, Person>)qry, (IgniteBiPredicate<Integer, Person>)(IgniteBiPredicate & Serializable)(k, v) -> v.age < 18 && keyFilter.apply(k, v));
        qry = new IndexQuery(Person.class, this.idxName).setFilter((IgniteBiPredicate)keyFilter);
        this.check((IndexQuery<Integer, Person>)qry, (IgniteBiPredicate<Integer, Person>)keyFilter);
    }

    @Test
    public void testValueFilter() {
        IgniteBiPredicate & Serializable valFilter = (IgniteBiPredicate & Serializable)(k, v) -> v.equals(persons.values().stream().findFirst().orElse(null));
        IndexQuery qry = new IndexQuery(Person.class, this.idxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"age", (Object)100)}).setFilter((IgniteBiPredicate)valFilter);
        this.check((IndexQuery<Integer, Person>)qry, (IgniteBiPredicate<Integer, Person>)valFilter);
        qry = new IndexQuery(Person.class, this.idxName).setFilter((IgniteBiPredicate)valFilter);
        this.check((IndexQuery<Integer, Person>)qry, (IgniteBiPredicate<Integer, Person>)valFilter);
    }

    @Test
    public void testAllowOrDisallowAll() {
        IndexQuery qry = new IndexQuery(Person.class, this.idxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"age", (Object)100)}).setFilter((IgniteBiPredicate & Serializable)(k, v) -> true);
        IndexQueryFilterTest.assertEquals((int)10000, (int)cache.query((Query)qry).getAll().size());
        qry = new IndexQuery(Person.class, this.idxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"age", (Object)18)}).setFilter((IgniteBiPredicate & Serializable)(k, v) -> true);
        this.check((IndexQuery<Integer, Person>)qry, (IgniteBiPredicate<Integer, Person>)(IgniteBiPredicate & Serializable)(k, v) -> v.age < 18);
        qry = new IndexQuery(Person.class, this.idxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"age", (Object)100)}).setFilter((IgniteBiPredicate & Serializable)(k, v) -> false);
        IndexQueryFilterTest.assertTrue((boolean)cache.query((Query)qry).getAll().isEmpty());
        qry = new IndexQuery(Person.class, this.idxName).setFilter((IgniteBiPredicate & Serializable)(k, v) -> false);
        IndexQueryFilterTest.assertTrue((boolean)cache.query((Query)qry).getAll().isEmpty());
    }

    @Test
    public void testFilterException() {
        IgniteBiPredicate & Serializable nameFilter = (IgniteBiPredicate & Serializable)(k, v) -> {
            throw new RuntimeException("My Message");
        };
        GridTestUtils.assertThrows(null, () -> {
            IndexQuery qry = new IndexQuery(Person.class, this.idxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"age", (Object)100)}).setFilter(nameFilter);
            cache.query((Query)qry).getAll();
            return null;
        }, RuntimeException.class, (String)"My Message");
    }

    private void check(IndexQuery<Integer, Person> qry, IgniteBiPredicate<Integer, Person> filter) {
        List all = cache.query(qry).getAll();
        if (qry.getIndexName() == null) {
            Map<Integer, Person> expected = persons.entrySet().stream().filter(e -> filter.apply(e.getKey(), e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            IndexQueryFilterTest.assertEquals((int)expected.size(), (int)all.size());
            for (int i = 0; i < all.size(); ++i) {
                Cache.Entry entry = (Cache.Entry)all.get(i);
                Person p = expected.remove(entry.getKey());
                IndexQueryFilterTest.assertNotNull((Object)p);
                IndexQueryFilterTest.assertEquals((Object)p, (Object)entry.getValue());
            }
            IndexQueryFilterTest.assertTrue((boolean)expected.isEmpty());
            return;
        }
        boolean pk = "_key_PK".equals(qry.getIndexName());
        TreeMap<Integer, Set<Person>> expected = pk ? this.pkPersons(filter) : this.ageIndexedPersons(filter);
        for (int i = 0; i < all.size(); ++i) {
            Map.Entry<Integer, Set<Person>> exp = expected.firstEntry();
            Cache.Entry entry = (Cache.Entry)all.get(i);
            IndexQueryFilterTest.assertTrue((boolean)exp.getValue().remove(entry.getValue()));
            if (!exp.getValue().isEmpty()) continue;
            expected.remove(exp.getKey());
        }
        IndexQueryFilterTest.assertTrue((boolean)expected.isEmpty());
    }

    private TreeMap<Integer, Set<Person>> ageIndexedPersons(IgniteBiPredicate<Integer, Person> filter) {
        return persons.entrySet().stream().filter(e -> filter.apply(e.getKey(), e.getValue())).collect(TreeMap::new, (m, e) -> {
            int age = ((Person)e.getValue()).age;
            m.computeIfAbsent(age, a -> new HashSet());
            ((Set)m.get(age)).add(e.getValue());
        }, (l, r) -> r.forEach((k, v) -> {
            int age = ((Person)((Object)v)).age;
            l.computeIfAbsent(age, a -> new HashSet());
            ((Set)l.get(age)).add((Person)((Object)v));
        }));
    }

    private TreeMap<Integer, Set<Person>> pkPersons(IgniteBiPredicate<Integer, Person> filter) {
        return persons.entrySet().stream().filter(e -> filter.apply(e.getKey(), e.getValue())).collect(TreeMap::new, (m, e) -> {
            Set cfr_ignored_0 = m.put(e.getKey(), new HashSet(Collections.singleton(e.getValue())));
        }, TreeMap::putAll);
    }

    static {
        persons = new HashMap<Integer, Person>();
    }

    private static class Person {
        @GridToStringInclude
        final int id;
        @GridToStringInclude
        @QuerySqlField(orderedGroups={@QuerySqlField.Group(name="IDX", order=0)})
        final int age;
        @GridToStringInclude
        final String name;

        Person(int id, int age, String name) {
            this.id = id;
            this.age = age;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Person person = (Person)o;
            return Objects.equals(this.id, person.id) && Objects.equals(this.age, person.age) && Objects.equals(this.name, person.name);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.age, this.name);
        }

        public String toString() {
            return S.toString(Person.class, (Object)this);
        }
    }
}

