/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sys.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.UUID;
import org.apache.ignite.cluster.ClusterMetrics;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.query.h2.sys.view.SqlAbstractLocalSystemView;
import org.apache.ignite.internal.processors.query.h2.sys.view.SqlSystemViewColumnCondition;
import org.apache.ignite.internal.util.typedef.F;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.result.SearchRow;

public class SqlSystemViewNodeMetrics
extends SqlAbstractLocalSystemView {
    public SqlSystemViewNodeMetrics(GridKernalContext ctx) {
        super("NODE_METRICS", "Node metrics", ctx, "NODE_ID", SqlSystemViewNodeMetrics.newColumn("NODE_ID", 20), SqlSystemViewNodeMetrics.newColumn("LAST_UPDATE_TIME", 11), SqlSystemViewNodeMetrics.newColumn("MAX_ACTIVE_JOBS", 4), SqlSystemViewNodeMetrics.newColumn("CUR_ACTIVE_JOBS", 4), SqlSystemViewNodeMetrics.newColumn("AVG_ACTIVE_JOBS", 8), SqlSystemViewNodeMetrics.newColumn("MAX_WAITING_JOBS", 4), SqlSystemViewNodeMetrics.newColumn("CUR_WAITING_JOBS", 4), SqlSystemViewNodeMetrics.newColumn("AVG_WAITING_JOBS", 8), SqlSystemViewNodeMetrics.newColumn("MAX_REJECTED_JOBS", 4), SqlSystemViewNodeMetrics.newColumn("CUR_REJECTED_JOBS", 4), SqlSystemViewNodeMetrics.newColumn("AVG_REJECTED_JOBS", 8), SqlSystemViewNodeMetrics.newColumn("TOTAL_REJECTED_JOBS", 4), SqlSystemViewNodeMetrics.newColumn("MAX_CANCELED_JOBS", 4), SqlSystemViewNodeMetrics.newColumn("CUR_CANCELED_JOBS", 4), SqlSystemViewNodeMetrics.newColumn("AVG_CANCELED_JOBS", 8), SqlSystemViewNodeMetrics.newColumn("TOTAL_CANCELED_JOBS", 4), SqlSystemViewNodeMetrics.newColumn("MAX_JOBS_WAIT_TIME", 5), SqlSystemViewNodeMetrics.newColumn("CUR_JOBS_WAIT_TIME", 5), SqlSystemViewNodeMetrics.newColumn("AVG_JOBS_WAIT_TIME", 5), SqlSystemViewNodeMetrics.newColumn("MAX_JOBS_EXECUTE_TIME", 5), SqlSystemViewNodeMetrics.newColumn("CUR_JOBS_EXECUTE_TIME", 5), SqlSystemViewNodeMetrics.newColumn("AVG_JOBS_EXECUTE_TIME", 5), SqlSystemViewNodeMetrics.newColumn("TOTAL_JOBS_EXECUTE_TIME", 5), SqlSystemViewNodeMetrics.newColumn("TOTAL_EXECUTED_JOBS", 4), SqlSystemViewNodeMetrics.newColumn("TOTAL_EXECUTED_TASKS", 4), SqlSystemViewNodeMetrics.newColumn("TOTAL_BUSY_TIME", 5), SqlSystemViewNodeMetrics.newColumn("TOTAL_IDLE_TIME", 5), SqlSystemViewNodeMetrics.newColumn("CUR_IDLE_TIME", 5), SqlSystemViewNodeMetrics.newColumn("BUSY_TIME_PERCENTAGE", 8), SqlSystemViewNodeMetrics.newColumn("IDLE_TIME_PERCENTAGE", 8), SqlSystemViewNodeMetrics.newColumn("TOTAL_CPU", 4), SqlSystemViewNodeMetrics.newColumn("CUR_CPU_LOAD", 7), SqlSystemViewNodeMetrics.newColumn("AVG_CPU_LOAD", 7), SqlSystemViewNodeMetrics.newColumn("CUR_GC_CPU_LOAD", 7), SqlSystemViewNodeMetrics.newColumn("HEAP_MEMORY_INIT", 5), SqlSystemViewNodeMetrics.newColumn("HEAP_MEMORY_USED", 5), SqlSystemViewNodeMetrics.newColumn("HEAP_MEMORY_COMMITED", 5), SqlSystemViewNodeMetrics.newColumn("HEAP_MEMORY_MAX", 5), SqlSystemViewNodeMetrics.newColumn("HEAP_MEMORY_TOTAL", 5), SqlSystemViewNodeMetrics.newColumn("NONHEAP_MEMORY_INIT", 5), SqlSystemViewNodeMetrics.newColumn("NONHEAP_MEMORY_USED", 5), SqlSystemViewNodeMetrics.newColumn("NONHEAP_MEMORY_COMMITED", 5), SqlSystemViewNodeMetrics.newColumn("NONHEAP_MEMORY_MAX", 5), SqlSystemViewNodeMetrics.newColumn("NONHEAP_MEMORY_TOTAL", 5), SqlSystemViewNodeMetrics.newColumn("UPTIME", 5), SqlSystemViewNodeMetrics.newColumn("JVM_START_TIME", 11), SqlSystemViewNodeMetrics.newColumn("NODE_START_TIME", 11), SqlSystemViewNodeMetrics.newColumn("LAST_DATA_VERSION", 5), SqlSystemViewNodeMetrics.newColumn("CUR_THREAD_COUNT", 4), SqlSystemViewNodeMetrics.newColumn("MAX_THREAD_COUNT", 4), SqlSystemViewNodeMetrics.newColumn("TOTAL_THREAD_COUNT", 5), SqlSystemViewNodeMetrics.newColumn("CUR_DAEMON_THREAD_COUNT", 4), SqlSystemViewNodeMetrics.newColumn("SENT_MESSAGES_COUNT", 4), SqlSystemViewNodeMetrics.newColumn("SENT_BYTES_COUNT", 5), SqlSystemViewNodeMetrics.newColumn("RECEIVED_MESSAGES_COUNT", 4), SqlSystemViewNodeMetrics.newColumn("RECEIVED_BYTES_COUNT", 5), SqlSystemViewNodeMetrics.newColumn("OUTBOUND_MESSAGES_QUEUE", 4));
    }

    @Override
    public Iterator<Row> getRows(Session ses, SearchRow first, SearchRow last) {
        Collection<Object> nodes;
        ArrayList<Row> rows;
        block6: {
            rows = new ArrayList<Row>();
            SqlSystemViewColumnCondition idCond = this.conditionForColumn("NODE_ID", first, last);
            if (idCond.isEquality()) {
                try {
                    ClusterNode node;
                    UUID nodeId = SqlSystemViewNodeMetrics.uuidFromValue(idCond.valueForEquality());
                    ClusterNode clusterNode = node = nodeId == null ? null : this.ctx.discovery().node(nodeId);
                    if (node != null) {
                        nodes = Collections.singleton(node);
                        break block6;
                    }
                    nodes = Collections.emptySet();
                }
                catch (Exception e) {
                    nodes = Collections.emptySet();
                }
            } else {
                nodes = F.concat((boolean)false, (Collection)this.ctx.discovery().allNodes(), (Collection)this.ctx.discovery().daemonNodes());
            }
        }
        for (ClusterNode node : nodes) {
            if (node == null) continue;
            ClusterMetrics metrics = node.metrics();
            rows.add(this.createRow(ses, node.id(), SqlSystemViewNodeMetrics.valueTimestampFromMillis(metrics.getLastUpdateTime()), metrics.getMaximumActiveJobs(), metrics.getCurrentActiveJobs(), Float.valueOf(metrics.getAverageActiveJobs()), metrics.getMaximumWaitingJobs(), metrics.getCurrentWaitingJobs(), Float.valueOf(metrics.getAverageWaitingJobs()), metrics.getMaximumRejectedJobs(), metrics.getCurrentRejectedJobs(), Float.valueOf(metrics.getAverageRejectedJobs()), metrics.getTotalRejectedJobs(), metrics.getMaximumCancelledJobs(), metrics.getCurrentCancelledJobs(), Float.valueOf(metrics.getAverageCancelledJobs()), metrics.getTotalCancelledJobs(), metrics.getMaximumJobWaitTime(), metrics.getCurrentJobWaitTime(), (long)metrics.getAverageJobWaitTime(), metrics.getMaximumJobExecuteTime(), metrics.getCurrentJobExecuteTime(), (long)metrics.getAverageJobExecuteTime(), metrics.getTotalJobsExecutionTime(), metrics.getTotalExecutedJobs(), metrics.getTotalExecutedTasks(), metrics.getTotalBusyTime(), metrics.getTotalIdleTime(), metrics.getCurrentIdleTime(), Float.valueOf(metrics.getBusyTimePercentage()), Float.valueOf(metrics.getIdleTimePercentage()), metrics.getTotalCpus(), metrics.getCurrentCpuLoad(), metrics.getAverageCpuLoad(), metrics.getCurrentGcCpuLoad(), metrics.getHeapMemoryInitialized(), metrics.getHeapMemoryUsed(), metrics.getHeapMemoryCommitted(), metrics.getHeapMemoryMaximum(), metrics.getHeapMemoryTotal(), metrics.getNonHeapMemoryInitialized(), metrics.getNonHeapMemoryUsed(), metrics.getNonHeapMemoryCommitted(), metrics.getNonHeapMemoryMaximum(), metrics.getNonHeapMemoryTotal(), metrics.getUpTime(), SqlSystemViewNodeMetrics.valueTimestampFromMillis(metrics.getStartTime()), SqlSystemViewNodeMetrics.valueTimestampFromMillis(metrics.getNodeStartTime()), metrics.getLastDataVersion(), metrics.getCurrentThreadCount(), metrics.getMaximumThreadCount(), metrics.getTotalStartedThreadCount(), metrics.getCurrentDaemonThreadCount(), metrics.getSentMessagesCount(), metrics.getSentBytesCount(), metrics.getReceivedMessagesCount(), metrics.getReceivedBytesCount(), metrics.getOutboundMessagesQueueSize()));
        }
        return rows.iterator();
    }

    @Override
    public boolean canGetRowCount() {
        return true;
    }

    @Override
    public long getRowCount() {
        return F.concat((boolean)false, (Collection)this.ctx.discovery().allNodes(), (Collection)this.ctx.discovery().daemonNodes()).size();
    }
}

