/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.maintenance;

import java.util.Collections;
import java.util.List;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.maintenance.MaintenanceRebuildIndexTarget;
import org.apache.ignite.internal.processors.query.h2.maintenance.RebuildIndexAction;
import org.apache.ignite.maintenance.MaintenanceAction;
import org.apache.ignite.maintenance.MaintenanceWorkflowCallback;
import org.jetbrains.annotations.Nullable;

public class RebuildIndexWorkflowCallback
implements MaintenanceWorkflowCallback {
    private final List<MaintenanceRebuildIndexTarget> indexesToRebuild;
    private final IgniteH2Indexing indexing;
    private final IgniteLogger log;

    public RebuildIndexWorkflowCallback(List<MaintenanceRebuildIndexTarget> indexesToRebuild, IgniteH2Indexing indexing, IgniteLogger log) {
        this.indexesToRebuild = indexesToRebuild;
        this.indexing = indexing;
        this.log = log;
    }

    public boolean shouldProceedWithMaintenance() {
        return true;
    }

    public List<MaintenanceAction<?>> allActions() {
        return Collections.singletonList(new RebuildIndexAction(this.indexesToRebuild, this.indexing, this.log));
    }

    @Nullable
    public MaintenanceAction<?> automaticAction() {
        return new RebuildIndexAction(this.indexesToRebuild, this.indexing, this.log);
    }
}

