/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.disk;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.OpenOption;
import org.apache.ignite.internal.metric.SqlMemoryStatisticsHolder;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIODecorator;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.query.h2.H2MemoryTracker;

public class TrackableFileIoFactory {
    private final FileIOFactory delegateFactory;
    private final SqlMemoryStatisticsHolder metrics;

    public TrackableFileIoFactory(FileIOFactory factory, SqlMemoryStatisticsHolder metrics) {
        this.delegateFactory = factory;
        this.metrics = metrics;
    }

    public FileIO create(File file, H2MemoryTracker tracker, OpenOption ... modes) throws IOException {
        FileIO delegate = this.delegateFactory.create(file, modes);
        return new TrackableFileIO(delegate, this.metrics, tracker.createChildTracker());
    }

    private static class TrackableFileIO
    extends FileIODecorator {
        private final SqlMemoryStatisticsHolder metrics;
        private final H2MemoryTracker tracker;

        private TrackableFileIO(FileIO delegate, SqlMemoryStatisticsHolder metrics, H2MemoryTracker tracker) {
            super(delegate);
            this.metrics = metrics;
            this.tracker = tracker;
            this.tracker.incrementFilesCreated();
        }

        public int read(ByteBuffer destBuf) throws IOException {
            int bytesRead = this.delegate.read(destBuf);
            this.trackReads(bytesRead);
            return bytesRead;
        }

        public int read(ByteBuffer destBuf, long position) throws IOException {
            int bytesRead = this.delegate.read(destBuf, position);
            this.trackReads(bytesRead);
            return bytesRead;
        }

        public int read(byte[] buf, int off, int len) throws IOException {
            int bytesRead = this.delegate.read(buf, off, len);
            this.trackReads(bytesRead);
            return bytesRead;
        }

        public int write(ByteBuffer srcBuf) throws IOException {
            int bytesWritten = this.delegate.write(srcBuf);
            this.trackWrites(bytesWritten);
            return bytesWritten;
        }

        public int write(ByteBuffer srcBuf, long position) throws IOException {
            int bytesWritten = this.delegate.write(srcBuf, position);
            this.trackWrites(bytesWritten);
            return bytesWritten;
        }

        public int write(byte[] buf, int off, int len) throws IOException {
            int bytesWritten = this.delegate.write(buf, off, len);
            this.trackWrites(bytesWritten);
            return bytesWritten;
        }

        private void trackReads(int read) {
            if (read > 0 && this.metrics != null) {
                this.metrics.trackOffloadingRead(read);
            }
        }

        private void trackWrites(int written) {
            if (this.metrics != null) {
                this.metrics.trackOffloadingWritten(written);
            }
            if (this.tracker != null) {
                this.tracker.spill((long)written);
            }
        }

        public void clear() throws IOException {
            super.clear();
            this.tracker.unspill(this.tracker.writtenOnDisk());
        }

        public void close() throws IOException {
            super.close();
            this.tracker.unspill(this.tracker.writtenOnDisk());
            this.tracker.close();
        }
    }
}

