/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.QueryIndexType;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.QueryMXBeanImpl;
import org.apache.ignite.internal.cluster.IgniteClusterEx;
import org.apache.ignite.internal.managers.discovery.IgniteDiscoverySpi;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.processors.cache.QueryCursorImpl;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.processors.io.BulkLoadCommandProcessorFactory;
import org.apache.ignite.internal.processors.query.GridQueryProperty;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.GridRunningQueryInfo;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.NestedTxMode;
import org.apache.ignite.internal.processors.query.QueryEntityEx;
import org.apache.ignite.internal.processors.query.QueryField;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.SqlClientContext;
import org.apache.ignite.internal.processors.query.h2.CommandResult;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.KillQueryRun;
import org.apache.ignite.internal.processors.query.h2.QueryParameters;
import org.apache.ignite.internal.processors.query.h2.SchemaManager;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAlterTableAddColumn;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAlterTableDropColumn;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlColumn;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlCreateIndex;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlCreateTable;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlDropIndex;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlDropTable;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlStatement;
import org.apache.ignite.internal.processors.query.messages.GridQueryKillRequest;
import org.apache.ignite.internal.processors.query.messages.GridQueryKillResponse;
import org.apache.ignite.internal.processors.query.schema.SchemaOperationException;
import org.apache.ignite.internal.processors.query.stat.StatisticsKey;
import org.apache.ignite.internal.processors.query.stat.StatisticsTarget;
import org.apache.ignite.internal.processors.query.stat.config.StatisticsObjectConfiguration;
import org.apache.ignite.internal.sql.command.SqlAlterTableCommand;
import org.apache.ignite.internal.sql.command.SqlAlterUserCommand;
import org.apache.ignite.internal.sql.command.SqlAnalyzeCommand;
import org.apache.ignite.internal.sql.command.SqlBeginTransactionCommand;
import org.apache.ignite.internal.sql.command.SqlBulkLoadCommand;
import org.apache.ignite.internal.sql.command.SqlCommand;
import org.apache.ignite.internal.sql.command.SqlCommitTransactionCommand;
import org.apache.ignite.internal.sql.command.SqlCreateIndexCommand;
import org.apache.ignite.internal.sql.command.SqlCreateUserCommand;
import org.apache.ignite.internal.sql.command.SqlDropIndexCommand;
import org.apache.ignite.internal.sql.command.SqlDropStatisticsCommand;
import org.apache.ignite.internal.sql.command.SqlDropUserCommand;
import org.apache.ignite.internal.sql.command.SqlIndexColumn;
import org.apache.ignite.internal.sql.command.SqlKillClientCommand;
import org.apache.ignite.internal.sql.command.SqlKillContinuousQueryCommand;
import org.apache.ignite.internal.sql.command.SqlKillQueryCommand;
import org.apache.ignite.internal.sql.command.SqlKillScanQueryCommand;
import org.apache.ignite.internal.sql.command.SqlRefreshStatitsicsCommand;
import org.apache.ignite.internal.sql.command.SqlRollbackTransactionCommand;
import org.apache.ignite.internal.sql.command.SqlSetStreamingCommand;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.IgniteInClosure2X;
import org.apache.ignite.internal.util.typedef.CIX2;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.gridgain.internal.h2.command.Prepared;
import org.gridgain.internal.h2.command.ddl.AlterTableAlterColumn;
import org.gridgain.internal.h2.command.ddl.CreateIndex;
import org.gridgain.internal.h2.command.ddl.CreateTable;
import org.gridgain.internal.h2.command.ddl.DropIndex;
import org.gridgain.internal.h2.command.ddl.DropTable;
import org.gridgain.internal.h2.command.dml.NoOperation;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.value.DataType;
import org.gridgain.internal.h2.value.TypeInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandProcessor {
    private final GridKernalContext ctx;
    private final SchemaManager schemaMgr;
    private final IgniteH2Indexing idx;
    private final IgniteLogger log;
    private static final boolean handleUuidAsByte = IgniteSystemProperties.getBoolean((String)"IGNITE_SQL_UUID_DDL_BYTE_FORMAT", (boolean)false);
    private final AtomicLong qryCancelReqCntr = new AtomicLong();
    private ConcurrentMap<Long, KillQueryRun> cancellationRuns = new ConcurrentHashMap<Long, KillQueryRun>();
    private volatile boolean stopped;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private static final IgniteProductVersion KILL_COMMAND_SINCE_VER = IgniteProductVersion.fromString((String)"2.8.0");
    private final CIX2<ClusterNode, Message> locNodeMsgHnd = new CIX2<ClusterNode, Message>(){

        public void applyx(ClusterNode locNode, Message msg) {
            CommandProcessor.this.onMessage(locNode.id(), msg);
        }
    };
    private final BulkLoadCommandProcessorFactory bulkLoadCommandProcessorFactory;

    public CommandProcessor(GridKernalContext ctx, SchemaManager schemaMgr, IgniteH2Indexing idx) {
        this.ctx = ctx;
        this.schemaMgr = schemaMgr;
        this.idx = idx;
        this.log = ctx.log(CommandProcessor.class);
        this.bulkLoadCommandProcessorFactory = new BulkLoadCommandProcessorFactory(ctx);
    }

    public void start() {
        this.ctx.io().addMessageListener(GridTopic.TOPIC_QUERY, (nodeId, msg, plc) -> this.onMessage(nodeId, msg));
        this.ctx.event().addLocalEventListener(new GridLocalEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onEvent(Event evt) {
                UUID nodeId = ((DiscoveryEvent)evt).eventNode().id();
                ArrayList<GridFutureAdapter<String>> futs = new ArrayList<GridFutureAdapter<String>>();
                CommandProcessor.this.lock.writeLock().lock();
                try {
                    Iterator it = CommandProcessor.this.cancellationRuns.values().iterator();
                    while (it.hasNext()) {
                        KillQueryRun qryRun = (KillQueryRun)it.next();
                        if (!qryRun.nodeId().equals(nodeId)) continue;
                        futs.add(qryRun.cancelFuture());
                        it.remove();
                    }
                }
                finally {
                    CommandProcessor.this.lock.writeLock().unlock();
                }
                futs.forEach(f -> f.onDone((Object)("Query node has left the grid: [nodeId=" + nodeId + "]")));
            }
        }, 12, new int[]{11});
    }

    public void stop() {
        this.stopped = true;
        this.completeCancellationFutures("Local node is stopping: [nodeId=" + this.ctx.localNodeId() + "]");
    }

    public void onDisconnected() {
        this.completeCancellationFutures("Failed to cancel query because local client node has been disconnected from the cluster");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeCancellationFutures(@Nullable String err) {
        this.lock.writeLock().lock();
        try {
            Iterator it = this.cancellationRuns.values().iterator();
            while (it.hasNext()) {
                KillQueryRun qryRun = (KillQueryRun)it.next();
                qryRun.cancelFuture().onDone((Object)err);
                it.remove();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void onMessage(UUID nodeId, Object msg) {
        assert (msg != null);
        ClusterNode node = this.ctx.discovery().node(nodeId);
        if (node == null) {
            return;
        }
        boolean processed = true;
        if (msg instanceof GridQueryKillRequest) {
            this.onQueryKillRequest((GridQueryKillRequest)msg, node);
        }
        if (msg instanceof GridQueryKillResponse) {
            this.onQueryKillResponse((GridQueryKillResponse)msg);
        } else {
            processed = false;
        }
        if (processed && this.log.isDebugEnabled()) {
            this.log.debug("Processed response: " + nodeId + "->" + this.ctx.localNodeId() + " " + msg);
        }
    }

    private void onQueryKillRequest(GridQueryKillRequest msg, ClusterNode node) {
        long qryId = msg.nodeQryId();
        String err = null;
        GridRunningQueryInfo runningQryInfo = this.idx.runningQueryManager().runningQueryInfo(Long.valueOf(qryId));
        if (runningQryInfo == null) {
            err = "Query with provided ID doesn't exist [nodeId=" + this.ctx.localNodeId() + ", qryId=" + qryId + "]";
        } else if (!runningQryInfo.cancelable()) {
            err = "Query doesn't support cancellation [nodeId=" + this.ctx.localNodeId() + ", qryId=" + qryId + "]";
        }
        if (msg.asyncResponse() || err != null) {
            this.sendKillResponse(msg, node, err);
        }
        if (err == null) {
            try {
                runningQryInfo.cancel();
            }
            catch (Exception e) {
                U.warn((IgniteLogger)this.log, (Object)("Cancellation of query failed: [qryId=" + qryId + "]"), (Throwable)e);
                if (!msg.asyncResponse()) {
                    this.sendKillResponse(msg, node, e.getMessage());
                }
                return;
            }
            if (!msg.asyncResponse()) {
                runningQryInfo.runningFuture().listen((IgniteInClosure & Serializable)f -> this.sendKillResponse(msg, node, (String)f.result()));
            }
        }
    }

    private void sendKillResponse(GridQueryKillRequest msg, ClusterNode node, @Nullable String err) {
        boolean snd = this.idx.send(GridTopic.TOPIC_QUERY, GridTopic.TOPIC_QUERY.ordinal(), (Collection<ClusterNode>)Collections.singleton(node), (Message)new GridQueryKillResponse(msg.requestId(), err), null, (IgniteInClosure2X<ClusterNode, Message>)this.locNodeMsgHnd, (byte)3, false);
        if (!snd) {
            U.warn((IgniteLogger)this.log, (Object)("Resposne on query cancellation wasn't send back: [qryId=" + msg.nodeQryId() + "]"));
        }
    }

    private void onQueryKillResponse(GridQueryKillResponse msg) {
        KillQueryRun qryRun;
        this.lock.readLock().lock();
        try {
            qryRun = (KillQueryRun)this.cancellationRuns.remove(msg.requestId());
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (qryRun != null) {
            qryRun.cancelFuture().onDone((Object)msg.error());
        }
    }

    private static boolean isDdl(SqlCommand cmd) {
        return cmd instanceof SqlCreateIndexCommand || cmd instanceof SqlDropIndexCommand || cmd instanceof SqlAlterTableCommand || cmd instanceof SqlCreateUserCommand || cmd instanceof SqlAlterUserCommand || cmd instanceof SqlDropUserCommand || cmd instanceof SqlAnalyzeCommand || cmd instanceof SqlRefreshStatitsicsCommand || cmd instanceof SqlDropStatisticsCommand;
    }

    public CommandResult runCommand(String sql, SqlCommand cmdNative, GridSqlStatement cmdH2, QueryParameters params, @Nullable SqlClientContext cliCtx, Long qryId) throws IgniteCheckedException {
        assert (cmdNative != null || cmdH2 != null);
        QueryCursorImpl<List<?>> res = H2Utils.zeroCursor();
        boolean unregister = true;
        if (cmdNative != null) {
            assert (cmdH2 == null);
            if (CommandProcessor.isDdl(cmdNative)) {
                this.runCommandNativeDdl(sql, cmdNative);
            } else if (cmdNative instanceof SqlBulkLoadCommand) {
                boolean serverBulkLoadEnabled = cliCtx == null || cliCtx.serverBulkLoadEnabled();
                res = this.bulkLoadCommandProcessorFactory.getBulkLoadCommandProcessor(serverBulkLoadEnabled).processBulkLoadCommand(this.ctx, (SqlBulkLoadCommand)cmdNative, qryId);
                unregister = false;
            } else if (cmdNative instanceof SqlSetStreamingCommand) {
                this.processSetStreamingCommand((SqlSetStreamingCommand)cmdNative, cliCtx);
            } else if (cmdNative instanceof SqlKillQueryCommand) {
                this.processKillQueryCommand((SqlKillQueryCommand)cmdNative);
            } else if (cmdNative instanceof SqlKillContinuousQueryCommand) {
                this.processKillContinuousQueryCommand((SqlKillContinuousQueryCommand)cmdNative);
            } else if (cmdNative instanceof SqlKillScanQueryCommand) {
                this.processKillScanQueryCommand((SqlKillScanQueryCommand)cmdNative);
            } else if (cmdNative instanceof SqlKillClientCommand) {
                this.processKillClientCommand((SqlKillClientCommand)cmdNative);
            } else {
                this.processTxCommand(cmdNative, params);
            }
        } else {
            assert (cmdH2 != null);
            this.runCommandH2(sql, cmdH2);
        }
        return new CommandResult((FieldsQueryCursor<List<?>>)res, unregister);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processKillQueryCommand(SqlKillQueryCommand cmd) {
        GridFutureAdapter fut;
        block11: {
            this.ctx.security().authorize(SecurityPermission.KILL_QUERY);
            fut = new GridFutureAdapter();
            this.lock.readLock().lock();
            try {
                if (this.stopped) {
                    throw new IgniteSQLException("Failed to cancel query due to node is stopped [nodeId=" + cmd.nodeId() + ",qryId=" + cmd.nodeQueryId() + "]");
                }
                ClusterNode node = this.ctx.discovery().node(cmd.nodeId());
                if (node != null) {
                    if (node.version().compareTo(KILL_COMMAND_SINCE_VER) < 0) {
                        throw new IgniteSQLException("Failed to cancel query: KILL QUERY operation is supported in versions 2.8.0 and newer");
                    }
                    if (this.log.isInfoEnabled()) {
                        this.log.info("Start to process query cancel: [nodeId=" + cmd.nodeId() + ", qryId=" + cmd.nodeQueryId() + ']');
                    }
                    KillQueryRun qryRun = new KillQueryRun(cmd.nodeId(), cmd.nodeQueryId(), (GridFutureAdapter<String>)fut);
                    long reqId = this.qryCancelReqCntr.incrementAndGet();
                    this.cancellationRuns.put(reqId, qryRun);
                    boolean snd = this.idx.send(GridTopic.TOPIC_QUERY, GridTopic.TOPIC_QUERY.ordinal(), (Collection<ClusterNode>)Collections.singleton(node), (Message)new GridQueryKillRequest(reqId, cmd.nodeQueryId(), cmd.async()), null, (IgniteInClosure2X<ClusterNode, Message>)this.locNodeMsgHnd, (byte)3, cmd.async());
                    if (!snd) {
                        this.cancellationRuns.remove(reqId);
                        throw new IgniteSQLException("Failed to cancel query due communication problem [nodeId=" + cmd.nodeId() + ",qryId=" + cmd.nodeQueryId() + "]");
                    }
                    break block11;
                }
                throw new IgniteSQLException("Failed to cancel query, node is not alive [nodeId=" + cmd.nodeId() + ",qryId=" + cmd.nodeQueryId() + "]");
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        try {
            String err = (String)fut.get();
            if (err != null) {
                throw new IgniteSQLException("Failed to cancel query [nodeId=" + cmd.nodeId() + ",qryId=" + cmd.nodeQueryId() + ",err=" + err + "]");
            }
        }
        catch (IgniteCheckedException e) {
            throw new IgniteSQLException("Failed to cancel query [nodeId=" + cmd.nodeId() + ",qryId=" + cmd.nodeQueryId() + ",err=" + (Object)((Object)e) + "]", (Throwable)e);
        }
    }

    private void processAnalyzeCommand(SqlAnalyzeCommand cmd) throws IgniteCheckedException {
        this.ctx.security().authorize(SecurityPermission.CHANGE_STATISTICS);
        IgniteH2Indexing indexing = (IgniteH2Indexing)this.ctx.query().getIndexing();
        StatisticsObjectConfiguration[] objCfgs = (StatisticsObjectConfiguration[])cmd.configurations().stream().map(t -> {
            if (t.key().schema() == null) {
                StatisticsKey key = new StatisticsKey(cmd.schemaName(), t.key().obj());
                return new StatisticsObjectConfiguration(key, t.columns().values(), t.maxPartitionObsolescencePercent());
            }
            return t;
        }).toArray(StatisticsObjectConfiguration[]::new);
        indexing.statsManager().collectStatistics(objCfgs);
    }

    private void processRefreshStatisticsCommand(SqlRefreshStatitsicsCommand cmd) throws IgniteCheckedException {
        this.ctx.security().authorize(SecurityPermission.REFRESH_STATISTICS);
        IgniteH2Indexing indexing = (IgniteH2Indexing)this.ctx.query().getIndexing();
        StatisticsTarget[] targets = (StatisticsTarget[])cmd.targets().stream().map(t -> t.schema() == null ? new StatisticsTarget(cmd.schemaName(), t.obj(), t.columns()) : t).toArray(StatisticsTarget[]::new);
        indexing.statsManager().refreshStatistics(targets);
    }

    private void processDropStatisticsCommand(SqlDropStatisticsCommand cmd) throws IgniteCheckedException {
        this.ctx.security().authorize(SecurityPermission.CHANGE_STATISTICS);
        IgniteH2Indexing indexing = (IgniteH2Indexing)this.ctx.query().getIndexing();
        StatisticsTarget[] targets = (StatisticsTarget[])cmd.targets().stream().map(t -> t.schema() == null ? new StatisticsTarget(cmd.schemaName(), t.obj(), t.columns()) : t).toArray(StatisticsTarget[]::new);
        indexing.statsManager().dropStatistics(targets);
    }

    private void processKillContinuousQueryCommand(SqlKillContinuousQueryCommand cmd) {
        new QueryMXBeanImpl(this.ctx).cancelContinuous(cmd.getOriginNodeId(), cmd.getRoutineId());
    }

    private void processKillScanQueryCommand(SqlKillScanQueryCommand command) {
        new QueryMXBeanImpl(this.ctx).cancelScan(command.getOriginNodeId(), command.getCacheName(), command.getQryId());
    }

    private void processKillClientCommand(SqlKillClientCommand cmd) {
        if (cmd.connectionId() == null) {
            this.ctx.sqlListener().mxBean().dropAllConnections();
        } else {
            this.ctx.sqlListener().mxBean().dropConnection(cmd.connectionId().longValue());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void runCommandNativeDdl(String sql, SqlCommand cmd) {
        GridFinishedFuture fut = null;
        try {
            CommandProcessor.isDdlOnSchemaSupported(cmd.schemaName());
            this.finishActiveTxIfNecessary();
            if (cmd instanceof SqlCreateIndexCommand) {
                SqlCreateIndexCommand cmd0 = (SqlCreateIndexCommand)cmd;
                GridH2Table tbl = this.schemaMgr.dataTable(cmd0.schemaName(), cmd0.tableName());
                if (tbl == null) {
                    throw new SchemaOperationException(2, cmd0.tableName());
                }
                assert (tbl.rowDescriptor() != null);
                CommandProcessor.ensureDdlSupported(tbl);
                QueryIndex newIdx = new QueryIndex();
                newIdx.setName(cmd0.indexName());
                newIdx.setIndexType(cmd0.spatial() ? QueryIndexType.GEOSPATIAL : QueryIndexType.SORTED);
                LinkedHashMap<String, Boolean> flds = new LinkedHashMap<String, Boolean>();
                GridQueryTypeDescriptor typeDesc = tbl.rowDescriptor().type();
                for (SqlIndexColumn col : cmd0.columns()) {
                    GridQueryProperty prop = typeDesc.property(col.name());
                    if (prop == null) {
                        throw new SchemaOperationException(4, col.name());
                    }
                    flds.put(prop.name(), !col.descending());
                }
                newIdx.setFields(flds);
                newIdx.setInlineSize(cmd0.inlineSize());
                fut = this.ctx.query().dynamicIndexCreate(tbl.cacheName(), cmd.schemaName(), typeDesc.tableName(), newIdx, cmd0.ifNotExists(), cmd0.parallel());
            } else if (cmd instanceof SqlDropIndexCommand) {
                SqlDropIndexCommand cmd0 = (SqlDropIndexCommand)cmd;
                GridH2Table tbl = this.schemaMgr.dataTableForIndex(cmd0.schemaName(), cmd0.indexName());
                if (tbl != null) {
                    CommandProcessor.ensureDdlSupported(tbl);
                    fut = this.ctx.query().dynamicIndexDrop(tbl.cacheName(), cmd0.schemaName(), cmd0.indexName(), cmd0.ifExists());
                } else {
                    if (!cmd0.ifExists()) throw new SchemaOperationException(6, cmd0.indexName());
                    fut = new GridFinishedFuture();
                }
            } else if (cmd instanceof SqlAlterTableCommand) {
                SqlAlterTableCommand cmd0 = (SqlAlterTableCommand)cmd;
                GridH2Table tbl = this.schemaMgr.dataTable(cmd0.schemaName(), cmd0.tableName());
                if (tbl == null) {
                    throw new SchemaOperationException(2, cmd0.tableName());
                }
                Boolean logging = cmd0.logging();
                assert (logging != null) : "Only LOGGING/NOLOGGING are supported at the moment.";
                IgniteClusterEx cluster = this.ctx.grid().cluster();
                if (logging.booleanValue()) {
                    boolean res = cluster.enableWal(tbl.cacheName());
                    if (!res) {
                        throw new IgniteSQLException("Logging already enabled for table: " + cmd0.tableName());
                    }
                } else {
                    boolean res = cluster.disableWal(tbl.cacheName());
                    if (!res) {
                        throw new IgniteSQLException("Logging already disabled for table: " + cmd0.tableName());
                    }
                }
                fut = new GridFinishedFuture();
            } else if (cmd instanceof SqlCreateUserCommand) {
                SqlCreateUserCommand addCmd = (SqlCreateUserCommand)cmd;
                this.ctx.authentication().addUser(addCmd.userName(), addCmd.password());
            } else if (cmd instanceof SqlAlterUserCommand) {
                SqlAlterUserCommand altCmd = (SqlAlterUserCommand)cmd;
                this.ctx.authentication().updateUser(altCmd.userName(), altCmd.password());
            } else if (cmd instanceof SqlDropUserCommand) {
                SqlDropUserCommand dropCmd = (SqlDropUserCommand)cmd;
                this.ctx.authentication().removeUser(dropCmd.userName());
            } else if (cmd instanceof SqlAnalyzeCommand) {
                this.processAnalyzeCommand((SqlAnalyzeCommand)cmd);
            } else if (cmd instanceof SqlRefreshStatitsicsCommand) {
                this.processRefreshStatisticsCommand((SqlRefreshStatitsicsCommand)cmd);
            } else {
                if (!(cmd instanceof SqlDropStatisticsCommand)) throw new IgniteSQLException("Unsupported DDL operation: " + sql, 1002);
                this.processDropStatisticsCommand((SqlDropStatisticsCommand)cmd);
            }
            if (fut == null) return;
            fut.get();
            return;
        }
        catch (SchemaOperationException e) {
            throw this.convert(e);
        }
        catch (IgniteSQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IgniteSQLException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void runCommandH2(String sql, GridSqlStatement cmdH2) {
        GridFinishedFuture fut = null;
        try {
            this.finishActiveTxIfNecessary();
            if (cmdH2 instanceof GridSqlCreateIndex) {
                GridSqlCreateIndex cmd = (GridSqlCreateIndex)cmdH2;
                CommandProcessor.isDdlOnSchemaSupported(cmd.schemaName());
                GridH2Table tbl = this.schemaMgr.dataTable(cmd.schemaName(), cmd.tableName());
                if (tbl == null) {
                    throw new SchemaOperationException(2, cmd.tableName());
                }
                assert (tbl.rowDescriptor() != null);
                CommandProcessor.ensureDdlSupported(tbl);
                QueryIndex newIdx = new QueryIndex();
                newIdx.setName(cmd.index().getName());
                newIdx.setIndexType(cmd.index().getIndexType());
                LinkedHashMap flds = new LinkedHashMap();
                GridQueryTypeDescriptor typeDesc = tbl.rowDescriptor().type();
                for (Map.Entry e : cmd.index().getFields().entrySet()) {
                    GridQueryProperty prop = typeDesc.property((String)e.getKey());
                    if (prop == null) {
                        throw new SchemaOperationException(4, (String)e.getKey());
                    }
                    flds.put(prop.name(), e.getValue());
                }
                newIdx.setFields(flds);
                fut = this.ctx.query().dynamicIndexCreate(tbl.cacheName(), cmd.schemaName(), typeDesc.tableName(), newIdx, cmd.ifNotExists(), 0);
            } else if (cmdH2 instanceof GridSqlDropIndex) {
                GridSqlDropIndex cmd = (GridSqlDropIndex)cmdH2;
                CommandProcessor.isDdlOnSchemaSupported(cmd.schemaName());
                GridH2Table tbl = this.schemaMgr.dataTableForIndex(cmd.schemaName(), cmd.indexName());
                if (tbl != null) {
                    CommandProcessor.ensureDdlSupported(tbl);
                    fut = this.ctx.query().dynamicIndexDrop(tbl.cacheName(), cmd.schemaName(), cmd.indexName(), cmd.ifExists());
                } else {
                    if (!cmd.ifExists()) throw new SchemaOperationException(6, cmd.indexName());
                    fut = new GridFinishedFuture();
                }
            } else if (cmdH2 instanceof GridSqlCreateTable) {
                GridSqlCreateTable cmd = (GridSqlCreateTable)cmdH2;
                this.ctx.security().authorize(cmd.cacheName(), SecurityPermission.CACHE_CREATE);
                CommandProcessor.isDdlOnSchemaSupported(cmd.schemaName());
                GridH2Table tbl = this.schemaMgr.dataTable(cmd.schemaName(), cmd.tableName());
                if (tbl != null) {
                    if (!cmd.ifNotExists()) {
                        throw new SchemaOperationException(3, cmd.tableName());
                    }
                } else {
                    QueryEntity e = CommandProcessor.toQueryEntity(this.ctx, cmd);
                    CacheConfiguration ccfg = new CacheConfiguration(cmd.tableName());
                    ccfg.setQueryEntities(Collections.singleton(e));
                    ccfg.setSqlSchema(cmd.schemaName());
                    SchemaOperationException err = QueryUtils.checkQueryEntityConflicts((CacheConfiguration)ccfg, this.ctx.cache().cacheDescriptors().values());
                    if (err != null) {
                        throw err;
                    }
                    if (!F.isEmpty((String)cmd.cacheName()) && this.ctx.cache().cacheDescriptor(cmd.cacheName()) != null) {
                        this.ctx.query().dynamicAddQueryEntity(cmd.cacheName(), cmd.schemaName(), e, cmd.parallelism(), true).get();
                    } else {
                        this.ctx.query().dynamicTableCreate(cmd.schemaName(), e, cmd.templateName(), cmd.cacheName(), cmd.cacheGroup(), cmd.dataRegionName(), cmd.affinityKey(), cmd.atomicityMode(), cmd.writeSynchronizationMode(), cmd.backups(), cmd.ifNotExists(), cmd.encrypted(), cmd.parallelism());
                    }
                }
            } else if (cmdH2 instanceof GridSqlDropTable) {
                GridSqlDropTable cmd = (GridSqlDropTable)cmdH2;
                CommandProcessor.isDdlOnSchemaSupported(cmd.schemaName());
                GridH2Table tbl = this.schemaMgr.dataTable(cmd.schemaName(), cmd.tableName());
                if (tbl == null) {
                    if (!cmd.ifExists()) {
                        throw new SchemaOperationException(2, cmd.tableName());
                    }
                } else {
                    this.ctx.security().authorize(tbl.cacheName(), SecurityPermission.CACHE_DESTROY);
                    String schema = tbl.getSchema().getName();
                    String tblName = tbl.getName();
                    this.ctx.query().dynamicTableDrop(tbl.cacheName(), cmd.tableName(), cmd.ifExists());
                }
            } else if (cmdH2 instanceof GridSqlAlterTableAddColumn) {
                GridSqlAlterTableAddColumn cmd = (GridSqlAlterTableAddColumn)cmdH2;
                CommandProcessor.isDdlOnSchemaSupported(cmd.schemaName());
                GridH2Table tbl = this.schemaMgr.dataTable(cmd.schemaName(), cmd.tableName());
                if (tbl == null) {
                    if (!cmd.ifTableExists()) {
                        throw new SchemaOperationException(2, cmd.tableName());
                    }
                } else {
                    if (QueryUtils.isSqlType((Class)tbl.rowDescriptor().type().valueClass())) {
                        throw new SchemaOperationException("Cannot add column(s) because table was created with WRAP_VALUE=false option.");
                    }
                    ArrayList<QueryField> cols = new ArrayList<QueryField>(cmd.columns().length);
                    boolean allFieldsNullable = true;
                    for (GridSqlColumn col : cmd.columns()) {
                        if (tbl.doesColumnExist(col.columnName())) {
                            if (!cmd.ifNotExists() || cmd.columns().length != 1) {
                                throw new SchemaOperationException(5, col.columnName());
                            }
                            cols = null;
                            break;
                        }
                        QueryField field = new QueryField(col.columnName(), CommandProcessor.getTypeClassName(col), col.column().isNullable(), col.defaultValue(), CommandProcessor.convertH2ColumnPrecision(col.column().getType()), CommandProcessor.convertH2ColumnScale(col.column().getType()));
                        cols.add(field);
                        allFieldsNullable &= field.isNullable();
                    }
                    if (cols != null) {
                        assert (tbl.rowDescriptor() != null);
                        if (!allFieldsNullable) {
                            QueryUtils.checkNotNullAllowed((CacheConfiguration)tbl.cacheInfo().config());
                        }
                        fut = this.ctx.query().dynamicColumnAdd(tbl.cacheName(), cmd.schemaName(), tbl.rowDescriptor().type().tableName(), cols, cmd.ifTableExists(), cmd.ifNotExists());
                    }
                }
            } else {
                if (!(cmdH2 instanceof GridSqlAlterTableDropColumn)) throw new IgniteSQLException("Unsupported DDL operation: " + sql, 1002);
                GridSqlAlterTableDropColumn cmd = (GridSqlAlterTableDropColumn)cmdH2;
                CommandProcessor.isDdlOnSchemaSupported(cmd.schemaName());
                GridH2Table tbl = this.schemaMgr.dataTable(cmd.schemaName(), cmd.tableName());
                if (tbl == null) {
                    if (!cmd.ifTableExists()) {
                        throw new SchemaOperationException(2, cmd.tableName());
                    }
                } else {
                    assert (tbl.rowDescriptor() != null);
                    if (tbl.cacheInfo().mvccEnabled()) {
                        throw new IgniteSQLException("Cannot drop column(s) with enabled MVCC. Operation is unsupported at the moment.", 1002);
                    }
                    if (QueryUtils.isSqlType((Class)tbl.rowDescriptor().type().valueClass())) {
                        throw new SchemaOperationException("Cannot drop column(s) because table was created with WRAP_VALUE=false option.");
                    }
                    ArrayList<String> cols = new ArrayList<String>(cmd.columns().length);
                    GridQueryTypeDescriptor type = tbl.rowDescriptor().type();
                    for (String colName : cmd.columns()) {
                        if (!tbl.doesColumnExist(colName)) {
                            if (!cmd.ifExists() || cmd.columns().length != 1) {
                                throw new SchemaOperationException(4, colName);
                            }
                            cols = null;
                            break;
                        }
                        SchemaOperationException err = QueryUtils.validateDropColumn((GridQueryTypeDescriptor)type, (String)colName);
                        if (err != null) {
                            throw err;
                        }
                        cols.add(colName);
                    }
                    if (cols != null) {
                        fut = this.ctx.query().dynamicColumnRemove(tbl.cacheName(), cmd.schemaName(), type.tableName(), cols, cmd.ifTableExists(), cmd.ifExists());
                    }
                }
            }
            if (fut == null) return;
            fut.get();
            return;
        }
        catch (SchemaOperationException e) {
            U.error(null, (Object)"DDL operation failure", (Throwable)e);
            throw this.convert(e);
        }
        catch (IgniteSQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IgniteSQLException(e.getMessage(), (Throwable)e);
        }
    }

    private static void isDdlOnSchemaSupported(String schemaName) {
        if (F.eq((Object)QueryUtils.sysSchemaName(), (Object)schemaName)) {
            throw new IgniteSQLException("DDL statements are not supported on " + schemaName + " schema", 1002);
        }
    }

    private static void ensureDdlSupported(GridH2Table tbl) throws IgniteSQLException {
        if (tbl.cacheInfo().config().getCacheMode() == CacheMode.LOCAL) {
            throw new IgniteSQLException("DDL statements are not supported on LOCAL caches", 1002);
        }
    }

    private void finishActiveTxIfNecessary() throws IgniteCheckedException {
        try (GridNearTxLocal tx = MvccUtils.tx((GridKernalContext)this.ctx);){
            if (tx == null) {
                return;
            }
            if (!tx.isRollbackOnly()) {
                tx.commit();
            } else {
                tx.rollback();
            }
        }
    }

    private IgniteSQLException convert(SchemaOperationException e) {
        int sqlCode;
        switch (e.code()) {
            case 1: {
                sqlCode = 4006;
                break;
            }
            case 2: {
                sqlCode = 3001;
                break;
            }
            case 3: {
                sqlCode = 3007;
                break;
            }
            case 4: {
                sqlCode = 3008;
                break;
            }
            case 5: {
                sqlCode = 3009;
                break;
            }
            case 6: {
                sqlCode = 3006;
                break;
            }
            case 7: {
                sqlCode = 3005;
                break;
            }
            default: {
                sqlCode = 1;
            }
        }
        return new IgniteSQLException(e.getMessage(), sqlCode, (Throwable)e);
    }

    private static QueryEntity toQueryEntity(GridKernalContext ctx, GridSqlCreateTable createTbl) {
        QueryEntityEx res = new QueryEntityEx();
        res.setTableName(createTbl.tableName());
        res.setImplicitPk(createTbl.implicitPk());
        HashSet<String> notNullFields = null;
        HashMap<String, Object> dfltValues = new HashMap<String, Object>();
        HashMap<String, Integer> precision = new HashMap<String, Integer>();
        HashMap<String, Integer> scale = new HashMap<String, Integer>();
        for (Map.Entry<String, GridSqlColumn> e : createTbl.columns().entrySet()) {
            int scaleVal;
            int precisionVal;
            Object dfltVal;
            GridSqlColumn gridCol = e.getValue();
            Column col = gridCol.column();
            res.addQueryField(e.getKey(), CommandProcessor.getTypeClassName(gridCol), null);
            if (!col.isNullable()) {
                if (notNullFields == null) {
                    notNullFields = new HashSet<String>();
                }
                notNullFields.add(e.getKey());
            }
            if ((dfltVal = gridCol.defaultValue()) != null) {
                dfltValues.put(e.getKey(), dfltVal);
            }
            if ((precisionVal = CommandProcessor.convertH2ColumnPrecision(col.getType())) != -1) {
                precision.put(e.getKey(), precisionVal);
            }
            if ((scaleVal = CommandProcessor.convertH2ColumnScale(col.getType())) == -1) continue;
            scale.put(e.getKey(), scaleVal);
        }
        if (!F.isEmpty(dfltValues)) {
            res.setDefaultFieldValues(dfltValues);
        }
        if (!F.isEmpty(precision)) {
            res.setFieldsPrecision(precision);
        }
        if (!F.isEmpty(scale)) {
            res.setFieldsScale(scale);
        }
        String digest = CommandProcessor.createFieldsDigest(createTbl);
        String valTypeName = QueryUtils.createTableValueTypeName((String)createTbl.schemaName(), (String)createTbl.tableName(), (String)digest);
        String keyTypeName = QueryUtils.createTableKeyTypeName((String)valTypeName);
        if (!F.isEmpty((String)createTbl.keyTypeName())) {
            keyTypeName = createTbl.keyTypeName();
        }
        if (!F.isEmpty((String)createTbl.valueTypeName())) {
            valTypeName = createTbl.valueTypeName();
        }
        assert (createTbl.wrapKey() != null);
        assert (createTbl.wrapValue() != null);
        if (!createTbl.wrapKey().booleanValue() && !createTbl.implicitPk()) {
            GridSqlColumn pkCol = createTbl.columns().get(createTbl.primaryKeyColumns().iterator().next());
            keyTypeName = CommandProcessor.getTypeClassName(pkCol);
            res.setKeyFieldName(pkCol.columnName());
        } else if (createTbl.wrapKey().booleanValue()) {
            res.setKeyFields(createTbl.primaryKeyColumns());
            if (IgniteFeatures.allNodesSupports((GridKernalContext)ctx, (Iterable)F.view((Collection)ctx.discovery().allNodes(), (IgnitePredicate[])new IgnitePredicate[]{IgniteDiscoverySpi.SRV_NODES}), (IgniteFeatures)IgniteFeatures.SPECIFIED_SEQ_PK_KEYS)) {
                res.setPreserveKeysOrder(true);
            }
        }
        if (!createTbl.wrapValue().booleanValue()) {
            GridSqlColumn valCol = null;
            for (Map.Entry<String, GridSqlColumn> e : createTbl.columns().entrySet()) {
                if (createTbl.primaryKeyColumns().contains(e.getKey())) continue;
                valCol = e.getValue();
                break;
            }
            assert (valCol != null);
            valTypeName = CommandProcessor.getTypeClassName(valCol);
            res.setValueFieldName(valCol.columnName());
        }
        res.setValueType(valTypeName);
        res.setKeyType(keyTypeName);
        if (!F.isEmpty(notNullFields)) {
            res.setNotNullFields(notNullFields);
        }
        if (IgniteFeatures.allNodesSupports((GridKernalContext)ctx, (Iterable)F.view((Collection)ctx.discovery().allNodes(), (IgnitePredicate[])new IgnitePredicate[]{IgniteDiscoverySpi.ALL_NODES}), (IgniteFeatures)IgniteFeatures.FILLS_ABSENT_PKS_WITH_DEFAULTS)) {
            res.fillAbsentPKsWithDefaults(true);
        }
        if (Objects.nonNull(createTbl.primaryKeyInlineSize())) {
            res.setPrimaryKeyInlineSize(createTbl.primaryKeyInlineSize());
        }
        if (Objects.nonNull(createTbl.affinityKeyInlineSize())) {
            res.setAffinityKeyInlineSize(createTbl.affinityKeyInlineSize());
        }
        return res;
    }

    private static int convertH2ColumnPrecision(TypeInfo type) {
        if (type.getValueType() == 6 ? type.getPrecision() < 65535L : (type.getValueType() == 13 || type.getValueType() == 21 || type.getValueType() == 14) && type.getPrecision() < Integer.MAX_VALUE) {
            return (int)type.getPrecision();
        }
        return -1;
    }

    private static int convertH2ColumnScale(TypeInfo type) {
        if (type.getValueType() == 6 && type.getScale() < Short.MAX_VALUE) {
            return type.getScale();
        }
        return -1;
    }

    public static boolean isCommand(Prepared cmd) {
        return cmd instanceof CreateIndex || cmd instanceof DropIndex || cmd instanceof CreateTable || cmd instanceof DropTable || cmd instanceof AlterTableAlterColumn;
    }

    public static boolean isCommandNoOp(Prepared cmd) {
        return cmd instanceof NoOperation;
    }

    private static String createFieldsDigest(GridSqlCreateTable tbl) {
        try {
            String concatedFields = CommandProcessor.concatFields(tbl);
            return U.calculateMD5((InputStream)new ByteArrayInputStream(concatedFields.getBytes()));
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    private static String concatFields(GridSqlCreateTable tbl) {
        ArrayList<String> fieldDigests = new ArrayList<String>(tbl.columns().size());
        for (Map.Entry<String, GridSqlColumn> e : tbl.columns().entrySet()) {
            String colName = e.getKey();
            String colType = CommandProcessor.getTypeClassName(e.getValue());
            String fd = "[" + colName + ":" + colType + "]";
            fieldDigests.add(fd.toUpperCase());
        }
        Collections.sort(fieldDigests);
        return String.join((CharSequence)", ", fieldDigests);
    }

    private static String getTypeClassName(GridSqlColumn col) {
        int type = col.column().getType().getValueType();
        switch (type) {
            case 20: {
                if (handleUuidAsByte) break;
                return UUID.class.getName();
            }
        }
        return DataType.getTypeClassName((int)type, (boolean)false);
    }

    private void processTxCommand(SqlCommand cmd, QueryParameters params) throws IgniteCheckedException {
        block14: {
            GridNearTxLocal tx;
            block12: {
                block13: {
                    NestedTxMode nestedTxMode = params.nestedTxMode();
                    tx = MvccUtils.tx((GridKernalContext)this.ctx);
                    if (!(cmd instanceof SqlBeginTransactionCommand)) break block12;
                    if (!MvccUtils.mvccEnabled((GridKernalContext)this.ctx)) {
                        throw new IgniteSQLException("MVCC must be enabled in order to start transaction.", 5002);
                    }
                    if (tx == null) break block13;
                    if (nestedTxMode == null) {
                        nestedTxMode = NestedTxMode.DEFAULT;
                    }
                    switch (nestedTxMode) {
                        case COMMIT: {
                            this.doCommit(tx);
                            MvccUtils.txStart((GridKernalContext)this.ctx, (long)params.timeout());
                            break block14;
                        }
                        case IGNORE: {
                            this.log.warning("Transaction has already been started, ignoring BEGIN command.");
                            break block14;
                        }
                        case ERROR: {
                            throw new IgniteSQLException("Transaction has already been started.", 5001);
                        }
                        default: {
                            throw new IgniteSQLException("Unexpected nested transaction handling mode: " + nestedTxMode.name());
                        }
                    }
                }
                MvccUtils.txStart((GridKernalContext)this.ctx, (long)params.timeout());
                break block14;
            }
            if (cmd instanceof SqlCommitTransactionCommand) {
                if (tx != null) {
                    this.doCommit(tx);
                }
            } else {
                assert (cmd instanceof SqlRollbackTransactionCommand);
                if (tx != null) {
                    this.doRollback(tx);
                }
            }
        }
    }

    private void doCommit(@NotNull GridNearTxLocal tx) throws IgniteCheckedException {
        try {
            tx.commit();
        }
        finally {
            this.closeTx(tx);
        }
    }

    public void doRollback(@NotNull GridNearTxLocal tx) throws IgniteCheckedException {
        try {
            tx.rollback();
        }
        finally {
            this.closeTx(tx);
        }
    }

    private void closeTx(@NotNull GridNearTxLocal tx) throws IgniteCheckedException {
        try {
            tx.close();
        }
        finally {
            this.ctx.cache().context().tm().resetContext();
        }
    }

    private void processSetStreamingCommand(SqlSetStreamingCommand cmd, @Nullable SqlClientContext cliCtx) {
        if (cliCtx == null) {
            throw new IgniteSQLException("SET STREAMING command can only be executed from JDBC or ODBC driver.");
        }
        if (cmd.isTurnOn()) {
            cliCtx.enableStreaming(cmd.allowOverwrite(), cmd.flushFrequency(), cmd.perNodeBufferSize(), cmd.perNodeParallelOperations(), cmd.isOrdered());
        } else {
            cliCtx.disableStreaming();
        }
    }
}

