/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.cache.CacheException;
import org.apache.ignite.cache.query.QueryCancelledException;
import org.apache.ignite.internal.processors.cache.QueryCursorImpl;
import org.apache.ignite.internal.processors.query.GridQueryCancel;
import org.apache.ignite.internal.processors.query.GridRunningQueryInfo;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.RunningQueryManager;
import org.apache.ignite.internal.processors.tracing.MTC;
import org.apache.ignite.internal.processors.tracing.NoopSpan;
import org.apache.ignite.internal.processors.tracing.Span;
import org.apache.ignite.internal.processors.tracing.SpanType;
import org.apache.ignite.internal.processors.tracing.TraceableIterator;
import org.apache.ignite.internal.processors.tracing.Tracing;

public class RegisteredQueryCursor<T>
extends QueryCursorImpl<T> {
    private static final AtomicReferenceFieldUpdater<RegisteredQueryCursor, Exception> FAIL_REASON_UPDATER = AtomicReferenceFieldUpdater.newUpdater(RegisteredQueryCursor.class, Exception.class, "failReason");
    private final AtomicBoolean unregistered = new AtomicBoolean(false);
    private RunningQueryManager runningQryMgr;
    private Long qryId;
    private volatile Exception failReason;
    private final Tracing tracing;
    private final Span qrySpan;

    public RegisteredQueryCursor(Iterable<T> iterExec, GridQueryCancel cancel, RunningQueryManager runningQryMgr, boolean lazy, Long qryId, Tracing tracing) {
        super(iterExec, cancel, true, lazy);
        assert (runningQryMgr != null);
        assert (qryId != null);
        this.runningQryMgr = runningQryMgr;
        this.qryId = qryId;
        this.tracing = tracing;
        GridRunningQueryInfo qryInfo = runningQryMgr.runningQueryInfo(qryId);
        this.qrySpan = qryInfo == null ? NoopSpan.INSTANCE : qryInfo.span();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Iterator<T> iter() {
        try (MTC.TraceSurroundings ignored = MTC.supportContinual((Span)this.qrySpan);){
            Iterator iter = this.lazy() ? new RegisteredIterator(super.iter()) : super.iter();
            Iterator iterator = this.qrySpan != NoopSpan.INSTANCE ? new TraceableIterator(iter) : iter;
            return iterator;
        }
        catch (Exception e) {
            this.qrySpan.addTag("error", e::getMessage);
            throw this.failReason(e);
        }
    }

    public void close() {
        Span span = MTC.span();
        try (MTC.TraceSurroundings ignored = MTC.support((Span)this.tracing.create(SpanType.SQL_CURSOR_CLOSE, span != NoopSpan.INSTANCE ? span : this.qrySpan));){
            super.close();
            this.unregisterQuery();
        }
        catch (Throwable th) {
            this.qrySpan.addTag("error", th::getMessage);
            throw th;
        }
    }

    public void cancel() {
        try (MTC.TraceSurroundings ignored = MTC.support((Span)this.tracing.create(SpanType.SQL_CURSOR_CANCEL, this.qrySpan));){
            FAIL_REASON_UPDATER.compareAndSet(this, null, (Exception)((Object)new QueryCancelledException()));
            this.qrySpan.addTag("error", this.failReason::getMessage);
            this.close();
        }
    }

    private void unregisterQuery() {
        if (this.unregistered.compareAndSet(false, true)) {
            this.runningQryMgr.unregister(this.qryId, (Throwable)this.failReason);
        }
    }

    private CacheException failReason(Exception e) {
        if (FAIL_REASON_UPDATER.compareAndSet(this, null, e) && QueryUtils.wasCancelled((Throwable)this.failReason)) {
            this.unregisterQuery();
        }
        return this.failReason instanceof CacheException ? (CacheException)this.failReason : new CacheException((Throwable)this.failReason);
    }

    private class RegisteredIterator
    implements Iterator<T> {
        final Iterator<T> delegateIt;

        private RegisteredIterator(Iterator<T> it) {
            this.delegateIt = it;
        }

        @Override
        public boolean hasNext() {
            try {
                return this.delegateIt.hasNext();
            }
            catch (Exception e) {
                throw RegisteredQueryCursor.this.failReason(e);
            }
        }

        @Override
        public T next() {
            try {
                return this.delegateIt.next();
            }
            catch (Exception e) {
                throw RegisteredQueryCursor.this.failReason(e);
            }
        }
    }
}

