/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.util;

import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.cache.CacheException;
import javax.cache.event.CacheEntryEvent;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.query.ContinuousQuery;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.client.ClientConnectionException;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.ClientConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.index.AbstractSchemaSelfTest;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryManager;
import org.apache.ignite.internal.util.typedef.T3;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.util.KillCommandsSQLTest;
import org.junit.Assert;

class KillCommandsTests {
    public static final String SVC_NAME = "my-svc";
    public static final String DEFAULT_CACHE_NAME = "default";
    public static final int PAGE_SZ = 5;
    public static final int TIMEOUT = 10000;

    KillCommandsTests() {
    }

    public static void doTestCancelSQLQuery(IgniteEx cli, Consumer<String> qryCanceler) {
        String qryStr = "SELECT * FROM \"default\".Integer";
        SqlFieldsQuery qry = new SqlFieldsQuery(qryStr).setPageSize(5);
        Iterator iter = AbstractSchemaSelfTest.queryProcessor((Ignite)cli).querySqlFields(qry, true).iterator();
        Assert.assertNotNull(iter.next());
        List<List<?>> sqlQries = KillCommandsSQLTest.execute((Ignite)cli, "SELECT * FROM SYS.SQL_QUERIES ORDER BY START_TIME", new Object[0]);
        Assert.assertEquals((long)2L, (long)sqlQries.size());
        String qryId = (String)sqlQries.get(0).get(0);
        Assert.assertEquals((Object)qryStr, sqlQries.get(0).get(1));
        qryCanceler.accept(qryId);
        for (int i = 0; i < 3; ++i) {
            Assert.assertNotNull(iter.next());
        }
        GridTestUtils.assertThrowsWithCause(iter::next, CacheException.class);
    }

    public static void doTestCancelContinuousQuery(IgniteEx cli, List<IgniteEx> srvs, BiConsumer<UUID, UUID> qryCanceler) throws Exception {
        int i;
        IgniteCache cache = cli.cache(DEFAULT_CACHE_NAME);
        ContinuousQuery cq = new ContinuousQuery();
        AtomicInteger cntr = new AtomicInteger();
        cq.setInitialQuery((Query)new ScanQuery());
        cq.setTimeInterval(1000L);
        cq.setPageSize(5);
        cq.setLocalListener(events -> {
            for (CacheEntryEvent e : events) {
                Assert.assertNotNull((Object)e);
                cntr.incrementAndGet();
            }
        });
        cache.query((Query)cq);
        for (int i2 = 0; i2 < 25; ++i2) {
            cache.put((Object)i2, (Object)i2);
        }
        boolean res = GridTestUtils.waitForCondition(() -> cntr.get() == 25, (long)10000L);
        Assert.assertTrue((boolean)res);
        List<List<?>> cqQries = KillCommandsSQLTest.execute((Ignite)cli, "SELECT NODE_ID, ROUTINE_ID FROM SYS.CONTINUOUS_QUERIES", new Object[0]);
        Assert.assertEquals((long)1L, (long)cqQries.size());
        UUID nodeId = (UUID)cqQries.get(0).get(0);
        UUID routineId = (UUID)cqQries.get(0).get(1);
        qryCanceler.accept(nodeId, routineId);
        long cnt = cntr.get();
        for (i = 0; i < 25; ++i) {
            cache.put((Object)i, (Object)i);
        }
        res = GridTestUtils.waitForCondition(() -> (long)cntr.get() > cnt, (long)10000L);
        Assert.assertFalse((boolean)res);
        for (i = 0; i < srvs.size(); ++i) {
            IgniteEx srv = srvs.get(i);
            res = GridTestUtils.waitForCondition(() -> KillCommandsSQLTest.execute((Ignite)srv, "SELECT ROUTINE_ID FROM SYS.CONTINUOUS_QUERIES", new Object[0]).isEmpty(), (long)10000L);
            Assert.assertTrue((String)srv.configuration().getIgniteInstanceName(), (boolean)res);
        }
    }

    public static void doTestScanQueryCancel(IgniteEx cli, List<IgniteEx> srvs, Consumer<T3<UUID, String, Long>> qryCanceler) {
        int i;
        IgniteCache cache = cli.cache(DEFAULT_CACHE_NAME);
        QueryCursor qry1 = cache.query((Query)new ScanQuery().setPageSize(5));
        Iterator iter1 = qry1.iterator();
        Assert.assertNotNull(iter1.next());
        List<List<?>> scanQries0 = KillCommandsSQLTest.execute((Ignite)srvs.get(0), "SELECT ORIGIN_NODE_ID, CACHE_NAME, QUERY_ID FROM SYS.SCAN_QUERIES", new Object[0]);
        Assert.assertEquals((long)1L, (long)scanQries0.size());
        UUID originNodeId = (UUID)scanQries0.get(0).get(0);
        String cacheName = (String)scanQries0.get(0).get(1);
        long qryId = (Long)scanQries0.get(0).get(2);
        QueryCursor qry2 = cache.query((Query)new ScanQuery().setPageSize(5));
        Iterator iter2 = qry2.iterator();
        Assert.assertNotNull(iter2.next());
        qryCanceler.accept((T3<UUID, String, Long>)new T3((Object)originNodeId, (Object)cacheName, (Object)qryId));
        for (i = 0; i < 5 * srvs.size() - 1; ++i) {
            Assert.assertNotNull(iter1.next());
        }
        GridTestUtils.assertThrowsWithCause(iter1::next, IgniteCheckedException.class);
        for (i = 0; i < 24; ++i) {
            Assert.assertNotNull(iter2.next());
        }
        for (i = 0; i < srvs.size(); ++i) {
            IgniteEx ignite = srvs.get(i);
            int cacheId = CU.cacheId((String)DEFAULT_CACHE_NAME);
            GridCacheContext ctx = ignite.context().cache().context().cacheContext(cacheId);
            ConcurrentMap qryIters = ctx.queries().queryIterators();
            Assert.assertTrue((qryIters.size() <= 1 ? 1 : 0) != 0);
            if (qryIters.isEmpty()) {
                return;
            }
            GridCacheQueryManager.RequestFutureMap futs = (GridCacheQueryManager.RequestFutureMap)qryIters.get(cli.localNode().id());
            Assert.assertNotNull((Object)futs);
            Assert.assertFalse((boolean)futs.containsKey((Object)qryId));
        }
    }

    public static void doTestCancelClientConnection(List<IgniteEx> srvs, BiConsumer<UUID, Long> cliCanceler) {
        ClientConfiguration cfg = new ClientConfiguration().setAddresses(new String[]{"127.0.0.1:" + srvs.get(0).localNode().attribute("clientListenerPort")}).setAffinityAwarenessEnabled(false);
        IgniteClient cli0 = Ignition.startClient((ClientConfiguration)cfg);
        IgniteClient cli1 = Ignition.startClient((ClientConfiguration)cfg);
        IgniteClient cli2 = Ignition.startClient((ClientConfiguration)cfg);
        IgniteClient cli3 = Ignition.startClient((ClientConfiguration)new ClientConfiguration().setAddresses(new String[]{"127.0.0.1:" + srvs.get(1).localNode().attribute("clientListenerPort")}).setAffinityAwarenessEnabled(false));
        Assert.assertEquals((Object)ClusterState.ACTIVE, (Object)cli0.cluster().state());
        Assert.assertEquals((Object)ClusterState.ACTIVE, (Object)cli1.cluster().state());
        Assert.assertEquals((Object)ClusterState.ACTIVE, (Object)cli2.cluster().state());
        Assert.assertEquals((Object)ClusterState.ACTIVE, (Object)cli3.cluster().state());
        List<List<?>> conns = KillCommandsSQLTest.execute((Ignite)srvs.get(0), "SELECT CONNECTION_ID FROM SYS.CLIENT_CONNECTIONS ORDER BY 1", new Object[0]);
        cliCanceler.accept(srvs.get(0).localNode().id(), (Long)conns.get(0).get(0));
        Predicate<IgniteClient> checker = cli -> {
            try {
                return GridTestUtils.waitForCondition(() -> {
                    try {
                        cli.cluster().state();
                        return false;
                    }
                    catch (ClientConnectionException e) {
                        return true;
                    }
                }, (long)10000L);
            }
            catch (Exception e) {
                return false;
            }
        };
        Assert.assertTrue((boolean)checker.test(cli0));
        Assert.assertEquals((Object)ClusterState.ACTIVE, (Object)cli1.cluster().state());
        Assert.assertEquals((Object)ClusterState.ACTIVE, (Object)cli2.cluster().state());
        Assert.assertEquals((Object)ClusterState.ACTIVE, (Object)cli3.cluster().state());
        cliCanceler.accept(srvs.get(0).localNode().id(), null);
        Assert.assertTrue((boolean)checker.test(cli1));
        Assert.assertTrue((boolean)checker.test(cli2));
        Assert.assertEquals((Object)ClusterState.ACTIVE, (Object)cli3.cluster().state());
        cliCanceler.accept(null, null);
        Assert.assertTrue((boolean)checker.test(cli3));
    }
}

