/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.util;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.AbstractSchemaSelfTest;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.apache.ignite.util.KillCommandsTests;
import org.junit.Test;

public class KillCommandsSQLTest
extends GridCommonAbstractTest {
    public static final int NODES_CNT = 3;
    public static final String KILL_SQL_QRY = "KILL QUERY";
    public static final String KILL_CQ_QRY = "KILL CONTINUOUS";
    public static final String KILL_SCAN_QRY = "KILL SCAN";
    public static final String KILL_CLI_QRY = "KILL CLIENT";
    private static List<IgniteEx> srvs;
    private static IgniteEx startCli;
    private static IgniteEx killCli;

    protected void beforeTestsStarted() throws Exception {
        this.startGridsMultiThreaded(3);
        srvs = new ArrayList<IgniteEx>();
        for (int i = 0; i < 3; ++i) {
            srvs.add(this.grid(i));
        }
        startCli = this.startClientGrid("startClient");
        killCli = this.startClientGrid("killClient");
        srvs.get(0).cluster().state(ClusterState.ACTIVE);
        IgniteCache cache = startCli.getOrCreateCache(new CacheConfiguration("default").setIndexedTypes(new Class[]{Integer.class, Integer.class}).setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL));
        for (int i = 0; i < 25; ++i) {
            cache.put((Object)i, (Object)i);
        }
    }

    @Test
    public void testCancelSQLQuery() {
        KillCommandsTests.doTestCancelSQLQuery(startCli, qryId -> KillCommandsSQLTest.execute((Ignite)killCli, "KILL QUERY '" + qryId + "'", new Object[0]));
    }

    @Test
    public void testCancelContinuousQuery() throws Exception {
        KillCommandsTests.doTestCancelContinuousQuery(startCli, srvs, (nodeId, routineId) -> KillCommandsSQLTest.execute((Ignite)killCli, "KILL CONTINUOUS '" + nodeId.toString() + "' '" + routineId.toString() + "'", new Object[0]));
    }

    @Test
    public void testCancelScanQuery() {
        KillCommandsTests.doTestScanQueryCancel(startCli, srvs, args -> KillCommandsSQLTest.execute((Ignite)killCli, "KILL SCAN '" + args.get1() + "' '" + (String)args.get2() + "' " + args.get3(), new Object[0]));
    }

    @Test
    public void testCancelClientConnection() {
        KillCommandsTests.doTestCancelClientConnection(srvs, (nodeId, connId) -> KillCommandsSQLTest.execute(nodeId == null ? (Ignite)srvs.get(1) : G.ignite((UUID)nodeId), "KILL CLIENT " + (connId == null ? "ALL" : Long.toString(connId)), new Object[0]));
    }

    @Test
    public void testCancelUnknownSQLQuery() {
        GridTestUtils.assertThrowsWithCause(() -> KillCommandsSQLTest.execute((Ignite)killCli, "KILL QUERY '" + srvs.get(0).localNode().id().toString() + "_42'", new Object[0]), RuntimeException.class);
    }

    @Test
    public void testCancelUnknownContinuousQuery() {
        KillCommandsSQLTest.execute((Ignite)startCli, "KILL CONTINUOUS '" + srvs.get(0).localNode().id().toString() + "' '" + UUID.randomUUID() + "'", new Object[0]);
    }

    @Test
    public void testCancelUnknownScanQuery() {
        KillCommandsSQLTest.execute((Ignite)startCli, "KILL SCAN '" + killCli.localNode().id() + "' 'unknown' 1", new Object[0]);
    }

    static List<List<?>> execute(Ignite node, String sql, Object ... args) {
        SqlFieldsQuery qry = new SqlFieldsQuery(sql).setArgs(args).setSchema("PUBLIC");
        return AbstractSchemaSelfTest.queryProcessor(node).querySqlFields(qry, true).getAll();
    }
}

