/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.timeout;

import java.util.List;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.query.QueryCancelledException;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.SqlConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.timeout.TimedQueryHelper;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public class DefaultQueryTimeoutConfigurationTest
extends AbstractIndexingCommonTest {
    private long cfgDfltQryTimeout = 0L;

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        super.afterTest();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setSqlConfiguration(new SqlConfiguration().setDefaultQueryTimeout(this.getCfgDefaultQueryTimeout()));
    }

    @Test
    public void testNegativeDefaultTimeoutByConfig() throws Exception {
        this.cfgDfltQryTimeout = -1L;
        GridTestUtils.assertThrowsWithCause(() -> {
            this.startGrid(0);
            return null;
        }, IllegalArgumentException.class);
    }

    @Test
    public void testNegativeDefaultTimeout() throws Exception {
        this.startGrid(0);
        GridTestUtils.assertThrowsWithCause(() -> {
            try {
                this.setDefaultQueryTimeout(-1);
            }
            catch (IgniteCheckedException e) {
                throw new RuntimeException("Unexpected", e);
            }
        }, IllegalArgumentException.class);
    }

    @Test
    public void testZeroDefaultTimeout() throws Exception {
        this.startGrid(0);
        this.setDefaultQueryTimeout(0);
    }

    @Test
    public void testPositiveDefaultTimeout() throws Exception {
        this.startGrid(0);
        this.setDefaultQueryTimeout(1);
    }

    @Test
    public void testTooBigDefaultTimeout() throws Exception {
        this.cfgDfltQryTimeout = 0x80000000L;
        DefaultQueryTimeoutConfigurationTest.assertTrue((this.cfgDfltQryTimeout > Integer.MAX_VALUE ? 1 : 0) != 0);
        GridTestUtils.assertThrowsWithCause(() -> {
            this.startGrid(0);
            return null;
        }, IllegalArgumentException.class);
    }

    @Test
    public void testChangeDefaultTimeout() throws Exception {
        this.startGrids(2);
        this.startClientGrid(2);
        this.setDefaultQueryTimeout(5000);
        TimedQueryHelper helper = new TimedQueryHelper(2000L, "default");
        helper.createCache((Ignite)this.grid(0));
        String sql = helper.buildTimedQuery();
        for (Ignite ign : G.allGrids()) {
            this.executeQuery(ign, sql);
        }
        this.setDefaultQueryTimeout(500);
        for (Ignite ign : G.allGrids()) {
            GridTestUtils.assertThrowsWithCause(() -> this.executeQuery(ign, sql), QueryCancelledException.class);
        }
    }

    private long getCfgDefaultQueryTimeout() {
        return this.cfgDfltQryTimeout;
    }

    private List<List<?>> executeQuery(Ignite ign, String sql) {
        SqlFieldsQuery qry = new SqlFieldsQuery(sql);
        return ((IgniteEx)ign).context().query().querySqlFields(qry, false).getAll();
    }

    private void setDefaultQueryTimeout(int timeout) throws IgniteCheckedException {
        ((IgniteH2Indexing)this.grid(0).context().query().getIndexing()).distributedConfiguration().defaultQueryTimeout(timeout);
        DefaultQueryTimeoutConfigurationTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> {
            for (Ignite ign : G.allGrids()) {
                if (((IgniteH2Indexing)((IgniteEx)ign).context().query().getIndexing()).distributedConfiguration().defaultQueryTimeout() == timeout) continue;
                return false;
            }
            return true;
        }, (long)2000L));
    }
}

