/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.persistence.IgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.ReadWriteMetastorage;
import org.apache.ignite.internal.processors.metastorage.persistence.ReadWriteMetaStorageMock;
import org.apache.ignite.internal.processors.query.stat.IgniteStatisticsPersistenceStoreImpl;
import org.apache.ignite.internal.processors.query.stat.ObjectPartitionStatisticsImpl;
import org.apache.ignite.internal.processors.query.stat.StatisticsAbstractTest;
import org.apache.ignite.internal.processors.query.stat.StatisticsKey;
import org.apache.ignite.internal.processors.subscription.GridInternalSubscriptionProcessor;
import org.junit.Test;
import org.mockito.Mockito;

public class StatisticsStorageRestartTest
extends StatisticsAbstractTest {
    private GridInternalSubscriptionProcessor subscriptionProcessor;
    private ReadWriteMetaStorageMock metastorage;
    private IgniteStatisticsPersistenceStoreImpl statStore;
    private StatisticsKey k1 = new StatisticsKey("A", "B");
    private ObjectPartitionStatisticsImpl stat1_1 = this.getPartitionStatistics(1);
    private StatisticsKey k2 = new StatisticsKey("A", "B2");
    private ObjectPartitionStatisticsImpl stat2_2 = this.getPartitionStatistics(2);
    private ObjectPartitionStatisticsImpl stat2_3 = this.getPartitionStatistics(3);

    public void beforeTest() {
        this.subscriptionProcessor = (GridInternalSubscriptionProcessor)Mockito.mock(GridInternalSubscriptionProcessor.class);
        this.metastorage = new ReadWriteMetaStorageMock();
        this.statStore = new IgniteStatisticsPersistenceStoreImpl(this.subscriptionProcessor, new IgniteCacheDatabaseSharedManager(){}, cls -> log);
    }

    @Test
    public void testRestart() throws IgniteCheckedException {
        this.statStore.onReadyForReadWrite((ReadWriteMetastorage)this.metastorage);
        this.statStore.saveLocalPartitionStatistics(this.k1, this.stat1_1);
        this.statStore.replaceLocalPartitionsStatistics(this.k2, Arrays.asList(this.stat2_2, this.stat2_3));
        StatisticsStorageRestartTest.assertEquals((int)1, (int)this.statStore.getLocalPartitionsStatistics(this.k1).size());
        StatisticsStorageRestartTest.assertEquals((Object)this.stat1_1, (Object)this.statStore.getLocalPartitionStatistics(this.k1, 1));
        StatisticsStorageRestartTest.assertEquals((int)2, (int)this.statStore.getLocalPartitionsStatistics(this.k2).size());
        StatisticsStorageRestartTest.assertEquals((Object)this.stat2_2, (Object)this.statStore.getLocalPartitionStatistics(this.k2, 2));
        StatisticsStorageRestartTest.assertEquals((Object)this.stat2_3, (Object)this.statStore.getLocalPartitionStatistics(this.k2, 3));
        IgniteStatisticsPersistenceStoreImpl statStore2 = new IgniteStatisticsPersistenceStoreImpl(this.subscriptionProcessor, new IgniteCacheDatabaseSharedManager(){}, cls -> log);
        statStore2.onReadyForReadWrite((ReadWriteMetastorage)this.metastorage);
        StatisticsStorageRestartTest.assertEquals((int)1, (int)statStore2.getLocalPartitionsStatistics(this.k1).size());
        StatisticsStorageRestartTest.assertEquals((Object)this.stat1_1, (Object)statStore2.getLocalPartitionStatistics(this.k1, 1));
        StatisticsStorageRestartTest.assertEquals((int)2, (int)statStore2.getLocalPartitionsStatistics(this.k2).size());
        StatisticsStorageRestartTest.assertEquals((Object)this.stat2_2, (Object)statStore2.getLocalPartitionStatistics(this.k2, 2));
        StatisticsStorageRestartTest.assertEquals((Object)this.stat2_3, (Object)statStore2.getLocalPartitionStatistics(this.k2, 3));
    }

    @Test
    public void testUnreadableStatistics() throws IgniteCheckedException {
        this.statStore.onReadyForReadWrite((ReadWriteMetastorage)this.metastorage);
        this.statStore.saveLocalPartitionStatistics(this.k1, this.stat1_1);
        this.statStore.replaceLocalPartitionsStatistics(this.k2, Arrays.asList(this.stat2_2, this.stat2_3));
        String statKeyInvalid = String.format("stats.data.%s.%s.%d", this.k1.schema(), this.k1.obj(), 1000);
        this.metastorage.write(statKeyInvalid, (Serializable)new byte[2]);
        String outerStatKey = "some.key.1";
        byte[] outerStatValue = new byte[]{1, 2};
        this.metastorage.write(outerStatKey, (Serializable)outerStatValue);
        IgniteStatisticsPersistenceStoreImpl statStore2 = new IgniteStatisticsPersistenceStoreImpl(this.subscriptionProcessor, new IgniteCacheDatabaseSharedManager(){}, cls -> log);
        statStore2.onReadyForReadWrite((ReadWriteMetastorage)this.metastorage);
        StatisticsStorageRestartTest.assertNull((Object)this.metastorage.read(statKeyInvalid));
        StatisticsStorageRestartTest.assertTrue((boolean)this.statStore.getLocalPartitionsStatistics(this.k1).isEmpty());
        StatisticsStorageRestartTest.assertFalse((boolean)this.statStore.getLocalPartitionsStatistics(this.k2).isEmpty());
        StatisticsStorageRestartTest.assertTrue((boolean)Arrays.equals(outerStatValue, (byte[])this.metastorage.read(outerStatKey)));
    }
}

