/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat;

import java.io.Serializable;
import java.util.Map;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.query.stat.IgniteStatisticsHelper;
import org.apache.ignite.internal.processors.query.stat.ObjectStatisticsImpl;
import org.apache.ignite.internal.processors.query.stat.StatisticsAbstractTest;
import org.apache.ignite.internal.processors.query.stat.StatisticsTarget;
import org.apache.ignite.internal.util.collection.IntMap;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public class StatisticsObsolescenceTest
extends StatisticsAbstractTest {
    @Test
    public void testObsolescence() throws Exception {
        this.startGridsMultiThreaded(1);
        this.createSmallTable(null);
        this.statisticsMgr(0).collectStatistics(IgniteStatisticsHelper.buildDefaultConfigurations((StatisticsTarget[])new StatisticsTarget[]{SMALL_TARGET}));
        StatisticsObsolescenceTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> this.statisticsMgr(0).getLocalStatistics(SMALL_KEY) != null, (long)3000L));
        ObjectStatisticsImpl stat1 = (ObjectStatisticsImpl)this.statisticsMgr(0).getLocalStatistics(SMALL_KEY);
        StatisticsObsolescenceTest.assertNotNull((Object)stat1);
        for (int i = 100; i < 200; ++i) {
            this.sql(String.format("INSERT INTO small(a, b, c) VALUES(%d, %d, %d)", i, i, i % 10));
        }
        this.statisticsMgr(0).processObsolescence();
        StatisticsObsolescenceTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> {
            ObjectStatisticsImpl stat2 = (ObjectStatisticsImpl)this.statisticsMgr(0).getLocalStatistics(SMALL_KEY);
            return stat2.rowCount() > stat1.rowCount();
        }, (long)3000L));
    }

    @Test
    public void testInactiveLoad() throws Exception {
        IgniteEx ignite = this.startGrid(0);
        IgniteEx ignite1 = this.startGrid(1);
        ignite.cluster().state(ClusterState.ACTIVE);
        this.createSmallTable(null);
        this.sql("ANALYZE SMALL");
        ignite.cluster().state(ClusterState.INACTIVE);
        ignite1.close();
        Map statObs = (Map)GridTestUtils.getFieldValue((Object)this.statisticsMgr(0).statisticsRepository(), (String[])new String[]{"statObs"});
        Integer oldSize = ((IntMap)statObs.get(SMALL_KEY)).size();
        ignite.cluster().state(ClusterState.ACTIVE);
        StatisticsObsolescenceTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> ((IntMap)statObs.get(SMALL_KEY)).size() > oldSize, (long)3000L));
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setConsistentId((Serializable)((Object)igniteInstanceName));
        DataStorageConfiguration memCfg = new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true));
        cfg.setDataStorageConfiguration(memCfg);
        return cfg;
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }
}

