/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.processors.cache.persistence.IgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.stat.ColumnStatistics;
import org.apache.ignite.internal.processors.query.stat.IgniteStatisticsHelper;
import org.apache.ignite.internal.processors.query.stat.IgniteStatisticsManager;
import org.apache.ignite.internal.processors.query.stat.IgniteStatisticsManagerImpl;
import org.apache.ignite.internal.processors.query.stat.ObjectStatisticsImpl;
import org.apache.ignite.internal.processors.query.stat.StatisticsAbstractTest;
import org.apache.ignite.internal.processors.query.stat.StatisticsKey;
import org.apache.ignite.internal.processors.query.stat.StatisticsTarget;
import org.apache.ignite.internal.processors.query.stat.StatisticsUsageState;
import org.apache.ignite.internal.processors.query.stat.config.StatisticsColumnConfiguration;
import org.apache.ignite.internal.processors.query.stat.config.StatisticsObjectConfiguration;
import org.apache.ignite.internal.processors.query.stat.messages.StatisticsObjectData;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.ListeningTestLogger;
import org.apache.ignite.testframework.LogListener;
import org.jetbrains.annotations.NotNull;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class StatisticsConfigurationTest
extends StatisticsAbstractTest {
    private static final String[] COLUMNS = new String[]{"A", "B", "C"};
    private LogListener obsolescenceLsnr = LogListener.matches((String)"Unable to save statistics obsolescence info on non server node.").build();
    private final ListeningTestLogger obsolescenceAwareLog = new ListeningTestLogger(this.log(), new LogListener[]{this.obsolescenceLsnr});
    @Parameterized.Parameter(value=0)
    public boolean persist;
    private Consumer<List<ObjectStatisticsImpl>> checkTotalRows = stats -> {
        long rows = stats.stream().mapToLong(s -> {
            StatisticsConfigurationTest.assertNotNull((Object)s);
            return s.rowCount();
        }).sum();
        StatisticsConfigurationTest.assertEquals((long)100L, (long)rows);
    };
    private Consumer<List<ObjectStatisticsImpl>> checkColumStats = stats -> {
        for (ObjectStatisticsImpl stat : stats) {
            for (String col : COLUMNS) {
                ColumnStatistics colStat = stat.columnStatistics(col);
                StatisticsConfigurationTest.assertNotNull((String)("Column: " + col), (Object)colStat);
                StatisticsConfigurationTest.assertTrue((String)("Column: " + col), (colStat.distinct() > 0L ? 1 : 0) != 0);
                StatisticsConfigurationTest.assertTrue((String)("Column: " + col), (colStat.max().getInt() > 0 ? 1 : 0) != 0);
                StatisticsConfigurationTest.assertTrue((String)("Column: " + col), (colStat.total() == stat.rowCount() ? 1 : 0) != 0);
            }
        }
    };

    @Parameterized.Parameters(name="persist={0}")
    public static List<Object[]> parameters() {
        boolean[] arrBool;
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (boolean persist0 : arrBool = new boolean[]{true, false}) {
            params.add(new Object[]{persist0});
        }
        return params;
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(this.persist))).setGridLogger((IgniteLogger)this.obsolescenceAwareLog);
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        super.afterTest();
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.cleanPersistenceDir();
    }

    protected IgniteEx startGridAndChangeBaseline(int nodeIdx) throws Exception {
        System.out.println("+++ START " + nodeIdx);
        IgniteEx ign = this.startGrid(nodeIdx);
        ign.cluster().state(ClusterState.ACTIVE);
        if (this.persist) {
            ign.cluster().setBaselineTopology(ign.cluster().topologyVersion());
        }
        this.awaitPartitionMapExchange();
        return ign;
    }

    protected void stopGridAndChangeBaseline(int nodeIdx) {
        System.out.println("+++ STOP " + nodeIdx);
        this.stopGrid(nodeIdx);
        if (this.persist) {
            ((Ignite)F.first((List)G.allGrids())).cluster().setBaselineTopology(((Ignite)F.first((List)G.allGrids())).cluster().topologyVersion());
        }
        try {
            this.awaitPartitionMapExchange();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Test
    public void updateStatisticsOnRestartSingleNode() throws Exception {
        if (!this.persist) {
            return;
        }
        this.startGridAndChangeBaseline(0);
        this.createSmallTable(null);
        this.collectStatistics(SMALL_TARGET);
        this.waitForStats("PUBLIC", "SMALL", 3000L, this.checkTotalRows, this.checkColumStats);
        this.stopGrid(0);
        this.startGrid(0);
        this.grid(0).cluster().state(ClusterState.ACTIVE);
        this.waitForStats("PUBLIC", "SMALL", 3000L, this.checkTotalRows, this.checkColumStats);
    }

    @Test
    public void stopNodeWithoutChangeBaseline() throws Exception {
        this.startGrids(2);
        this.grid(0).cluster().state(ClusterState.ACTIVE);
        this.createSmallTable(null);
        this.collectStatistics(SMALL_TARGET);
        this.waitForStats("PUBLIC", "SMALL", 3000L, this.checkTotalRows, this.checkColumStats);
        this.stopGrid(1);
        this.waitForStats("PUBLIC", "SMALL", 3000L, this.checkTotalRows, this.checkColumStats);
    }

    @Test
    public void checkClientNode() throws Exception {
        this.startGridAndChangeBaseline(0);
        this.createSmallTable(null);
        IgniteEx client = this.startClientGrid("cli");
        this.collectStatistics(SMALL_TARGET);
        this.sql("delete from small");
        for (int i = 0; i < 1000; ++i) {
            this.sql(String.format("INSERT INTO small(a, b, c) VALUES(%d, %d, %d)", i, i, i % 10));
        }
        StatisticsObjectConfiguration smallCfg = this.statisticsMgr(0).statisticConfiguration().config(SMALL_KEY);
        this.statisticsMgr(client).refreshStatistics(new StatisticsTarget[]{SMALL_TARGET});
        Thread.sleep(100L);
        StatisticsObjectConfiguration smallCfg2 = this.statisticsMgr(0).statisticConfiguration().config(SMALL_KEY);
        StatisticsConfigurationTest.assertNotSame((Object)((StatisticsColumnConfiguration)smallCfg.columns().get("A")).version(), (Object)((StatisticsColumnConfiguration)smallCfg2.columns().get("A")).version());
        client.cluster().state(ClusterState.INACTIVE);
        client.cluster().state(ClusterState.ACTIVE);
        StatisticsConfigurationTest.assertFalse((boolean)this.obsolescenceLsnr.check(3000L));
    }

    @Test
    public void updateStatisticsOnChangeTopology() throws Exception {
        log.info("Starting server 0 node");
        this.startGridAndChangeBaseline(0);
        this.createSmallTable(null);
        this.collectStatistics(SMALL_TARGET);
        this.waitForStats("PUBLIC", "SMALL", 3000L, this.checkTotalRows, this.checkColumStats);
        log.info("Starting client cli node");
        this.startClientGrid("cli");
        log.info("Starting server 1 node");
        this.startGridAndChangeBaseline(1);
        this.waitForStats("PUBLIC", "SMALL", 3000L, this.checkTotalRows, this.checkColumStats);
        log.info("Starting server 2 node");
        this.startGridAndChangeBaseline(2);
        this.waitForStats("PUBLIC", "SMALL", 3000L, this.checkTotalRows, this.checkColumStats);
        log.info("Starting server 2 node");
        this.startGridAndChangeBaseline(3);
        this.waitForStats("PUBLIC", "SMALL", 3000L, this.checkTotalRows, this.checkColumStats);
        log.info("Stoppping server 0 node");
        this.stopGridAndChangeBaseline(0);
        this.waitForStats("PUBLIC", "SMALL", 3000L, this.checkTotalRows, this.checkColumStats);
        log.info("Stopping server 2 node");
        this.stopGridAndChangeBaseline(2);
        this.waitForStats("PUBLIC", "SMALL", 3000L, this.checkTotalRows, this.checkColumStats);
        log.info("Stopping server 3 node");
        this.stopGridAndChangeBaseline(3);
        this.waitForStats("PUBLIC", "SMALL", 3000L, this.checkTotalRows, this.checkColumStats);
        log.info("Starting server 3 node");
        this.startGridAndChangeBaseline(3);
        this.waitForStats("PUBLIC", "SMALL", 3000L, this.checkTotalRows, this.checkColumStats);
    }

    @Test
    public void dropUpdate() throws Exception {
        this.startGrids(3);
        this.grid(0).cluster().state(ClusterState.ACTIVE);
        this.createSmallTable(null);
        this.collectStatistics(SMALL_TARGET);
        this.waitForStats("PUBLIC", "SMALL", 3000L, this.checkTotalRows, this.checkColumStats);
        this.statisticsMgr(0).dropStatistics(new StatisticsTarget[]{new StatisticsTarget("PUBLIC", "SMALL", new String[]{"A"})});
        this.waitForStats("PUBLIC", "SMALL", 3000L, stats -> stats.forEach(s -> StatisticsConfigurationTest.assertNull((Object)s.columnStatistics("A"))));
        this.collectStatistics(new StatisticsTarget("PUBLIC", "SMALL", new String[]{"A"}));
        this.waitForStats("PUBLIC", "SMALL", 3000L, this.checkTotalRows, this.checkColumStats);
    }

    @Test
    public void dropSingleColumnStatisticWhileNodeDown() throws Exception {
        this.startGrids(3);
        this.grid(0).cluster().state(ClusterState.ACTIVE);
        this.createSmallTable(null);
        this.collectStatistics(SMALL_TARGET);
        this.waitForStats("PUBLIC", "SMALL", 3000L, this.checkTotalRows, this.checkColumStats);
        this.stopGrid(1);
        this.statisticsMgr(0).dropStatistics(new StatisticsTarget[]{new StatisticsTarget("PUBLIC", "SMALL", new String[]{"A"})});
        this.waitForStats("PUBLIC", "SMALL", 3000L, stats -> stats.forEach(s -> StatisticsConfigurationTest.assertNull((String)("Invalid stats: " + stats), (Object)s.columnStatistics("A"))));
        this.checkStatisticsInMetastore(this.grid(0).context().cache().context().database(), 3000L, "PUBLIC", "SMALL", s -> StatisticsConfigurationTest.assertNull(s.data().get("A")));
        this.checkStatisticsInMetastore(this.grid(2).context().cache().context().database(), 3000L, "PUBLIC", "SMALL", s -> StatisticsConfigurationTest.assertNull(s.data().get("A")));
        this.startGrid(1);
        this.checkStatisticsInMetastore(this.grid(1).context().cache().context().database(), 3000L, "PUBLIC", "SMALL", s -> StatisticsConfigurationTest.assertNull(s.data().get("A")));
        this.waitForStats("PUBLIC", "SMALL", 3000L, this.checkTotalRows, stats -> stats.forEach(s -> StatisticsConfigurationTest.assertNull((String)("Invalid stats: " + stats), (Object)s.columnStatistics("A"))));
    }

    @Test
    public void testOrphanDataCleanup() throws Exception {
        this.startGrids(2);
        this.grid(0).cluster().state(ClusterState.ACTIVE);
        this.createSmallTable(null);
        this.collectStatistics(SMALL_TARGET);
        this.waitForStats("PUBLIC", "SMALL", 3000L, this.checkTotalRows, this.checkColumStats);
        this.statisticsMgr(0).statisticConfiguration().stop();
        this.statisticsMgr(1).statisticConfiguration().stop();
        this.dropSmallTable(null);
        this.waitForStats("PUBLIC", "SMALL", 3000L, stats -> stats.forEach(s -> StatisticsConfigurationTest.assertNotNull((Object)s)));
        this.checkStatisticsInMetastore(this.grid(0).context().cache().context().database(), 3000L, "PUBLIC", "SMALL", s -> StatisticsConfigurationTest.assertNotNull(s.data().get("A")));
        this.grid(0).cluster().state(ClusterState.INACTIVE);
        this.grid(0).cluster().state(ClusterState.ACTIVE);
        this.waitForStats("PUBLIC", "SMALL", 3000L, stats -> stats.forEach(s -> StatisticsConfigurationTest.assertNull((Object)s)));
        this.checkStatisticsInMetastore(this.grid(0).context().cache().context().database(), 3000L, "PUBLIC", "SMALL", s -> StatisticsConfigurationTest.assertNull(s.data().get("A")));
    }

    @Test
    public void dropTable() throws Exception {
        this.startGrids(3);
        this.grid(0).cluster().state(ClusterState.ACTIVE);
        this.createSmallTable(null);
        this.createSmallTable("_A");
        this.collectStatistics(new StatisticsTarget("PUBLIC", "SMALL", new String[0]), new StatisticsTarget("PUBLIC", "SMALL_A", new String[0]));
        this.waitForStats("PUBLIC", "SMALL", 3000L, this.checkTotalRows, this.checkColumStats);
        this.waitForStats("PUBLIC", "SMALL_A", 3000L, this.checkTotalRows, this.checkColumStats);
        this.dropSmallTable(null);
        this.waitForStats("PUBLIC", "SMALL", 3000L, stats -> stats.forEach(s -> StatisticsConfigurationTest.assertNull((Object)s)));
        this.waitForStats("PUBLIC", "SMALL_A", 3000L, this.checkTotalRows, this.checkColumStats);
        for (Ignite ign : G.allGrids()) {
            this.checkStatisticsInMetastore(((IgniteEx)ign).context().cache().context().database(), 3000L, "PUBLIC", "SMALL", s -> StatisticsConfigurationTest.assertNull((Object)s));
        }
    }

    @Test
    public void dropColumn() throws Exception {
        this.startGrids(3);
        this.grid(0).cluster().state(ClusterState.ACTIVE);
        this.createSmallTable(null);
        this.collectStatistics(SMALL_TARGET);
        this.waitForStats("PUBLIC", "SMALL", 3000L, this.checkTotalRows, this.checkColumStats);
        this.sql("DROP INDEX SMALL_B");
        this.sql("ALTER TABLE SMALL DROP COLUMN B");
        this.waitForStats("PUBLIC", "SMALL", 3000L, stats -> stats.forEach(s -> {
            StatisticsConfigurationTest.assertNotNull((Object)s.columnStatistics("A"));
            StatisticsConfigurationTest.assertNotNull((Object)s.columnStatistics("C"));
            StatisticsConfigurationTest.assertNull((Object)s.columnStatistics("B"));
        }));
        for (Ignite ign : G.allGrids()) {
            this.checkStatisticsInMetastore(((IgniteEx)ign).context().cache().context().database(), 3000L, "PUBLIC", "SMALL", s -> StatisticsConfigurationTest.assertNull(s.data().get("B")));
        }
    }

    @Test
    public void dropColumnWhileNodeDown() throws Exception {
        if (this.persist) {
            return;
        }
        this.startGrids(3);
        this.grid(0).cluster().state(ClusterState.ACTIVE);
        this.createSmallTable(null);
        this.collectStatistics(SMALL_TARGET);
        this.waitForStats("PUBLIC", "SMALL", 3000L, this.checkTotalRows, this.checkColumStats);
        this.stopGrid(2);
        this.sql("DROP INDEX SMALL_B");
        this.sql("ALTER TABLE SMALL DROP COLUMN B");
        this.startGrid(2);
        this.waitForStats("PUBLIC", "SMALL", 3000L, stats -> stats.forEach(s -> {
            StatisticsConfigurationTest.assertNotNull((Object)s.columnStatistics("A"));
            StatisticsConfigurationTest.assertNotNull((Object)s.columnStatistics("C"));
            StatisticsConfigurationTest.assertNull((Object)s.columnStatistics("B"));
        }));
        for (Ignite ign : G.allGrids()) {
            this.checkStatisticsInMetastore(((IgniteEx)ign).context().cache().context().database(), 3000L, "PUBLIC", "SMALL", s -> StatisticsConfigurationTest.assertNull(s.data().get("B")));
        }
    }

    @Test
    public void testChangeState() throws Exception {
        IgniteEx ign0 = this.startGrids(2);
        ign0.cluster().state(ClusterState.ACTIVE);
        IgniteEx ign1 = this.grid(1);
        StatisticsConfigurationTest.assertEquals((Object)StatisticsUsageState.ON, (Object)this.statisticsMgr(0).usageState());
        this.createSmallTable(null);
        StatisticsConfigurationTest.assertTrue((boolean)this.executeStatisticsConfigurationCommands(ign0));
        StatisticsConfigurationTest.assertTrue((boolean)this.executeStatisticsConfigurationCommands(ign1));
        this.statisticsMgr(0).usageState(StatisticsUsageState.NO_UPDATE);
        StatisticsConfigurationTest.assertTrue((boolean)this.executeStatisticsConfigurationCommands(ign0));
        StatisticsConfigurationTest.assertTrue((boolean)this.executeStatisticsConfigurationCommands(ign1));
        this.statisticsMgr(0).usageState(StatisticsUsageState.OFF);
        StatisticsConfigurationTest.assertFalse((boolean)this.executeStatisticsConfigurationCommands(ign0));
        StatisticsConfigurationTest.assertFalse((boolean)this.executeStatisticsConfigurationCommands(ign1));
        this.statisticsMgr(0).usageState(StatisticsUsageState.NO_UPDATE);
        StatisticsConfigurationTest.assertTrue((boolean)this.executeStatisticsConfigurationCommands(ign0));
        StatisticsConfigurationTest.assertTrue((boolean)this.executeStatisticsConfigurationCommands(ign1));
        this.statisticsMgr(0).usageState(StatisticsUsageState.ON);
        StatisticsConfigurationTest.assertTrue((boolean)this.executeStatisticsConfigurationCommands(ign0));
        StatisticsConfigurationTest.assertTrue((boolean)this.executeStatisticsConfigurationCommands(ign1));
    }

    private boolean executeStatisticsConfigurationCommands(IgniteEx ign) throws IgniteInterruptedCheckedException {
        int success;
        block11: {
            IgniteStatisticsManagerImpl statMgr;
            block10: {
                block9: {
                    statMgr = this.statisticsMgr(ign);
                    success = 0;
                    try {
                        statMgr.collectStatistics(IgniteStatisticsHelper.buildDefaultConfigurations((StatisticsTarget[])new StatisticsTarget[]{SMALL_TARGET}));
                        ++success;
                    }
                    catch (Exception e) {
                        if (e instanceof IgniteException && e.getMessage().contains("while statistics usage state is OFF.")) break block9;
                        StatisticsConfigurationTest.fail((String)("Unknown error: " + e));
                    }
                }
                if (GridTestUtils.waitForCondition(() -> StatisticsConfigurationTest.lambda$executeStatisticsConfigurationCommands$27((IgniteStatisticsManager)statMgr), (long)3000L)) {
                    ++success;
                }
                try {
                    statMgr.refreshStatistics(new StatisticsTarget[]{SMALL_TARGET});
                    ++success;
                }
                catch (Exception e) {
                    if (e instanceof IgniteException && e.getMessage().contains("while statistics usage state is OFF.")) break block10;
                    StatisticsConfigurationTest.fail((String)("Unknown error: " + e));
                }
            }
            try {
                statMgr.dropStatistics(new StatisticsTarget[]{SMALL_TARGET});
                ++success;
            }
            catch (Exception e) {
                if (e instanceof IgniteException && e.getMessage().contains("while statistics usage state is OFF.")) break block11;
                StatisticsConfigurationTest.fail((String)("Unknown error: " + e));
            }
        }
        if (success == 4) {
            return true;
        }
        if (success == 0) {
            return false;
        }
        StatisticsConfigurationTest.fail((String)"Partially success execution");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkStatisticsInMetastore(IgniteCacheDatabaseSharedManager db, long timeout, String schema, String obj, Consumer<StatisticsObjectData> ... checkers) throws IgniteCheckedException {
        if (!this.persist) {
            return;
        }
        long t0 = U.currentTimeMillis();
        while (true) {
            db.checkpointReadLock();
            try {
                db.metaStorage().iterate("stats.data." + schema + '.' + obj + '.', (k, v) -> Arrays.stream(checkers).forEach(ch -> ch.accept((StatisticsObjectData)v)), true);
                return;
            }
            catch (Throwable ex) {
                if (t0 + timeout < U.currentTimeMillis()) {
                    throw ex;
                }
                U.sleep((long)200L);
                continue;
            }
            finally {
                db.checkpointReadUnlock();
                continue;
            }
            break;
        }
    }

    private void waitForStats(String schema, String objName, long timeout, Consumer<List<ObjectStatisticsImpl>> ... statsCheckers) {
        long t0 = U.currentTimeMillis();
        while (true) {
            try {
                List<ObjectStatisticsImpl> stats = this.statisticsAllNodes(schema, objName);
                for (Consumer<List<ObjectStatisticsImpl>> statChecker : statsCheckers) {
                    statChecker.accept(stats);
                }
                return;
            }
            catch (Throwable ex) {
                if (t0 + timeout < U.currentTimeMillis()) {
                    log.error("Unexpected stats");
                    List<ObjectStatisticsImpl> stats = this.statisticsAllNodes(schema, objName);
                    stats.forEach(s -> log.error("Stat: " + s));
                    throw ex;
                }
                try {
                    U.sleep((long)200L);
                }
                catch (IgniteInterruptedCheckedException igniteInterruptedCheckedException) {
                }
                continue;
            }
            break;
        }
    }

    @NotNull
    private List<ObjectStatisticsImpl> statisticsAllNodes(String schema, String objName) {
        List mgrs = G.allGrids().stream().filter(ign -> !((IgniteEx)ign).context().clientNode()).map(ign -> ((IgniteH2Indexing)((IgniteEx)ign).context().query().getIndexing()).statsManager()).collect(Collectors.toList());
        return mgrs.stream().map(m -> (ObjectStatisticsImpl)m.getLocalStatistics(new StatisticsKey(schema, objName))).collect(Collectors.toList());
    }

    private static /* synthetic */ boolean lambda$executeStatisticsConfigurationCommands$27(IgniteStatisticsManager statMgr) {
        return statMgr.getLocalStatistics(SMALL_KEY) != null;
    }
}

