/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.util.Collections;
import java.util.List;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.cache.CacheKeyConfiguration;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.query.h2.twostep.AbstractPartitionPruningBaseTest;
import org.apache.ignite.internal.util.typedef.F;
import org.junit.Test;

public class JoinPartitionPruningSelfTest
extends AbstractPartitionPruningBaseTest {
    @Override
    protected void beforeTest() throws Exception {
        super.beforeTest();
        JoinPartitionPruningSelfTest.clearIoState();
    }

    @Test
    public void testSimpleJoin() {
        this.createPartitionedTable("t1", this.pkColumn("k1"), "v2");
        this.createPartitionedTable("t2", this.pkColumn("k1"), this.affinityColumn("ak2"), "v3");
        this.executeSql("INSERT INTO t1 VALUES ('1', '1')", new Object[0]);
        this.executeSql("INSERT INTO t2 VALUES ('1', '1', '1')", new Object[0]);
        this.executeSql("INSERT INTO t1 VALUES ('2', '2')", new Object[0]);
        this.executeSql("INSERT INTO t2 VALUES ('2', '2', '2')", new Object[0]);
        this.executeSql("INSERT INTO t1 VALUES ('3', '3')", new Object[0]);
        this.executeSql("INSERT INTO t2 VALUES ('3', '3', '3')", new Object[0]);
        this.executeSql("INSERT INTO t1 VALUES ('4', '4')", new Object[0]);
        this.executeSql("INSERT INTO t2 VALUES ('4', '4', '4')", new Object[0]);
        this.executeSql("INSERT INTO t1 VALUES ('5', '5')", new Object[0]);
        this.executeSql("INSERT INTO t2 VALUES ('5', '5', '5')", new Object[0]);
        this.execute("SELECT * FROM t1 INNER JOIN t2 ON t1.k1 = t2.ak2 WHERE t1.k1 = ?", res -> {
            JoinPartitionPruningSelfTest.assertPartitions(this.partition("t1", "1"));
            JoinPartitionPruningSelfTest.assertEquals((int)1, (int)res.size());
            JoinPartitionPruningSelfTest.assertEquals((Object)"1", ((List)res.get(0)).get(0));
        }, "1");
        this.execute("SELECT * FROM t1 INNER JOIN t2 ON t1.k1 = t2.ak2 WHERE t1._KEY = ?", res -> {
            JoinPartitionPruningSelfTest.assertPartitions(this.partition("t1", "2"));
            JoinPartitionPruningSelfTest.assertEquals((int)1, (int)res.size());
            JoinPartitionPruningSelfTest.assertEquals((Object)"2", ((List)res.get(0)).get(0));
        }, "2");
        this.execute("SELECT * FROM t1 INNER JOIN t2 ON t1.k1 = t2.ak2 WHERE t2.k1 = ?", res -> {
            JoinPartitionPruningSelfTest.assertNoPartitions();
            JoinPartitionPruningSelfTest.assertEquals((int)1, (int)res.size());
            JoinPartitionPruningSelfTest.assertEquals((Object)"3", ((List)res.get(0)).get(0));
        }, "3");
        this.execute("SELECT * FROM t1 INNER JOIN t2 ON t1.k1 = t2.ak2 WHERE t2.ak2 = ?", res -> {
            JoinPartitionPruningSelfTest.assertPartitions(this.partition("t2", "4"));
            JoinPartitionPruningSelfTest.assertEquals((int)1, (int)res.size());
            JoinPartitionPruningSelfTest.assertEquals((Object)"4", ((List)res.get(0)).get(0));
        }, "4");
        BinaryObject key = this.client().binary().builder("t2_key").setField("k1", (Object)"5").setField("ak2", (Object)"5").build();
        List<List<?>> res2 = this.executeSingle("SELECT * FROM t1 INNER JOIN t2 ON t1.k1 = t2.ak2 WHERE t2._KEY = ?", key);
        JoinPartitionPruningSelfTest.assertPartitions(this.partition("t2", "5"));
        JoinPartitionPruningSelfTest.assertEquals((int)1, (int)res2.size());
        JoinPartitionPruningSelfTest.assertEquals((Object)"5", res2.get(0).get(0));
    }

    @Test
    public void testPartitionTransfer() {
        this.createPartitionedTable("t1", this.pkColumn("k1"), "v2");
        this.createPartitionedTable("t2", this.pkColumn("k1"), this.affinityColumn("ak2"), "v3");
        this.createPartitionedTable("t3", this.pkColumn("k1"), this.affinityColumn("ak2"), "v3", "v4");
        this.execute("SELECT * FROM t1 INNER JOIN t2 ON t1.k1 = t2.ak2 WHERE t1.k1 = ? AND t2.ak2 = ?", res -> JoinPartitionPruningSelfTest.assertPartitions(this.partition("t1", "1")), "1", "1");
        this.execute("SELECT * FROM t1 INNER JOIN t2 ON t1.k1 = t2.ak2 WHERE t1.k1 = ? AND t2.ak2 = ?", res -> JoinPartitionPruningSelfTest.assertNoRequests(), "1", "2");
        this.execute("SELECT * FROM t1 INNER JOIN t2 ON t1.k1 = t2.ak2 WHERE t1.k1 = ? AND t2.ak2 IN (?, ?)", res -> JoinPartitionPruningSelfTest.assertPartitions(this.partition("t1", "1")), "1", "1", "2");
        this.execute("SELECT * FROM t1 INNER JOIN t2 ON t1.k1 = t2.ak2 WHERE t1.k1 = ? AND t2.ak2 IN (?, ?)", res -> JoinPartitionPruningSelfTest.assertNoRequests(), "1", "2", "3");
        this.execute("SELECT * FROM t1 INNER JOIN t2 ON t1.k1 = t2.ak2 WHERE t1.k1 IN (?, ?) AND t2.ak2 IN (?, ?)", res -> JoinPartitionPruningSelfTest.assertPartitions(this.partition("t1", "2")), "1", "2", "2", "3");
        this.execute("SELECT * FROM t1 INNER JOIN t2 ON t1.k1 = t2.ak2 WHERE t1.k1 IN (?, ?) AND t2.ak2 IN (?, ?)", res -> JoinPartitionPruningSelfTest.assertNoRequests(), "1", "2", "3", "4");
        this.execute("SELECT * FROM t1 INNER JOIN t2 ON t1.k1 = t2.ak2 WHERE t1.k1 = ? OR t2.ak2 = ?", res -> JoinPartitionPruningSelfTest.assertPartitions(this.partition("t1", "1")), "1", "1");
        this.execute("SELECT * FROM t1 INNER JOIN t2 ON t1.k1 = t2.ak2 WHERE t1.k1 = ? OR t2.ak2 = ?", res -> JoinPartitionPruningSelfTest.assertPartitions(this.partition("t1", "1"), this.partition("t2", "2")), "1", "2");
        this.execute("SELECT * FROM t1 INNER JOIN t2 ON t1.k1 = t2.ak2 WHERE t1.k1 = ? OR t2.ak2 IN (?, ?)", res -> JoinPartitionPruningSelfTest.assertPartitions(this.partition("t1", "1"), this.partition("t2", "2")), "1", "1", "2");
        this.execute("SELECT * FROM t1 INNER JOIN t2 ON t1.k1 = t2.ak2 WHERE t1.k1 = ? OR t2.ak2 IN (?, ?)", res -> JoinPartitionPruningSelfTest.assertPartitions(this.partition("t1", "1"), this.partition("t2", "2"), this.partition("t2", "3")), "1", "2", "3");
        this.execute("SELECT * FROM t1 INNER JOIN t2 ON t1.k1 = t2.ak2 WHERE t1.k1 IN (?, ?) OR t2.ak2 IN (?, ?)", res -> JoinPartitionPruningSelfTest.assertPartitions(this.partition("t1", "1"), this.partition("t1", "2"), this.partition("t2", "3")), "1", "2", "2", "3");
        this.execute("SELECT * FROM t1 INNER JOIN t2 ON t1.k1 = t2.ak2 WHERE t1.k1 IN (?, ?) OR t2.ak2 IN (?, ?)", res -> JoinPartitionPruningSelfTest.assertPartitions(this.partition("t1", "1"), this.partition("t1", "2"), this.partition("t2", "3"), this.partition("t2", "4")), "1", "2", "3", "4");
        this.execute("SELECT * FROM t1 INNER JOIN t2 ON t1.k1 = t2.ak2 INNER JOIN t3 ON t1.k1 = t3.ak2 WHERE t1.k1 = ? AND t2.ak2 = ? AND t3.ak2 = ?", res -> JoinPartitionPruningSelfTest.assertPartitions(this.partition("t1", "1")), "1", "1", "1");
        this.execute("SELECT * FROM t1 INNER JOIN t2 ON t1.k1 = t2.ak2 INNER JOIN t3 ON t1.k1 = t3.ak2 WHERE t1.k1 = ? AND t2.ak2 = ? AND t3.ak2 = ?", res -> JoinPartitionPruningSelfTest.assertNoRequests(), "1", "2", "3");
        this.execute("SELECT * FROM t1 INNER JOIN t3 ON t1.k1 = t3.v3 INNER JOIN t2 ON t3.v4 = t2.ak2 WHERE t1.k1 = ? AND t2.ak2 = ?", res -> JoinPartitionPruningSelfTest.assertNoPartitions(), "1", "1");
        this.execute("SELECT * FROM t1 INNER JOIN t2 ON 1=1 WHERE t1.k1 = ? OR t1.k1 = t2.ak2", res -> JoinPartitionPruningSelfTest.assertNoPartitions(), "1");
    }

    @Test
    public void testCrossJoin() {
        this.createPartitionedTable("t1", this.pkColumn("k1"), "v2");
        this.createPartitionedTable("t2", this.pkColumn("k1"), this.affinityColumn("ak2"), "v3");
        this.executeSql("INSERT INTO t1 VALUES ('1', '1')", new Object[0]);
        this.executeSql("INSERT INTO t2 VALUES ('1', '1', '1')", new Object[0]);
        this.executeSql("INSERT INTO t1 VALUES ('2', '2')", new Object[0]);
        this.executeSql("INSERT INTO t2 VALUES ('2', '2', '2')", new Object[0]);
        this.executeSql("INSERT INTO t1 VALUES ('3', '3')", new Object[0]);
        this.executeSql("INSERT INTO t2 VALUES ('3', '3', '3')", new Object[0]);
        this.execute("SELECT * FROM t1, t2 WHERE t1.k1 = ?", res -> {
            JoinPartitionPruningSelfTest.assertPartitions(this.partition("t1", "1"));
            JoinPartitionPruningSelfTest.assertEquals((int)1, (int)res.size());
            JoinPartitionPruningSelfTest.assertEquals((Object)"1", ((List)res.get(0)).get(0));
        }, "1");
        this.execute("SELECT * FROM t1 INNER JOIN t2 ON 1=1 WHERE t1.k1 = ?", res -> {
            JoinPartitionPruningSelfTest.assertPartitions(this.partition("t1", "1"));
            JoinPartitionPruningSelfTest.assertEquals((int)1, (int)res.size());
            JoinPartitionPruningSelfTest.assertEquals((Object)"1", ((List)res.get(0)).get(0));
        }, "1");
        this.execute("SELECT * FROM t1, t2 WHERE t2.ak2 = ?", res -> {
            JoinPartitionPruningSelfTest.assertPartitions(this.partition("t2", "2"));
            JoinPartitionPruningSelfTest.assertEquals((int)1, (int)res.size());
            JoinPartitionPruningSelfTest.assertEquals((Object)"2", ((List)res.get(0)).get(0));
        }, "2");
        this.execute("SELECT * FROM t1 INNER JOIN t2 ON 1=1 WHERE t2.ak2 = ?", res -> {
            JoinPartitionPruningSelfTest.assertPartitions(this.partition("t2", "2"));
            JoinPartitionPruningSelfTest.assertEquals((int)1, (int)res.size());
            JoinPartitionPruningSelfTest.assertEquals((Object)"2", ((List)res.get(0)).get(0));
        }, "2");
        this.execute("SELECT * FROM t1, t2 WHERE t1.k1=? AND t2.ak2 = ?", res -> JoinPartitionPruningSelfTest.assertNoPartitions(), "3", "3");
        this.execute("SELECT * FROM t1, t2 WHERE t1.k1=? AND t2.ak2 = ?", res -> JoinPartitionPruningSelfTest.assertNoPartitions(), "3", "3");
        this.execute("SELECT * FROM t1 INNER JOIN t2 ON 1=1 WHERE t1.k1=? AND t2.ak2 = ?", res -> JoinPartitionPruningSelfTest.assertNoPartitions(), "3", "3");
    }

    @Test
    public void testThetaJoin() {
        this.createPartitionedTable("t1", this.pkColumn("k1"), "v2");
        this.createPartitionedTable("t2", this.pkColumn("k1"), this.affinityColumn("ak2"), "v3");
        this.execute("SELECT * FROM t1 INNER JOIN t2 ON t1.k1 > t2.ak2 WHERE t1.k1 = ?", res -> JoinPartitionPruningSelfTest.assertPartitions(this.partition("t1", "1")), "1");
        this.execute("SELECT * FROM t1 INNER JOIN t2 ON t1.k1 > t2.ak2 WHERE t2.ak2 = ?", res -> JoinPartitionPruningSelfTest.assertPartitions(this.partition("t1", "1")), "1");
        this.execute("SELECT * FROM t1 INNER JOIN t2 ON t1.k1 > t2.ak2 WHERE t1.k1 = ? AND t2.ak2 = ?", res -> JoinPartitionPruningSelfTest.assertNoPartitions(), "1", "1");
        this.execute("SELECT * FROM t1 INNER JOIN t2 ON t1.k1 > t2.ak2 WHERE t1.k1 = ? OR t2.ak2 = ?", res -> JoinPartitionPruningSelfTest.assertNoPartitions(), "1", "2");
        this.execute("SELECT * FROM t1 INNER JOIN t2 ON t1.k1 < t2.ak2 WHERE t1.k1 = ?", res -> JoinPartitionPruningSelfTest.assertPartitions(this.partition("t1", "1")), "1");
        this.execute("SELECT * FROM t1 INNER JOIN t2 ON t1.k1 < t2.ak2 WHERE t2.ak2 = ?", res -> JoinPartitionPruningSelfTest.assertPartitions(this.partition("t1", "1")), "1");
        this.execute("SELECT * FROM t1 INNER JOIN t2 ON t1.k1 < t2.ak2 WHERE t1.k1 = ? AND t2.ak2 = ?", res -> JoinPartitionPruningSelfTest.assertNoPartitions(), "1", "1");
        this.execute("SELECT * FROM t1 INNER JOIN t2 ON t1.k1 < t2.ak2 WHERE t1.k1 = ? OR t2.ak2 = ?", res -> JoinPartitionPruningSelfTest.assertNoPartitions(), "1", "2");
        this.execute("SELECT * FROM t1 INNER JOIN t2 ON t1.k1 <> t2.ak2 WHERE t1.k1 = ?", res -> JoinPartitionPruningSelfTest.assertPartitions(this.partition("t1", "1")), "1");
        this.execute("SELECT * FROM t1 INNER JOIN t2 ON t1.k1 <> t2.ak2 WHERE t2.ak2 = ?", res -> JoinPartitionPruningSelfTest.assertPartitions(this.partition("t1", "1")), "1");
        this.execute("SELECT * FROM t1 INNER JOIN t2 ON t1.k1 <> t2.ak2 WHERE t1.k1 = ? AND t2.ak2 = ?", res -> JoinPartitionPruningSelfTest.assertNoPartitions(), "1", "1");
        this.execute("SELECT * FROM t1 INNER JOIN t2 ON t1.k1 <> t2.ak2 WHERE t1.k1 = ? OR t2.ak2 = ?", res -> JoinPartitionPruningSelfTest.assertNoPartitions(), "1", "2");
    }

    @Test
    public void testJoinWithReplicated() {
        this.createPartitionedTable("t1", this.pkColumn("k1"), "v2");
        this.createReplicatedTable("t2", this.pkColumn("k1"), "v2", "v3");
        this.execute("SELECT * FROM t1 INNER JOIN t2 ON t1.k1 = t2.k1 WHERE t1.k1 = ? AND t2.k1 = ?", res -> JoinPartitionPruningSelfTest.assertPartitions(this.partition("t1", "1")), "1", "2");
        this.execute("SELECT * FROM t1 INNER JOIN t2 ON t1.k1 = t2.k1 WHERE t1.k1 IN (?, ?) AND t2.k1 = ?", res -> JoinPartitionPruningSelfTest.assertPartitions(this.partition("t1", "1"), this.partition("t1", "2")), "1", "2", "3");
        this.execute("SELECT * FROM t1 INNER JOIN t2 ON t1.k1 = t2.k1 WHERE t1.k1 = ? OR t2.k1 = ?", res -> JoinPartitionPruningSelfTest.assertNoPartitions(), "1", "2");
        this.execute("SELECT * FROM t1 INNER JOIN t2 ON t1.k1 = t2.k1 WHERE t2.k1 = ?", res -> JoinPartitionPruningSelfTest.assertNoPartitions(), "1");
    }

    @Test
    public void testJoinWithDifferentAffinityFunctions() {
        this.checkAffinityFunctions(JoinPartitionPruningSelfTest.cacheConfiguration(256, 1, false, false, false), JoinPartitionPruningSelfTest.cacheConfiguration(256, 1, false, false, false), true);
        this.checkAffinityFunctions(JoinPartitionPruningSelfTest.cacheConfiguration(1024, 1, false, false, false), JoinPartitionPruningSelfTest.cacheConfiguration(256, 1, false, false, false), false);
        this.checkAffinityFunctions(JoinPartitionPruningSelfTest.cacheConfiguration(256, 1, false, false, false), JoinPartitionPruningSelfTest.cacheConfiguration(1024, 1, false, false, false), false);
        this.checkAffinityFunctions(JoinPartitionPruningSelfTest.cacheConfiguration(256, 1, false, false, false), JoinPartitionPruningSelfTest.cacheConfiguration(256, 2, false, false, false), true);
        this.checkAffinityFunctions(JoinPartitionPruningSelfTest.cacheConfiguration(256, 2, true, false, false), JoinPartitionPruningSelfTest.cacheConfiguration(256, 2, false, false, false), false);
        this.checkAffinityFunctions(JoinPartitionPruningSelfTest.cacheConfiguration(256, 2, false, false, false), JoinPartitionPruningSelfTest.cacheConfiguration(256, 2, true, false, false), false);
        this.checkAffinityFunctions(JoinPartitionPruningSelfTest.cacheConfiguration(256, 2, true, false, false), JoinPartitionPruningSelfTest.cacheConfiguration(256, 2, true, false, false), false);
        this.checkAffinityFunctions(JoinPartitionPruningSelfTest.cacheConfiguration(256, 2, false, true, false), JoinPartitionPruningSelfTest.cacheConfiguration(256, 2, false, false, false), false);
        this.checkAffinityFunctions(JoinPartitionPruningSelfTest.cacheConfiguration(256, 2, false, false, false), JoinPartitionPruningSelfTest.cacheConfiguration(256, 2, false, true, false), false);
        this.checkAffinityFunctions(JoinPartitionPruningSelfTest.cacheConfiguration(256, 2, false, true, false), JoinPartitionPruningSelfTest.cacheConfiguration(256, 2, false, true, false), false);
        this.checkAffinityFunctions(JoinPartitionPruningSelfTest.cacheConfiguration(256, 2, false, false, true), JoinPartitionPruningSelfTest.cacheConfiguration(256, 2, false, false, false), false);
        this.checkAffinityFunctions(JoinPartitionPruningSelfTest.cacheConfiguration(256, 2, false, false, false), JoinPartitionPruningSelfTest.cacheConfiguration(256, 2, false, false, true), false);
        this.checkAffinityFunctions(JoinPartitionPruningSelfTest.cacheConfiguration(256, 2, false, false, true), JoinPartitionPruningSelfTest.cacheConfiguration(256, 2, false, false, true), true);
    }

    private void checkAffinityFunctions(CacheConfiguration ccfg1, CacheConfiguration ccfg2, boolean compatible) {
        IgniteEx cli = this.client();
        cli.destroyCaches(cli.cacheNames());
        ccfg1.setName("t1");
        ccfg2.setName("t2");
        QueryEntity entity1 = new QueryEntity(KeyClass1.class, ValueClass.class).setTableName("t1");
        QueryEntity entity2 = new QueryEntity(KeyClass2.class, ValueClass.class).setTableName("t2");
        ccfg1.setQueryEntities(Collections.singletonList(entity1));
        ccfg2.setQueryEntities(Collections.singletonList(entity2));
        ccfg1.setKeyConfiguration(new CacheKeyConfiguration[]{new CacheKeyConfiguration(entity1.getKeyType(), "k1")});
        ccfg2.setKeyConfiguration(new CacheKeyConfiguration[]{new CacheKeyConfiguration(entity2.getKeyType(), "ak2")});
        ccfg1.setSqlSchema("PUBLIC");
        ccfg2.setSqlSchema("PUBLIC");
        this.client().createCache(ccfg1);
        this.client().createCache(ccfg2);
        this.execute("SELECT * FROM t1 INNER JOIN t2 ON t1.k1 = t2.ak2 WHERE t1.k1 = ?", res -> JoinPartitionPruningSelfTest.assertPartitions(this.partition("t1", "1")), "1");
        this.execute("SELECT * FROM t1 INNER JOIN t2 ON t1.k1 = t2.ak2 WHERE t2.ak2 = ?", res -> JoinPartitionPruningSelfTest.assertPartitions(this.partition("t2", "2")), "2");
        if (compatible) {
            this.execute("SELECT * FROM t1 INNER JOIN t2 ON t1.k1 = t2.ak2 WHERE t1.k1 = ? OR t2.ak2 = ?", res -> JoinPartitionPruningSelfTest.assertPartitions(this.partition("t1", "1"), this.partition("t2", "2")), "1", "2");
        } else {
            this.execute("SELECT * FROM t1 INNER JOIN t2 ON t1.k1 = t2.ak2 WHERE t1.k1 = ? OR t2.ak2 = ?", res -> JoinPartitionPruningSelfTest.assertNoPartitions(), "1", "2");
        }
    }

    private static CacheConfiguration cacheConfiguration(int parts, int backups, boolean customAffinity, boolean nodeFilter, boolean persistent) {
        CacheConfiguration ccfg = new CacheConfiguration();
        ccfg.setCacheMode(CacheMode.PARTITIONED);
        ccfg.setBackups(backups);
        RendezvousAffinityFunction affFunc = customAffinity ? new CustomRendezvousAffinityFunction() : new RendezvousAffinityFunction();
        affFunc.setPartitions(parts);
        ccfg.setAffinity((AffinityFunction)affFunc);
        if (nodeFilter) {
            ccfg.setNodeFilter(F.alwaysTrue());
        }
        if (persistent) {
            ccfg.setDataRegionName("disk");
        }
        return ccfg;
    }

    @Test
    public void testJoinWithSubquery() {
        this.createPartitionedTable("t1", this.pkColumn("k1"), "v2");
        this.createPartitionedTable("t2", this.pkColumn("k1"), this.affinityColumn("ak2"), "v3");
        this.execute("SELECT * FROM t1 INNER JOIN (SELECT * FROM t2) T2_SUB ON t1.k1 = T2_SUB.ak2 WHERE t1.k1 = ?", res -> JoinPartitionPruningSelfTest.assertPartitions(this.partition("t1", "1")), "1");
        this.execute("SELECT * FROM t1 INNER JOIN (SELECT * FROM t2) T2_SUB ON t1.k1 = T2_SUB.ak2 WHERE T2_SUB.ak2 = ?", res -> JoinPartitionPruningSelfTest.assertPartitions(this.partition("t2", "1")), "1");
    }

    @Test
    public void testExplicitPartitions() {
        this.createPartitionedTable("t1", this.pkColumn("k1"), "v2");
        this.createPartitionedTable("t2", this.pkColumn("k1"), this.affinityColumn("ak2"), "v3");
        this.executeSqlFieldsQuery(new SqlFieldsQuery("SELECT * FROM t1 INNER JOIN t2 ON t1.k1 = t2.ak2 WHERE t1.k1=? OR t2.ak2=?").setArgs(new Object[]{"1", "2"}).setPartitions(new int[]{1}));
        JoinPartitionPruningSelfTest.assertPartitions(1);
    }

    @Test
    public void testOuterJoin() {
        this.createPartitionedTable("t1", this.pkColumn("k1"), "v2");
        this.createPartitionedTable("t2", this.pkColumn("k1"), this.affinityColumn("ak2"), "v3");
        this.execute("SELECT * FROM t1 LEFT OUTER JOIN t2 ON t1.k1 = t2.ak2 WHERE t1.k1 = ?", res -> JoinPartitionPruningSelfTest.assertPartitions(this.partition("t1", "1")), "1");
        this.execute("SELECT * FROM t1 LEFT OUTER JOIN t2 ON t1.k1 = t2.ak2 WHERE t2.ak2 = ?", res -> JoinPartitionPruningSelfTest.assertNoPartitions(), "1");
        this.execute("SELECT * FROM t1 LEFT OUTER JOIN t2 T2_1 ON t1.k1 = T2_1.ak2 INNER JOIN t2 T2_2 ON T2_1.k1 = T2_2.k1 WHERE T2_2.ak2 = ?", res -> JoinPartitionPruningSelfTest.assertPartitions(this.partition("t2", "1")), "1");
        this.execute("SELECT * FROM t1 LEFT OUTER JOIN t2 T2_1 ON t1.k1 = T2_1.ak2 INNER JOIN t2 T2_2 ON t1.k1 = T2_2.ak2 WHERE T2_1.ak2 = ? AND T2_2.ak2=?", res -> JoinPartitionPruningSelfTest.assertPartitions(this.partition("t2", "2")), "1", "2");
    }

    @Test
    public void testSelfJoin() {
        this.createPartitionedTable("t1", this.pkColumn("k1"), "v2");
        this.execute("SELECT * FROM t1 A INNER JOIN t1 B ON A.k1 = B.k1 WHERE A.k1 = ?", res -> JoinPartitionPruningSelfTest.assertPartitions(this.partition("t1", "1")), "1");
        this.execute("SELECT * FROM t1 A INNER JOIN t1 B ON A.k1 = B.k1 WHERE A.k1 = ? AND B.k1 = ?", res -> JoinPartitionPruningSelfTest.assertPartitions(this.partition("t1", "1")), "1", "1");
        this.execute("SELECT * FROM t1 A INNER JOIN t1 B ON A.k1 = B.k1 WHERE A.k1 = ? AND B.k1 = ?", res -> JoinPartitionPruningSelfTest.assertNoRequests(), "1", "2");
        this.execute("SELECT * FROM t1 A INNER JOIN t1 B ON A.k1 = B.k1 WHERE A.k1 = ? OR B.k1 = ?", res -> JoinPartitionPruningSelfTest.assertPartitions(this.partition("t1", "1"), this.partition("t1", "2")), "1", "2");
    }

    private static class ValueClass {
        @QuerySqlField
        private String v;

        private ValueClass() {
        }
    }

    private static class KeyClass2 {
        @QuerySqlField
        private String k1;
        @QuerySqlField
        private String ak2;

        private KeyClass2() {
        }
    }

    private static class KeyClass1 {
        @QuerySqlField
        private String k1;

        private KeyClass1() {
        }
    }

    private static class CustomRendezvousAffinityFunction
    extends RendezvousAffinityFunction {
        private CustomRendezvousAffinityFunction() {
        }
    }
}

