/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlQuery;
import org.apache.ignite.internal.processors.query.h2.twostep.GridMapQueryExecutor;
import org.apache.ignite.internal.util.IgniteUtils;
import org.junit.Assert;
import org.junit.Test;

public class GridMapQueryExecutorTest {
    private static void testBuildQueryLogDetailsWithSampleParams(String sensitivity, Object[] params, String expectedParams) {
        System.setProperty("IGNITE_SENSITIVE_DATA_LOGGING", sensitivity);
        List<GridCacheSqlQuery> queries = Collections.singletonList(new GridCacheSqlQuery("SELECT * FROM test"));
        String log = GridMapQueryExecutor.buildQueryLogDetails((long)123L, (String)"TestLabel", (String)"TestSchema", queries, (Object[])params, (Throwable)new RuntimeException("Test exception"), (UUID)UUID.randomUUID(), (UUID)UUID.randomUUID());
        Assert.assertTrue((String)"Log does not contain expected param string", (boolean)log.contains("params=" + expectedParams));
    }

    @Test
    public void testBuildQueryLogDetailsWithNullParams() {
        List<GridCacheSqlQuery> queries = Collections.singletonList(new GridCacheSqlQuery("SELECT * FROM test"));
        String log = GridMapQueryExecutor.buildQueryLogDetails((long)123L, (String)"TestLabel", (String)"TestSchema", queries, null, (Throwable)new RuntimeException("Test exception"), (UUID)UUID.randomUUID(), (UUID)UUID.randomUUID());
        Assert.assertTrue((boolean)log.contains("params=N/A"));
    }

    @Test
    public void testBuildQueryLogDetailsWithEmptyParams() {
        List<GridCacheSqlQuery> queries = Collections.singletonList(new GridCacheSqlQuery("SELECT * FROM test"));
        String log = GridMapQueryExecutor.buildQueryLogDetails((long)123L, (String)"TestLabel", (String)"TestSchema", queries, (Object[])new Object[0], (Throwable)new RuntimeException("Test exception"), (UUID)UUID.randomUUID(), (UUID)UUID.randomUUID());
        Assert.assertTrue((boolean)log.contains("params=N/A"));
    }

    @Test
    public void testBuildQueryLogDetailsHandlesNullFields() {
        String log = GridMapQueryExecutor.buildQueryLogDetails((long)999L, null, null, null, null, null, (UUID)UUID.randomUUID(), (UUID)UUID.randomUUID());
        Assert.assertTrue((boolean)log.contains("label=N/A"));
        Assert.assertTrue((boolean)log.contains("schema=N/A"));
        Assert.assertTrue((boolean)log.contains("queries=N/A"));
        Assert.assertTrue((boolean)log.contains("params=N/A"));
    }

    @Test
    public void testBuildQueryLogDetailsWithPlainSensitivity() {
        Object[] givenParams = new Object[]{42, "john", 345};
        GridMapQueryExecutorTest.testBuildQueryLogDetailsWithSampleParams("plain", givenParams, "[42, john, 345]");
    }

    @Test
    public void testBuildQueryLogDetailsWithHashSensitivity() {
        Object[] givenParams = new Object[]{42, "john", 345};
        int hash = Arrays.hashCode(givenParams);
        String expected = String.valueOf(IgniteUtils.hash((int)hash));
        GridMapQueryExecutorTest.testBuildQueryLogDetailsWithSampleParams("hash", givenParams, expected);
    }

    @Test
    public void testBuildQueryLogDetailsWithNoneSensitivity() {
        Object[] givenParams = new Object[]{42, "john", 345};
        GridMapQueryExecutorTest.testBuildQueryLogDetailsWithSampleParams("none", givenParams, "HIDDEN");
    }
}

