/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.managers.communication.GridIoMessage;
import org.apache.ignite.internal.processors.query.h2.twostep.JoinSqlTestHelper;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2QueryRequest;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class BetweenOperationExtractPartitionSelfTest
extends GridCommonAbstractTest {
    private static final int NODES_COUNT = 8;
    private static final int ORG_COUNT = 10000;
    private static final String ORG_CACHE_NAME = "orgBetweenTest";
    private static final int[] EMPTY_PARTITIONS_ARRAY = new int[0];
    private static final String BETWEEN_QRY = "select * from Organization org where org._KEY between %d and %d";
    private static final String RANGE_QRY = "select * from Organization org where org._KEY %s %d and org._KEY %s %d";
    private static final String AND_BETWEEN_QRY = "select * from Organization org where org._KEY > 10 and org._KEY between %d and %d";
    private static final String AND_RANGE_QRY = "select * from Organization org where org._KEY > 10 and org._KEY %s %d and org._KEY %s %d";
    private static final String BETWEEN_AND_QRY = "select * from Organization org where org._KEY between %d and %d and org._KEY > 10";
    private static final String RANGE_AND_QRY = "select * from Organization org where org._KEY %s %d and org._KEY %s %d and org._KEY > 10";
    private static final String BETWEEN_AND_BETWEEN_QRY = "select * from Organization org where org._KEY between %d and %d and org._KEY between 10 and 20";
    private static final String RANGE_AND_RANGE_QRY = "select * from Organization org where org._KEY %s %d and org._KEY %s %d and org._KEY >= 10 and org._KEY <= 20";
    private static final String BETWEEN_AND_AND_AND_BETWEEN_QRY = "select * from Organization org where org._KEY between %d and %d and org._KEY < 30 and org._KEY between 10 and 20";
    private static final String RANGE_AND_AND_AND_RANGE_QRY = "select * from Organization org where org._KEY %s %d and org._KEY %s %d and org._KEY < 30 and org._KEY >= 10 and org._KEY <= 20";
    private static final String BETWEEN_OR_QRY = "select * from Organization org where org._KEY between %d and %d or org._KEY < 5";
    private static final String RANGE_OR_QRY = "select * from Organization org where org._KEY %s %d and org._KEY %s %d or org._KEY < 5";
    private static final String OR_BETWEEN_QRY = "select * from Organization org where org._KEY < 5 or org._KEY between %d and %d";
    private static final String OR_RANGE_QRY = "select * from Organization org where org._KEY < 5 or org._KEY %s %d and org._KEY %s %d";
    private static final String BETWEEN_OR_BETWEEN_QRY = "select * from Organization org where org._KEY between %d and %d or org._KEY between 20 and 25";
    private static final String RANGE_OR_RANGE_QRY = "select * from Organization org where org._KEY %s %d and org._KEY %s %d or org._KEY >= 20 and org._KEY <= 25";
    private static final String RANGE_OR_BETWEEN_QRY = "select * from Organization org where org._KEY %s %d and org._KEY %s %d or org._KEY between 20 and 25";
    private static final String EMPTY_RANGE_QRY = "select * from Organization org where org._KEY %s %d and org._KEY %s %d";
    private static IgniteCache<Integer, JoinSqlTestHelper.Organization> orgCache;
    private boolean clientMode;

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        cfg.setCommunicationSpi((CommunicationSpi)new TestCommunicationSpi());
        cfg.setClientMode(this.clientMode);
        return cfg;
    }

    private static Collection<QueryEntity> organizationQueryEntity() {
        QueryEntity entity = new QueryEntity(Integer.class, JoinSqlTestHelper.Organization.class);
        entity.setKeyFieldName("ID");
        entity.getFields().put("ID", String.class.getName());
        return Collections.singletonList(entity);
    }

    protected void beforeTestsStarted() throws Exception {
        this.startGridsMultiThreaded(7, false);
        this.clientMode = true;
        this.startGrid(8);
        orgCache = this.ignite(8).getOrCreateCache(new CacheConfiguration(ORG_CACHE_NAME).setCacheMode(CacheMode.PARTITIONED).setQueryEntities(BetweenOperationExtractPartitionSelfTest.organizationQueryEntity()));
        this.awaitPartitionMapExchange();
        this.populateDataIntoOrg();
    }

    protected void afterTestsStopped() throws Exception {
        orgCache = null;
        this.stopAllGrids();
        super.afterTestsStopped();
    }

    @Test
    public void testBetweenConst() {
        this.testBetweenConstOperator(BETWEEN_QRY, 1, 3, 3);
        this.testBetweenConstOperator(BETWEEN_QRY, 5, 5, 1);
        this.testBetweenConstOperator(BETWEEN_QRY, 7, 8, 2);
        this.testBetweenConstOperator(AND_BETWEEN_QRY, 11, 13, 3);
        this.testBetweenConstOperator(AND_BETWEEN_QRY, 15, 15, 1);
        this.testBetweenConstOperator(AND_BETWEEN_QRY, 17, 18, 2);
        this.testBetweenConstOperator(BETWEEN_AND_QRY, 11, 13, 3);
        this.testBetweenConstOperator(BETWEEN_AND_QRY, 15, 15, 1);
        this.testBetweenConstOperator(BETWEEN_AND_QRY, 17, 18, 2);
        this.testBetweenConstOperator(BETWEEN_AND_BETWEEN_QRY, 11, 13, 3);
        this.testBetweenConstOperator(BETWEEN_AND_BETWEEN_QRY, 15, 15, 1);
        this.testBetweenConstOperator(BETWEEN_AND_BETWEEN_QRY, 17, 18, 2);
        this.testBetweenConstOperator(BETWEEN_AND_AND_AND_BETWEEN_QRY, 11, 13, 3);
        this.testBetweenConstOperator(BETWEEN_AND_AND_AND_BETWEEN_QRY, 15, 15, 1);
        this.testBetweenConstOperator(BETWEEN_AND_AND_AND_BETWEEN_QRY, 17, 18, 2);
        this.testBetweenConstOperator(BETWEEN_OR_QRY, 11, 13, 8, EMPTY_PARTITIONS_ARRAY);
        this.testBetweenConstOperator(OR_BETWEEN_QRY, 11, 13, 8, EMPTY_PARTITIONS_ARRAY);
        this.testBetweenConstOperator(BETWEEN_OR_BETWEEN_QRY, 11, 13, 9, 11, 12, 13, 20, 21, 22, 23, 24, 25);
    }

    @Test
    public void testRangeConst() {
        this.testRangeConstOperator("select * from Organization org where org._KEY %s %d and org._KEY %s %d", 1, 3, 3, false);
        this.testRangeConstOperator("select * from Organization org where org._KEY %s %d and org._KEY %s %d", 5, 5, 1, false);
        this.testRangeConstOperator("select * from Organization org where org._KEY %s %d and org._KEY %s %d", 7, 8, 2, false);
        this.testRangeConstOperator(AND_RANGE_QRY, 11, 13, 3, true);
        this.testRangeConstOperator(AND_RANGE_QRY, 15, 15, 1, true);
        this.testRangeConstOperator(AND_RANGE_QRY, 17, 18, 2, true);
        this.testRangeConstOperator(RANGE_AND_QRY, 11, 13, 3, true);
        this.testRangeConstOperator(RANGE_AND_QRY, 15, 15, 1, true);
        this.testRangeConstOperator(RANGE_AND_QRY, 17, 18, 2, true);
        this.testRangeConstOperator(RANGE_AND_RANGE_QRY, 11, 13, 3, true);
        this.testRangeConstOperator(RANGE_AND_RANGE_QRY, 15, 15, 1, true);
        this.testRangeConstOperator(RANGE_AND_RANGE_QRY, 17, 18, 2, true);
        this.testRangeConstOperator(RANGE_AND_AND_AND_RANGE_QRY, 11, 13, 3, true);
        this.testRangeConstOperator(RANGE_AND_AND_AND_RANGE_QRY, 15, 15, 1, true);
        this.testRangeConstOperator(RANGE_AND_AND_AND_RANGE_QRY, 17, 18, 2, true);
        this.testRangeConstOperator(RANGE_OR_QRY, 11, 13, ">", "<", 6, EMPTY_PARTITIONS_ARRAY);
        this.testRangeConstOperator(RANGE_OR_QRY, 11, 13, ">=", "<", 7, EMPTY_PARTITIONS_ARRAY);
        this.testRangeConstOperator(RANGE_OR_QRY, 11, 13, ">", "<=", 7, EMPTY_PARTITIONS_ARRAY);
        this.testRangeConstOperator(RANGE_OR_QRY, 11, 13, ">=", "<=", 8, EMPTY_PARTITIONS_ARRAY);
        this.testRangeConstOperator(OR_RANGE_QRY, 11, 13, ">", "<", 6, EMPTY_PARTITIONS_ARRAY);
        this.testRangeConstOperator(OR_RANGE_QRY, 11, 13, ">=", "<", 7, EMPTY_PARTITIONS_ARRAY);
        this.testRangeConstOperator(OR_RANGE_QRY, 11, 13, ">", "<=", 7, EMPTY_PARTITIONS_ARRAY);
        this.testRangeConstOperator(OR_RANGE_QRY, 11, 13, ">=", "<=", 8, EMPTY_PARTITIONS_ARRAY);
        this.testRangeConstOperator(RANGE_OR_RANGE_QRY, 11, 13, ">", "<", 7, 12, 20, 21, 22, 23, 24, 25);
        this.testRangeConstOperator(RANGE_OR_RANGE_QRY, 11, 13, ">=", "<", 8, 11, 12, 20, 21, 22, 23, 24, 25);
        this.testRangeConstOperator(RANGE_OR_RANGE_QRY, 11, 13, ">", "<=", 8, 12, 13, 20, 21, 22, 23, 24, 25);
        this.testRangeConstOperator(RANGE_OR_RANGE_QRY, 11, 13, ">=", "<=", 9, 11, 12, 13, 20, 21, 22, 23, 24, 25);
        this.testRangeConstOperator(RANGE_OR_BETWEEN_QRY, 11, 13, ">", "<", 7, 12, 20, 21, 22, 23, 24, 25);
        this.testRangeConstOperator(RANGE_OR_BETWEEN_QRY, 11, 13, ">=", "<", 8, 11, 12, 20, 21, 22, 23, 24, 25);
        this.testRangeConstOperator(RANGE_OR_BETWEEN_QRY, 11, 13, ">", "<=", 8, 12, 13, 20, 21, 22, 23, 24, 25);
        this.testRangeConstOperator(RANGE_OR_BETWEEN_QRY, 11, 13, ">=", "<=", 9, 11, 12, 13, 20, 21, 22, 23, 24, 25);
        this.testRangeConstOperator("select * from Organization org where org._KEY %s %d and org._KEY %s %d", 11, 13, "<", ">", 0, EMPTY_PARTITIONS_ARRAY);
    }

    @Test
    public void testBetweenConstAgainstNonAffinityColumn() {
        this.testBetweenConstOperator("select * from Organization org where org.debtCapital between %d and %d", 1, 3, 3, EMPTY_PARTITIONS_ARRAY);
    }

    @Test
    public void testBetweenConstAgainstDifferentColumns() {
        this.testRangeConstOperator("select * from Organization org where org._key %s %d and org.debtCapital %s %d", 1, 3, ">=", "<=", 3, EMPTY_PARTITIONS_ARRAY);
    }

    @Test
    public void testBetweenPartitionsDefaultLimitExceeding() {
        this.testBetweenConstOperator(BETWEEN_QRY, 1, 16, 16);
        this.testBetweenConstOperator(BETWEEN_QRY, 1, 17, 17, EMPTY_PARTITIONS_ARRAY);
    }

    @Test
    public void testRevertedRangeConst() {
        this.testRevertedRangeConstOperator(3, 1, 3);
        this.testRevertedRangeConstOperator(5, 5, 1);
        this.testRevertedRangeConstOperator(8, 7, 2);
    }

    private void testBetweenConstOperator(String sqlQry, int from, int to, int expResCnt) {
        TestCommunicationSpi commSpi = this.runQuery(sqlQry, from, to, expResCnt);
        BetweenOperationExtractPartitionSelfTest.assertEquals(this.extractExpectedPartitions(from, to), commSpi.partitionsSet());
    }

    private void testBetweenConstOperator(String sqlQry, int from, int to, int expResCnt, int ... expPartitions) {
        TestCommunicationSpi commSpi = this.runQuery(sqlQry, from, to, expResCnt);
        HashSet<Integer> expPartitionsSet = new HashSet<Integer>();
        for (int expPartition : expPartitions) {
            expPartitionsSet.add(expPartition);
        }
        BetweenOperationExtractPartitionSelfTest.assertEquals(expPartitionsSet, commSpi.partitionsSet());
    }

    private void testRangeConstOperator(String sqlQry, int const1, int const2, int expResCnt, boolean skipPartitionsCheck) {
        TestCommunicationSpi commSpi = this.runQuery(sqlQry, const1, const2, ">", "<", expResCnt - 2);
        if (!skipPartitionsCheck) {
            BetweenOperationExtractPartitionSelfTest.assertEquals(this.extractExpectedPartitions(const1 + 1, const2 - 1), commSpi.partitionsSet());
        }
        commSpi = this.runQuery(sqlQry, const1, const2, ">=", "<", expResCnt - 1);
        if (!skipPartitionsCheck) {
            BetweenOperationExtractPartitionSelfTest.assertEquals(this.extractExpectedPartitions(const1, const2 - 1), commSpi.partitionsSet());
        }
        commSpi = this.runQuery(sqlQry, const1, const2, ">", "<=", expResCnt - 1);
        if (!skipPartitionsCheck) {
            BetweenOperationExtractPartitionSelfTest.assertEquals(this.extractExpectedPartitions(const1 + 1, const2), commSpi.partitionsSet());
        }
        commSpi = this.runQuery(sqlQry, const1, const2, ">=", "<=", expResCnt);
        if (!skipPartitionsCheck) {
            BetweenOperationExtractPartitionSelfTest.assertEquals(this.extractExpectedPartitions(const1, const2), commSpi.partitionsSet());
        }
    }

    private void testRevertedRangeConstOperator(int const1, int const2, int expResCnt) {
        TestCommunicationSpi commSpi = this.runQuery("select * from Organization org where org._KEY %s %d and org._KEY %s %d", const1, const2, "<", ">", expResCnt - 2);
        BetweenOperationExtractPartitionSelfTest.assertEquals(this.extractExpectedPartitions(const2 + 1, const1 - 1), commSpi.partitionsSet());
        commSpi = this.runQuery("select * from Organization org where org._KEY %s %d and org._KEY %s %d", const1, const2, "<=", ">", expResCnt - 1);
        BetweenOperationExtractPartitionSelfTest.assertEquals(this.extractExpectedPartitions(const2 + 1, const1), commSpi.partitionsSet());
        commSpi = this.runQuery("select * from Organization org where org._KEY %s %d and org._KEY %s %d", const1, const2, "<", ">=", expResCnt - 1);
        BetweenOperationExtractPartitionSelfTest.assertEquals(this.extractExpectedPartitions(const2, const1 - 1), commSpi.partitionsSet());
        commSpi = this.runQuery("select * from Organization org where org._KEY %s %d and org._KEY %s %d", const1, const2, "<=", ">=", expResCnt);
        BetweenOperationExtractPartitionSelfTest.assertEquals(this.extractExpectedPartitions(const2, const1), commSpi.partitionsSet());
    }

    private void testRangeConstOperator(String sqlQry, int from, int to, String leftOp, String rightOp, int expResCnt, int ... expPartitions) {
        TestCommunicationSpi commSpi = this.runQuery(sqlQry, from, to, leftOp, rightOp, expResCnt);
        BetweenOperationExtractPartitionSelfTest.assertEquals(Arrays.stream(expPartitions).boxed().collect(Collectors.toSet()), commSpi.partitionsSet());
    }

    private TestCommunicationSpi runQuery(String sqlQry, int from, int to, int expResCnt) {
        TestCommunicationSpi commSpi = (TestCommunicationSpi)this.grid(8).configuration().getCommunicationSpi();
        commSpi.resetPartitions();
        try (FieldsQueryCursor cur = orgCache.query(new SqlFieldsQuery(String.format(sqlQry, from, to)));){
            BetweenOperationExtractPartitionSelfTest.assertNotNull((Object)cur);
            List rows = cur.getAll();
            BetweenOperationExtractPartitionSelfTest.assertEquals((int)expResCnt, (int)rows.size());
        }
        return commSpi;
    }

    private TestCommunicationSpi runQuery(String sqlQry, int from, int to, String leftRangeOperand, String rightRangeOperand, int expResCnt) {
        TestCommunicationSpi commSpi = (TestCommunicationSpi)this.grid(8).configuration().getCommunicationSpi();
        commSpi.resetPartitions();
        try (FieldsQueryCursor cur = orgCache.query(new SqlFieldsQuery(String.format(sqlQry, leftRangeOperand, from, rightRangeOperand, to)));){
            BetweenOperationExtractPartitionSelfTest.assertNotNull((Object)cur);
            List rows = cur.getAll();
            BetweenOperationExtractPartitionSelfTest.assertEquals((int)Math.max(expResCnt, 0), (int)rows.size());
        }
        return commSpi;
    }

    private Set<Integer> extractExpectedPartitions(int keyFrom, int keyTo) {
        HashSet<Integer> partitions = new HashSet<Integer>();
        for (int i = keyFrom; i <= keyTo; ++i) {
            partitions.add(this.ignite(0).affinity(ORG_CACHE_NAME).partition((Object)i));
        }
        return partitions;
    }

    private void populateDataIntoOrg() {
        for (int i = 0; i < 10000; ++i) {
            JoinSqlTestHelper.Organization org = new JoinSqlTestHelper.Organization();
            org.setName("Organization #" + i);
            org.debtCapital(i);
            orgCache.put((Object)i, (Object)org);
        }
    }

    private static class TestCommunicationSpi
    extends TcpCommunicationSpi {
        Set<Integer> partitions = ConcurrentHashMap.newKeySet();

        private TestCommunicationSpi() {
        }

        public void sendMessage(ClusterNode node, Message msg, IgniteInClosure<IgniteException> ackC) throws IgniteSpiException {
            GridH2QueryRequest gridH2QryReq;
            if (((GridIoMessage)msg).message() instanceof GridH2QueryRequest && (gridH2QryReq = (GridH2QueryRequest)((GridIoMessage)msg).message()).queryPartitions() != null) {
                for (int partition : gridH2QryReq.queryPartitions()) {
                    this.partitions.add(partition);
                }
            }
            super.sendMessage(node, msg, ackC);
        }

        Set<Integer> partitionsSet() {
            return this.partitions;
        }

        void resetPartitions() {
            this.partitions.clear();
        }
    }
}

