/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.io.Serializable;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.processors.query.h2.TableStatisticsAbstractTest;
import org.junit.Test;

public class RowCountTableStatisticsSurvivesNodeRestartTest
extends TableStatisticsAbstractTest {
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setConsistentId((Serializable)((Object)igniteInstanceName));
        DataStorageConfiguration memCfg = new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true));
        cfg.setDataStorageConfiguration(memCfg);
        return cfg;
    }

    protected void beforeTest() throws Exception {
        int i;
        this.cleanPersistenceDir();
        this.startGridsMultiThreaded(1);
        this.grid(0).getOrCreateCache("default");
        this.runSql("DROP TABLE IF EXISTS big");
        this.runSql("DROP TABLE IF EXISTS small");
        this.runSql("CREATE TABLE big (a INT PRIMARY KEY, b INT, c INT)");
        this.runSql("CREATE TABLE small (a INT PRIMARY KEY, b INT, c INT)");
        this.runSql("CREATE INDEX big_b ON big(b)");
        this.runSql("CREATE INDEX small_b ON small(b)");
        this.runSql("CREATE INDEX big_c ON big(c)");
        this.runSql("CREATE INDEX small_c ON small(c)");
        IgniteCache cache = this.grid(0).cache("default");
        for (i = 0; i < 1000; ++i) {
            this.runSql("INSERT INTO big(a, b, c) VALUES(" + i + "," + i + "," + i % 10 + ")");
        }
        for (i = 0; i < 100; ++i) {
            this.runSql("INSERT INTO small(a, b, c) VALUES(" + i + "," + i + "," + i % 10 + ")");
        }
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    @Test
    public void statisticsSurvivesRestart() throws Exception {
        String sql = "SELECT COUNT(*) FROM t1 JOIN t2 ON t1.c = t2.c WHERE t1.b >= 0 AND t2.b >= 0";
        this.checkOptimalPlanChosenForDifferentJoinOrders((Ignite)this.grid(0), sql, "small", "big");
        this.stopGrid(0);
        this.startGrid(0);
        this.grid(0).cluster().state(ClusterState.ACTIVE);
        this.checkOptimalPlanChosenForDifferentJoinOrders((Ignite)this.grid(0), sql, "small", "big");
    }
}

