/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.configuration.Factory;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.affinity.AffinityKeyMapper;
import org.apache.ignite.cache.eviction.EvictableEntry;
import org.apache.ignite.cache.eviction.EvictionFilter;
import org.apache.ignite.cache.eviction.EvictionPolicy;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.IndexQuery;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.cluster.ClusterMetrics;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.ClientConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.SqlConfiguration;
import org.apache.ignite.configuration.TopologyValidator;
import org.apache.ignite.internal.ClusterMetricsSnapshot;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.managers.discovery.ClusterMetricsImpl;
import org.apache.ignite.internal.processors.cache.GridCacheProcessor;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.cache.index.AbstractSchemaSelfTest;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteRunnable;
import org.apache.ignite.spi.discovery.tcp.internal.TcpDiscoveryNode;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.GridAbstractTest;
import org.junit.Assert;
import org.junit.Test;

public class SqlSystemViewsSelfTest
extends AbstractIndexingCommonTest {
    private static final int METRICS_CHECK_ATTEMPTS = 10;
    private final boolean activateLazyByDflt = (Boolean)GridTestUtils.getFieldValue(SqlFieldsQuery.class, (String[])new String[]{"DFLT_LAZY"});
    private boolean isPersistenceEnabled;

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.cleanPersistenceDir();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
        this.isPersistenceEnabled = false;
        GridQueryProcessor.idxCls = null;
    }

    private List<List<?>> execSql(Ignite ignite, String sql, Object ... args) {
        IgniteCache cache = ignite.cache("default");
        SqlFieldsQuery qry = new SqlFieldsQuery(sql);
        if (args != null && args.length > 0) {
            qry.setArgs(args);
        }
        return cache.query(qry).getAll();
    }

    private List<List<?>> execSql(String sql, Object ... args) {
        return this.execSql((Ignite)this.grid(), sql, args);
    }

    private void assertSqlError(final String sql) {
        Throwable t = GridTestUtils.assertThrowsWithCause((Callable)new Callable<Void>(){

            @Override
            public Void call() {
                SqlSystemViewsSelfTest.this.execSql(sql, new Object[0]);
                return null;
            }
        }, IgniteSQLException.class);
        IgniteSQLException sqlE = (IgniteSQLException)X.cause((Throwable)t, IgniteSQLException.class);
        assert (sqlE != null);
        SqlSystemViewsSelfTest.assertEquals((int)1002, (int)sqlE.statusCode());
    }

    @Test
    public void testModifications() throws Exception {
        this.startGrid(this.getConfiguration());
        this.assertSqlError("DROP TABLE " + QueryUtils.sysSchemaName() + ".NODES");
        this.assertSqlError("TRUNCATE TABLE " + QueryUtils.sysSchemaName() + ".NODES");
        this.assertSqlError("ALTER TABLE " + QueryUtils.sysSchemaName() + ".NODES RENAME TO " + QueryUtils.sysSchemaName() + ".N");
        this.assertSqlError("ALTER TABLE " + QueryUtils.sysSchemaName() + ".NODES ADD COLUMN C VARCHAR");
        this.assertSqlError("ALTER TABLE " + QueryUtils.sysSchemaName() + ".NODES DROP COLUMN NODE_ID");
        this.assertSqlError("ALTER TABLE " + QueryUtils.sysSchemaName() + ".NODES RENAME COLUMN NODE_ID TO C");
        this.assertSqlError("CREATE INDEX IDX ON " + QueryUtils.sysSchemaName() + ".NODES(NODE_ID)");
        this.assertSqlError("INSERT INTO " + QueryUtils.sysSchemaName() + ".NODES (NODE_ID) VALUES ('-')");
        this.assertSqlError("UPDATE " + QueryUtils.sysSchemaName() + ".NODES SET NODE_ID = '-'");
        this.assertSqlError("DELETE " + QueryUtils.sysSchemaName() + ".NODES");
    }

    @Test
    public void testSchemasView() throws Exception {
        IgniteEx srv = this.startGrid(this.getConfiguration().setSqlConfiguration(new SqlConfiguration().setSqlSchemas(new String[]{"PREDIFINED_SCHEMA_1"})));
        IgniteEx client = this.startGrid(this.getConfiguration().setClientMode(true).setIgniteInstanceName("CLIENT").setSqlConfiguration(new SqlConfiguration().setSqlSchemas(new String[]{"PREDIFINED_SCHEMA_2"})));
        srv.createCache(this.cacheConfiguration("TST1"));
        String schemasSql = "SELECT * FROM " + QueryUtils.sysSchemaName() + ".SCHEMAS";
        List<List<?>> srvNodeSchemas = this.execSql(schemasSql, new Object[0]);
        List<List<?>> clientNodeSchemas = this.execSql((Ignite)client, schemasSql, new Object[0]);
        HashSet expSchemasSrv = Sets.newHashSet((Object[])new String[]{"PREDIFINED_SCHEMA_1", "PUBLIC", "TST1", QueryUtils.sysSchemaName()});
        Set schemasSrv = srvNodeSchemas.stream().map(f -> f.get(0)).map(String.class::cast).collect(Collectors.toSet());
        Assert.assertEquals((Object)expSchemasSrv, schemasSrv);
        HashSet expSchemasCli = Sets.newHashSet((Object[])new String[]{"PREDIFINED_SCHEMA_2", "PUBLIC", "TST1", QueryUtils.sysSchemaName()});
        Set schemasCli = clientNodeSchemas.stream().map(f -> f.get(0)).map(String.class::cast).collect(Collectors.toSet());
        Assert.assertEquals((Object)expSchemasCli, schemasCli);
    }

    @Test
    public void testIndexesView() throws Exception {
        IgniteEx srv = this.startGrid(this.getConfiguration());
        IgniteEx client = this.startGrid(this.getConfiguration().setClientMode(true).setIgniteInstanceName("CLIENT"));
        srv.createCache(this.cacheConfiguration("TST1"));
        this.execSql("CREATE TABLE PUBLIC.AFF_CACHE (ID1 INT, ID2 INT, MY_VAL VARCHAR, PRIMARY KEY (ID1 DESC, ID2)) WITH \"affinity_key=ID2\"", new Object[0]);
        this.execSql("CREATE TABLE CACHE_SQL (ID INT PRIMARY KEY, MY_VAL VARCHAR)", new Object[0]);
        this.execSql("CREATE INDEX IDX_2 ON CACHE_SQL(ID DESC) INLINE_SIZE 13", new Object[0]);
        this.execSql("CREATE TABLE PUBLIC.DFLT_CACHE (ID1 INT, ID2 INT, MY_VAL VARCHAR, PRIMARY KEY (ID1 DESC, ID2))", new Object[0]);
        this.execSql("CREATE INDEX IDX_1 ON PUBLIC.DFLT_CACHE(ID2 DESC, ID1, MY_VAL DESC)", new Object[0]);
        this.execSql("CREATE INDEX IDX_3 ON PUBLIC.DFLT_CACHE(MY_VAL)", new Object[0]);
        this.execSql("CREATE TABLE PUBLIC.DFLT_AFF_CACHE (ID1 INT, ID2 INT, MY_VAL VARCHAR, PRIMARY KEY (ID1 DESC, ID2)) WITH \"affinity_key=ID1\"", new Object[0]);
        this.execSql("CREATE INDEX IDX_AFF_1 ON PUBLIC.DFLT_AFF_CACHE(ID2 DESC, ID1, MY_VAL DESC)", new Object[0]);
        String idxSql = "SELECT   CACHE_ID,  CACHE_NAME,  SCHEMA_NAME,  TABLE_NAME,  INDEX_NAME,  INDEX_TYPE,  COLUMNS,  IS_PK,  IS_UNIQUE,  INLINE_SIZE FROM " + QueryUtils.sysSchemaName() + ".INDEXES ORDER BY TABLE_NAME, INDEX_NAME";
        List<List<List<?>>> srvNodeIndexes = this.execSql((Ignite)srv, idxSql, new Object[0]);
        List<List<?>> clientNodeNodeIndexes = this.execSql((Ignite)client, idxSql, new Object[0]);
        SqlSystemViewsSelfTest.assertTrue((boolean)srvNodeIndexes.containsAll(clientNodeNodeIndexes));
        Object[][] expectedResults = new Object[][]{{-825022849, "SQL_PUBLIC_AFF_CACHE", "PUBLIC", "AFF_CACHE", "AFFINITY_KEY", "BTREE", "\"ID2\" ASC, \"ID1\" ASC", false, false, 10}, {-825022849, "SQL_PUBLIC_AFF_CACHE", "PUBLIC", "AFF_CACHE", "__SCAN_", "SCAN", null, false, false, null}, {-825022849, "SQL_PUBLIC_AFF_CACHE", "PUBLIC", "AFF_CACHE", "_key_PK", "BTREE", "\"ID1\" ASC, \"ID2\" ASC", true, true, 10}, {-825022849, "SQL_PUBLIC_AFF_CACHE", "PUBLIC", "AFF_CACHE", "_key_PK_hash", "HASH", "\"ID1\" ASC, \"ID2\" ASC, \"ID2\" ASC", false, true, null}, {707660652, "SQL_PUBLIC_CACHE_SQL", "PUBLIC", "CACHE_SQL", "IDX_2", "BTREE", "\"ID\" DESC, \"ID\" ASC", false, false, 10}, {707660652, "SQL_PUBLIC_CACHE_SQL", "PUBLIC", "CACHE_SQL", "__SCAN_", "SCAN", null, false, false, null}, {707660652, "SQL_PUBLIC_CACHE_SQL", "PUBLIC", "CACHE_SQL", "_key_PK", "BTREE", "\"ID\" ASC", true, true, 5}, {707660652, "SQL_PUBLIC_CACHE_SQL", "PUBLIC", "CACHE_SQL", "_key_PK_hash", "HASH", "\"ID\" ASC", false, true, null}, {1374144180, "SQL_PUBLIC_DFLT_AFF_CACHE", "PUBLIC", "DFLT_AFF_CACHE", "AFFINITY_KEY", "BTREE", "\"ID1\" ASC, \"ID2\" ASC", false, false, 10}, {1374144180, "SQL_PUBLIC_DFLT_AFF_CACHE", "PUBLIC", "DFLT_AFF_CACHE", "IDX_AFF_1", "BTREE", "\"ID2\" DESC, \"ID1\" ASC, \"MY_VAL\" DESC", false, false, 20}, {1374144180, "SQL_PUBLIC_DFLT_AFF_CACHE", "PUBLIC", "DFLT_AFF_CACHE", "__SCAN_", "SCAN", null, false, false, null}, {1374144180, "SQL_PUBLIC_DFLT_AFF_CACHE", "PUBLIC", "DFLT_AFF_CACHE", "_key_PK", "BTREE", "\"ID1\" ASC, \"ID2\" ASC", true, true, 10}, {1374144180, "SQL_PUBLIC_DFLT_AFF_CACHE", "PUBLIC", "DFLT_AFF_CACHE", "_key_PK_hash", "HASH", "\"ID1\" ASC, \"ID2\" ASC, \"ID1\" ASC", false, true, null}, {1102275506, "SQL_PUBLIC_DFLT_CACHE", "PUBLIC", "DFLT_CACHE", "IDX_1", "BTREE", "\"ID2\" DESC, \"ID1\" ASC, \"MY_VAL\" DESC, \"ID1\" ASC, \"ID2\" ASC", false, false, 25}, {1102275506, "SQL_PUBLIC_DFLT_CACHE", "PUBLIC", "DFLT_CACHE", "IDX_3", "BTREE", "\"MY_VAL\" ASC, \"ID1\" ASC, \"ID2\" ASC, \"ID1\" ASC, \"ID2\" ASC", false, false, 25}, {1102275506, "SQL_PUBLIC_DFLT_CACHE", "PUBLIC", "DFLT_CACHE", "__SCAN_", "SCAN", null, false, false, null}, {1102275506, "SQL_PUBLIC_DFLT_CACHE", "PUBLIC", "DFLT_CACHE", "_key_PK", "BTREE", "\"ID1\" ASC, \"ID2\" ASC", true, true, 10}, {1102275506, "SQL_PUBLIC_DFLT_CACHE", "PUBLIC", "DFLT_CACHE", "_key_PK_hash", "HASH", "\"ID1\" ASC, \"ID2\" ASC", false, true, null}, {2584860, "TST1", "TST1", "VALUECLASS", "TST1_INDEX", "BTREE", "\"KEY\" ASC, \"_KEY\" ASC", false, false, 10}, {2584860, "TST1", "TST1", "VALUECLASS", "__SCAN_", "SCAN", null, false, false, null}, {2584860, "TST1", "TST1", "VALUECLASS", "_key_PK", "BTREE", "\"_KEY\" ASC", true, true, 5}, {2584860, "TST1", "TST1", "VALUECLASS", "_key_PK_hash", "HASH", "\"_KEY\" ASC", false, true, null}};
        SqlSystemViewsSelfTest.assertEquals((int)expectedResults.length, (int)srvNodeIndexes.size());
        for (int i = 0; i < srvNodeIndexes.size(); ++i) {
            List<?> resRow = srvNodeIndexes.get(i);
            Object[] expRow = expectedResults[i];
            SqlSystemViewsSelfTest.assertEquals((int)expRow.length, (int)resRow.size());
            for (int j = 0; j < expRow.length; ++j) {
                SqlSystemViewsSelfTest.assertEquals((Object)expRow[j], resRow.get(j));
            }
        }
    }

    @Test
    public void testTableViewDuringRebuilding() throws Exception {
        this.isPersistenceEnabled = true;
        IgniteEx srv = this.startGrid(this.getConfiguration());
        srv.cluster().active(true);
        String cacheName1 = "CACHE_1";
        String cacheSqlName1 = "SQL_PUBLIC_" + cacheName1;
        String cacheName2 = "CACHE_2";
        String cacheSqlName2 = "SQL_PUBLIC_" + cacheName2;
        this.execSql("CREATE TABLE " + cacheName1 + " (ID1 INT PRIMARY KEY, MY_VAL VARCHAR)", new Object[0]);
        this.execSql("CREATE INDEX IDX_1 ON " + cacheName1 + " (MY_VAL DESC)", new Object[0]);
        this.execSql("CREATE TABLE " + cacheName2 + " (ID INT PRIMARY KEY, MY_VAL VARCHAR)", new Object[0]);
        this.execSql("CREATE INDEX IDX_2 ON " + cacheName2 + " (ID DESC)", new Object[0]);
        this.execSql("INSERT INTO " + cacheName1 + " VALUES(?, ?)", 1, "12345");
        this.execSql("INSERT INTO " + cacheName2 + " VALUES(?, ?)", 1, "12345");
        List<Path> idxPaths = this.getIndexBinPaths(cacheSqlName1);
        idxPaths.addAll(this.getIndexBinPaths(cacheSqlName2));
        this.stopAllGrids();
        idxPaths.forEach(idxPath -> SqlSystemViewsSelfTest.assertTrue((boolean)U.delete((Path)idxPath)));
        GridQueryProcessor.idxCls = AbstractIndexingCommonTest.BlockingIndexing.class;
        srv = this.startGrid(this.getConfiguration());
        srv.cluster().active(true);
        this.checkIndexRebuild(cacheName1, true);
        this.checkIndexRebuild(cacheName2, true);
        ((AbstractIndexingCommonTest.BlockingIndexing)srv.context().query().getIndexing()).stopBlock(cacheSqlName1);
        srv.cache(cacheSqlName1).indexReadyFuture().get(30000L);
        this.checkIndexRebuild(cacheName1, false);
        this.checkIndexRebuild(cacheName2, true);
        ((AbstractIndexingCommonTest.BlockingIndexing)srv.context().query().getIndexing()).stopBlock(cacheSqlName2);
        srv.cache(cacheSqlName2).indexReadyFuture().get(30000L);
        this.checkIndexRebuild(cacheName1, false);
        this.checkIndexRebuild(cacheName2, false);
    }

    private void checkIndexRebuild(String cacheName, boolean rebuild) {
        String idxSql = "SELECT IS_INDEX_REBUILD_IN_PROGRESS FROM " + QueryUtils.sysSchemaName() + ".TABLES WHERE TABLE_NAME = ?";
        List<List<?>> res = this.execSql((Ignite)this.grid(), idxSql, cacheName);
        SqlSystemViewsSelfTest.assertFalse((boolean)res.isEmpty());
        SqlSystemViewsSelfTest.assertTrue((boolean)res.stream().allMatch(row -> {
            SqlSystemViewsSelfTest.assertEquals((int)1, (int)row.size());
            Boolean isIndexRebuildInProgress = (Boolean)row.get(0);
            return isIndexRebuildInProgress == rebuild;
        }));
    }

    protected CacheConfiguration<AbstractSchemaSelfTest.KeyClass, AbstractSchemaSelfTest.ValueClass> cacheConfiguration(String cacheName) throws Exception {
        CacheConfiguration ccfg = new CacheConfiguration().setName(cacheName);
        QueryEntity entity = new QueryEntity();
        entity.setKeyType(AbstractSchemaSelfTest.KeyClass.class.getName());
        entity.setValueType(AbstractSchemaSelfTest.ValueClass.class.getName());
        entity.setKeyFieldName("key");
        entity.addQueryField("key", entity.getKeyType(), null);
        entity.addQueryField("id", Long.class.getName(), null);
        entity.addQueryField("field1", Long.class.getName(), null);
        entity.setKeyFields(Collections.singleton("id"));
        entity.setIndexes(Collections.singletonList(new QueryIndex("key", true, cacheName + "_index")));
        ccfg.setQueryEntities(Collections.singletonList(entity));
        return ccfg;
    }

    @Test
    public void testQueryModes() throws Exception {
        IgniteEx ignite = this.startGrid(0);
        this.startGrid(1);
        UUID nodeId = ignite.cluster().localNode().id();
        IgniteCache cache = ignite.getOrCreateCache("default");
        String sql = "SELECT NODE_ID FROM " + QueryUtils.sysSchemaName() + ".NODES WHERE NODE_ORDER = 1";
        SqlFieldsQuery qry = new SqlFieldsQuery(sql).setDistributedJoins(true);
        SqlSystemViewsSelfTest.assertEquals((Object)nodeId, ((List)cache.query(qry).getAll().get(0)).get(0));
        qry = new SqlFieldsQuery(sql).setReplicatedOnly(true);
        SqlSystemViewsSelfTest.assertEquals((Object)nodeId, ((List)cache.query(qry).getAll().get(0)).get(0));
        qry = new SqlFieldsQuery(sql).setLocal(true);
        SqlSystemViewsSelfTest.assertEquals((Object)nodeId, ((List)cache.query(qry).getAll().get(0)).get(0));
    }

    @Test
    public void testQueryHistoryMetricsModes() throws Exception {
        IgniteEx ignite = this.startGrid(0);
        String SCHEMA_NAME = "TEST_SCHEMA";
        long MAX_SLEEP = 500L;
        long MIN_SLEEP = 50L;
        long tsBeforeRun = System.currentTimeMillis();
        IgniteCache cache = ignite.createCache(new CacheConfiguration("default").setIndexedTypes(new Class[]{Integer.class, String.class}).setSqlSchema("TEST_SCHEMA").setSqlFunctionClasses(new Class[]{GridTestUtils.SqlTestFunctions.class}));
        cache.put((Object)100, (Object)"200");
        String sql = "SELECT \"STRING\"._KEY, \"STRING\"._VAL FROM \"STRING\" WHERE _key=100 AND sleep_and_can_fail()>0";
        GridTestUtils.SqlTestFunctions.sleepMs = 50L;
        GridTestUtils.SqlTestFunctions.fail = false;
        cache.query(new SqlFieldsQuery(sql).setSchema("TEST_SCHEMA")).getAll();
        GridTestUtils.SqlTestFunctions.sleepMs = 500L;
        GridTestUtils.SqlTestFunctions.fail = false;
        cache.query(new SqlFieldsQuery(sql).setSchema("TEST_SCHEMA")).getAll();
        GridTestUtils.SqlTestFunctions.sleepMs = 50L;
        GridTestUtils.SqlTestFunctions.fail = true;
        GridTestUtils.assertThrows((IgniteLogger)log, () -> cache.query(new SqlFieldsQuery(sql).setSchema("TEST_SCHEMA")).getAll(), CacheException.class, (String)"Exception calling user-defined function");
        String sqlHist = "SELECT SCHEMA_NAME, SQL, LOCAL, EXECUTIONS, FAILURES, DURATION_MIN, DURATION_MAX, LAST_START_TIME, ENFORCE_JOIN_ORDER , DISTRIBUTED_JOINS, LAZY FROM " + QueryUtils.sysSchemaName() + ".SQL_QUERIES_HISTORY ORDER BY LAST_START_TIME";
        cache.query(new SqlFieldsQuery(sqlHist).setLocal(true)).getAll();
        cache.query(new SqlFieldsQuery(sqlHist).setLocal(true)).getAll();
        List res = cache.query(new SqlFieldsQuery(sqlHist).setLocal(true)).getAll();
        SqlSystemViewsSelfTest.assertEquals((int)2, (int)res.size());
        long tsAfterRun = System.currentTimeMillis();
        List firstRow = (List)res.get(0);
        List secondRow = (List)res.get(1);
        SqlSystemViewsSelfTest.assertEquals((Object)"TEST_SCHEMA", firstRow.get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)"TEST_SCHEMA", secondRow.get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)sql, firstRow.get(1));
        SqlSystemViewsSelfTest.assertEquals((Object)sqlHist, secondRow.get(1));
        SqlSystemViewsSelfTest.assertEquals((Object)false, firstRow.get(2));
        SqlSystemViewsSelfTest.assertEquals((Object)true, secondRow.get(2));
        SqlSystemViewsSelfTest.assertEquals((Object)3L, firstRow.get(3));
        SqlSystemViewsSelfTest.assertEquals((Object)2L, secondRow.get(3));
        SqlSystemViewsSelfTest.assertEquals((Object)1L, firstRow.get(4));
        SqlSystemViewsSelfTest.assertEquals((Object)0L, secondRow.get(4));
        SqlSystemViewsSelfTest.assertTrue(((Long)firstRow.get(5) >= 50L ? 1 : 0) != 0);
        SqlSystemViewsSelfTest.assertTrue(((Long)firstRow.get(5) < (Long)firstRow.get(6) ? 1 : 0) != 0);
        SqlSystemViewsSelfTest.assertTrue(((Long)firstRow.get(6) >= 500L ? 1 : 0) != 0);
        SqlSystemViewsSelfTest.assertFalse((boolean)((Timestamp)firstRow.get(7)).before(new Timestamp(tsBeforeRun)));
        SqlSystemViewsSelfTest.assertFalse((boolean)((Timestamp)firstRow.get(7)).after(new Timestamp(tsAfterRun)));
        SqlSystemViewsSelfTest.assertEquals((Object)false, secondRow.get(8));
        SqlSystemViewsSelfTest.assertEquals((Object)false, secondRow.get(9));
        SqlSystemViewsSelfTest.assertEquals((Object)this.activateLazyByDflt, secondRow.get(10));
    }

    @Test
    public void testRunningQueriesView() throws Exception {
        IgniteEx ignite = this.startGrid(0);
        IgniteCache cache = ignite.createCache(new CacheConfiguration("default").setIndexedTypes(new Class[]{Integer.class, String.class}));
        cache.put((Object)100, (Object)"200");
        String sql = "SELECT SQL, QUERY_ID, SCHEMA_NAME, LOCAL, START_TIME, DURATION, ENFORCE_JOIN_ORDER, DISTRIBUTED_JOINS, LAZY, LABEL FROM " + QueryUtils.sysSchemaName() + ".SQL_QUERIES";
        String qryPrefix = ignite.localNode().id() + "_";
        String label0 = "test-label-0";
        String label1 = "test-label-1";
        FieldsQueryCursor notClosedFieldQryCursor = cache.query(new SqlFieldsQuery(sql).setLabel(label0).setLocal(true));
        List cur = cache.query(new SqlFieldsQuery(sql).setLabel(label1).setLocal(true)).getAll();
        SqlSystemViewsSelfTest.assertEquals((int)2, (int)cur.size());
        List res0 = (List)cur.get(0);
        List res1 = (List)cur.get(1);
        Timestamp ts = (Timestamp)res0.get(4);
        Instant now = Instant.now();
        long diffInMillis = now.minusMillis(ts.getTime()).toEpochMilli();
        SqlSystemViewsSelfTest.assertTrue((diffInMillis < 3000L ? 1 : 0) != 0);
        SqlSystemViewsSelfTest.assertEquals((Object)sql, res0.get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)sql, res1.get(0));
        SqlSystemViewsSelfTest.assertTrue((boolean)((Boolean)res0.get(3)));
        SqlSystemViewsSelfTest.assertFalse((boolean)((Boolean)res0.get(6)));
        SqlSystemViewsSelfTest.assertFalse((boolean)((Boolean)res0.get(7)));
        SqlSystemViewsSelfTest.assertEquals((Object)this.activateLazyByDflt, res0.get(8));
        String id0 = (String)res0.get(1);
        String id1 = (String)res1.get(1);
        Assert.assertNotEquals((Object)id0, (Object)id1);
        SqlSystemViewsSelfTest.assertEquals((Object)label0, res0.get(9));
        SqlSystemViewsSelfTest.assertEquals((Object)label1, res1.get(9));
        String qryId1 = qryPrefix + "1";
        String qryId2 = qryPrefix + "2";
        SqlSystemViewsSelfTest.assertTrue((id0.equals(qryId1) || id1.equals(qryId1) ? 1 : 0) != 0);
        SqlSystemViewsSelfTest.assertTrue((id0.equals(qryId2) || id1.equals(qryId2) ? 1 : 0) != 0);
        SqlSystemViewsSelfTest.assertEquals((int)2, (int)cache.query(new SqlFieldsQuery(sql)).getAll().size());
        notClosedFieldQryCursor.close();
        SqlSystemViewsSelfTest.assertEquals((int)1, (int)cache.query(new SqlFieldsQuery(sql)).getAll().size());
        cache.put((Object)100, (Object)"200");
        QueryCursor notClosedQryCursor = cache.query((Query)new SqlQuery(String.class, "_key=100"));
        String expSqlQry = "SELECT \"default\".\"STRING\"._KEY, \"default\".\"STRING\"._VAL FROM \"default\".\"STRING\" WHERE _key=100";
        List cur2 = cache.query(new SqlFieldsQuery(sql)).getAll();
        SqlSystemViewsSelfTest.assertEquals((int)2, (int)cur2.size());
        List res02 = (List)cur2.get(0);
        List res12 = (List)cur2.get(1);
        SqlSystemViewsSelfTest.assertTrue((String)expSqlQry, (res02.get(0).equals(expSqlQry) || res12.get(0).equals(expSqlQry) ? 1 : 0) != 0);
        SqlSystemViewsSelfTest.assertFalse((boolean)((Boolean)res02.get(3)));
        SqlSystemViewsSelfTest.assertFalse((boolean)((Boolean)res12.get(3)));
        notClosedQryCursor.close();
        String label = "test-label-2";
        expSqlQry = "select * from \"default\".\"STRING\" where  _key=100";
        FieldsQueryCursor notClosedFieldsQryCursor = cache.query(new SqlFieldsQuery(expSqlQry).setLabel(label));
        cur = cache.query(new SqlFieldsQuery(sql).setLabel(label)).getAll();
        SqlSystemViewsSelfTest.assertEquals((int)2, (int)cur.size());
        res0 = (List)cur.get(0);
        res1 = (List)cur.get(1);
        SqlSystemViewsSelfTest.assertTrue((String)expSqlQry, (res0.get(0).equals(expSqlQry) || res1.get(0).equals(expSqlQry) ? 1 : 0) != 0);
        SqlSystemViewsSelfTest.assertFalse((boolean)((Boolean)res0.get(3)));
        SqlSystemViewsSelfTest.assertFalse((boolean)((Boolean)res1.get(3)));
        SqlSystemViewsSelfTest.assertEquals((Object)label, res0.get(9));
        SqlSystemViewsSelfTest.assertEquals((Object)label, res1.get(9));
        notClosedFieldsQryCursor.close();
        label = "test-label-3";
        expSqlQry = "SELECT _KEY, _VAL FROM \"default\".\"STRING\" USE INDEX (\"_key_PK\") ORDER BY \"_KEY\"";
        QueryCursor notClosedIdxQryCursor = cache.query((Query)new IndexQuery(String.class, "_key_PK").setLabel(label));
        cur = cache.query(new SqlFieldsQuery(sql).setLabel(label)).getAll();
        SqlSystemViewsSelfTest.assertEquals((int)2, (int)cur.size());
        res0 = (List)cur.get(0);
        res1 = (List)cur.get(1);
        SqlSystemViewsSelfTest.assertTrue((String)expSqlQry, (res0.get(0).equals(expSqlQry) || res1.get(0).equals(expSqlQry) ? 1 : 0) != 0);
        SqlSystemViewsSelfTest.assertFalse((boolean)((Boolean)res0.get(3)));
        SqlSystemViewsSelfTest.assertFalse((boolean)((Boolean)res1.get(3)));
        SqlSystemViewsSelfTest.assertEquals((Object)label, res0.get(9));
        SqlSystemViewsSelfTest.assertEquals((Object)label, res1.get(9));
        notClosedIdxQryCursor.close();
        sql = "SELECT SQL, QUERY_ID FROM " + QueryUtils.sysSchemaName() + ".SQL_QUERIES WHERE QUERY_ID='" + qryPrefix + "11'";
        SqlSystemViewsSelfTest.assertEquals((Object)(qryPrefix + "11"), ((List)cache.query(new SqlFieldsQuery(sql)).getAll().get(0)).get(1));
        sql = "SELECT SQL FROM " + QueryUtils.sysSchemaName() + ".SQL_QUERIES WHERE DURATION > 100000";
        SqlSystemViewsSelfTest.assertTrue((boolean)cache.query(new SqlFieldsQuery(sql)).getAll().isEmpty());
        sql = "SELECT SQL FROM " + QueryUtils.sysSchemaName() + ".SQL_QUERIES WHERE QUERY_ID='UNKNOWN'";
        SqlSystemViewsSelfTest.assertTrue((boolean)cache.query(new SqlFieldsQuery(sql)).getAll().isEmpty());
    }

    @Test
    public void testCacheToViewJoin() throws Exception {
        IgniteEx ignite = this.startGrid();
        ignite.createCache(new CacheConfiguration().setName("default").setQueryEntities(Collections.singleton(new QueryEntity(Integer.class.getName(), String.class.getName()))));
        this.assertSqlError("SELECT * FROM \"default\".String JOIN " + QueryUtils.sysSchemaName() + ".NODES ON 1=1");
    }

    private void assertColumnTypes(List<?> rowData, Class<?> ... colTypes) {
        for (int i = 0; i < colTypes.length; ++i) {
            if (rowData.get(i) == null) continue;
            SqlSystemViewsSelfTest.assertEquals((String)("Column " + i + " type"), colTypes[i], rowData.get(i).getClass());
        }
    }

    @Test
    public void testNodesViews() throws Exception {
        Ignite igniteSrv = this.startGrid(this.getTestIgniteInstanceName(), this.getConfiguration().setMetricsUpdateFrequency(500L));
        Ignite igniteCli = this.startGrid(this.getTestIgniteInstanceName(1), this.getConfiguration().setMetricsUpdateFrequency(500L).setClientMode(true));
        this.startGrid(this.getTestIgniteInstanceName(2), this.getConfiguration().setMetricsUpdateFrequency(500L).setDaemon(true));
        UUID nodeId0 = igniteSrv.cluster().localNode().id();
        this.awaitPartitionMapExchange();
        List<List<?>> resAll = this.execSql("SELECT NODE_ID, CONSISTENT_ID, VERSION, IS_CLIENT, IS_DAEMON, NODE_ORDER, ADDRESSES, HOSTNAMES FROM " + QueryUtils.sysSchemaName() + ".NODES", new Object[0]);
        this.assertColumnTypes(resAll.get(0), UUID.class, String.class, String.class, Boolean.class, Boolean.class, Long.class, String.class, String.class);
        SqlSystemViewsSelfTest.assertEquals((int)3, (int)resAll.size());
        List<List<?>> resSrv = this.execSql("SELECT NODE_ID, NODE_ORDER FROM " + QueryUtils.sysSchemaName() + ".NODES WHERE IS_CLIENT = FALSE AND IS_DAEMON = FALSE", new Object[0]);
        SqlSystemViewsSelfTest.assertEquals((int)1, (int)resSrv.size());
        SqlSystemViewsSelfTest.assertEquals((Object)nodeId0, resSrv.get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)1L, resSrv.get(0).get(1));
        List<List<?>> resCli = this.execSql("SELECT NODE_ID, NODE_ORDER FROM " + QueryUtils.sysSchemaName() + ".NODES WHERE IS_CLIENT = TRUE", new Object[0]);
        SqlSystemViewsSelfTest.assertEquals((int)1, (int)resCli.size());
        SqlSystemViewsSelfTest.assertEquals((Object)this.nodeId(1), resCli.get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)2L, resCli.get(0).get(1));
        List<List<?>> resDaemon = this.execSql("SELECT NODE_ID, NODE_ORDER FROM " + QueryUtils.sysSchemaName() + ".NODES WHERE IS_DAEMON = TRUE", new Object[0]);
        SqlSystemViewsSelfTest.assertEquals((int)1, (int)resDaemon.size());
        SqlSystemViewsSelfTest.assertEquals((Object)this.nodeId(2), resDaemon.get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)3L, resDaemon.get(0).get(1));
        SqlSystemViewsSelfTest.assertEquals((int)0, (int)this.execSql("SELECT NODE_ID FROM " + QueryUtils.sysSchemaName() + ".NODES WHERE NODE_ID = '-'", new Object[0]).size());
        SqlSystemViewsSelfTest.assertEquals((int)1, (int)this.execSql("SELECT NODE_ID FROM " + QueryUtils.sysSchemaName() + ".NODES WHERE NODE_ID = ?", nodeId0).size());
        SqlSystemViewsSelfTest.assertEquals((int)1, (int)this.execSql("SELECT NODE_ID FROM " + QueryUtils.sysSchemaName() + ".NODES WHERE NODE_ID = ?", this.nodeId(2)).size());
        SqlSystemViewsSelfTest.assertEquals((int)3, (int)this.execSql("SELECT NODE_ID FROM " + QueryUtils.sysSchemaName() + ".NODES WHERE NODE_ID = ? OR node_order=1 OR node_order=2 OR node_order=3", nodeId0).size());
        SqlSystemViewsSelfTest.assertEquals((Object)3L, this.execSql("SELECT COUNT(*) FROM " + QueryUtils.sysSchemaName() + ".NODES", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)nodeId0, this.execSql("SELECT N1.NODE_ID FROM " + QueryUtils.sysSchemaName() + ".NODES N1 JOIN " + QueryUtils.sysSchemaName() + ".NODES N2 ON N1.NODE_ORDER = N2.NODE_ORDER JOIN " + QueryUtils.sysSchemaName() + ".NODES N3 ON N2.NODE_ID = N3.NODE_ID WHERE N3.NODE_ORDER = 1", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)nodeId0, this.execSql("SELECT N1.NODE_ID FROM " + QueryUtils.sysSchemaName() + ".NODES N1 WHERE NOT EXISTS (SELECT 1 FROM " + QueryUtils.sysSchemaName() + ".NODES N2 WHERE N2.NODE_ID = N1.NODE_ID AND N2.NODE_ORDER <> 1)", new Object[0]).get(0).get(0));
        String cliAttrName = "org.apache.ignite.cache.client";
        this.assertColumnTypes(this.execSql("SELECT NODE_ID, NAME, VALUE FROM " + QueryUtils.sysSchemaName() + ".NODE_ATTRIBUTES", new Object[0]).get(0), UUID.class, String.class, String.class);
        SqlSystemViewsSelfTest.assertEquals((int)1, (int)this.execSql("SELECT NODE_ID FROM " + QueryUtils.sysSchemaName() + ".NODE_ATTRIBUTES WHERE NAME = ? AND VALUE = 'true'", cliAttrName).size());
        SqlSystemViewsSelfTest.assertEquals((int)3, (int)this.execSql("SELECT NODE_ID FROM " + QueryUtils.sysSchemaName() + ".NODE_ATTRIBUTES WHERE NAME = ?", cliAttrName).size());
        SqlSystemViewsSelfTest.assertEquals((int)1, (int)this.execSql("SELECT NODE_ID FROM " + QueryUtils.sysSchemaName() + ".NODE_ATTRIBUTES WHERE NODE_ID = ? AND NAME = ? AND VALUE = 'true'", this.nodeId(1), cliAttrName).size());
        SqlSystemViewsSelfTest.assertEquals((int)0, (int)this.execSql("SELECT NODE_ID FROM " + QueryUtils.sysSchemaName() + ".NODE_ATTRIBUTES WHERE NODE_ID = '-' AND NAME = ?", cliAttrName).size());
        SqlSystemViewsSelfTest.assertEquals((int)0, (int)this.execSql("SELECT NODE_ID FROM " + QueryUtils.sysSchemaName() + ".NODE_ATTRIBUTES WHERE NODE_ID = ? AND NAME = '-'", this.nodeId(1)).size());
        String sqlAllMetrics = "SELECT NODE_ID, LAST_UPDATE_TIME, MAX_ACTIVE_JOBS, CUR_ACTIVE_JOBS, AVG_ACTIVE_JOBS, MAX_WAITING_JOBS, CUR_WAITING_JOBS, AVG_WAITING_JOBS, MAX_REJECTED_JOBS, CUR_REJECTED_JOBS, AVG_REJECTED_JOBS, TOTAL_REJECTED_JOBS, MAX_CANCELED_JOBS, CUR_CANCELED_JOBS, AVG_CANCELED_JOBS, TOTAL_CANCELED_JOBS, MAX_JOBS_WAIT_TIME, CUR_JOBS_WAIT_TIME, AVG_JOBS_WAIT_TIME, MAX_JOBS_EXECUTE_TIME, CUR_JOBS_EXECUTE_TIME, AVG_JOBS_EXECUTE_TIME, TOTAL_JOBS_EXECUTE_TIME, TOTAL_EXECUTED_JOBS, TOTAL_EXECUTED_TASKS, TOTAL_BUSY_TIME, TOTAL_IDLE_TIME, CUR_IDLE_TIME, BUSY_TIME_PERCENTAGE, IDLE_TIME_PERCENTAGE, TOTAL_CPU, CUR_CPU_LOAD, AVG_CPU_LOAD, CUR_GC_CPU_LOAD, HEAP_MEMORY_INIT, HEAP_MEMORY_USED, HEAP_MEMORY_COMMITED, HEAP_MEMORY_MAX, HEAP_MEMORY_TOTAL, NONHEAP_MEMORY_INIT, NONHEAP_MEMORY_USED, NONHEAP_MEMORY_COMMITED, NONHEAP_MEMORY_MAX, NONHEAP_MEMORY_TOTAL, UPTIME, JVM_START_TIME, NODE_START_TIME, LAST_DATA_VERSION, CUR_THREAD_COUNT, MAX_THREAD_COUNT, TOTAL_THREAD_COUNT, CUR_DAEMON_THREAD_COUNT, SENT_MESSAGES_COUNT, SENT_BYTES_COUNT, RECEIVED_MESSAGES_COUNT, RECEIVED_BYTES_COUNT, OUTBOUND_MESSAGES_QUEUE FROM " + QueryUtils.sysSchemaName() + ".NODE_METRICS";
        List<List<?>> resMetrics = this.execSql(sqlAllMetrics, new Object[0]);
        this.assertColumnTypes(resMetrics.get(0), UUID.class, Timestamp.class, Integer.class, Integer.class, Float.class, Integer.class, Integer.class, Float.class, Integer.class, Integer.class, Float.class, Integer.class, Integer.class, Integer.class, Float.class, Integer.class, Long.class, Long.class, Long.class, Long.class, Long.class, Long.class, Long.class, Integer.class, Integer.class, Long.class, Long.class, Long.class, Float.class, Float.class, Integer.class, Double.class, Double.class, Double.class, Long.class, Long.class, Long.class, Long.class, Long.class, Long.class, Long.class, Long.class, Long.class, Long.class, Long.class, Timestamp.class, Timestamp.class, Long.class, Integer.class, Integer.class, Long.class, Integer.class, Integer.class, Long.class, Integer.class, Long.class, Integer.class);
        SqlSystemViewsSelfTest.assertEquals((int)3, (int)resAll.size());
        SqlSystemViewsSelfTest.assertEquals((int)3, (int)this.execSql("SELECT NM.LAST_UPDATE_TIME FROM " + QueryUtils.sysSchemaName() + ".NODES N JOIN " + QueryUtils.sysSchemaName() + ".NODE_METRICS NM ON N.NODE_ID = NM.NODE_ID", new Object[0]).size());
        SqlSystemViewsSelfTest.assertEquals((int)1, (int)this.execSql("SELECT LAST_UPDATE_TIME FROM " + QueryUtils.sysSchemaName() + ".NODE_METRICS WHERE NODE_ID = ?", this.nodeId(1)).size());
        SqlSystemViewsSelfTest.assertEquals((int)0, (int)this.execSql("SELECT LAST_UPDATE_TIME FROM " + QueryUtils.sysSchemaName() + ".NODE_METRICS WHERE NODE_ID = ?", "-").size());
        SqlSystemViewsSelfTest.assertEquals((Object)3L, this.execSql("SELECT COUNT(*) FROM " + QueryUtils.sysSchemaName() + ".NODE_METRICS", new Object[0]).get(0).get(0));
        for (int i = 0; i < 100; ++i) {
            IgniteFuture fut = igniteSrv.compute(igniteSrv.cluster().forNodeId(nodeId0, new UUID[]{this.nodeId(1)})).broadcastAsync(new IgniteRunnable(){

                public void run() {
                    Random rnd = new Random();
                    try {
                        GridAbstractTest.doSleep((long)rnd.nextInt(100));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
            if (i % 10 != 0) continue;
            fut.cancel();
        }
        SqlSystemViewsSelfTest.doSleep((long)(igniteSrv.configuration().getMetricsUpdateFrequency() * 3L));
        block1: for (Ignite grid : G.allGrids()) {
            UUID nodeId = grid.cluster().localNode().id();
            Ignite ignite = F.eq((Object)nodeId, (Object)nodeId0) ? igniteCli : igniteSrv;
            for (int i = 0; i < 10; ++i) {
                ClusterMetrics metrics = ignite.cluster().node(nodeId).metrics();
                SqlSystemViewsSelfTest.assertTrue((boolean)(metrics instanceof ClusterMetricsSnapshot));
                resMetrics = this.execSql(ignite, sqlAllMetrics + " WHERE NODE_ID = ?", nodeId);
                log.info("Check metrics for node " + grid.name() + ", attempt " + (i + 1));
                if (metrics.getLastUpdateTime() == ((Timestamp)resMetrics.get(0).get(1)).getTime()) {
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getMaximumActiveJobs(), resMetrics.get(0).get(2));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getCurrentActiveJobs(), resMetrics.get(0).get(3));
                    SqlSystemViewsSelfTest.assertEquals((Object)Float.valueOf(metrics.getAverageActiveJobs()), resMetrics.get(0).get(4));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getMaximumWaitingJobs(), resMetrics.get(0).get(5));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getCurrentWaitingJobs(), resMetrics.get(0).get(6));
                    SqlSystemViewsSelfTest.assertEquals((Object)Float.valueOf(metrics.getAverageWaitingJobs()), resMetrics.get(0).get(7));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getMaximumRejectedJobs(), resMetrics.get(0).get(8));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getCurrentRejectedJobs(), resMetrics.get(0).get(9));
                    SqlSystemViewsSelfTest.assertEquals((Object)Float.valueOf(metrics.getAverageRejectedJobs()), resMetrics.get(0).get(10));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getTotalRejectedJobs(), resMetrics.get(0).get(11));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getMaximumCancelledJobs(), resMetrics.get(0).get(12));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getCurrentCancelledJobs(), resMetrics.get(0).get(13));
                    SqlSystemViewsSelfTest.assertEquals((Object)Float.valueOf(metrics.getAverageCancelledJobs()), resMetrics.get(0).get(14));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getTotalCancelledJobs(), resMetrics.get(0).get(15));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getMaximumJobWaitTime(), resMetrics.get(0).get(16));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getCurrentJobWaitTime(), resMetrics.get(0).get(17));
                    SqlSystemViewsSelfTest.assertEquals((Object)((long)metrics.getAverageJobWaitTime()), resMetrics.get(0).get(18));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getMaximumJobExecuteTime(), resMetrics.get(0).get(19));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getCurrentJobExecuteTime(), resMetrics.get(0).get(20));
                    SqlSystemViewsSelfTest.assertEquals((Object)((long)metrics.getAverageJobExecuteTime()), resMetrics.get(0).get(21));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getTotalJobsExecutionTime(), resMetrics.get(0).get(22));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getTotalExecutedJobs(), resMetrics.get(0).get(23));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getTotalExecutedTasks(), resMetrics.get(0).get(24));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getTotalBusyTime(), resMetrics.get(0).get(25));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getTotalIdleTime(), resMetrics.get(0).get(26));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getCurrentIdleTime(), resMetrics.get(0).get(27));
                    SqlSystemViewsSelfTest.assertEquals((Object)Float.valueOf(metrics.getBusyTimePercentage()), resMetrics.get(0).get(28));
                    SqlSystemViewsSelfTest.assertEquals((Object)Float.valueOf(metrics.getIdleTimePercentage()), resMetrics.get(0).get(29));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getTotalCpus(), resMetrics.get(0).get(30));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getCurrentCpuLoad(), resMetrics.get(0).get(31));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getAverageCpuLoad(), resMetrics.get(0).get(32));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getCurrentGcCpuLoad(), resMetrics.get(0).get(33));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getHeapMemoryInitialized(), resMetrics.get(0).get(34));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getHeapMemoryUsed(), resMetrics.get(0).get(35));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getHeapMemoryCommitted(), resMetrics.get(0).get(36));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getHeapMemoryMaximum(), resMetrics.get(0).get(37));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getHeapMemoryTotal(), resMetrics.get(0).get(38));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getNonHeapMemoryInitialized(), resMetrics.get(0).get(39));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getNonHeapMemoryUsed(), resMetrics.get(0).get(40));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getNonHeapMemoryCommitted(), resMetrics.get(0).get(41));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getNonHeapMemoryMaximum(), resMetrics.get(0).get(42));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getNonHeapMemoryTotal(), resMetrics.get(0).get(43));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getUpTime(), resMetrics.get(0).get(44));
                    SqlSystemViewsSelfTest.assertEquals((long)metrics.getStartTime(), (long)((Timestamp)resMetrics.get(0).get(45)).getTime());
                    SqlSystemViewsSelfTest.assertEquals((long)metrics.getNodeStartTime(), (long)((Timestamp)resMetrics.get(0).get(46)).getTime());
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getLastDataVersion(), resMetrics.get(0).get(47));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getCurrentThreadCount(), resMetrics.get(0).get(48));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getMaximumThreadCount(), resMetrics.get(0).get(49));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getTotalStartedThreadCount(), resMetrics.get(0).get(50));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getCurrentDaemonThreadCount(), resMetrics.get(0).get(51));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getSentMessagesCount(), resMetrics.get(0).get(52));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getSentBytesCount(), resMetrics.get(0).get(53));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getReceivedMessagesCount(), resMetrics.get(0).get(54));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getReceivedBytesCount(), resMetrics.get(0).get(55));
                    SqlSystemViewsSelfTest.assertEquals((Object)metrics.getOutboundMessagesQueueSize(), resMetrics.get(0).get(56));
                    continue block1;
                }
                log.info("Metrics was updated in background, will retry check");
                if (i != 9) continue;
                SqlSystemViewsSelfTest.fail((String)"Failed to check metrics, attempts limit reached (10)");
            }
        }
    }

    @Test
    public void testBaselineViews() throws Exception {
        String customAttr = "CUSTOM_NODE_ATTR";
        this.cleanPersistenceDir();
        Ignite ignite = this.startGrid(this.getTestIgniteInstanceName(), this.getPdsConfiguration("node0").setUserAttributes(F.asMap((Object)customAttr, (Object)"val0")));
        this.startGrid(this.getTestIgniteInstanceName(1), this.getPdsConfiguration("node1").setUserAttributes(F.asMap((Object)customAttr, (Object)"val1")));
        ignite.cluster().active(true);
        List<List<?>> res = this.execSql("SELECT CONSISTENT_ID, ONLINE FROM " + QueryUtils.sysSchemaName() + ".BASELINE_NODES ORDER BY CONSISTENT_ID", new Object[0]);
        this.assertColumnTypes(res.get(0), String.class, Boolean.class);
        SqlSystemViewsSelfTest.assertEquals((int)2, (int)res.size());
        SqlSystemViewsSelfTest.assertEquals((Object)"node0", res.get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)"node1", res.get(1).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)true, res.get(0).get(1));
        SqlSystemViewsSelfTest.assertEquals((Object)true, res.get(1).get(1));
        this.stopGrid(this.getTestIgniteInstanceName(1));
        res = this.execSql("SELECT CONSISTENT_ID FROM " + QueryUtils.sysSchemaName() + ".BASELINE_NODES WHERE ONLINE = false", new Object[0]);
        SqlSystemViewsSelfTest.assertEquals((int)1, (int)res.size());
        SqlSystemViewsSelfTest.assertEquals((Object)"node1", res.get(0).get(0));
        Ignite ignite2 = this.startGrid(this.getTestIgniteInstanceName(2), this.getPdsConfiguration("node2").setUserAttributes(F.asMap((Object)customAttr, (Object)"val2")));
        SqlSystemViewsSelfTest.assertEquals((int)2, (int)this.execSql(ignite2, "SELECT CONSISTENT_ID FROM " + QueryUtils.sysSchemaName() + ".BASELINE_NODES", new Object[0]).size());
        res = this.execSql("SELECT CONSISTENT_ID FROM " + QueryUtils.sysSchemaName() + ".NODES N WHERE NOT EXISTS (SELECT 1 FROM " + QueryUtils.sysSchemaName() + ".BASELINE_NODES B WHERE B.CONSISTENT_ID = N.CONSISTENT_ID)", new Object[0]);
        SqlSystemViewsSelfTest.assertEquals((int)1, (int)res.size());
        SqlSystemViewsSelfTest.assertEquals((Object)"node2", res.get(0).get(0));
        this.assertColumnTypes(this.execSql("SELECT NODE_CONSISTENT_ID, NAME, VALUE FROM " + QueryUtils.sysSchemaName() + ".BASELINE_NODE_ATTRIBUTES", new Object[0]).get(0), String.class, String.class, String.class);
        res = this.execSql("SELECT NAME, VALUE FROM " + QueryUtils.sysSchemaName() + ".BASELINE_NODE_ATTRIBUTES ORDER BY VALUE", new Object[0]);
        SqlSystemViewsSelfTest.assertTrue((res.size() > 1 ? 1 : 0) != 0);
        SqlSystemViewsSelfTest.assertEquals((int)1, (int)F.size(res, (IgnitePredicate[])new IgnitePredicate[]{(IgnitePredicate & Serializable)row -> customAttr.equals(row.get(0)) && "val0".equals(row.get(1))}));
        SqlSystemViewsSelfTest.assertEquals((int)1, (int)F.size(res, (IgnitePredicate[])new IgnitePredicate[]{(IgnitePredicate & Serializable)row -> customAttr.equals(row.get(0)) && "val1".equals(row.get(1))}));
        res = this.execSql("SELECT NAME, VALUE FROM " + QueryUtils.sysSchemaName() + ".BASELINE_NODE_ATTRIBUTES WHERE NODE_CONSISTENT_ID = ?", "node0");
        SqlSystemViewsSelfTest.assertTrue((res.size() > 1 ? 1 : 0) != 0);
        SqlSystemViewsSelfTest.assertEquals((int)1, (int)F.size(res, (IgnitePredicate[])new IgnitePredicate[]{(IgnitePredicate & Serializable)row -> customAttr.equals(row.get(0)) && "val0".equals(row.get(1))}));
        res = this.execSql("SELECT NAME, VALUE FROM " + QueryUtils.sysSchemaName() + ".BASELINE_NODE_ATTRIBUTES WHERE NODE_CONSISTENT_ID = ? AND NAME = ?", "node0", customAttr);
        SqlSystemViewsSelfTest.assertEquals((int)1, (int)res.size());
        SqlSystemViewsSelfTest.assertEquals((Object)"val0", res.get(0).get(1));
        res = this.execSql("SELECT NAME, VALUE FROM " + QueryUtils.sysSchemaName() + ".BASELINE_NODE_ATTRIBUTES WHERE NAME = ? ORDER BY VALUE", customAttr);
        SqlSystemViewsSelfTest.assertEquals((int)2, (int)res.size());
        SqlSystemViewsSelfTest.assertEquals((Object)"val0", res.get(0).get(1));
        SqlSystemViewsSelfTest.assertEquals((Object)"val1", res.get(1).get(1));
        this.startGrid(this.getTestIgniteInstanceName(1), this.getPdsConfiguration("node1").setUserAttributes(F.asMap((Object)customAttr, (Object)"val3")));
        res = this.execSql("SELECT NAME, VALUE FROM " + QueryUtils.sysSchemaName() + ".BASELINE_NODE_ATTRIBUTES WHERE NODE_CONSISTENT_ID = ? AND NAME = ?", "node1", customAttr);
        SqlSystemViewsSelfTest.assertEquals((int)1, (int)res.size());
        SqlSystemViewsSelfTest.assertEquals((Object)"val1", res.get(0).get(1));
        res = this.execSql("SELECT N.CONSISTENT_ID, NA.NAME, NA.VALUE FROM " + QueryUtils.sysSchemaName() + ".BASELINE_NODE_ATTRIBUTES NA JOIN " + QueryUtils.sysSchemaName() + ".BASELINE_NODES N ON N.CONSISTENT_ID = NA.NODE_CONSISTENT_ID WHERE NODE_CONSISTENT_ID = ? AND NAME = ?", "node0", customAttr);
        SqlSystemViewsSelfTest.assertEquals((int)1, (int)res.size());
        SqlSystemViewsSelfTest.assertEquals((Object)"node0", res.get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)customAttr, res.get(0).get(1));
        SqlSystemViewsSelfTest.assertEquals((Object)"val0", res.get(0).get(2));
    }

    @Test
    public void testClientConnectionViews() throws Exception {
        this.startGrid(this.getConfiguration());
        try (IgniteClient cl1 = Ignition.startClient((ClientConfiguration)new ClientConfiguration().setAddresses(new String[]{"127.0.0.1:10800"}).setUserAttributes(F.asMap((Object)"attr1", (Object)"val1", (Object)"attr2", (Object)"val2")));
             IgniteClient cl2 = Ignition.startClient((ClientConfiguration)new ClientConfiguration().setAddresses(new String[]{"127.0.0.1:10800"}).setUserAttributes(F.asMap((Object)"attr1", (Object)"val2")));
             IgniteClient cl3 = Ignition.startClient((ClientConfiguration)new ClientConfiguration().setAddresses(new String[]{"127.0.0.1:10800"}));){
            List<List<?>> res = this.execSql("SELECT CONNECTION_ID FROM " + QueryUtils.sysSchemaName() + ".CLIENT_CONNECTIONS", new Object[0]);
            SqlSystemViewsSelfTest.assertEquals((int)3, (int)res.size());
            res = this.execSql("SELECT C.CONNECTION_ID, CA.NAME, CA.VALUE FROM " + QueryUtils.sysSchemaName() + ".CLIENT_CONNECTIONS C JOIN " + QueryUtils.sysSchemaName() + ".CLIENT_CONNECTION_ATTRIBUTES CA ON (C.CONNECTION_ID = CA.CONNECTION_ID)", new Object[0]);
            SqlSystemViewsSelfTest.assertEquals((int)3, (int)res.size());
            res = this.execSql("SELECT C.CONNECTION_ID, CA.NAME, CA.VALUE FROM " + QueryUtils.sysSchemaName() + ".CLIENT_CONNECTIONS C JOIN " + QueryUtils.sysSchemaName() + ".CLIENT_CONNECTION_ATTRIBUTES CA ON (C.CONNECTION_ID = CA.CONNECTION_ID) WHERE CA.NAME = ?", "attr2");
            SqlSystemViewsSelfTest.assertEquals((int)1, (int)res.size());
            SqlSystemViewsSelfTest.assertEquals((Object)"attr2", res.get(0).get(1));
            SqlSystemViewsSelfTest.assertEquals((Object)"val2", res.get(0).get(2));
        }
    }

    protected IgniteConfiguration getConfiguration() throws Exception {
        IgniteConfiguration cfg = super.getConfiguration().setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration().setName("default")});
        if (this.isPersistenceEnabled) {
            cfg.setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true).setMaxSize(0xA00000L)));
        }
        return cfg;
    }

    @Test
    public void testIoStatisticsViews() throws Exception {
        Ignite ignite = this.startGrid(this.getTestIgniteInstanceName(), this.getPdsConfiguration("node0"));
        ignite.cluster().active(true);
        this.execSql("CREATE TABLE TST(id INTEGER PRIMARY KEY, name VARCHAR, age integer)", new Object[0]);
        for (int i = 0; i < 500; ++i) {
            this.execSql("INSERT INTO TST(id, name, age) VALUES (" + i + ",'name-" + i + "'," + i + 1 + ")", new Object[0]);
        }
        String sql1 = "SELECT CACHE_GROUP_ID, CACHE_GROUP_NAME, PHYSICAL_READS, LOGICAL_READS FROM " + QueryUtils.sysSchemaName() + ".LOCAL_CACHE_GROUPS_IO";
        List<List<?>> res1 = this.execSql(sql1, new Object[0]);
        Map<Object, Object> map = res1.stream().collect(Collectors.toMap(k -> k.get(1), v -> v.get(3)));
        SqlSystemViewsSelfTest.assertEquals((int)2, (int)map.size());
        SqlSystemViewsSelfTest.assertTrue((boolean)map.containsKey("SQL_PUBLIC_TST"));
        SqlSystemViewsSelfTest.assertTrue(((Long)map.get("SQL_PUBLIC_TST") > 0L ? 1 : 0) != 0);
        SqlSystemViewsSelfTest.assertTrue((boolean)map.containsKey("default"));
        sql1 = "SELECT CACHE_GROUP_ID, CACHE_GROUP_NAME, PHYSICAL_READS, LOGICAL_READS FROM " + QueryUtils.sysSchemaName() + ".LOCAL_CACHE_GROUPS_IO WHERE CACHE_GROUP_NAME='SQL_PUBLIC_TST'";
        SqlSystemViewsSelfTest.assertEquals((int)1, (int)this.execSql(sql1, new Object[0]).size());
    }

    @Test
    public void testTablesView() throws Exception {
        IgniteEx ignite = this.startGrid(this.getConfiguration());
        GridCacheProcessor cacheProc = ignite.context().cache();
        this.execSql("CREATE TABLE CACHE_SQL (ID INT PRIMARY KEY, MY_VAL VARCHAR) WITH \"cache_name=cache_sql,template=partitioned,atomicity=atomic,wrap_value=true,value_type=random_name\"", new Object[0]);
        this.execSql("CREATE TABLE PUBLIC.DFLT_CACHE (ID1 INT, ID2 INT, MY_VAL VARCHAR, PRIMARY KEY (ID1, ID2)) WITH\"affinity_key=ID2,wrap_value=false,key_type=random_name\"", new Object[0]);
        int cacheSqlId = cacheProc.cacheDescriptor("cache_sql").cacheId();
        int ddlTabId = cacheProc.cacheDescriptor("SQL_PUBLIC_DFLT_CACHE").cacheId();
        List<List<?>> cacheSqlInfos = this.execSql("SELECT * FROM " + QueryUtils.sysSchemaName() + ".TABLES WHERE TABLE_NAME = 'CACHE_SQL'", new Object[0]);
        List<Serializable> expRow = Arrays.asList(cacheSqlId, "cache_sql", cacheSqlId, "cache_sql", "PUBLIC", "CACHE_SQL", null, "ID", null, "java.lang.Integer", "random_name", false);
        SqlSystemViewsSelfTest.assertEquals((String)"Returned incorrect info. ", expRow, cacheSqlInfos.get(0));
        SqlSystemViewsSelfTest.assertEquals((String)"Expected to return only one row", (int)1, (int)cacheSqlInfos.size());
        List<List<?>> allInfos = this.execSql("SELECT * FROM " + QueryUtils.sysSchemaName() + ".TABLES", new Object[0]);
        List<List> allExpRows = Arrays.asList(expRow, Arrays.asList(ddlTabId, "SQL_PUBLIC_DFLT_CACHE", ddlTabId, "SQL_PUBLIC_DFLT_CACHE", "PUBLIC", "DFLT_CACHE", "ID2", null, "MY_VAL", "random_name", "java.lang.String", false));
        if (!F.eqNotOrdered(allExpRows, allInfos)) {
            SqlSystemViewsSelfTest.fail((String)("Returned incorrect rows [expected=" + allExpRows + ", actual=" + allInfos + "]."));
        }
        SqlSystemViewsSelfTest.assertEquals(Collections.singletonList(Arrays.asList("DFLT_CACHE", "SQL_PUBLIC_DFLT_CACHE")), this.execSql("SELECT TABLE_NAME, CACHE_NAME FROM " + QueryUtils.sysSchemaName() + ".TABLES WHERE CACHE_NAME LIKE 'SQL\\_PUBLIC\\_%'", new Object[0]));
        SqlSystemViewsSelfTest.assertEquals(Collections.singletonList(Arrays.asList("CACHE_SQL", "cache_sql")), this.execSql("SELECT TABLE_NAME, CACHE_NAME FROM " + QueryUtils.sysSchemaName() + ".TABLES WHERE CACHE_NAME NOT LIKE 'SQL\\_PUBLIC\\_%'", new Object[0]));
        SqlSystemViewsSelfTest.assertEquals(Arrays.asList(Arrays.asList("DFLT_CACHE", "SQL_PUBLIC_DFLT_CACHE", "SQL_PUBLIC_DFLT_CACHE"), Arrays.asList("CACHE_SQL", "cache_sql", "cache_sql")), this.execSql("SELECT TABLE_NAME, TAB.CACHE_NAME, C.CACHE_NAME FROM " + QueryUtils.sysSchemaName() + ".TABLES AS TAB JOIN " + QueryUtils.sysSchemaName() + ".CACHES AS C ON TAB.CACHE_ID = C.CACHE_ID ORDER BY C.CACHE_NAME", new Object[0]));
    }

    @Test
    public void testTablesDropAndCreate() throws Exception {
        IgniteEx ignite = this.startGrid(this.getConfiguration());
        String selectTabNameCacheName = "SELECT TABLE_NAME, CACHE_NAME FROM " + QueryUtils.sysSchemaName() + ".TABLES ORDER BY TABLE_NAME";
        SqlSystemViewsSelfTest.assertTrue((String)"Initially no tables expected", (boolean)this.execSql(selectTabNameCacheName, new Object[0]).isEmpty());
        this.execSql("CREATE TABLE PUBLIC.TAB1 (ID INT PRIMARY KEY, VAL VARCHAR)", new Object[0]);
        SqlSystemViewsSelfTest.assertEquals(Arrays.asList(Arrays.asList("TAB1", "SQL_PUBLIC_TAB1")), this.execSql(selectTabNameCacheName, new Object[0]));
        this.execSql("CREATE TABLE PUBLIC.TAB2 (ID LONG PRIMARY KEY, VAL_STR VARCHAR) WITH \"cache_name=cache2\"", new Object[0]);
        this.execSql("CREATE TABLE PUBLIC.TAB3 (ID LONG PRIMARY KEY, VAL_INT INT) WITH \"cache_name=cache3\" ", new Object[0]);
        SqlSystemViewsSelfTest.assertEquals(Arrays.asList(Arrays.asList("TAB1", "SQL_PUBLIC_TAB1"), Arrays.asList("TAB2", "cache2"), Arrays.asList("TAB3", "cache3")), this.execSql(selectTabNameCacheName, new Object[0]));
        this.execSql("DROP TABLE PUBLIC.TAB2", new Object[0]);
        SqlSystemViewsSelfTest.assertEquals(Arrays.asList(Arrays.asList("TAB1", "SQL_PUBLIC_TAB1"), Arrays.asList("TAB3", "cache3")), this.execSql(selectTabNameCacheName, new Object[0]));
        this.execSql("DROP TABLE PUBLIC.TAB3", new Object[0]);
        SqlSystemViewsSelfTest.assertEquals(Arrays.asList(Arrays.asList("TAB1", "SQL_PUBLIC_TAB1")), this.execSql(selectTabNameCacheName, new Object[0]));
        this.execSql("DROP TABLE PUBLIC.TAB1", new Object[0]);
        SqlSystemViewsSelfTest.assertTrue((String)"All tables should be dropped", (boolean)this.execSql(selectTabNameCacheName, new Object[0]).isEmpty());
    }

    @Test
    public void testTablesNullAffinityKey() throws Exception {
        IgniteEx ignite = this.startGrid(this.getConfiguration());
        ConstantMapper fakeMapper = new ConstantMapper();
        ignite.getOrCreateCache(SqlSystemViewsSelfTest.defaultCacheConfiguration().setName("NO_KEY_FIELDS_CACHE").setAffinityMapper((AffinityKeyMapper)fakeMapper).setQueryEntities(Collections.singleton(new QueryEntity(Object.class.getName(), "Object2").addQueryField("name", String.class.getName(), null).addQueryField("salary", Integer.class.getName(), null).setTableName("NO_KEY_TABLE"))));
        List<List<String>> expected = Collections.singletonList(Arrays.asList("NO_KEY_TABLE", null));
        SqlSystemViewsSelfTest.assertEquals(expected, this.execSql("SELECT TABLE_NAME, AFFINITY_KEY_COLUMN FROM " + QueryUtils.sysSchemaName() + ".TABLES WHERE CACHE_NAME = 'NO_KEY_FIELDS_CACHE'", new Object[0]));
        SqlSystemViewsSelfTest.assertEquals(expected, this.execSql("SELECT TABLE_NAME, AFFINITY_KEY_COLUMN FROM " + QueryUtils.sysSchemaName() + ".TABLES WHERE AFFINITY_KEY_COLUMN IS NULL", new Object[0]));
    }

    @Test
    public void testTablesViewKeyVal() throws Exception {
        IgniteEx ignite = this.startGrid(this.getConfiguration());
        ignite.getOrCreateCache(SqlSystemViewsSelfTest.defaultCacheConfiguration().setName("NO_ALIAS_NON_SQL_KEY").setQueryEntities(Collections.singleton(new QueryEntity(Object.class.getName(), "Object2").addQueryField("name", String.class.getName(), null).addQueryField("salary", Integer.class.getName(), null).setTableName("NO_ALIAS_NON_SQL_KEY"))));
        List<?> keyValAliases = this.execSql("SELECT KEY_ALIAS, VALUE_ALIAS FROM " + QueryUtils.sysSchemaName() + ".TABLES WHERE TABLE_NAME = 'NO_ALIAS_NON_SQL_KEY'", new Object[0]).get(0);
        SqlSystemViewsSelfTest.assertEquals(Arrays.asList(null, null), keyValAliases);
        this.execSql("CREATE TABLE PUBLIC.SIMPLE_KEY_SIMPLE_VAL (ID INT PRIMARY KEY, NAME VARCHAR) WITH \"wrap_value=false\"", new Object[0]);
        keyValAliases = this.execSql("SELECT KEY_ALIAS, VALUE_ALIAS FROM " + QueryUtils.sysSchemaName() + ".TABLES WHERE TABLE_NAME = 'SIMPLE_KEY_SIMPLE_VAL'", new Object[0]).get(0);
        SqlSystemViewsSelfTest.assertEquals(Arrays.asList("ID", "NAME"), keyValAliases);
        this.execSql("CREATE TABLE PUBLIC.COMPLEX_KEY_COMPLEX_VAL (ID1 INT, ID2 INT, VAL1 VARCHAR, VAL2 VARCHAR, PRIMARY KEY(ID1, ID2))", new Object[0]);
        keyValAliases = this.execSql("SELECT KEY_ALIAS, VALUE_ALIAS FROM " + QueryUtils.sysSchemaName() + ".TABLES WHERE TABLE_NAME = 'COMPLEX_KEY_COMPLEX_VAL'", new Object[0]).get(0);
        SqlSystemViewsSelfTest.assertEquals(Arrays.asList(null, null), keyValAliases);
    }

    @Test
    public void testCachesViews() throws Exception {
        DataStorageConfiguration dsCfg = new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setName("def").setPersistenceEnabled(true)).setDataRegionConfigurations(new DataRegionConfiguration[]{new DataRegionConfiguration().setName("dr1"), new DataRegionConfiguration().setName("dr2"), new DataRegionConfiguration().setName("dr3")});
        IgniteEx ignite0 = this.startGrid(this.getConfiguration().setDataStorageConfiguration(dsCfg));
        IgniteEx ignite1 = this.startGrid(this.getConfiguration().setDataStorageConfiguration(dsCfg).setIgniteInstanceName("node1"));
        ignite0.cluster().active(true);
        IgniteEx ignite2 = this.startGrid(this.getConfiguration().setDataStorageConfiguration(dsCfg).setIgniteInstanceName("node2"));
        IgniteEx ignite3 = this.startGrid(this.getConfiguration().setDataStorageConfiguration(dsCfg).setIgniteInstanceName("node3").setClientMode(true));
        ignite0.getOrCreateCache(new CacheConfiguration().setName("cache_atomic_part").setAtomicityMode(CacheAtomicityMode.ATOMIC).setCacheMode(CacheMode.PARTITIONED).setGroupName("cache_grp").setNodeFilter((IgnitePredicate)new TestNodeFilter(ignite0.cluster().localNode().consistentId())));
        ignite0.getOrCreateCache(new CacheConfiguration().setName("cache_atomic_repl").setAtomicityMode(CacheAtomicityMode.ATOMIC).setCacheMode(CacheMode.REPLICATED).setDataRegionName("dr1").setTopologyValidator((TopologyValidator)new TestTopologyValidator()));
        ignite0.getOrCreateCache(new CacheConfiguration().setName("cache_tx_part").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setCacheMode(CacheMode.PARTITIONED).setGroupName("cache_grp").setNodeFilter((IgnitePredicate)new TestNodeFilter(ignite0.cluster().localNode().consistentId())));
        ignite0.getOrCreateCache(new CacheConfiguration().setName("cache_tx_repl").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setCacheMode(CacheMode.REPLICATED).setDataRegionName("dr2").setEvictionFilter((EvictionFilter)new TestEvictionFilter()).setEvictionPolicyFactory((Factory)new TestEvictionPolicyFactory()).setOnheapCacheEnabled(true));
        ignite0.getOrCreateCache(new CacheConfiguration().setName("cache_cust_node_filter").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setCacheMode(CacheMode.REPLICATED).setDataRegionName("dr3").setEvictionFilter((EvictionFilter)new TestEvictionFilter()).setEvictionPolicyFactory((Factory)new TestEvictionPolicyFactory()).setOnheapCacheEnabled(true).setNodeFilter((IgnitePredicate)new CustomNodeFilter(Integer.MAX_VALUE)));
        ignite0.getOrCreateCache(new CacheConfiguration().setName("cache_cust_err_node_filter").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setCacheMode(CacheMode.REPLICATED).setDataRegionName("dr3").setEvictionFilter((EvictionFilter)new TestEvictionFilter()).setEvictionPolicyFactory((Factory)new TestEvictionPolicyFactory()).setOnheapCacheEnabled(true).setNodeFilter((IgnitePredicate)new CustomNodeFilter(1)));
        this.execSql("CREATE TABLE cache_sql (ID INT PRIMARY KEY, VAL VARCHAR) WITH \"cache_name=cache_sql,template=partitioned,atomicity=atomic\"", new Object[0]);
        this.awaitPartitionMapExchange();
        List<List<?>> resAll = this.execSql("SELECT CACHE_GROUP_ID, CACHE_GROUP_NAME, CACHE_ID, CACHE_NAME, CACHE_TYPE,CACHE_MODE, ATOMICITY_MODE, IS_ONHEAP_CACHE_ENABLED, IS_COPY_ON_READ, IS_LOAD_PREVIOUS_VALUE, IS_READ_FROM_BACKUP, PARTITION_LOSS_POLICY, NODE_FILTER, TOPOLOGY_VALIDATOR, IS_EAGER_TTL, WRITE_SYNCHRONIZATION_MODE, IS_INVALIDATE, IS_EVENTS_DISABLED, IS_STATISTICS_ENABLED, IS_MANAGEMENT_ENABLED, BACKUPS, AFFINITY, AFFINITY_MAPPER, REBALANCE_MODE, REBALANCE_BATCH_SIZE, REBALANCE_TIMEOUT, REBALANCE_DELAY, REBALANCE_THROTTLE, REBALANCE_BATCHES_PREFETCH_COUNT, REBALANCE_ORDER, EVICTION_FILTER, EVICTION_POLICY_FACTORY, IS_NEAR_CACHE_ENABLED, NEAR_CACHE_EVICTION_POLICY_FACTORY, NEAR_CACHE_START_SIZE, DEFAULT_LOCK_TIMEOUT, INTERCEPTOR, CACHE_STORE_FACTORY, IS_STORE_KEEP_BINARY, IS_READ_THROUGH, IS_WRITE_THROUGH, IS_WRITE_BEHIND_ENABLED, WRITE_BEHIND_COALESCING, WRITE_BEHIND_FLUSH_SIZE, WRITE_BEHIND_FLUSH_FREQUENCY, WRITE_BEHIND_FLUSH_THREAD_COUNT, WRITE_BEHIND_BATCH_SIZE, MAX_CONCURRENT_ASYNC_OPERATIONS, CACHE_LOADER_FACTORY, CACHE_WRITER_FACTORY, EXPIRY_POLICY_FACTORY, IS_SQL_ESCAPE_ALL, SQL_SCHEMA, SQL_INDEX_MAX_INLINE_SIZE, IS_SQL_ONHEAP_CACHE_ENABLED, SQL_ONHEAP_CACHE_MAX_SIZE, QUERY_DETAIL_METRICS_SIZE, QUERY_PARALLELISM, MAX_QUERY_ITERATORS_COUNT, DATA_REGION_NAME FROM " + QueryUtils.sysSchemaName() + ".CACHES", new Object[0]);
        this.assertColumnTypes(resAll.get(0), Integer.class, String.class, Integer.class, String.class, String.class, String.class, String.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, String.class, String.class, String.class, Boolean.class, String.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Integer.class, String.class, String.class, String.class, Integer.class, Long.class, Long.class, Long.class, Long.class, Integer.class, String.class, String.class, Boolean.class, String.class, Integer.class, Long.class, String.class, String.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Integer.class, Long.class, Integer.class, Integer.class, Integer.class, String.class, String.class, String.class, Boolean.class, String.class, Integer.class, Boolean.class, Integer.class, Integer.class, Integer.class, Integer.class, String.class);
        SqlSystemViewsSelfTest.assertEquals((Object)"cache_tx_part", this.execSql("SELECT CACHE_NAME FROM " + QueryUtils.sysSchemaName() + ".CACHES WHERE CACHE_MODE = 'PARTITIONED' AND ATOMICITY_MODE = 'TRANSACTIONAL' AND CACHE_NAME like 'cache%'", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)"cache_atomic_repl", this.execSql("SELECT CACHE_NAME FROM " + QueryUtils.sysSchemaName() + ".CACHES WHERE CACHE_MODE = 'REPLICATED' AND ATOMICITY_MODE = 'ATOMIC' AND CACHE_NAME like 'cache%'", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)2L, this.execSql("SELECT COUNT(*) FROM " + QueryUtils.sysSchemaName() + ".CACHES WHERE CACHE_GROUP_NAME = 'cache_grp'", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)"cache_atomic_repl", this.execSql("SELECT CACHE_NAME FROM " + QueryUtils.sysSchemaName() + ".CACHES WHERE DATA_REGION_NAME = 'dr1'", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)"cache_tx_repl", this.execSql("SELECT CACHE_NAME FROM " + QueryUtils.sysSchemaName() + ".CACHES WHERE DATA_REGION_NAME = 'dr2'", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)"PARTITIONED", this.execSql("SELECT CACHE_MODE FROM " + QueryUtils.sysSchemaName() + ".CACHES WHERE CACHE_NAME = 'cache_atomic_part'", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)"USER", this.execSql("SELECT CACHE_TYPE FROM " + QueryUtils.sysSchemaName() + ".CACHES WHERE CACHE_NAME = 'cache_sql'", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)0L, this.execSql("SELECT COUNT(*) FROM " + QueryUtils.sysSchemaName() + ".CACHES WHERE CACHE_NAME = 'no_such_cache'", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)0L, this.execSql("SELECT COUNT(*) FROM " + QueryUtils.sysSchemaName() + ".CACHES WHERE CACHE_NAME = '1'", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)"TestNodeFilter", this.execSql("SELECT NODE_FILTER FROM " + QueryUtils.sysSchemaName() + ".CACHES WHERE CACHE_NAME = 'cache_atomic_part'", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)"TestEvictionFilter", this.execSql("SELECT EVICTION_FILTER FROM " + QueryUtils.sysSchemaName() + ".CACHES WHERE CACHE_NAME = 'cache_tx_repl'", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)"TestEvictionPolicyFactory", this.execSql("SELECT EVICTION_POLICY_FACTORY FROM " + QueryUtils.sysSchemaName() + ".CACHES WHERE CACHE_NAME = 'cache_tx_repl'", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)"TestTopologyValidator", this.execSql("SELECT TOPOLOGY_VALIDATOR FROM " + QueryUtils.sysSchemaName() + ".CACHES WHERE CACHE_NAME = 'cache_atomic_repl'", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals(this.execSql("SELECT COUNT(*) FROM " + QueryUtils.sysSchemaName() + ".CACHES", new Object[0]).get(0).get(0), this.execSql("SELECT COUNT(*) FROM " + QueryUtils.sysSchemaName() + ".CACHES WHERE CACHE_ID <> CACHE_ID + 1", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)7L, this.execSql("SELECT COUNT(*) FROM " + QueryUtils.sysSchemaName() + ".CACHES WHERE CACHE_NAME like 'cache%'", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)7L, this.execSql((Ignite)ignite1, "SELECT COUNT(*) FROM " + QueryUtils.sysSchemaName() + ".CACHES WHERE CACHE_NAME like 'cache%'", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)7L, this.execSql((Ignite)ignite2, "SELECT COUNT(*) FROM " + QueryUtils.sysSchemaName() + ".CACHES WHERE CACHE_NAME like 'cache%'", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)7L, this.execSql((Ignite)ignite3, "SELECT COUNT(*) FROM " + QueryUtils.sysSchemaName() + ".CACHES WHERE CACHE_NAME like 'cache%'", new Object[0]).get(0).get(0));
        resAll = this.execSql("SELECT CACHE_GROUP_ID, CACHE_GROUP_NAME, IS_SHARED, CACHE_COUNT, CACHE_MODE, ATOMICITY_MODE, AFFINITY, PARTITIONS_COUNT, NODE_FILTER, DATA_REGION_NAME, TOPOLOGY_VALIDATOR, PARTITION_LOSS_POLICY, REBALANCE_MODE, REBALANCE_DELAY, REBALANCE_ORDER, BACKUPS FROM " + QueryUtils.sysSchemaName() + ".CACHE_GROUPS", new Object[0]);
        this.assertColumnTypes(resAll.get(0), Integer.class, String.class, Boolean.class, Integer.class, String.class, String.class, String.class, Integer.class, String.class, String.class, String.class, String.class, String.class, Long.class, Integer.class, Integer.class);
        SqlSystemViewsSelfTest.assertEquals((Object)2, this.execSql("SELECT CACHE_COUNT FROM " + QueryUtils.sysSchemaName() + ".CACHE_GROUPS WHERE CACHE_GROUP_NAME = 'cache_grp'", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)"cache_grp", this.execSql("SELECT CACHE_GROUP_NAME FROM " + QueryUtils.sysSchemaName() + ".CACHE_GROUPS WHERE IS_SHARED = true AND CACHE_GROUP_NAME like 'cache%'", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)"cache_tx_repl", this.execSql("SELECT CACHE_GROUP_NAME FROM " + QueryUtils.sysSchemaName() + ".CACHE_GROUPS WHERE CACHE_GROUP_ID = ?", ignite0.cachex("cache_tx_repl").context().groupId()).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((int)0, (int)this.execSql("SELECT CACHE_GROUP_ID FROM " + QueryUtils.sysSchemaName() + ".CACHE_GROUPS WHERE CACHE_GROUP_ID = 0", new Object[0]).size());
        SqlSystemViewsSelfTest.assertEquals((Object)"cache_tx_repl", this.execSql("SELECT CG.CACHE_GROUP_NAME FROM " + QueryUtils.sysSchemaName() + ".CACHES C JOIN " + QueryUtils.sysSchemaName() + ".CACHE_GROUPS CG ON C.CACHE_GROUP_ID = CG.CACHE_GROUP_ID WHERE C.CACHE_NAME = 'cache_tx_repl'", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)"cache_grp", this.execSql("SELECT CG.CACHE_GROUP_NAME FROM " + QueryUtils.sysSchemaName() + ".CACHES C JOIN " + QueryUtils.sysSchemaName() + ".CACHE_GROUPS CG ON C.CACHE_GROUP_NAME = CG.CACHE_GROUP_NAME WHERE C.CACHE_NAME = 'cache_tx_part'", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)5L, this.execSql("SELECT COUNT(*) FROM " + QueryUtils.sysSchemaName() + ".CACHES C JOIN " + QueryUtils.sysSchemaName() + ".CACHE_GROUPS CG ON C.CACHE_NAME = CG.CACHE_GROUP_NAME WHERE C.CACHE_NAME like 'cache%' AND C.CACHE_MODE = CG.CACHE_MODE AND C.ATOMICITY_MODE = CG.ATOMICITY_MODE AND COALESCE(C.AFFINITY, '-') = COALESCE(CG.AFFINITY, '-') AND COALESCE(C.NODE_FILTER, '-') = COALESCE(CG.NODE_FILTER, '-') AND COALESCE(C.DATA_REGION_NAME, '-') = COALESCE(CG.DATA_REGION_NAME, '-') AND COALESCE(C.TOPOLOGY_VALIDATOR, '-') = COALESCE(CG.TOPOLOGY_VALIDATOR, '-') AND C.PARTITION_LOSS_POLICY = CG.PARTITION_LOSS_POLICY AND C.REBALANCE_MODE = CG.REBALANCE_MODE AND C.REBALANCE_DELAY = CG.REBALANCE_DELAY AND C.REBALANCE_ORDER = CG.REBALANCE_ORDER AND COALESCE(C.BACKUPS, -1) = COALESCE(CG.BACKUPS, -1)", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals(this.execSql("SELECT COUNT(*) FROM " + QueryUtils.sysSchemaName() + ".CACHE_GROUPS", new Object[0]).get(0).get(0), this.execSql("SELECT COUNT(*) FROM " + QueryUtils.sysSchemaName() + ".CACHE_GROUPS WHERE CACHE_GROUP_ID <> CACHE_GROUP_ID + 1", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)6L, this.execSql("SELECT COUNT(*) FROM " + QueryUtils.sysSchemaName() + ".CACHE_GROUPS WHERE CACHE_GROUP_NAME like 'cache%'", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)6L, this.execSql((Ignite)ignite1, "SELECT COUNT(*) FROM " + QueryUtils.sysSchemaName() + ".CACHE_GROUPS WHERE CACHE_GROUP_NAME like 'cache%'", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)6L, this.execSql((Ignite)ignite2, "SELECT COUNT(*) FROM " + QueryUtils.sysSchemaName() + ".CACHE_GROUPS WHERE CACHE_GROUP_NAME like 'cache%'", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)6L, this.execSql((Ignite)ignite3, "SELECT COUNT(*) FROM " + QueryUtils.sysSchemaName() + ".CACHE_GROUPS WHERE CACHE_GROUP_NAME like 'cache%'", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)5L, this.execSql((Ignite)ignite0, "SELECT COUNT(*) FROM " + QueryUtils.sysSchemaName() + ".CACHE_GROUPS WHERE NODE_FILTER is NULL", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)1L, this.execSql((Ignite)ignite0, "SELECT COUNT(*) FROM " + QueryUtils.sysSchemaName() + ".CACHE_GROUPS WHERE NODE_FILTER = 'CUSTOM_NODE_FILTER'", new Object[0]).get(0).get(0));
        SqlSystemViewsSelfTest.assertEquals((Object)1L, this.execSql((Ignite)ignite0, "SELECT COUNT(*) FROM " + QueryUtils.sysSchemaName() + ".CACHE_GROUPS WHERE NODE_FILTER like '%Oops... incorrect customer realization.'", new Object[0]).get(0).get(0));
    }

    @Test
    public void testDurationMetricsCanBeLonger24Hours() throws Exception {
        Ignite ign = this.startGrid("MockedMetrics", this.getConfiguration().setMetricsUpdateFrequency(500L));
        ClusterNode node = ign.cluster().localNode();
        assert (node instanceof TcpDiscoveryNode) : "Setup failed, test is incorrect.";
        SqlSystemViewsSelfTest.setField(node, "metricsProvider", null);
        ClusterMetricsImpl original = (ClusterMetricsImpl)SqlSystemViewsSelfTest.getField(node, "metrics");
        SqlSystemViewsSelfTest.setField(node, "metrics", (Object)new MockedClusterMetrics(original));
        List<?> durationMetrics = this.execSql(ign, "SELECT MAX_JOBS_WAIT_TIME, CUR_JOBS_WAIT_TIME, AVG_JOBS_WAIT_TIME, MAX_JOBS_EXECUTE_TIME, CUR_JOBS_EXECUTE_TIME, AVG_JOBS_EXECUTE_TIME, TOTAL_JOBS_EXECUTE_TIME, TOTAL_BUSY_TIME, TOTAL_IDLE_TIME, CUR_IDLE_TIME, UPTIME FROM " + QueryUtils.sysSchemaName() + ".NODE_METRICS", new Object[0]).get(0);
        List elevenExpVals = LongStream.generate(() -> MockedClusterMetrics.LONG_DURATION_MS).limit(11L).boxed().collect(Collectors.toList());
        SqlSystemViewsSelfTest.assertEqualsCollections(elevenExpVals, durationMetrics);
    }

    @Test
    public void testConfigurationView() throws Exception {
        IgniteConfiguration icfg = new IgniteConfiguration();
        long expMaxSize = 0xA00000L;
        String expName = "my-instance";
        String expDrName = "my-dr";
        icfg.setIgniteInstanceName(expName);
        icfg.setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setLazyMemoryAllocation(false)).setDataRegionConfigurations(new DataRegionConfiguration[]{new DataRegionConfiguration().setName(expDrName).setMaxSize(expMaxSize)}));
        try (IgniteEx srv = this.startGrid(icfg);){
            srv.createCache("default");
            BiConsumer<String, String> checker = (name, val) -> SqlSystemViewsSelfTest.assertEquals((Object)val, this.execSql((Ignite)srv, "SELECT VALUE FROM SYS.CONFIGURATION WHERE NAME = ?", name).get(0).get(0));
            checker.accept("IgniteInstanceName", expName);
            checker.accept("DataStorageConfiguration.DefaultDataRegionConfiguration.LazyMemoryAllocation", "false");
            checker.accept("DataStorageConfiguration.DataRegionConfigurations[0].Name", expDrName);
            checker.accept("DataStorageConfiguration.DataRegionConfigurations[0].MaxSize", Long.toString(expMaxSize));
            checker.accept("CacheConfiguration[0].AtomicityMode", CacheAtomicityMode.TRANSACTIONAL.name());
            checker.accept("AddressResolver", null);
        }
    }

    private static <T> T getField(Object target, String fieldName) throws Exception {
        Class<?> clazz = target.getClass();
        Field fld = clazz.getDeclaredField(fieldName);
        fld.setAccessible(true);
        return (T)fld.get(target);
    }

    private static void setField(Object target, String fieldName, Object val) throws Exception {
        Class<?> clazz = target.getClass();
        Field fld = clazz.getDeclaredField(fieldName);
        fld.setAccessible(true);
        fld.set(target, val);
    }

    private IgniteConfiguration getPdsConfiguration(String consistentId) throws Exception {
        IgniteConfiguration cfg = this.getConfiguration();
        cfg.setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setMaxSize(0x6400000L).setPersistenceEnabled(true)));
        cfg.setConsistentId((Serializable)((Object)consistentId));
        return cfg;
    }

    private static class CustomNodeFilter
    implements IgnitePredicate<ClusterNode> {
        private final int attemptsBeforeE;
        private volatile int attempts;

        public CustomNodeFilter(int attemptsBeforeE) {
            this.attemptsBeforeE = attemptsBeforeE;
        }

        public boolean apply(ClusterNode node) {
            return true;
        }

        public String toString() {
            if (this.attempts++ > this.attemptsBeforeE) {
                throw new NullPointerException("Oops... incorrect customer realization.");
            }
            return "CUSTOM_NODE_FILTER";
        }
    }

    private static class TestTopologyValidator
    implements TopologyValidator {
        private TestTopologyValidator() {
        }

        public boolean validate(Collection<ClusterNode> nodes) {
            return true;
        }

        public String toString() {
            return "TestTopologyValidator";
        }
    }

    private static class TestEvictionPolicyFactory
    implements Factory<EvictionPolicy<Object, Object>> {
        private TestEvictionPolicyFactory() {
        }

        public EvictionPolicy<Object, Object> create() {
            return new EvictionPolicy<Object, Object>(){

                public void onEntryAccessed(boolean rmv, EvictableEntry<Object, Object> entry) {
                }
            };
        }

        public String toString() {
            return "TestEvictionPolicyFactory";
        }
    }

    private static class TestEvictionFilter
    implements EvictionFilter<Object, Object> {
        private TestEvictionFilter() {
        }

        public boolean evictAllowed(Cache.Entry<Object, Object> entry) {
            return false;
        }

        public String toString() {
            return "TestEvictionFilter";
        }
    }

    private static class TestNodeFilter
    implements IgnitePredicate<ClusterNode> {
        private final Object consistentId;

        TestNodeFilter(Object consistentId) {
            this.consistentId = consistentId;
        }

        public boolean apply(ClusterNode n) {
            return n.consistentId().equals(this.consistentId);
        }

        public String toString() {
            return "TestNodeFilter";
        }
    }

    public static class MockedClusterMetrics
    extends ClusterMetricsImpl {
        public static final long LONG_DURATION_MS = TimeUnit.DAYS.toMillis(365L);

        public MockedClusterMetrics(ClusterMetricsImpl original) throws Exception {
            super((GridKernalContext)SqlSystemViewsSelfTest.getField(original, "ctx"), ((Long)SqlSystemViewsSelfTest.getField(original, "nodeStartTime")).longValue());
        }

        public long getMaximumJobWaitTime() {
            return LONG_DURATION_MS;
        }

        public long getCurrentJobWaitTime() {
            return LONG_DURATION_MS;
        }

        public double getAverageJobWaitTime() {
            return LONG_DURATION_MS;
        }

        public long getMaximumJobExecuteTime() {
            return LONG_DURATION_MS;
        }

        public long getCurrentJobExecuteTime() {
            return LONG_DURATION_MS;
        }

        public double getAverageJobExecuteTime() {
            return LONG_DURATION_MS;
        }

        public long getTotalJobsExecutionTime() {
            return LONG_DURATION_MS;
        }

        public long getTotalBusyTime() {
            return LONG_DURATION_MS;
        }

        public long getTotalIdleTime() {
            return LONG_DURATION_MS;
        }

        public long getCurrentIdleTime() {
            return LONG_DURATION_MS;
        }

        public long getUpTime() {
            return LONG_DURATION_MS;
        }
    }

    static class ConstantMapper
    implements AffinityKeyMapper {
        private static final long serialVersionUID = 7018626316531791556L;

        ConstantMapper() {
        }

        public Object affinityKey(Object key) {
            return 1;
        }

        public void reset() {
        }
    }
}

