/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.List;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.junit.Test;

public class SqlNestedQuerySelfTest
extends AbstractIndexingCommonTest {
    private IgniteEx node;

    protected void beforeTest() throws Exception {
        this.node = this.startGrid();
        this.startGrid(2);
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    @Test
    public void testNestingQuery() {
        this.sql("CREATE TABLE txs(txId INTEGER PRIMARY KEY, created INTEGER)");
        this.sql("CREATE TABLE ops(id INTEGER PRIMARY KEY, txId INTEGER, stage VARCHAR, tStamp INTEGER)");
        this.sql("INSERT INTO txs(txId, created) VALUES (1, 599000), (2, 599111), (3, 599234)");
        this.sql("INSERT INTO ops(id, txId, stage, tStamp) VALUES (1, 1, 'NEW', 599686), (2, 1, 'OLD', 599722), (3, 1, 'OLD', 599736), (4, 2, 'NEW', 599767)");
        this.sql("WITH cacheJoin (txId, stage, tStamp) AS (SELECT t.txId, o.stage, o.tStamp FROM txs t INNER JOIN ops o ON t.txId = o.txId) SELECT ou.stage, COUNT(*) as cou, SUM(CASE WHEN ou.stage = in.stage THEN 1 ELSE 0 END) AS ttl FROM (SELECT txId, stage FROM cacheJoin cte GROUP BY txId, stage) ou INNER JOIN (SELECT mx.txId, mx.stage FROM (SELECT txId, tStamp, stage FROM cacheJoin cte) mx INNER JOIN (SELECT txId, MAX(tStamp) AS maxTStamp FROM cacheJoin cte GROUP BY txId) mix ON mx.txId = mix.txId AND mx.tStamp = mix.maxTStamp) in ON ou.txId = in.txId GROUP BY ou.stage");
    }

    private List<List<?>> sql(String sql) {
        GridQueryProcessor qryProc = this.node.context().query();
        SqlFieldsQuery qry = new SqlFieldsQuery(sql).setSchema("PUBLIC");
        return qryProc.querySqlFields(qry, true).getAll();
    }
}

