/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.Collections;
import java.util.List;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.transactions.TransactionDuplicateKeyException;
import org.junit.Test;

public class SqlInsertMergeImplicitColumnsTest
extends AbstractIndexingCommonTest {
    protected void beforeTestsStarted() throws Exception {
        this.startGrid(0);
    }

    protected void afterTest() throws Exception {
        for (String cache : this.grid(0).cacheNames()) {
            this.grid(0).destroyCache(cache);
        }
        super.afterTest();
    }

    @Test
    public void testInsert() {
        this.sql("CREATE TABLE test3 (id int primary key, val1 varchar, val2 varchar)");
        this.checkDml("INSERT INTO test3 values (1,'Kenny', null)", 1L);
        this.checkDml("INSERT INTO test3 set id=2, val1='Bobby'", 1L);
        GridTestUtils.assertThrows((IgniteLogger)log, () -> this.sql("INSERT INTO test3 set id=1, val2='Kennedy'"), TransactionDuplicateKeyException.class, (String)"Duplicate key during INSERT [key=1, table=PUBLIC.TEST3]");
    }

    @Test
    public void testMerge() {
        this.sql("CREATE TABLE test3 (id int primary key, val1 varchar, val2 varchar)");
        this.checkDml("MERGE INTO test3 values (1,'Kenny', null)", 1L);
        this.checkDml("MERGE INTO test3 values (1, 'Cartman', 'Rodrigez'), (2, 'Hardik','kaushik')", 2L);
    }

    @Test
    public void testKeyValWithUnspecifiedNames() {
        IgniteCache cache = this.grid(0).createCache(new CacheConfiguration().setName("test").setSqlSchema("TEST").setQueryEntities(Collections.singleton(new QueryEntity(Integer.class, Integer.class))));
        this.checkDml("MERGE INTO test.integer values (1, 1)", 1L);
        this.checkDml("MERGE INTO test.integer values (2, 3), (4, 5)", 2L);
    }

    private void checkDml(String sql, long expUpdateCounts) {
        List<List<?>> res = this.sql(sql);
        SqlInsertMergeImplicitColumnsTest.assertEquals((int)1, (int)res.size());
        SqlInsertMergeImplicitColumnsTest.assertEquals((int)1, (int)res.get(0).size());
        SqlInsertMergeImplicitColumnsTest.assertEquals((Object)expUpdateCounts, res.get(0).get(0));
    }

    protected List<List<?>> sql(String sql) {
        GridQueryProcessor qryProc = this.grid(0).context().query();
        SqlFieldsQuery qry = new SqlFieldsQuery(sql).setSchema("PUBLIC");
        return qryProc.querySqlFields(qry, true).getAll();
    }
}

