/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.QueryCancelledException;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.LongRunningQueryManager;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.ListeningTestLogger;
import org.apache.ignite.testframework.LogListener;
import org.junit.Test;

public class LongRunningQueryTest
extends AbstractIndexingCommonTest {
    private static final int KEY_CNT = 1000;
    private static final String LRQ_LABEL = "test-label";
    private static final Pattern LABEL_PATTERN = Pattern.compile(", label=test-label,");
    private boolean local;
    private int pageSize = 4096;
    private static final int LAZY_QRYS_KEY_CNT = 5;
    private boolean lazy;

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.startGrid();
        IgniteCache c = this.grid().createCache(new CacheConfiguration().setName("test").setSqlSchema("TEST").setQueryEntities(Collections.singleton(new QueryEntity(Long.class, Long.class).setTableName("test").addQueryField("id", Long.class.getName(), null).addQueryField("val", Long.class.getName(), null).setKeyFieldName("id").setValueFieldName("val"))).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 10)).setSqlFunctionClasses(new Class[]{TestSQLFunctions.class}));
        for (long i = 0L; i < 1000L; ++i) {
            c.put((Object)i, (Object)i);
        }
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        super.afterTest();
    }

    @Test
    public void testLongDistributed() {
        this.local = false;
        this.lazy = false;
        this.checkLongRunning();
        this.checkFastQueries();
    }

    @Test
    public void testLongDistributedLazy() {
        this.local = false;
        this.lazy = true;
        this.checkLongRunning();
        this.checkFastQueries();
    }

    @Test
    public void testLongDmlDistributed() {
        this.local = false;
        this.lazy = false;
        this.checkLongRunningDml();
        this.checkFastQueries();
    }

    @Test
    public void testLongLocal() {
        this.local = true;
        this.lazy = false;
        this.checkLongRunning();
        this.checkFastQueries();
    }

    @Test
    public void testLongLocalLazy() {
        this.local = true;
        this.lazy = true;
        this.checkLongRunning();
        this.checkFastQueries();
    }

    @Test
    public void testLongDmlLocal() {
        this.local = true;
        this.lazy = false;
        this.checkLongRunningDml();
        this.checkFastQueries();
    }

    @Test
    public void testBigResultSetLocal() throws Exception {
        this.local = true;
        this.lazy = true;
        this.checkBigResultSet();
    }

    @Test
    public void testBigResultDistributed() throws Exception {
        this.local = false;
        this.lazy = true;
        this.checkBigResultSet();
    }

    @Test
    public void testCorrectThreadName() {
        GridWorker checkWorker = (GridWorker)GridTestUtils.getFieldValue((Object)this.longRunningQueryManager(), (String[])new String[]{"checkWorker"});
        LogListener logLsnr = LogListener.matches((String)"Query execution is too long").andMatches(logStr -> Thread.currentThread().getName().startsWith(checkWorker.name())).andMatches(LABEL_PATTERN).build();
        this.testLog().registerListener(logLsnr);
        this.sqlCheckLongRunning();
        LongRunningQueryTest.assertTrue((boolean)logLsnr.check());
    }

    private void checkFastQueries() {
        ListeningTestLogger testLog = this.testLog();
        LogListener lsnr = LogListener.matches((Pattern)Pattern.compile("Query execution is too long")).andMatches(LABEL_PATTERN).build();
        testLog.registerListener(lsnr);
        for (int i = 0; i < 10; ++i) {
            this.sql("SELECT * FROM test", new Object[0]).getAll();
        }
        LongRunningQueryTest.assertFalse((boolean)lsnr.check());
    }

    private void checkLongRunning() {
        this.checkLongRunning(false);
    }

    private void checkLongRunningDml() {
        this.checkLongRunning(true);
    }

    private void checkLongRunning(boolean dml) {
        ListeningTestLogger testLog = this.testLog();
        LogListener lsnr = LogListener.matches((String)"Query execution is too long").andMatches(LABEL_PATTERN).build();
        testLog.registerListener(lsnr);
        this.sqlCheckLongRunning(dml);
        LongRunningQueryTest.assertTrue((boolean)lsnr.check());
    }

    private void checkBigResultSet() throws Exception {
        ListeningTestLogger testLog = this.testLog();
        LogListener lsnr = LogListener.matches((String)"Query produced big result set").andMatches(LABEL_PATTERN).build();
        testLog.registerListener(lsnr);
        try (FieldsQueryCursor<List<?>> cur = this.sql("SELECT T0.id FROM test AS T0, test AS T1", new Object[0]);){
            Iterator it = cur.iterator();
            while (it.hasNext()) {
                it.next();
            }
        }
        LongRunningQueryTest.assertTrue((boolean)lsnr.check(1000L));
    }

    private void sqlCheckLongRunning(String sql, Object ... args) {
        GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, () -> this.sql(sql, args).getAll(), QueryCancelledException.class, (String)"");
    }

    private void sqlCheckLongRunning() {
        this.sqlCheckLongRunning(false);
    }

    private void sqlCheckLongRunningLazy(String sql, Object ... args) {
        this.pageSize = 1;
        try {
            LongRunningQueryTest.assertEquals((int)5, (int)this.sql(sql, args).getAll().size());
        }
        finally {
            this.pageSize = 4096;
        }
    }

    private void sqlCheckLongRunning(boolean dml) {
        if (dml) {
            this.sqlCheckLongRunning("DELETE FROM test WHERE id not in (SELECT T0.id FROM test AS T0, test AS T1, test AS T2 where T0.id > ?)", 0);
        } else if (this.lazy) {
            this.sqlCheckLongRunningLazy("SELECT * FROM test WHERE _key < sleep_func(?, ?)", 2000, 5);
        } else {
            this.sqlCheckLongRunning("SELECT T0.id FROM test AS T0, test AS T1, test AS T2 where T0.id > ?", 0);
        }
    }

    private FieldsQueryCursor<List<?>> sql(String sql, Object ... args) {
        return this.grid().context().query().querySqlFields(new SqlFieldsQuery(sql).setTimeout(10, TimeUnit.SECONDS).setLocal(this.local).setLazy(this.lazy).setSchema("TEST").setPageSize(this.pageSize).setLabel(LRQ_LABEL).setArgs(args), false);
    }

    private ListeningTestLogger testLog() {
        ListeningTestLogger testLog = new ListeningTestLogger(false, log);
        GridTestUtils.setFieldValue((Object)this.longRunningQueryManager(), (String)"log", (Object)testLog);
        GridTestUtils.setFieldValue((Object)((IgniteH2Indexing)this.grid().context().query().getIndexing()).mapQueryExecutor(), (String)"log", (Object)testLog);
        GridTestUtils.setFieldValue((Object)this.grid().context().query().getIndexing(), (String)"log", (Object)testLog);
        return testLog;
    }

    private LongRunningQueryManager longRunningQueryManager() {
        return ((IgniteH2Indexing)this.grid().context().query().getIndexing()).longRunningQueries();
    }

    public static class TestSQLFunctions {
        @QuerySqlFunction
        public static int sleep_func(int sleep, int val) {
            try {
                Thread.sleep(sleep);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return val;
        }
    }
}

