/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.junit.Ignore;
import org.junit.Test;

public class IgniteSqlDistributedJoin2SelfTest
extends AbstractIndexingCommonTest {
    private static final int NODES_COUNT = 3;
    private static final String PERSON_CACHE = "person";
    private static final String MED_INFO_CACHE = "medical_info";
    private static final String BLOOD_INFO_PJ_CACHE = "blood_group_info_PJ";
    private static final String BLOOD_INFO_P_CACHE = "blood_group_info_P";

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        super.afterTest();
    }

    @Ignore(value="https://ggsystems.atlassian.net/browse/GG-29449")
    @Test
    public void testNonCollocatedDistributedJoinSingleCache() throws Exception {
        this.startGridsMultiThreaded(3, false);
        QueryEntity bgQueryEntity = new QueryEntity(String.class, BloodGroupInfoP.class).setTableName(BLOOD_INFO_P_CACHE).setKeyFieldName("blood_group");
        bgQueryEntity.getFields().put("blood_group", String.class.toString());
        IgniteCache cache = this.ignite(0).createCache(new CacheConfiguration("default").setQueryEntities(Arrays.asList(new QueryEntity(String.class, Person.class).setTableName(PERSON_CACHE), new QueryEntity(Long.class, MedicalInfo.class).setTableName(MED_INFO_CACHE), new QueryEntity(Long.class, BloodGroupInfoPJ.class).setTableName(BLOOD_INFO_PJ_CACHE), bgQueryEntity)));
        this.awaitPartitionMapExchange();
        this.populatePersonData((IgniteCache<Object, Object>)cache);
        this.populateMedInfoData((IgniteCache<Object, Object>)cache);
        this.populateBloodGrpPJData((IgniteCache<Object, Object>)cache);
        this.populateBloodGrpPData((IgniteCache<Object, Object>)cache);
        this.checkQueries((IgniteCache<Object, Object>)cache);
    }

    @Test
    public void testNonCollocatedDistributedJoin() throws Exception {
        this.startGridsMultiThreaded(3, false);
        IgniteCache personCache = this.ignite(0).createCache(new CacheConfiguration(PERSON_CACHE).setQueryEntities(Collections.singleton(new QueryEntity(String.class, Person.class))).setSqlSchema("PUBLIC"));
        IgniteCache medInfoCache = this.ignite(0).createCache(new CacheConfiguration(MED_INFO_CACHE).setQueryEntities(Collections.singleton(new QueryEntity(Long.class, MedicalInfo.class).setTableName(MED_INFO_CACHE))).setSqlSchema("PUBLIC"));
        IgniteCache bloodGrpCache1 = this.ignite(0).createCache(new CacheConfiguration(BLOOD_INFO_PJ_CACHE).setQueryEntities(Collections.singleton(new QueryEntity(Long.class, BloodGroupInfoPJ.class).setTableName(BLOOD_INFO_PJ_CACHE))).setSqlSchema("PUBLIC"));
        QueryEntity bgQueryEntity = new QueryEntity(String.class, BloodGroupInfoP.class).setTableName(BLOOD_INFO_P_CACHE).setKeyFieldName("blood_group");
        bgQueryEntity.getFields().put("blood_group", String.class.toString());
        IgniteCache bloodGrpCache2 = this.ignite(0).createCache(new CacheConfiguration(BLOOD_INFO_P_CACHE).setQueryEntities(Collections.singleton(bgQueryEntity)).setSqlSchema("PUBLIC"));
        this.awaitPartitionMapExchange();
        this.populatePersonData((IgniteCache<Object, Object>)personCache);
        this.populateMedInfoData((IgniteCache<Object, Object>)medInfoCache);
        this.populateBloodGrpPJData((IgniteCache<Object, Object>)bloodGrpCache1);
        this.populateBloodGrpPData((IgniteCache<Object, Object>)bloodGrpCache2);
        this.checkQueries((IgniteCache<Object, Object>)personCache);
    }

    private void checkQueries(IgniteCache<Object, Object> cache) {
        SqlFieldsQuery qry1 = new SqlFieldsQuery("SELECT person.id, person.name, medical_info.blood_group, blood_group_info_PJ.universal_donor FROM person\n  LEFT JOIN medical_info ON medical_info.name = person.name \n  LEFT JOIN blood_group_info_PJ ON blood_group_info_PJ.blood_group = medical_info.blood_group;");
        SqlFieldsQuery qry2 = new SqlFieldsQuery("SELECT person.id, person.name, medical_info.blood_group, blood_group_info_P.universal_donor FROM person\n  LEFT JOIN medical_info ON medical_info.name = person.name \n  LEFT JOIN blood_group_info_P ON blood_group_info_P.blood_group = medical_info.blood_group;");
        qry1.setDistributedJoins(true);
        qry2.setDistributedJoins(true);
        String res1 = this.queryResultAsString(cache.query(qry1).getAll());
        String res2 = this.queryResultAsString(cache.query(qry2).getAll());
        log.info("Query1 result: \n" + res1);
        log.info("Query2 result: \n" + res2);
        String expOut = "2001,Shravya,null,null\n2002,Kiran,O+,O+A+B+AB+\n2003,Harika,AB+,AB+\n2004,Srinivas,null,null\n2005,Madhavi,A+,A+AB+\n2006,Deeps,null,null\n2007,Hope,null,null\n";
        IgniteSqlDistributedJoin2SelfTest.assertEquals((String)"Wrong result", (String)expOut, (String)res1);
        IgniteSqlDistributedJoin2SelfTest.assertEquals((String)"Wrong result", (String)expOut, (String)res2);
    }

    private String queryResultAsString(List<List<?>> res) {
        ArrayList<String> results = new ArrayList<String>();
        for (List<?> row : res) {
            StringBuilder sb = new StringBuilder();
            Iterator<?> iterator = row.iterator();
            while (iterator.hasNext()) {
                sb.append(iterator.next());
                if (!iterator.hasNext()) continue;
                sb.append(',');
            }
            results.add(sb.toString());
        }
        results.sort(String::compareTo);
        StringBuilder sb = new StringBuilder();
        for (String result : results) {
            sb.append(result).append('\n');
        }
        return sb.toString();
    }

    private void populatePersonData(IgniteCache<Object, Object> cache) {
        cache.put((Object)"Shravya", (Object)new Person(2001L, "Shravya"));
        cache.put((Object)"Kiran", (Object)new Person(2002L, "Kiran"));
        cache.put((Object)"Harika", (Object)new Person(2003L, "Harika"));
        cache.put((Object)"Srinivas", (Object)new Person(2004L, "Srinivas"));
        cache.put((Object)"Madhavi", (Object)new Person(2005L, "Madhavi"));
        cache.put((Object)"Deeps", (Object)new Person(2006L, "Deeps"));
        cache.put((Object)"Hope", (Object)new Person(2007L, "Hope"));
    }

    private void populateMedInfoData(IgniteCache<Object, Object> cache) {
        cache.put((Object)2001L, (Object)new MedicalInfo(2001L, "Madhavi", "A+"));
        cache.put((Object)2002L, (Object)new MedicalInfo(2002L, "Diggi", "B+"));
        cache.put((Object)2003L, (Object)new MedicalInfo(2003L, "Kiran", "O+"));
        cache.put((Object)2004L, (Object)new MedicalInfo(2004L, "Harika", "AB+"));
    }

    private void populateBloodGrpPJData(IgniteCache<Object, Object> cache) {
        cache.put((Object)2001L, (Object)new BloodGroupInfoPJ(2001L, "A+", "A+AB+"));
        cache.put((Object)2002L, (Object)new BloodGroupInfoPJ(2002L, "O+", "O+A+B+AB+"));
        cache.put((Object)2003L, (Object)new BloodGroupInfoPJ(2003L, "B+", "B+AB+"));
        cache.put((Object)2004L, (Object)new BloodGroupInfoPJ(2004L, "AB+", "AB+"));
        cache.put((Object)2005L, (Object)new BloodGroupInfoPJ(2005L, "O-", "EveryOne"));
    }

    private void populateBloodGrpPData(IgniteCache<Object, Object> cache) {
        cache.put((Object)"A+", (Object)new BloodGroupInfoP(2001L, "A+", "A+AB+"));
        cache.put((Object)"O+", (Object)new BloodGroupInfoP(2002L, "O+", "O+A+B+AB+"));
        cache.put((Object)"B+", (Object)new BloodGroupInfoP(2003L, "B+", "B+AB+"));
        cache.put((Object)"AB+", (Object)new BloodGroupInfoP(2004L, "AB+", "AB+"));
        cache.put((Object)"O-", (Object)new BloodGroupInfoP(2005L, "O-", "EveryOne"));
    }

    private static class BloodGroupInfoP {
        private long id;
        @QuerySqlField
        private String bloodGroup;
        @QuerySqlField(name="universal_donor")
        private String universalDonor;

        BloodGroupInfoP(long id, String bloodGroup, String universalDonor) {
            this.id = id;
            this.bloodGroup = bloodGroup;
            this.universalDonor = universalDonor;
        }

        public void setId(long id) {
            this.id = id;
        }

        public long getId() {
            return this.id;
        }

        public String getBloodGroup() {
            return this.bloodGroup;
        }

        public void setBloodGroup(String bloodGroup) {
            this.bloodGroup = bloodGroup;
        }

        public String getUniversalDonor() {
            return this.universalDonor;
        }

        public void setUniversalDonor(String universalDonor) {
            this.universalDonor = universalDonor;
        }
    }

    private static class BloodGroupInfoPJ {
        @QuerySqlField
        private long id;
        @QuerySqlField(index=true, name="blood_group")
        private String bloodGroup;
        @QuerySqlField(name="universal_donor")
        private String universalDonor;

        BloodGroupInfoPJ(long id, String bloodGroup, String universalDonor) {
            this.id = id;
            this.bloodGroup = bloodGroup;
            this.universalDonor = universalDonor;
        }

        public void setId(long id) {
            this.id = id;
        }

        public long getId() {
            return this.id;
        }

        public String getBloodGroup() {
            return this.bloodGroup;
        }

        public void setBloodGroup(String bloodGroup) {
            this.bloodGroup = bloodGroup;
        }

        public String getUniversalDonor() {
            return this.universalDonor;
        }

        public void setUniversalDonor(String universalDonor) {
            this.universalDonor = universalDonor;
        }
    }

    private static class MedicalInfo {
        @QuerySqlField
        private long id;
        @QuerySqlField(index=true)
        private String name;
        @QuerySqlField(name="blood_group")
        private String bloodGroup;

        MedicalInfo(long id, String name, String bloodGroup) {
            this.id = id;
            this.name = name;
            this.bloodGroup = bloodGroup;
        }

        public void setId(long id) {
            this.id = id;
        }

        public long getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getBloodGroup() {
            return this.bloodGroup;
        }

        public void setBloodGroup(String bloodGroup) {
            this.bloodGroup = bloodGroup;
        }
    }

    private static class Person {
        @QuerySqlField
        private long id;
        @QuerySqlField
        private String name;

        Person(long id, String name) {
            this.id = id;
            this.name = name;
        }

        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

