/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DisabledSqlFunctionsTest
extends AbstractIndexingCommonTest {
    private static final Pattern PTRN_FUNC_NOT_FOUND = Pattern.compile("Failed to parse query. Function \"\\w+\" not found");
    private static final int KEY_CNT = 10;
    @Parameterized.Parameter
    public boolean local;
    @Parameterized.Parameter(value=1)
    public boolean client;

    @Parameterized.Parameters(name="local={0}, client={1}")
    public static Collection parameters() {
        LinkedHashSet<Object[]> paramsSet = new LinkedHashSet<Object[]>();
        for (int i = 0; i < 4; ++i) {
            Object[] params = new Object[]{(i & 1) == 0, (i & 2) == 0};
            paramsSet.add(params);
        }
        return paramsSet;
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        FileSystem fs = FileSystems.getDefault();
        Files.deleteIfExists(fs.getPath("test.dat", new String[0]));
        Files.deleteIfExists(fs.getPath("test.csv", new String[0]));
        Files.deleteIfExists(fs.getPath("test.mv.db", new String[0]));
        super.afterTest();
    }

    protected void beforeTest() throws Exception {
        this.startGrid("srv");
        this.startGrid("cli");
        IgniteCache c = this.grid("srv").createCache(new CacheConfiguration().setName("test").setSqlSchema("PUBLIC").setQueryEntities(Collections.singleton(new QueryEntity(Long.class, Long.class).setTableName("test").addQueryField("id", Long.class.getName(), null).addQueryField("val", Long.class.getName(), null).setKeyFieldName("id").setValueFieldName("val"))).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 10)));
        for (long i = 0L; i < 10L; ++i) {
            c.put((Object)i, (Object)i);
        }
    }

    @Test
    public void testDefaultSelect() throws Exception {
        this.checkSqlWithDisabledFunction("SELECT FILE_WRITE(0, 'test.dat')", new Object[0]);
        this.checkSqlWithDisabledFunction("SELECT FILE_READ('test.dat')", new Object[0]);
        this.checkSqlWithDisabledFunction("SELECT CSVWRITE('test.csv', 'select 1, 2')", new Object[0]);
        this.checkSqlWithDisabledFunction("SELECT * FROM CSVREAD('test.csv')", new Object[0]);
        this.checkSqlWithDisabledFunction("SELECT MEMORY_FREE()", new Object[0]);
        this.checkSqlWithDisabledFunction("SELECT MEMORY_USED()", new Object[0]);
        this.checkSqlWithDisabledFunction("SELECT LOCK_MODE()", new Object[0]);
        this.checkSqlWithDisabledFunction("SELECT LINK_SCHEMA('TEST2', '', 'jdbc:gg-h2:./test', 'sa', 'sa', 'PUBLIC')", new Object[0]);
        this.checkSqlWithDisabledFunction("SELECT SESSION_ID()", new Object[0]);
        this.checkSqlWithDisabledFunction("SELECT CANCEL_SESSION(1)", new Object[0]);
    }

    @Test
    public void testDefaultInsert() throws Exception {
        this.checkSqlWithDisabledFunction("INSERT INTO TEST (ID, VAL) SELECT 1, FILE_WRITE(0, 'test.dat')", new Object[0]);
        this.checkSqlWithDisabledFunction("INSERT INTO TEST (ID, VAL) SELECT 1, FILE_READ('test.dat')", new Object[0]);
        this.checkSqlWithDisabledFunction("INSERT INTO TEST (ID, VAL) SELECT 1, SELECT CSVWRITE('test.csv', 'select 1, 2')", new Object[0]);
        this.checkSqlWithDisabledFunction("INSERT INTO TEST (ID, VAL) SELECT 1, count(*) FROM CSVREAD('test.csv')", new Object[0]);
        this.checkSqlWithDisabledFunction("INSERT INTO TEST (ID, VAL) SELECT 1, MEMORY_FREE()", new Object[0]);
        this.checkSqlWithDisabledFunction("INSERT INTO TEST (ID, VAL) SELECT 1, MEMORY_USED()", new Object[0]);
        this.checkSqlWithDisabledFunction("INSERT INTO TEST (ID, VAL) SELECT 1, LOCK_MODE()", new Object[0]);
        this.checkSqlWithDisabledFunction("INSERT INTO TEST (ID, VAL) SELECT 1, LINK_SCHEMA('TEST2', '', 'jdbc:gg-h2:./test', 'sa', 'sa', 'PUBLIC')", new Object[0]);
        this.checkSqlWithDisabledFunction("INSERT INTO TEST (ID, VAL) SELECT 1, SESSION_ID()", new Object[0]);
        this.checkSqlWithDisabledFunction("INSERT INTO TEST (ID, VAL) SELECT 1, CANCEL_SESSION(1)", new Object[0]);
    }

    @Test
    public void testDefaultUpdate() throws Exception {
        this.checkSqlWithDisabledFunction("UPDATE TEST SET VAL = FILE_WRITE(0, 'test.dat')", new Object[0]);
        this.checkSqlWithDisabledFunction("UPDATE TEST SET VAL = LENGTH(FILE_READ('test.dat'))", new Object[0]);
        this.checkSqlWithDisabledFunction("UPDATE TEST SET VAL = CSVWRITE('test.csv', 'select 1, 2')", new Object[0]);
        this.checkSqlWithDisabledFunction("UPDATE TEST SET VAL = SELECT count(*) FROM CSVREAD('test.csv')", new Object[0]);
        this.checkSqlWithDisabledFunction("UPDATE TEST SET VAL = MEMORY_FREE()", new Object[0]);
        this.checkSqlWithDisabledFunction("UPDATE TEST SET VAL = MEMORY_USED()", new Object[0]);
        this.checkSqlWithDisabledFunction("UPDATE TEST SET VAL = LOCK_MODE()", new Object[0]);
        this.checkSqlWithDisabledFunction("UPDATE TEST SET VAL = LINK_SCHEMA('TEST2', '', 'jdbc:gg-h2:./test', 'sa', 'sa', 'PUBLIC')", new Object[0]);
        this.checkSqlWithDisabledFunction("UPDATE TEST SET VAL = SESSION_ID()", new Object[0]);
        this.checkSqlWithDisabledFunction("UPDATE TEST SET VAL = CANCEL_SESSION(1)", new Object[0]);
    }

    @Test
    public void testDefaultDelete() throws Exception {
        this.checkSqlWithDisabledFunction("DELETE FROM TEST WHERE VAL = FILE_WRITE(0, 'test.dat')", new Object[0]);
        this.checkSqlWithDisabledFunction("DELETE FROM TEST WHERE VAL = LENGTH(FILE_READ('test.dat'))", new Object[0]);
        this.checkSqlWithDisabledFunction("DELETE FROM TEST WHERE VAL = CSVWRITE('test.csv', 'select 1, 2')", new Object[0]);
        this.checkSqlWithDisabledFunction("DELETE FROM TEST WHERE VAL = SELECT count(*) FROM CSVREAD('test.csv')", new Object[0]);
        this.checkSqlWithDisabledFunction("DELETE FROM TEST WHERE VAL = MEMORY_FREE()", new Object[0]);
        this.checkSqlWithDisabledFunction("DELETE FROM TEST WHERE VAL = MEMORY_USED()", new Object[0]);
        this.checkSqlWithDisabledFunction("DELETE FROM TEST WHERE VAL = LOCK_MODE()", new Object[0]);
        this.checkSqlWithDisabledFunction("DELETE FROM TEST WHERE VAL = LINK_SCHEMA('TEST2', '', 'jdbc:gg-h2:./test', 'sa', 'sa', 'PUBLIC')", new Object[0]);
        this.checkSqlWithDisabledFunction("DELETE FROM TEST WHERE VAL = SESSION_ID()", new Object[0]);
        this.checkSqlWithDisabledFunction("DELETE FROM TEST WHERE VAL = CANCEL_SESSION(1)", new Object[0]);
    }

    @Test
    public void testAllowFunctionsDisabledByDefault() throws Exception {
        this.setDisabledSqlFunction(new String[0]);
        this.sql("SELECT FILE_WRITE(0, 'test.dat')", new Object[0]).getAll();
        this.sql("SELECT FILE_READ('test.dat')", new Object[0]).getAll();
        this.sql("SELECT CSVWRITE('test.csv', 'select 1, 2')", new Object[0]).getAll();
        this.sql("SELECT * FROM CSVREAD('test.csv')", new Object[0]).getAll();
        this.sql("SELECT MEMORY_FREE()", new Object[0]).getAll();
        this.sql("SELECT MEMORY_USED()", new Object[0]).getAll();
        this.sql("SELECT LOCK_MODE()", new Object[0]).getAll();
        this.sql("SELECT LINK_SCHEMA('TEST2', '', 'jdbc:gg-h2:./test', 'sa', 'sa', 'PUBLIC')", new Object[0]).getAll();
        this.sql("SELECT SESSION_ID()", new Object[0]).getAll();
        this.sql("SELECT CANCEL_SESSION(1)", new Object[0]).getAll();
    }

    @Test
    public void testCustomDisabledFunctionsSet_Length() throws Exception {
        this.setDisabledSqlFunction("LENGTH");
        this.sql("SELECT FILE_WRITE(0, 'test.dat')", new Object[0]).getAll();
        this.sql("SELECT FILE_READ('test.dat')", new Object[0]).getAll();
        this.sql("SELECT CSVWRITE('test.csv', 'select 1, 2')", new Object[0]).getAll();
        this.sql("SELECT * FROM CSVREAD('test.csv')", new Object[0]).getAll();
        this.sql("SELECT MEMORY_FREE()", new Object[0]).getAll();
        this.sql("SELECT MEMORY_USED()", new Object[0]).getAll();
        this.sql("SELECT LOCK_MODE()", new Object[0]).getAll();
        this.sql("SELECT LINK_SCHEMA('TEST2', '', 'jdbc:gg-h2:./test', 'sa', 'sa', 'PUBLIC')", new Object[0]).getAll();
        this.sql("SELECT SESSION_ID()", new Object[0]).getAll();
        this.sql("SELECT CANCEL_SESSION(1)", new Object[0]).getAll();
        this.checkSqlWithDisabledFunction("SELECT LENGTH(?)", "test");
    }

    @Test
    public void testCustomDisabledFunctionsSet_FileRead_User() throws Exception {
        this.setDisabledSqlFunction("FILE_READ", "USER");
        this.sql("SELECT FILE_WRITE(0, 'test.dat')", new Object[0]).getAll();
        this.checkSqlWithDisabledFunction("SELECT FILE_READ('test.dat')", new Object[0]);
        this.sql("SELECT CSVWRITE('test.csv', 'select 1, 2')", new Object[0]).getAll();
        this.sql("SELECT * FROM CSVREAD('test.csv')", new Object[0]).getAll();
        this.sql("SELECT MEMORY_FREE()", new Object[0]).getAll();
        this.sql("SELECT MEMORY_USED()", new Object[0]).getAll();
        this.sql("SELECT LOCK_MODE()", new Object[0]).getAll();
        this.sql("SELECT LINK_SCHEMA('TEST2', '', 'jdbc:gg-h2:./test', 'sa', 'sa', 'PUBLIC')", new Object[0]).getAll();
        this.sql("SELECT SESSION_ID()", new Object[0]).getAll();
        this.sql("SELECT CANCEL_SESSION(1)", new Object[0]).getAll();
        this.checkSqlWithDisabledFunction("SELECT USER()", new Object[0]);
        this.sql("SELECT CURRENT_TIMESTAMP()", new Object[0]).getAll();
    }

    private void checkSqlWithDisabledFunction(String sql, Object ... args) {
        try {
            this.sql(sql, args).getAll();
            DisabledSqlFunctionsTest.fail((String)"Exception must be thrown");
        }
        catch (IgniteSQLException e) {
            Matcher m = PTRN_FUNC_NOT_FOUND.matcher(e.getMessage());
            DisabledSqlFunctionsTest.assertTrue((String)("Unexpected error message: " + e.getMessage()), (boolean)m.find());
        }
        catch (Throwable e) {
            log.error("Unexpected exception", e);
            DisabledSqlFunctionsTest.fail((String)"Unexpected exception");
        }
    }

    private FieldsQueryCursor<List<?>> sql(String sql, Object ... args) {
        IgniteEx ign = this.client ? this.grid("cli") : this.grid("srv");
        return ign.context().query().querySqlFields(new SqlFieldsQuery(sql).setLocal(this.local).setArgs(args), false);
    }

    private void setDisabledSqlFunction(String ... funcs) throws IgniteCheckedException {
        HashSet set = new HashSet(Arrays.stream(funcs).collect(Collectors.toSet()));
        ((IgniteH2Indexing)this.grid("srv").context().query().getIndexing()).distributedConfiguration().disabledFunctions(set).get();
    }
}

