/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.SqlConfiguration;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractCustomSchemaTest
extends AbstractIndexingCommonTest {
    protected static final String TBL_NAME = "T1";
    protected static final String SCHEMA_NAME_1 = "SCHEMA_1";
    protected static final String SCHEMA_NAME_2 = "SCHEMA_2";
    private static final String SCHEMA_NAME_3 = "ScHeMa3";
    private static final String SCHEMA_NAME_4 = "SCHEMA_4";
    private static final String UNKNOWN_SCHEMA_NAME = "UNKNOWN_SCHEMA";
    private static final String CACHE_NAME = "cache_4";

    protected static String t(String schema, String tbl) {
        return schema + "." + tbl;
    }

    private static String q(String str) {
        return "\"" + str + "\"";
    }

    protected abstract List<List<?>> execSql(String var1);

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setSqlConfiguration(new SqlConfiguration().setSqlSchemas(new String[]{SCHEMA_NAME_1, SCHEMA_NAME_2, AbstractCustomSchemaTest.q(SCHEMA_NAME_3)})).setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration(CACHE_NAME).setSqlSchema(SCHEMA_NAME_4)});
    }

    protected void beforeTestsStarted() throws Exception {
        this.startGrid(0);
    }

    @After
    public void clear() {
        this.execSql("DROP TABLE IF EXISTS " + AbstractCustomSchemaTest.t(SCHEMA_NAME_1, TBL_NAME));
        this.execSql("DROP TABLE IF EXISTS " + AbstractCustomSchemaTest.t(SCHEMA_NAME_2, TBL_NAME));
        this.execSql("DROP TABLE IF EXISTS " + AbstractCustomSchemaTest.t(AbstractCustomSchemaTest.q(SCHEMA_NAME_3), TBL_NAME));
        this.execSql("DROP TABLE IF EXISTS " + AbstractCustomSchemaTest.t(SCHEMA_NAME_4, TBL_NAME));
    }

    @Test
    public void testBasicOpsDiffSchemas() {
        this.execSql("CREATE TABLE " + AbstractCustomSchemaTest.t(SCHEMA_NAME_1, TBL_NAME) + " (s1_key INT PRIMARY KEY, s1_val INT)");
        this.execSql("CREATE TABLE " + AbstractCustomSchemaTest.t(SCHEMA_NAME_2, TBL_NAME) + " (s2_key INT PRIMARY KEY, s2_val INT)");
        this.execSql("CREATE TABLE " + AbstractCustomSchemaTest.t(AbstractCustomSchemaTest.q(SCHEMA_NAME_3), TBL_NAME) + " (s3_key INT PRIMARY KEY, s3_val INT)");
        this.execSql("CREATE TABLE " + AbstractCustomSchemaTest.t(SCHEMA_NAME_4, TBL_NAME) + " (s4_key INT PRIMARY KEY, s4_val INT)");
        this.execSql("INSERT INTO " + AbstractCustomSchemaTest.t(SCHEMA_NAME_1, TBL_NAME) + " (s1_key, s1_val) VALUES (1, 2)");
        this.execSql("INSERT INTO " + AbstractCustomSchemaTest.t(SCHEMA_NAME_2, TBL_NAME) + " (s2_key, s2_val) VALUES (1, 2)");
        this.execSql("INSERT INTO " + AbstractCustomSchemaTest.t(AbstractCustomSchemaTest.q(SCHEMA_NAME_3), TBL_NAME) + " (s3_key, s3_val) VALUES (1, 2)");
        this.execSql("INSERT INTO " + AbstractCustomSchemaTest.t(SCHEMA_NAME_4, TBL_NAME) + " (s4_key, s4_val) VALUES (1, 2)");
        this.execSql("UPDATE " + AbstractCustomSchemaTest.t(SCHEMA_NAME_1, TBL_NAME) + " SET s1_val = 5");
        this.execSql("UPDATE " + AbstractCustomSchemaTest.t(SCHEMA_NAME_2, TBL_NAME) + " SET s2_val = 5");
        this.execSql("UPDATE " + AbstractCustomSchemaTest.t(AbstractCustomSchemaTest.q(SCHEMA_NAME_3), TBL_NAME) + " SET s3_val = 5");
        this.execSql("UPDATE " + AbstractCustomSchemaTest.t(SCHEMA_NAME_4, TBL_NAME) + " SET s4_val = 5");
        this.execSql("DELETE FROM " + AbstractCustomSchemaTest.t(SCHEMA_NAME_1, TBL_NAME));
        this.execSql("DELETE FROM " + AbstractCustomSchemaTest.t(SCHEMA_NAME_2, TBL_NAME));
        this.execSql("DELETE FROM " + AbstractCustomSchemaTest.t(AbstractCustomSchemaTest.q(SCHEMA_NAME_3), TBL_NAME));
        this.execSql("DELETE FROM " + AbstractCustomSchemaTest.t(SCHEMA_NAME_4, TBL_NAME));
        this.execSql("CREATE INDEX t1_idx_1 ON " + AbstractCustomSchemaTest.t(SCHEMA_NAME_1, TBL_NAME) + "(s1_val)");
        this.execSql("CREATE INDEX t1_idx_1 ON " + AbstractCustomSchemaTest.t(SCHEMA_NAME_2, TBL_NAME) + "(s2_val)");
        this.execSql("CREATE INDEX t1_idx_1 ON " + AbstractCustomSchemaTest.t(AbstractCustomSchemaTest.q(SCHEMA_NAME_3), TBL_NAME) + "(s3_val)");
        this.execSql("CREATE INDEX t1_idx_1 ON " + AbstractCustomSchemaTest.t(SCHEMA_NAME_4, TBL_NAME) + "(s4_val)");
        this.execSql("SELECT * FROM " + AbstractCustomSchemaTest.t(SCHEMA_NAME_1, TBL_NAME));
        this.execSql("SELECT * FROM " + AbstractCustomSchemaTest.t(SCHEMA_NAME_2, TBL_NAME));
        this.execSql("SELECT * FROM " + AbstractCustomSchemaTest.t(AbstractCustomSchemaTest.q(SCHEMA_NAME_3), TBL_NAME));
        this.execSql("SELECT * FROM " + AbstractCustomSchemaTest.t(SCHEMA_NAME_4, TBL_NAME));
        this.execSql("SELECT * FROM " + AbstractCustomSchemaTest.t(SCHEMA_NAME_1, TBL_NAME) + " JOIN " + AbstractCustomSchemaTest.t(SCHEMA_NAME_2, TBL_NAME) + " JOIN " + AbstractCustomSchemaTest.t(AbstractCustomSchemaTest.q(SCHEMA_NAME_3), TBL_NAME) + " JOIN " + AbstractCustomSchemaTest.t(SCHEMA_NAME_4, TBL_NAME));
        this.verifyTbls();
        this.execSql("DROP TABLE " + AbstractCustomSchemaTest.t(SCHEMA_NAME_1, TBL_NAME));
        this.execSql("DROP TABLE " + AbstractCustomSchemaTest.t(SCHEMA_NAME_2, TBL_NAME));
        this.execSql("DROP TABLE " + AbstractCustomSchemaTest.t(AbstractCustomSchemaTest.q(SCHEMA_NAME_3), TBL_NAME));
        this.execSql("DROP TABLE " + AbstractCustomSchemaTest.t(SCHEMA_NAME_4, TBL_NAME));
    }

    @Test
    public void testRecreateTableWithinSchema() {
        this.grid(0).cache(CACHE_NAME).destroy();
        this.grid(0).createCache(new CacheConfiguration("cache_4_new").setSqlSchema(SCHEMA_NAME_4));
        List<List<?>> res = this.execSql("SELECT SQL_SCHEMA FROM " + AbstractCustomSchemaTest.t(QueryUtils.sysSchemaName(), "CACHES") + " WHERE CACHE_NAME = '" + CACHE_NAME + "_new'");
        Assert.assertEquals(Collections.singletonList(Collections.singletonList(SCHEMA_NAME_4)), res);
    }

    @Test
    public void testCreateTblsInDiffSchemasForSameCache() {
        String testCache = "cache1";
        this.execSql("CREATE TABLE " + AbstractCustomSchemaTest.t(SCHEMA_NAME_1, TBL_NAME) + " (s1_key INT PRIMARY KEY, s1_val INT) WITH \"cache_name=" + "cache1" + "\"");
        GridTestUtils.assertThrowsWithCause(() -> this.execSql("CREATE TABLE " + AbstractCustomSchemaTest.t(SCHEMA_NAME_2, TBL_NAME) + " (s1_key INT PRIMARY KEY, s2_val INT) WITH \"cache_name=" + "cache1" + "\""), SQLException.class);
        this.execSql("DROP TABLE " + AbstractCustomSchemaTest.t(SCHEMA_NAME_1, TBL_NAME));
    }

    @Test
    public void testCreateDropNonExistingSchema() {
        GridTestUtils.assertThrowsWithCause(() -> this.execSql("CREATE TABLE " + AbstractCustomSchemaTest.t(UNKNOWN_SCHEMA_NAME, TBL_NAME) + "(id INT PRIMARY KEY, val INT)"), SQLException.class);
        GridTestUtils.assertThrowsWithCause(() -> this.execSql("DROP TABLE " + AbstractCustomSchemaTest.t(UNKNOWN_SCHEMA_NAME, TBL_NAME)), SQLException.class);
    }

    private void verifyTbls() {
        List<List<?>> res = this.execSql("SELECT SCHEMA_NAME, KEY_ALIAS FROM " + AbstractCustomSchemaTest.t(QueryUtils.sysSchemaName(), "TABLES") + " ORDER BY SCHEMA_NAME");
        List<List> exp = Arrays.asList(Arrays.asList(SCHEMA_NAME_1, "S1_KEY"), Arrays.asList(SCHEMA_NAME_2, "S2_KEY"), Arrays.asList(SCHEMA_NAME_4, "S4_KEY"), Arrays.asList(SCHEMA_NAME_3, "S3_KEY"));
        Assert.assertEquals(exp, res);
    }
}

