/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.mvcc;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.mvcc.CacheMvccAbstractTest;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.TransactionProxyImpl;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.junit.Test;

public class CacheMvccTxNodeMappingTest
extends CacheMvccAbstractTest {
    protected CacheMode cacheMode() {
        throw new RuntimeException("Is not supposed to be used");
    }

    @Test
    public void testAllTxNodesAreTrackedCli() throws Exception {
        this.checkAllTxNodesAreTracked(false);
    }

    @Test
    public void testAllTxNodesAreTrackedSrv() throws Exception {
        this.checkAllTxNodesAreTracked(true);
    }

    private void checkAllTxNodesAreTracked(boolean nearSrv) throws Exception {
        int i;
        IgniteEx ign;
        int srvCnt = 4;
        this.startGridsMultiThreaded(srvCnt);
        if (nearSrv) {
            ign = this.grid(0);
        } else {
            this.client = true;
            ign = this.startGrid(srvCnt);
        }
        IgniteCache cache = ign.createCache(CacheMvccTxNodeMappingTest.basicCcfg().setBackups(2));
        Affinity aff = ign.affinity(cache.getName());
        Integer k1 = null;
        Integer k2 = null;
        for (i = 0; i < 100; ++i) {
            if (!aff.isPrimary(this.grid(0).localNode(), (Object)i) || !aff.isBackup(this.grid(1).localNode(), (Object)i) || !aff.isBackup(this.grid(2).localNode(), (Object)i)) continue;
            k1 = i;
            break;
        }
        for (i = 0; i < 100; ++i) {
            if (!aff.isPrimary(this.grid(1).localNode(), (Object)i) || !aff.isBackup(this.grid(0).localNode(), (Object)i) || !aff.isBackup(this.grid(2).localNode(), (Object)i)) continue;
            k2 = i;
            break;
        }
        Integer key1 = k1;
        Integer key2 = k2;
        assert (key1 != null && key2 != null);
        cache.query(new SqlFieldsQuery("insert into Integer(_key, _val) values(?, 42)").setArgs(new Object[]{key1}));
        cache.query(new SqlFieldsQuery("insert into Integer(_key, _val) values(?, 42)").setArgs(new Object[]{key2}));
        ImmutableMap txNodes = ImmutableMap.of((Object)this.grid(0).localNode().id(), (Object)Sets.newHashSet((Object[])new UUID[]{this.grid(1).localNode().id(), this.grid(2).localNode().id()}), (Object)this.grid(1).localNode().id(), (Object)Sets.newHashSet((Object[])new UUID[]{this.grid(0).localNode().id(), this.grid(2).localNode().id()}));
        this.checkScenario(ign, srvCnt, (ImmutableMap<UUID, Set<UUID>>)txNodes, () -> {
            cache.put((Object)key1, (Object)42);
            cache.put((Object)key2, (Object)42);
        });
        this.checkScenario(ign, srvCnt, (ImmutableMap<UUID, Set<UUID>>)txNodes, () -> {
            cache.query(new SqlFieldsQuery("merge into Integer(_key, _val) values(?, 42)").setArgs(new Object[]{key1}));
            cache.query(new SqlFieldsQuery("merge into Integer(_key, _val) values(?, 42)").setArgs(new Object[]{key2}));
        });
        this.checkScenario(ign, srvCnt, (ImmutableMap<UUID, Set<UUID>>)txNodes, () -> {
            cache.query(new SqlFieldsQuery("update Integer set _val = _val + 1 where _key = ?").setArgs(new Object[]{key1}));
            cache.query(new SqlFieldsQuery("update Integer set _val = _val + 1 where _key = ?").setArgs(new Object[]{key2}));
        });
        this.checkScenario(ign, srvCnt, (ImmutableMap<UUID, Set<UUID>>)txNodes, () -> cache.query(new SqlFieldsQuery("update Integer set _val = _val + 1").setArgs(new Object[]{key1})));
        ImmutableMap sfuTxNodes = ImmutableMap.of((Object)this.grid(0).localNode().id(), Collections.emptySet(), (Object)this.grid(1).localNode().id(), Collections.emptySet());
        this.checkScenario(ign, srvCnt, (ImmutableMap<UUID, Set<UUID>>)sfuTxNodes, () -> {
            cache.query(new SqlFieldsQuery("select _val from Integer where _key = ? for update").setArgs(new Object[]{key1})).getAll();
            cache.query(new SqlFieldsQuery("select _val from Integer where _key = ? for update").setArgs(new Object[]{key2})).getAll();
        });
        this.checkScenario(ign, srvCnt, (ImmutableMap<UUID, Set<UUID>>)sfuTxNodes, () -> cache.query(new SqlFieldsQuery("select _val from Integer for update").setArgs(new Object[]{key1})).getAll());
    }

    private void checkScenario(IgniteEx ign, int srvCnt, ImmutableMap<UUID, Set<UUID>> txNodes, Runnable r) throws Exception {
        try (Transaction userTx = ign.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            r.run();
            GridNearTxLocal nearTx = ((TransactionProxyImpl)userTx).tx();
            nearTx.prepareNearTxLocal().get();
            List<IgniteInternalTx> txs = IntStream.range(0, srvCnt).mapToObj(i -> CacheMvccTxNodeMappingTest.txsOnNode(this.grid(i), nearTx.nearXidVersion())).flatMap(Collection::stream).collect(Collectors.toList());
            CacheMvccTxNodeMappingTest.assertFalse((boolean)txs.isEmpty());
            txs.forEach(tx -> CacheMvccTxNodeMappingTest.assertEquals((Object)txNodes, CacheMvccTxNodeMappingTest.repack(tx.transactionNodes())));
        }
    }

    private static CacheConfiguration<Object, Object> basicCcfg() {
        return new CacheConfiguration("test").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT).setCacheMode(CacheMode.PARTITIONED).setIndexedTypes(new Class[]{Integer.class, Integer.class});
    }

    private static Map<UUID, Set<UUID>> repack(Map<UUID, Collection<UUID>> orig) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        orig.forEach((primary, backups) -> builder.put(primary, new HashSet(backups)));
        return builder.build();
    }

    private static List<IgniteInternalTx> txsOnNode(IgniteEx node, GridCacheVersion xidVer) {
        return node.context().cache().context().tm().activeTransactions().stream().peek(tx -> CacheMvccTxNodeMappingTest.assertEquals((Object)xidVer, (Object)tx.nearXidVersion())).collect(Collectors.toList());
    }
}

