/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.client.Person;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.index.AbstractRebuildIndexTest;
import org.apache.ignite.internal.processors.cache.persistence.RootPage;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.pendingtask.DurableBackgroundTaskResult;
import org.apache.ignite.internal.processors.localtask.DurableBackgroundTaskState;
import org.apache.ignite.internal.processors.query.h2.DurableBackgroundCleanupIndexTreeTaskV2;
import org.apache.ignite.internal.processors.query.h2.database.H2Tree;
import org.apache.ignite.internal.processors.query.h2.database.H2TreeIndex;
import org.apache.ignite.internal.util.function.ThrowableFunction;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

@WithSystemProperty(key="IGNITE_MAX_INDEX_PAYLOAD_SIZE", value="1000000")
public class DropIndexTest
extends AbstractRebuildIndexTest {
    private DurableBackgroundCleanupIndexTreeTaskV2.H2TreeFactory originalTaskIdxTreeFactory;

    @Override
    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.originalTaskIdxTreeFactory = DurableBackgroundCleanupIndexTreeTaskV2.idxTreeFactory;
    }

    @Override
    protected void afterTest() throws Exception {
        super.afterTest();
        DurableBackgroundCleanupIndexTreeTaskV2.idxTreeFactory = this.originalTaskIdxTreeFactory;
    }

    @Override
    protected void populate(IgniteCache<Integer, Person> cache, int cnt) {
        String prefix = IntStream.range(0, 1000).mapToObj(i -> "name").collect(Collectors.joining("_")) + "_";
        for (int i2 = 0; i2 < cnt; ++i2) {
            cache.put((Object)i2, (Object)new Person(Integer.valueOf(i2), prefix + i2));
        }
    }

    @Test
    public void testDestroyIndexTrees() throws Exception {
        this.checkDestroyIndexTrees(true, 3L);
    }

    @Test
    public void testTaskNotExecuteIfAbsentCacheGroupOrRootPages() throws Exception {
        IgniteEx n = this.startGrid(0);
        String fake = UUID.randomUUID().toString();
        GridCacheContext cctx = GridTestUtils.cacheContext((IgniteCache)n.cache("default"));
        List tasks = F.asList((Object[])new DurableBackgroundCleanupIndexTreeTaskV2[]{new DurableBackgroundCleanupIndexTreeTaskV2(fake, fake, fake, fake, fake, 10, null), new DurableBackgroundCleanupIndexTreeTaskV2(cctx.group().name(), cctx.name(), fake, fake, fake, 10, null)});
        for (DurableBackgroundCleanupIndexTreeTaskV2 task : tasks) {
            DurableBackgroundTaskResult res = (DurableBackgroundTaskResult)task.executeAsync(n.context()).get(0L);
            DropIndexTest.assertTrue((boolean)res.completed());
            DropIndexTest.assertNull((Object)res.error());
            DropIndexTest.assertNull((Object)res.result());
        }
    }

    @Test
    public void testCorrectTaskExecute() throws Exception {
        IgniteEx n = this.startGrid(0);
        IgniteCache cache = n.cache("default");
        this.populate((IgniteCache<Integer, Person>)cache, 100);
        String idxName = "IDX0";
        this.createIdx((IgniteCache<Integer, Person>)cache, idxName);
        GridCacheContext cctx = GridTestUtils.cacheContext((IgniteCache)cache);
        H2TreeIndex idx = this.index(n, (IgniteCache<Integer, Person>)cache, idxName);
        H2Tree[] trees = this.segments(idx);
        Map rootPages = DurableBackgroundCleanupIndexTreeTaskV2.toRootPages((H2Tree[])trees);
        for (int i = 0; i < trees.length; ++i) {
            H2Tree tree = trees[i];
            DropIndexTest.assertEquals((Object)new FullPageId(tree.getMetaPageId(), tree.groupId()), (Object)((RootPage)rootPages.get(i)).pageId());
        }
        String oldTreeName = this.treeName(idx);
        String newTreeName = UUID.randomUUID().toString();
        int segments = idx.segmentsCount();
        DropIndexTest.assertFalse((boolean)DurableBackgroundCleanupIndexTreeTaskV2.findIndexRootPages((CacheGroupContext)cctx.group(), (String)cctx.name(), (String)oldTreeName, (int)segments).isEmpty());
        DropIndexTest.assertTrue((boolean)DurableBackgroundCleanupIndexTreeTaskV2.findIndexRootPages((CacheGroupContext)cctx.group(), (String)cctx.name(), (String)newTreeName, (int)segments).isEmpty());
        DurableBackgroundCleanupIndexTreeTaskV2 task = new DurableBackgroundCleanupIndexTreeTaskV2(cctx.group().name(), cctx.name(), idxName, oldTreeName, newTreeName, segments, trees);
        DropIndexTest.assertTrue((boolean)task.name().startsWith(this.taskNamePrefix(cctx.name(), idxName)));
        DropIndexTest.assertTrue((boolean)((Boolean)GridTestUtils.getFieldValue((Object)task, (String[])new String[]{"needToRen"})));
        GridFutureAdapter startFut = new GridFutureAdapter();
        GridFutureAdapter endFut = new GridFutureAdapter();
        DurableBackgroundCleanupIndexTreeTaskV2.idxTreeFactory = this.taskIndexTreeFactoryEx((GridFutureAdapter<Void>)startFut, (GridFutureAdapter<Void>)endFut);
        IgniteInternalFuture taskFut = task.executeAsync(n.context());
        startFut.get(this.getTestTimeout());
        DropIndexTest.assertTrue((boolean)DurableBackgroundCleanupIndexTreeTaskV2.findIndexRootPages((CacheGroupContext)cctx.group(), (String)cctx.name(), (String)oldTreeName, (int)segments).isEmpty());
        DropIndexTest.assertFalse((boolean)DurableBackgroundCleanupIndexTreeTaskV2.findIndexRootPages((CacheGroupContext)cctx.group(), (String)cctx.name(), (String)newTreeName, (int)segments).isEmpty());
        endFut.onDone();
        DurableBackgroundTaskResult res = (DurableBackgroundTaskResult)taskFut.get(this.getTestTimeout());
        DropIndexTest.assertTrue((boolean)res.completed());
        DropIndexTest.assertNull((Object)res.error());
        DropIndexTest.assertTrue(((Long)res.result() >= 3L ? 1 : 0) != 0);
        DropIndexTest.assertTrue((boolean)DurableBackgroundCleanupIndexTreeTaskV2.findIndexRootPages((CacheGroupContext)cctx.group(), (String)cctx.name(), (String)oldTreeName, (int)segments).isEmpty());
        DropIndexTest.assertTrue((boolean)DurableBackgroundCleanupIndexTreeTaskV2.findIndexRootPages((CacheGroupContext)cctx.group(), (String)cctx.name(), (String)newTreeName, (int)segments).isEmpty());
        DropIndexTest.assertFalse((boolean)((Boolean)GridTestUtils.getFieldValue((Object)task, (String[])new String[]{"needToRen"})));
    }

    @Test
    public void testExecuteTaskOnDropIdx() throws Exception {
        this.checkExecuteTask(true, 3L);
    }

    @Test
    public void testExecuteTaskOnDropIdxAfterRestart() throws Exception {
        this.checkExecuteTaskAfterRestart(true, 3L, (ThrowableFunction<IgniteEx, IgniteEx, Exception>)((ThrowableFunction)n -> {
            n.cluster().baselineAutoAdjustEnabled(false);
            this.stopGrid(0);
            n = this.startGrid(0, cfg -> cfg.setClusterStateOnStart(ClusterState.INACTIVE));
            return n;
        }));
    }

    @Test
    public void testExecuteTaskOnDropIdxAfterReActivated() throws Exception {
        this.checkExecuteTaskAfterRestart(true, 3L, (ThrowableFunction<IgniteEx, IgniteEx, Exception>)((ThrowableFunction)n -> {
            n.cluster().state(ClusterState.INACTIVE);
            return n;
        }));
    }

    @Test
    public void testExecuteTaskOnDropIdxForInMemory() throws Exception {
        this.checkExecuteTask(false, 2L);
    }

    @Test
    public void testExecuteTaskOnDropIdxAfterReActivatedForInMemory() throws Exception {
        this.checkExecuteTaskAfterRestart(false, null, (ThrowableFunction<IgniteEx, IgniteEx, Exception>)((ThrowableFunction)n -> {
            n.cluster().state(ClusterState.INACTIVE);
            return n;
        }));
    }

    @Test
    public void testDestroyIndexTreesForInMemory() throws Exception {
        this.checkDestroyIndexTrees(false, 2L);
    }

    @Test
    public void testDonotAddTaskOnDeactivateForInMemory() throws Exception {
        IgniteEx n = this.startGrid(0, cfg -> cfg.getDataStorageConfiguration().getDefaultDataRegionConfiguration().setPersistenceEnabled(false));
        n.cluster().state(ClusterState.ACTIVE);
        IgniteCache cache = n.cache("default");
        this.populate((IgniteCache<Integer, Person>)cache, 100);
        String idxName = "IDX0";
        this.createIdx((IgniteCache<Integer, Person>)cache, idxName);
        n.cluster().state(ClusterState.INACTIVE);
        DropIndexTest.assertTrue((boolean)this.tasks(n).isEmpty());
    }

    private H2Tree[] segments(H2TreeIndex idx) {
        return (H2Tree[])GridTestUtils.getFieldValue((Object)idx, (String[])new String[]{"segments"});
    }

    @Nullable
    private DurableBackgroundTaskState<?> taskState(IgniteEx n, String taskNamePrefix) {
        return this.tasks(n).entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(taskNamePrefix)).map(Map.Entry::getValue).findAny().orElse(null);
    }

    private Map<String, DurableBackgroundTaskState<?>> tasks(IgniteEx n) {
        return (Map)GridTestUtils.getFieldValue((Object)n.context().durableBackgroundTask(), (String[])new String[]{"tasks"});
    }

    private String taskNamePrefix(String cacheName, String idxName) {
        return "drop-sql-index-" + cacheName + "-" + idxName + "-";
    }

    private DurableBackgroundCleanupIndexTreeTaskV2.H2TreeFactory taskIndexTreeFactoryEx(final GridFutureAdapter<Void> startFut, final GridFutureAdapter<Void> endFut) {
        return new DurableBackgroundCleanupIndexTreeTaskV2.H2TreeFactory(){

            protected H2Tree create(CacheGroupContext grpCtx, RootPage rootPage, String treeName, String idxName, String cacheName) throws IgniteCheckedException {
                startFut.onDone();
                endFut.get(DropIndexTest.this.getTestTimeout());
                return super.create(grpCtx, rootPage, treeName, idxName, cacheName);
            }
        };
    }

    private List<List<?>> dropIdx(IgniteCache<Integer, Person> cache, String idxName) {
        return cache.query(new SqlFieldsQuery("DROP INDEX " + idxName)).getAll();
    }

    private void checkExecuteTask(boolean persistent, long expRes) throws Exception {
        IgniteEx n = this.startGrid(0, cfg -> cfg.getDataStorageConfiguration().getDefaultDataRegionConfiguration().setPersistenceEnabled(persistent));
        n.cluster().state(ClusterState.ACTIVE);
        IgniteCache cache = n.cache("default");
        this.populate((IgniteCache<Integer, Person>)cache, 100);
        String idxName = "IDX0";
        this.createIdx((IgniteCache<Integer, Person>)cache, idxName);
        GridFutureAdapter startFut = new GridFutureAdapter();
        GridFutureAdapter endFut = new GridFutureAdapter();
        DurableBackgroundCleanupIndexTreeTaskV2.idxTreeFactory = this.taskIndexTreeFactoryEx((GridFutureAdapter<Void>)startFut, (GridFutureAdapter<Void>)endFut);
        IgniteInternalFuture dropIdxFut = GridTestUtils.runAsync(() -> this.dropIdx((IgniteCache<Integer, Person>)cache, idxName));
        startFut.get(this.getTestTimeout());
        GridFutureAdapter taskFut = this.taskState(n, this.taskNamePrefix("default", idxName)).outFuture();
        DropIndexTest.assertFalse((boolean)taskFut.isDone());
        endFut.onDone();
        DropIndexTest.assertTrue(((Long)taskFut.get(this.getTestTimeout()) >= expRes ? 1 : 0) != 0);
        dropIdxFut.get(this.getTestTimeout());
    }

    private void checkExecuteTaskAfterRestart(boolean persistent, @Nullable Long expRes, ThrowableFunction<IgniteEx, IgniteEx, Exception> restartFun) throws Exception {
        IgniteEx n = this.startGrid(0, cfg -> cfg.getDataStorageConfiguration().getDefaultDataRegionConfiguration().setPersistenceEnabled(persistent));
        n.cluster().state(ClusterState.ACTIVE);
        IgniteCache cache = n.cache("default");
        this.populate((IgniteCache<Integer, Person>)cache, 100);
        String idxName = "IDX0";
        this.createIdx((IgniteCache<Integer, Person>)cache, idxName);
        GridFutureAdapter startFut = new GridFutureAdapter();
        GridFutureAdapter endFut = new GridFutureAdapter();
        DurableBackgroundCleanupIndexTreeTaskV2.idxTreeFactory = this.taskIndexTreeFactoryEx((GridFutureAdapter<Void>)startFut, (GridFutureAdapter<Void>)endFut);
        endFut.onDone((Throwable)new IgniteCheckedException("Stop drop idx"));
        this.dropIdx((IgniteCache<Integer, Person>)cache, idxName);
        String taskNamePrefix = this.taskNamePrefix(GridTestUtils.cacheContext((IgniteCache)cache).name(), idxName);
        DropIndexTest.assertFalse((boolean)this.taskState(n, taskNamePrefix).outFuture().isDone());
        n = (IgniteEx)restartFun.apply((Object)n);
        DurableBackgroundCleanupIndexTreeTaskV2.idxTreeFactory = this.originalTaskIdxTreeFactory;
        GridFutureAdapter taskFut = this.taskState(n, taskNamePrefix).outFuture();
        DropIndexTest.assertFalse((boolean)taskFut.isDone());
        n.cluster().state(ClusterState.ACTIVE);
        if (expRes == null) {
            DropIndexTest.assertNull((Object)taskFut.get(this.getTestTimeout()));
        } else {
            DropIndexTest.assertTrue(((Long)taskFut.get(this.getTestTimeout()) >= expRes ? 1 : 0) != 0);
        }
    }

    private void checkDestroyIndexTrees(boolean persistent, long expRes) throws Exception {
        IgniteEx n = this.startGrid(0, cfg -> cfg.getDataStorageConfiguration().getDefaultDataRegionConfiguration().setPersistenceEnabled(persistent));
        n.cluster().state(ClusterState.ACTIVE);
        IgniteCache cache = n.cache("default");
        this.populate((IgniteCache<Integer, Person>)cache, 100);
        String idxName = "IDX0";
        this.createIdx((IgniteCache<Integer, Person>)cache, idxName);
        GridCacheContext cctx = GridTestUtils.cacheContext((IgniteCache)cache);
        H2TreeIndex idx = this.index(n, (IgniteCache<Integer, Person>)cache, idxName);
        String treeName = this.treeName(idx);
        int segments = idx.segmentsCount();
        HashMap rootPages = new HashMap();
        if (persistent) {
            rootPages.putAll(DurableBackgroundCleanupIndexTreeTaskV2.findIndexRootPages((CacheGroupContext)cctx.group(), (String)cctx.name(), (String)treeName, (int)segments));
        } else {
            rootPages.putAll(DurableBackgroundCleanupIndexTreeTaskV2.toRootPages((H2Tree[])this.segments(idx)));
        }
        DropIndexTest.assertFalse((boolean)rootPages.isEmpty());
        Thread.currentThread().interrupt();
        long pageCnt = 0L;
        for (Map.Entry e : rootPages.entrySet()) {
            pageCnt += DurableBackgroundCleanupIndexTreeTaskV2.destroyIndexTrees((CacheGroupContext)cctx.group(), (RootPage)((RootPage)e.getValue()), (String)cctx.name(), (String)treeName, (String)idxName, (int)((Integer)e.getKey()));
        }
        DropIndexTest.assertTrue((pageCnt >= expRes ? 1 : 0) != 0);
        DropIndexTest.assertTrue((boolean)DurableBackgroundCleanupIndexTreeTaskV2.findIndexRootPages((CacheGroupContext)cctx.group(), (String)cctx.name(), (String)treeName, (int)segments).isEmpty());
    }
}

