/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.junit.Test;

public class ComplexSecondaryKeyUnwrapSelfTest
extends AbstractIndexingCommonTest {
    private static int tblCnt = 0;

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGrid(0);
    }

    @Test
    public void testSecondaryIndexWithIntersectColumnsComplexPk() {
        String tblName = this.createTableName();
        this.executeSql("CREATE TABLE " + tblName + " (id int, name varchar, age int, company varchar, city varchar, primary key (name, city))", new Object[0]);
        this.executeSql("CREATE INDEX ON " + tblName + "(id, name, city)", new Object[0]);
        this.checkUsingIndexes(tblName, "'1'");
    }

    @Test
    public void testSecondaryIndexSimplePk() {
        HashMap types = new HashMap(){
            {
                this.put("boolean", "1");
                this.put("char", "'1'");
                this.put("varchar", "'1'");
                this.put("real", "1");
                this.put("number", "1");
                this.put("int", "1");
                this.put("long", "1");
                this.put("float", "1");
                this.put("double", "1");
                this.put("tinyint", "1");
                this.put("smallint", "1");
                this.put("bigint", "1");
                this.put("varchar_ignorecase", "'1'");
                this.put("time", "'11:11:11'");
                this.put("timestamp", "'20018-11-02 11:11:11'");
                this.put("uuid", "'1'");
            }
        };
        for (Map.Entry entry : types.entrySet()) {
            String tblName = this.createTableName();
            String type = (String)entry.getKey();
            String val = (String)entry.getValue();
            this.executeSql("CREATE TABLE " + tblName + " (id int, name " + type + ", age int, company varchar, city varchar, primary key (name))", new Object[0]);
            this.executeSql("CREATE INDEX ON " + tblName + "(id, name, city)", new Object[0]);
            this.checkUsingIndexes(tblName, val);
        }
    }

    private void checkUsingIndexes(String tblName, String nameVal) {
        String explainSQL = "explain SELECT * FROM " + tblName + " WHERE ";
        List<List<?>> results = this.executeSql(explainSQL + "id=1", new Object[0]);
        this.assertUsingSecondaryIndex(results);
        results = this.executeSql(explainSQL + "id=1 and name=" + nameVal, new Object[0]);
        this.assertUsingSecondaryIndex(results);
        results = this.executeSql(explainSQL + "id=1 and name=" + nameVal + " and age=0", new Object[0]);
        this.assertUsingSecondaryIndex(results);
    }

    private void assertUsingSecondaryIndex(List<List<?>> results) {
        ComplexSecondaryKeyUnwrapSelfTest.assertEquals((int)2, (int)results.size());
        String explainPlan = (String)results.get(0).get(0);
        ComplexSecondaryKeyUnwrapSelfTest.assertTrue((String)explainPlan, (boolean)explainPlan.contains("_idx\": "));
        ComplexSecondaryKeyUnwrapSelfTest.assertFalse((String)explainPlan, (boolean)explainPlan.contains("_SCAN_"));
    }

    private String createTableName() {
        return "TST_TABLE_" + tblCnt++;
    }

    private List<List<?>> executeSql(String stmt, Object ... args) {
        return this.executeSql(this.node(), stmt, args);
    }

    private List<List<?>> executeSql(IgniteEx node, String stmt, Object ... args) {
        return node.context().query().querySqlFields(new SqlFieldsQuery(stmt).setArgs(args), true).getAll();
    }

    private IgniteEx node() {
        return this.grid(0);
    }

    static class TestValue {
        @QuerySqlField
        private String name;
        @QuerySqlField
        private String company;
        @QuerySqlField
        private String city;
        @QuerySqlField
        private int age;

        public TestValue(int age, String name, String company, String city) {
            this.age = age;
            this.name = name;
            this.company = company;
            this.city = city;
        }
    }

    static class TestKey {
        @QuerySqlField
        private int id;

        public TestKey(int id) {
            this.id = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestKey testKey = (TestKey)o;
            return this.id == testKey.id;
        }

        public int hashCode() {
            return this.id;
        }
    }
}

