/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.replicated;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import javax.cache.Cache;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.IgniteCacheAbstractQuerySelfTest;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.util.lang.GridAbsPredicate;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.transactions.Transaction;
import org.junit.Test;

public class IgniteCacheReplicatedQuerySelfTest
extends IgniteCacheAbstractQuerySelfTest {
    private static final boolean TEST_DEBUG = false;
    private static Ignite ignite1;
    private static Ignite ignite2;
    private static Ignite ignite3;
    private static IgniteCache<CacheKey, CacheValue> cache1;
    private static IgniteCache<CacheKey, CacheValue> cache2;
    private static IgniteCache<CacheKey, CacheValue> cache3;
    private static volatile int keySerCnt;
    private static volatile int keyDesCnt;
    private static volatile int valSerCnt;
    private static volatile int valDesCnt;

    @Override
    protected int gridCount() {
        return 3;
    }

    @Override
    protected CacheMode cacheMode() {
        return CacheMode.REPLICATED;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        ignite1 = this.grid(0);
        ignite2 = this.grid(1);
        ignite3 = this.grid(2);
        cache1 = this.jcache(ignite1, CacheKey.class, CacheValue.class);
        cache2 = this.jcache(ignite2, CacheKey.class, CacheValue.class);
        cache3 = this.jcache(ignite3, CacheKey.class, CacheValue.class);
    }

    @Override
    protected void afterTest() throws Exception {
        super.afterTest();
        ignite1 = null;
        ignite2 = null;
        ignite3 = null;
        cache1 = null;
        cache2 = null;
        cache3 = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientOnlyNode() throws Exception {
        try {
            IgniteEx g = this.startGrid("client");
            IgniteCache<Integer, Integer> c = this.jcache((Ignite)g, Integer.class, Integer.class);
            for (int i = 0; i < 10; ++i) {
                c.put((Object)i, (Object)i);
            }
            IgniteCacheReplicatedQuerySelfTest.assertEquals((int)0, (int)c.localSize(new CachePeekMode[0]));
            List res = c.query((Query)new SqlQuery(Integer.class, "_key >= 5 order by _key")).getAll();
            IgniteCacheReplicatedQuerySelfTest.assertEquals((int)5, (int)res.size());
            int i = 5;
            for (Cache.Entry e : res) {
                IgniteCacheReplicatedQuerySelfTest.assertEquals((int)i, (int)((Integer)e.getKey()));
                IgniteCacheReplicatedQuerySelfTest.assertEquals((int)i, (int)((Integer)e.getValue()));
                ++i;
            }
        }
        finally {
            this.stopGrid("client");
        }
    }

    @Test
    public void testIterator() throws Exception {
        int keyCnt = 100;
        for (int i = 0; i < keyCnt; ++i) {
            cache1.put((Object)new CacheKey(i), (Object)new CacheValue("val" + i));
        }
        IgniteCacheReplicatedQuerySelfTest.assertEquals((int)keyCnt, (int)cache1.localSize(new CachePeekMode[]{CachePeekMode.ALL}));
        IgniteCacheReplicatedQuerySelfTest.assertEquals((int)keyCnt, (int)cache2.localSize(new CachePeekMode[]{CachePeekMode.ALL}));
        IgniteCacheReplicatedQuerySelfTest.assertEquals((int)keyCnt, (int)cache3.localSize(new CachePeekMode[]{CachePeekMode.ALL}));
        QueryCursor qry = cache1.query((Query)new SqlQuery(CacheValue.class, "true"));
        Iterator iter = qry.iterator();
        assert (iter.hasNext());
        int cnt = 0;
        while (iter.hasNext()) {
            iter.next();
            ++cnt;
        }
        IgniteCacheReplicatedQuerySelfTest.assertEquals((int)keyCnt, (int)cnt);
    }

    @Test
    public void testLocalQueryWithExplicitFlag() throws Exception {
        this.doTestLocalQuery(true);
    }

    @Test
    public void testLocalQueryWithoutExplicitFlag() throws Exception {
        this.doTestLocalQuery(false);
    }

    private void doTestLocalQuery(boolean loc) throws Exception {
        cache1.clear();
        Transaction tx = ignite1.transactions().txStart();
        try {
            cache1.put((Object)new CacheKey(1), (Object)new CacheValue("1"));
            cache1.put((Object)new CacheKey(2), (Object)new CacheValue("2"));
            cache1.put((Object)new CacheKey(3), (Object)new CacheValue("3"));
            cache1.put((Object)new CacheKey(4), (Object)new CacheValue("4"));
            tx.commit();
            this.info("Committed transaction: " + tx);
        }
        catch (IgniteException e) {
            tx.rollback();
            throw e;
        }
        this.checkLocalQueryResults(cache1, loc);
        this.checkLocalQueryResults(cache2, loc);
        this.checkLocalQueryResults(cache3, loc);
    }

    @Test
    public void testDistributedQuery() throws Exception {
        int keyCnt = 4;
        Transaction tx = ignite1.transactions().txStart();
        try {
            for (int i = 1; i <= 4; ++i) {
                cache1.put((Object)new CacheKey(i), (Object)new CacheValue(String.valueOf(i)));
            }
            tx.commit();
            this.info("Committed transaction: " + tx);
        }
        catch (IgniteException e) {
            tx.rollback();
            throw e;
        }
        GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicate(){

            public boolean apply() {
                return cache2.size(new CachePeekMode[0]) == 4 && cache3.size(new CachePeekMode[0]) == 4;
            }
        }, (long)5000L);
        QueryCursor qry = cache1.query((Query)new SqlQuery(CacheValue.class, "val > 1 and val < 4"));
        IgniteCacheReplicatedQuerySelfTest.assertEquals((int)2, (int)qry.getAll().size());
        qry = cache3.query((Query)new SqlQuery(CacheValue.class, "val > 1 and val < 4").setLocal(true));
        Iterator iter = qry.iterator();
        assert (iter != null);
        assert (iter.hasNext());
        iter.next();
        assert (iter.hasNext());
        iter.next();
        assert (!iter.hasNext());
    }

    @Test
    public void testToString() throws Exception {
        int keyCnt = 4;
        for (int i = 1; i <= keyCnt; ++i) {
            cache1.put((Object)new CacheKey(i), (Object)new CacheValue(String.valueOf(i)));
        }
        QueryCursor qry = cache1.query((Query)new SqlQuery(CacheValue.class, "val > 0"));
        IgniteCacheReplicatedQuerySelfTest.assertEquals((int)keyCnt, (int)qry.getAll().size());
    }

    @Test
    public void testLostIterator() throws Exception {
        IgniteCache<Integer, Integer> cache = this.jcache(Integer.class, Integer.class);
        for (int i = 0; i < 1000; ++i) {
            cache.put((Object)i, (Object)i);
        }
        QueryCursor fut = null;
        for (int i = 0; i < ((CacheConfiguration)cache.getConfiguration(CacheConfiguration.class)).getMaxQueryIteratorsCount() + 1; ++i) {
            QueryCursor q = cache.query((Query)new SqlQuery(Integer.class, "_key >= 0 order by _key").setPageSize(1));
            IgniteCacheReplicatedQuerySelfTest.assertEquals((int)0, (int)((Integer)((Cache.Entry)q.iterator().next()).getKey()));
            if (fut != null) continue;
            fut = q;
        }
        final QueryCursor fut0 = fut;
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Cache.Entry e;
                int i = 0;
                while ((e = (Cache.Entry)fut0.iterator().next()) != null) {
                    IgniteCacheReplicatedQuerySelfTest.assertEquals((int)(++i), (int)((Integer)e.getKey()));
                }
                return null;
            }
        }, IgniteException.class, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNodeLeft() throws Exception {
        IgniteEx client = this.startGrid("client");
        try {
            IgniteCacheReplicatedQuerySelfTest.assertTrue((boolean)client.configuration().isClientMode());
            IgniteCache<Integer, Integer> cache = this.jcache((Ignite)client, Integer.class, Integer.class);
            for (int i = 0; i < 1000; ++i) {
                cache.put((Object)i, (Object)i);
            }
            IgniteCacheReplicatedQuerySelfTest.assertEquals((int)0, (int)cache.localSize(new CachePeekMode[0]));
            QueryCursor q = cache.query((Query)new SqlQuery(Integer.class, "_key >= 0 order by _key").setPageSize(10));
            IgniteCacheReplicatedQuerySelfTest.assertEquals((int)0, (int)((Integer)((Cache.Entry)q.iterator().next()).getKey()));
            ConcurrentMap<?, ?> mapNode1 = this.queryResultMap(0);
            ConcurrentMap<?, ?> mapNode2 = this.queryResultMap(1);
            ConcurrentMap<?, ?> mapNode3 = this.queryResultMap(2);
            IgniteCacheReplicatedQuerySelfTest.assertEquals((int)1, (int)(mapNode1.size() + mapNode2.size() + mapNode3.size()));
            final UUID nodeId = client.cluster().localNode().id();
            final CountDownLatch latch = new CountDownLatch(3);
            for (int i = 0; i < 3; ++i) {
                this.grid(i).events().localListen((IgnitePredicate)new IgnitePredicate<Event>(){

                    public boolean apply(Event evt) {
                        if (((DiscoveryEvent)evt).eventNode().id().equals(nodeId)) {
                            latch.countDown();
                        }
                        return true;
                    }
                }, new int[]{11, 12});
            }
            this.stopGrid("client");
            latch.await();
            IgniteCacheReplicatedQuerySelfTest.assertEquals((int)0, (int)mapNode1.size());
            IgniteCacheReplicatedQuerySelfTest.assertEquals((int)0, (int)mapNode2.size());
            IgniteCacheReplicatedQuerySelfTest.assertEquals((int)0, (int)mapNode3.size());
        }
        finally {
            this.stopGrid("client");
        }
    }

    private ConcurrentMap<?, ?> queryResultMap(int node) {
        return (ConcurrentMap)U.field((Object)((IgniteH2Indexing)U.field((Object)this.grid(node).context().query(), (String)"idx")).mapQueryExecutor(), (String)"qryRess");
    }

    private void checkLocalQueryResults(IgniteCache<CacheKey, CacheValue> cache, boolean loc) throws Exception {
        QueryCursor qry = cache.query((Query)new SqlQuery(CacheValue.class, "val > 1 and val < 4").setReplicatedOnly(true).setLocal(loc));
        Iterator iter = qry.iterator();
        assert (iter != null);
        assert (iter.hasNext());
        Cache.Entry entry = (Cache.Entry)iter.next();
        assert (((CacheKey)entry.getKey()).equals(new CacheKey(2)) || ((CacheKey)entry.getKey()).equals(new CacheKey(3)));
        assert (iter.hasNext());
        entry = (Cache.Entry)iter.next();
        assert (((CacheKey)entry.getKey()).equals(new CacheKey(2)) || ((CacheKey)entry.getKey()).equals(new CacheKey(3)));
        assert (!iter.hasNext());
    }

    public static class CacheValue
    implements Externalizable {
        @QuerySqlField
        private String val;

        CacheValue(String val) {
            this.val = val;
        }

        public CacheValue() {
        }

        public String getValue() {
            return this.val;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.val = U.readString((DataInput)in);
            valDesCnt++;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            U.writeString((DataOutput)out, (String)this.val);
            valSerCnt++;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheValue val = (CacheValue)o;
            return !(this.val == null ? val.val != null : !this.val.equals(val.val));
        }

        public int hashCode() {
            return this.val != null ? this.val.hashCode() : 0;
        }

        public String toString() {
            return S.toString(CacheValue.class, (Object)this);
        }
    }

    public static class CacheKey
    implements Externalizable {
        private int key;

        CacheKey(int key) {
            this.key = key;
        }

        public CacheKey() {
        }

        public int getKey() {
            return this.key;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.key = in.readInt();
            keyDesCnt++;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.key);
            keySerCnt++;
        }

        public boolean equals(Object o) {
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.key == cacheKey.key;
        }

        public int hashCode() {
            return this.key;
        }

        public String toString() {
            return S.toString(CacheKey.class, (Object)this);
        }
    }
}

