/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.failure.FailureHandler;
import org.apache.ignite.failure.StopNodeOrHaltFailureHandler;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.testframework.ListeningTestLogger;
import org.apache.ignite.testframework.LogListener;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

@WithSystemProperty(key="IGNITE_MAX_INDEX_PAYLOAD_SIZE", value="1")
public class CheckIndexesInlineSizeOnNodeJoinMultiJvmTest
extends GridCommonAbstractTest {
    private static final String STR = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String INDEXES_WARN_MSG_FORMAT = "PUBLIC#TEST_TABLE#L_IDX(%d,%d),PUBLIC#TEST_TABLE#S1_IDX(%d,%d),PUBLIC#TEST_TABLE#S0_IDX(%d,%d),PUBLIC#TEST_TABLE#I_IDX(%d,%d)";
    private static final int NODES_CNT = 3;
    private static final int INITIAL_PAYLOAD_SIZE = 1;
    private ListeningTestLogger testLog;
    private int payloadSize;
    private UUID nodeId;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName).setConsistentId((Serializable)((Object)igniteInstanceName)).setFailureHandler((FailureHandler)new StopNodeOrHaltFailureHandler()).setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true)));
        if (!this.isRemoteJvm(igniteInstanceName)) {
            cfg.setGridLogger((IgniteLogger)this.testLog);
        }
        if (this.nodeId != null) {
            cfg.setNodeId(this.nodeId);
        }
        return cfg;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
        CheckIndexesInlineSizeOnNodeJoinMultiJvmTest.assertEquals((int)1, (int)Integer.parseInt(System.getProperty("IGNITE_MAX_INDEX_PAYLOAD_SIZE")));
        this.testLog = new ListeningTestLogger(false, log);
        this.startGrids(3).cluster().active(true);
        for (Map.Entry<String, Object[]> entry : CheckIndexesInlineSizeOnNodeJoinMultiJvmTest.getSqlStatements().entrySet()) {
            CheckIndexesInlineSizeOnNodeJoinMultiJvmTest.executeSql(this.grid(0), entry.getKey(), entry.getValue());
        }
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
        super.afterTest();
    }

    protected boolean isMultiJvm() {
        return true;
    }

    protected List<String> additionalRemoteJvmArgs() {
        List args = super.additionalRemoteJvmArgs();
        args.add("-DIGNITE_MAX_INDEX_PAYLOAD_SIZE=" + this.payloadSize);
        return args;
    }

    protected IgniteEx startGrid(int idx) throws Exception {
        this.payloadSize = this.getMaxPayloadSize(idx);
        return super.startGrid(idx);
    }

    @Test
    public void testWarnOnJoiningNode() throws Exception {
        this.performTestScenario(0);
    }

    @Test
    public void testWarnOnNodeInCluster() throws Exception {
        this.performTestScenario(1);
    }

    private void performTestScenario(int restartNodeIdx) throws Exception {
        CheckIndexesInlineSizeOnNodeJoinMultiJvmTest.assertTrue((String)("Wrong restart node index: " + restartNodeIdx), (restartNodeIdx >= 0 && restartNodeIdx < 3 ? 1 : 0) != 0);
        Map<Integer, UUID> nodeIdxToNodeId = IntStream.range(0, 3).boxed().collect(Collectors.toMap(i -> i, i -> this.grid((int)i).localNode().id()));
        this.stopGrid(restartNodeIdx);
        this.nodeId = UUID.randomUUID();
        nodeIdxToNodeId.put(restartNodeIdx, this.nodeId);
        Collection<LogListener> listeners = this.registerListeners(restartNodeIdx, nodeIdxToNodeId);
        CheckIndexesInlineSizeOnNodeJoinMultiJvmTest.assertFalse((boolean)F.isEmpty(listeners));
        this.startGrid(restartNodeIdx);
        this.awaitPartitionMapExchange();
        for (LogListener listener : listeners) {
            CheckIndexesInlineSizeOnNodeJoinMultiJvmTest.assertTrue((String)listener.toString(), (boolean)listener.check());
        }
    }

    private Collection<LogListener> registerListeners(int restartNodeIdx, Map<Integer, UUID> nodeIdxToNodeId) {
        ArrayList<String> msgs = new ArrayList<String>(2);
        int payloadSize = this.getMaxPayloadSize(restartNodeIdx);
        if (restartNodeIdx == 0) {
            for (Integer idx : nodeIdxToNodeId.keySet()) {
                if (idx == 0) continue;
                msgs.add(this.generateIndexesWarnMessage(nodeIdxToNodeId.get(idx), payloadSize, this.getMaxPayloadSize(idx)));
            }
        } else {
            msgs.add(this.generateIndexesWarnMessage(nodeIdxToNodeId.get(restartNodeIdx), this.getMaxPayloadSize(0), payloadSize));
        }
        Collection listeners = msgs.stream().map(m -> LogListener.matches((String)m).build(m)).collect(Collectors.toList());
        listeners.forEach(l -> this.testLog.registerListener(l));
        return listeners;
    }

    private String generateIndexesWarnMessage(UUID nodeId, int payloadSize1, int payloadSize2) {
        String indexesInfo = String.format(INDEXES_WARN_MSG_FORMAT, payloadSize1, payloadSize2, payloadSize1, payloadSize2, payloadSize1, payloadSize2, payloadSize1, payloadSize2);
        return String.format("Inline sizes on local node and node %s are different. Please drop and create again these indexes to avoid performance problems with SQL queries. Problem indexes: %s", nodeId, indexesInfo);
    }

    private int getMaxPayloadSize(int nodeId) {
        return 1 + nodeId;
    }

    private static List<List<?>> executeSql(IgniteEx node, String stmt, Object ... args) {
        return node.context().query().querySqlFields(new SqlFieldsQuery(stmt).setArgs(args), true).getAll();
    }

    public static Map<String, Object[]> getSqlStatements() {
        Object[] EMPTY = new Object[]{};
        LinkedHashMap<String, Object[]> stmts = new LinkedHashMap<String, Object[]>();
        stmts.put("CREATE TABLE TEST_TABLE (i INT, l LONG, s0 VARCHAR, s1 VARCHAR, PRIMARY KEY (i, s0)) WITH \"backups=1\"", EMPTY);
        for (int i = 0; i < 10; ++i) {
            stmts.put("INSERT INTO TEST_TABLE (i, l, s0, s1) VALUES (?, ?, ?, ?)", Stream.of(Integer.valueOf(i), i * i, STR + i, STR + i * i).toArray());
        }
        stmts.put("CREATE INDEX i_idx ON TEST_TABLE(i)", EMPTY);
        stmts.put("CREATE INDEX l_idx ON TEST_TABLE(l)", EMPTY);
        stmts.put("CREATE INDEX s0_idx ON TEST_TABLE(s0) INLINE_SIZE 10", EMPTY);
        stmts.put("CREATE INDEX s1_idx ON TEST_TABLE(s1)", EMPTY);
        return stmts;
    }
}

