/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.Ignition;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.processors.cache.CacheConfigurationP2PTestServer;
import org.apache.ignite.internal.util.GridJavaProcess;
import org.apache.ignite.internal.util.lang.GridAbsPredicate;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class CacheConfigurationP2PTest
extends GridCommonAbstractTest {
    public static final String NODE_START_MSG = "Test external node started";
    private static final String CLIENT_CLS_NAME = "org.apache.ignite.tests.p2p.startcache.CacheConfigurationP2PTestClient";

    static IgniteConfiguration createConfiguration() {
        IgniteConfiguration cfg = new IgniteConfiguration();
        cfg.setPeerClassLoadingEnabled(true);
        cfg.setLocalHost("127.0.0.1");
        TcpDiscoverySpi disco = new TcpDiscoverySpi();
        disco.setIpFinderCleanFrequency(1000L);
        TcpDiscoveryVmIpFinder ipFinder = new TcpDiscoveryVmIpFinder();
        ipFinder.setAddresses(Arrays.asList("127.0.0.1:47500..47509"));
        disco.setIpFinder((TcpDiscoveryIpFinder)ipFinder);
        cfg.setDiscoverySpi((DiscoverySpi)disco);
        return cfg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCacheConfigurationP2P() throws Exception {
        CacheConfigurationP2PTest.fail((String)"Enable when IGNITE-537 is fixed.");
        try (Ignite ignite = Ignition.start((IgniteConfiguration)CacheConfigurationP2PTest.createConfiguration());){
            final CountDownLatch srvsReadyLatch = new CountDownLatch(2);
            final CountDownLatch clientReadyLatch = new CountDownLatch(1);
            GridJavaProcess node1 = null;
            GridJavaProcess node2 = null;
            GridJavaProcess clientNode = null;
            List<String> jvmArgs = Arrays.asList("-ea", "-DIGNITE_QUIET=false");
            try {
                node1 = GridJavaProcess.exec((String)CacheConfigurationP2PTestServer.class.getName(), null, (IgniteLogger)log, (IgniteInClosure)new CI1<String>(){

                    public void apply(String s) {
                        CacheConfigurationP2PTest.this.info("Server node1: " + s);
                        if (s.contains(CacheConfigurationP2PTest.NODE_START_MSG)) {
                            srvsReadyLatch.countDown();
                        }
                    }
                }, null, null, jvmArgs, null);
                node2 = GridJavaProcess.exec((String)CacheConfigurationP2PTestServer.class.getName(), null, (IgniteLogger)log, (IgniteInClosure)new CI1<String>(){

                    public void apply(String s) {
                        CacheConfigurationP2PTest.this.info("Server node2: " + s);
                        if (s.contains(CacheConfigurationP2PTest.NODE_START_MSG)) {
                            srvsReadyLatch.countDown();
                        }
                    }
                }, null, null, jvmArgs, null);
                CacheConfigurationP2PTest.assertTrue((boolean)srvsReadyLatch.await(60L, TimeUnit.SECONDS));
                String cp = U.getIgniteHome() + "/modules/extdata/p2p/target/classes/";
                clientNode = GridJavaProcess.exec((String)CLIENT_CLS_NAME, null, (IgniteLogger)log, (IgniteInClosure)new CI1<String>(){

                    public void apply(String s) {
                        CacheConfigurationP2PTest.this.info("Client node: " + s);
                        if (s.contains(CacheConfigurationP2PTest.NODE_START_MSG)) {
                            clientReadyLatch.countDown();
                        }
                    }
                }, null, null, jvmArgs, (String)cp);
                CacheConfigurationP2PTest.assertTrue((boolean)clientReadyLatch.await(60L, TimeUnit.SECONDS));
                int exitCode = clientNode.getProcess().waitFor();
                CacheConfigurationP2PTest.assertEquals((String)"Unexpected exit code", (int)0, (int)exitCode);
                node1.killProcess();
                node2.killProcess();
                final DiscoverySpi spi = ignite.configuration().getDiscoverySpi();
                boolean wait = GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicate(){

                    public boolean apply() {
                        Map p2pLdrs = (Map)GridTestUtils.getFieldValue((Object)spi, (String[])new String[]{"p2pLdrs"});
                        log.info("p2pLdrs: " + p2pLdrs.size());
                        return p2pLdrs.isEmpty();
                    }
                }, (long)10000L);
                CacheConfigurationP2PTest.assertTrue((boolean)wait);
            }
            finally {
                if (node1 != null) {
                    node1.killProcess();
                }
                if (node2 != null) {
                    node2.killProcess();
                }
                if (clientNode != null) {
                    clientNode.killProcess();
                }
            }
        }
    }
}

