/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metric;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.metric.AbstractIndexPageMetricsTest;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.persistence.DataRegion;
import org.apache.ignite.internal.processors.cache.persistence.DataRegionMetricsImpl;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMetrics;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class IndexPagesMetricsPersistentTest
extends AbstractIndexPageMetricsTest {
    @Override
    boolean isPersistenceEnabled() {
        return true;
    }

    @Override
    protected void beforeTest() throws Exception {
        this.cleanPersistenceDir();
        super.beforeTest();
    }

    @Override
    protected void afterTest() throws Exception {
        super.afterTest();
        this.cleanPersistenceDir();
    }

    @Override
    void validateIdxPagesCnt() throws IgniteCheckedException {
        DataRegion dataRegion = this.defaultDataRegion();
        DataRegionMetricsImpl dataRegionMetrics = dataRegion.metrics();
        long totalIdxPages = 0L;
        for (IgniteInternalCache cache : this.gridCacheProcessor().caches()) {
            int grpId = cache.context().groupId();
            long idxPages = this.indexPageCounter.countIdxPagesInMemory(grpId);
            PageMetrics metrics = dataRegionMetrics.cacheGrpPageMetrics(grpId);
            Assert.assertThat((Object)metrics.indexPages().value(), (Matcher)CoreMatchers.is((Object)idxPages));
            totalIdxPages += idxPages;
        }
        Assert.assertThat((Object)dataRegionMetrics.pageMetrics().indexPages().value(), (Matcher)CoreMatchers.is((Object)totalIdxPages));
    }
}

