/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntUnaryOperator;
import java.util.stream.Stream;
import javax.cache.Cache;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.query.IndexQuery;
import org.apache.ignite.cache.query.IndexQueryCriteriaBuilder;
import org.apache.ignite.cache.query.IndexQueryCriterion;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.query.QueryCursorEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IndexQueryRangeTest
extends GridCommonAbstractTest {
    private static final String CACHE = "TEST_CACHE";
    private static final String IDX = "PERSON_ID_IDX";
    private static final String DESC_IDX = "PERSON_DESCID_IDX";
    private static final int CNT = 10000;
    private Ignite crd;
    private IgniteCache<Long, Person> cache;
    @Parameterized.Parameter
    public int qryParallelism;
    @Parameterized.Parameter(value=1)
    public CacheAtomicityMode atomicityMode;
    @Parameterized.Parameter(value=2)
    public CacheMode cacheMode;
    @Parameterized.Parameter(value=3)
    public String node;
    @Parameterized.Parameter(value=4)
    public int backups;
    @Parameterized.Parameter(value=5)
    public String idxName;
    @Parameterized.Parameter(value=6)
    public int duplicates;

    @Parameterized.Parameters(name="qryPar={0} atomicity={1} mode={2} node={3} backups={4} idxName={5} duplicates={6}")
    public static Collection<Object[]> testParams() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        Stream.of("CRD", "CLN").forEach(node -> Stream.of(0, 2).forEach(backups -> Stream.of(1, 10).forEach(duplicates -> Stream.of(IDX, DESC_IDX).forEach(idx -> {
            params.add(new Object[]{1, CacheAtomicityMode.TRANSACTIONAL, CacheMode.REPLICATED, node, backups, idx, duplicates});
            params.add(new Object[]{1, CacheAtomicityMode.TRANSACTIONAL, CacheMode.PARTITIONED, node, backups, idx, duplicates});
            params.add(new Object[]{4, CacheAtomicityMode.TRANSACTIONAL, CacheMode.PARTITIONED, node, backups, idx, duplicates});
        }))));
        return params;
    }

    protected void beforeTest() throws Exception {
        this.crd = this.startGrids(4);
        IgniteEx client = this.startClientGrid();
        this.cache = "CRD".equals(this.node) ? this.crd.cache(CACHE) : client.cache(CACHE);
    }

    protected void afterTest() {
        this.stopAllGrids();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheConfiguration ccfg = new CacheConfiguration().setName(CACHE).setIndexedTypes(new Class[]{Long.class, Person.class}).setAtomicityMode(this.atomicityMode).setCacheMode(this.cacheMode).setQueryParallelism(this.qryParallelism).setBackups(this.backups);
        if (this.atomicityMode == CacheAtomicityMode.ATOMIC) {
            ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        }
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        return cfg;
    }

    @Test
    public void testRangeQueries() throws Exception {
        IndexQuery qry = new IndexQuery(Person.class, this.idxName);
        IndexQueryRangeTest.assertTrue((boolean)this.cache.query((Query)qry).getAll().isEmpty());
        this.insertData();
        qry = new IndexQuery(Person.class, this.idxName);
        this.check((Query<Cache.Entry<Long, Person>>)qry, 0, 10000);
        String fld = this.idxName.equals(IDX) ? "id" : "descId";
        int pivot = new Random().nextInt(10000);
        qry = new IndexQuery(Person.class, this.idxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.eq((String)fld, (Object)pivot)});
        this.check((Query<Cache.Entry<Long, Person>>)qry, pivot, pivot + 1);
        qry = new IndexQuery(Person.class, this.idxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)fld, (Object)pivot)});
        this.check((Query<Cache.Entry<Long, Person>>)qry, 0, pivot);
        qry = new IndexQuery(Person.class, this.idxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lte((String)fld, (Object)pivot)});
        this.check((Query<Cache.Entry<Long, Person>>)qry, 0, pivot + 1);
        qry = new IndexQuery(Person.class, this.idxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.gt((String)fld, (Object)pivot)});
        this.check((Query<Cache.Entry<Long, Person>>)qry, pivot + 1, 10000);
        qry = new IndexQuery(Person.class, this.idxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.gte((String)fld, (Object)pivot)});
        this.check((Query<Cache.Entry<Long, Person>>)qry, pivot, 10000);
        int lower = new Random().nextInt(5000);
        int upper = lower + 500;
        qry = new IndexQuery(Person.class, this.idxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.between((String)fld, (Object)lower, (Object)upper)});
        this.check((Query<Cache.Entry<Long, Person>>)qry, lower, upper + 1);
        qry = new IndexQuery(Person.class, this.idxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.in((String)fld, (Collection)F.asList((Object[])new Integer[]{pivot, pivot + 1}))});
        this.check((Query<Cache.Entry<Long, Person>>)qry, pivot, pivot + 2);
    }

    private void check(Query<Cache.Entry<Long, Person>> qry, int left, int right) throws Exception {
        QueryCursor cursor = this.cache.query(qry);
        int expSize = (right - left) * this.duplicates;
        HashSet<Long> expKeys = new HashSet<Long>(expSize);
        LinkedList<Integer> expOrderedValues = new LinkedList<Integer>();
        boolean desc = this.idxName.equals(DESC_IDX);
        int from = desc ? right - 1 : left;
        int to = desc ? left - 1 : right;
        IntUnaryOperator op = i -> desc ? i - 1 : i + 1;
        int i2 = from;
        while (i2 != to) {
            for (int j = 0; j < this.duplicates; ++j) {
                expOrderedValues.add(i2);
                expKeys.add(10000L * (long)j + (long)i2);
            }
            i2 = op.applyAsInt(i2);
        }
        AtomicInteger actSize = new AtomicInteger();
        ((QueryCursorEx)cursor).getAll(entry -> {
            IndexQueryRangeTest.assertEquals((int)((Integer)expOrderedValues.remove(0)), (int)((Person)entry.getValue()).id);
            IndexQueryRangeTest.assertTrue((boolean)expKeys.remove(entry.getKey()));
            int persId = ((Long)entry.getKey()).intValue() % 10000;
            IndexQueryRangeTest.assertEquals((Object)new Person(persId), (Object)entry.getValue());
            actSize.incrementAndGet();
        });
        IndexQueryRangeTest.assertEquals((int)expSize, (int)actSize.get());
        IndexQueryRangeTest.assertTrue((boolean)expKeys.isEmpty());
    }

    private void insertData() {
        try (IgniteDataStreamer streamer = this.crd.dataStreamer(this.cache.getName());){
            for (int persId = 0; persId < 10000; ++persId) {
                for (int i = 0; i < this.duplicates; ++i) {
                    streamer.addData((Object)(10000L * (long)i + (long)persId), (Object)new Person(persId));
                }
            }
        }
    }

    private static class Person {
        @QuerySqlField(index=true)
        final int id;
        @QuerySqlField(index=true, descending=true)
        final int descId;
        @QuerySqlField
        final int nonIdxSqlFld;
        final int nonSqlFld;

        Person(int id) {
            this.id = id;
            this.descId = id;
            this.nonIdxSqlFld = id;
            this.nonSqlFld = id;
        }

        public String toString() {
            return "Person[id=" + this.id + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Person person = (Person)o;
            return Objects.equals(this.id, person.id) && Objects.equals(this.descId, person.descId) && Objects.equals(this.nonIdxSqlFld, person.nonIdxSqlFld) && Objects.equals(this.nonSqlFld, person.nonSqlFld);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.descId, this.nonIdxSqlFld, this.nonSqlFld);
        }
    }
}

