/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.query;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import javax.cache.Cache;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.query.IndexQuery;
import org.apache.ignite.cache.query.IndexQueryCriteriaBuilder;
import org.apache.ignite.cache.query.IndexQueryCriterion;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IndexQueryAliasTest
extends GridCommonAbstractTest {
    private static final String CACHE = "TEST_CACHE";
    private static final String ID_IDX = "ID_IDX";
    private static final String DESC_ID_IDX = "DESC_ID_IDX";
    private static final int CNT = 10000;
    @Parameterized.Parameter
    public String qryIdx;
    @Parameterized.Parameter(value=1)
    public String qryDescIdx;
    private static IgniteCache<Long, Person> cache;

    @Parameterized.Parameters(name="qryIdx={0}, qryDescIdx={1}")
    public static List<Object[]> params() {
        return F.asList((Object[])new Object[][]{{null, null}, {ID_IDX, DESC_ID_IDX}});
    }

    protected void beforeTestsStarted() throws Exception {
        IgniteEx crd = this.startGrids(2);
        cache = crd.cache(CACHE);
        for (int i = 0; i < 10000; ++i) {
            cache.put((Object)i, (Object)new Person(i));
        }
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        QueryIndex idIdx = new QueryIndex("id", true, ID_IDX);
        QueryIndex descIdIdx = new QueryIndex("descId", false, DESC_ID_IDX);
        QueryEntity e = new QueryEntity(Long.class.getName(), Person.class.getName()).setFields(new LinkedHashMap(F.asMap((Object)"id", (Object)Integer.class.getName(), (Object)"descId", (Object)Integer.class.getName()))).setAliases(F.asMap((Object)"id", (Object)"asId", (Object)"descId", (Object)"asDescId")).setIndexes(Arrays.asList(idIdx, descIdIdx));
        CacheConfiguration ccfg1 = new CacheConfiguration().setName(CACHE).setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setQueryEntities(Collections.singletonList(e));
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg1});
        return cfg;
    }

    @Test
    public void testAliasRangeQueries() {
        int pivot = new Random().nextInt(10000);
        IndexQuery qry = new IndexQuery(Person.class, this.qryIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"asId", (Object)pivot)});
        this.check((QueryCursor<Cache.Entry<Long, Person>>)cache.query((Query)qry), 0, pivot, false);
        IndexQuery descQry = new IndexQuery(Person.class, this.qryDescIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"asDescId", (Object)pivot)});
        this.check((QueryCursor<Cache.Entry<Long, Person>>)cache.query((Query)descQry), 0, pivot, true);
    }

    @Test
    public void testAliasCaseRangeQueries() {
        int pivot = new Random().nextInt(10000);
        String idIdx = this.qryIdx != null ? this.qryIdx.toLowerCase() : null;
        IndexQuery qry = new IndexQuery(Person.class, idIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"ASID", (Object)pivot)});
        this.check((QueryCursor<Cache.Entry<Long, Person>>)cache.query((Query)qry), 0, pivot, false);
        String idDescIdx = this.qryDescIdx != null ? this.qryDescIdx.toLowerCase() : null;
        IndexQuery descQry = new IndexQuery(Person.class, idDescIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"ASDESCID", (Object)pivot)});
        this.check((QueryCursor<Cache.Entry<Long, Person>>)cache.query((Query)descQry), 0, pivot, true);
    }

    private void check(QueryCursor<Cache.Entry<Long, Person>> cursor, int left, int right, boolean desc) {
        List all = cursor.getAll();
        IndexQueryAliasTest.assertEquals((int)(right - left), (int)all.size());
        if (this.qryIdx != null) {
            for (int i = 0; i < all.size(); ++i) {
                int expKey = desc ? right - 1 - i : i;
                IndexQueryAliasTest.assertEquals((Object)new Person(expKey), (Object)((Cache.Entry)all.get(i)).getValue());
            }
            return;
        }
        Set expKeys = LongStream.range(left, right).boxed().collect(Collectors.toSet());
        for (int i = 0; i < all.size(); ++i) {
            Cache.Entry entry = (Cache.Entry)all.get(i);
            IndexQueryAliasTest.assertTrue((boolean)expKeys.remove(entry.getKey()));
            IndexQueryAliasTest.assertEquals((Object)new Person(((Long)entry.getKey()).intValue()), (Object)((Cache.Entry)all.get(i)).getValue());
        }
    }

    private static class Person {
        @GridToStringInclude
        final int id;
        @GridToStringInclude
        final int descId;

        Person(int id) {
            this.id = id;
            this.descId = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Person person = (Person)o;
            return Objects.equals(this.id, person.id) && Objects.equals(this.descId, person.descId);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.descId);
        }

        public String toString() {
            return S.toString(Person.class, (Object)this);
        }
    }
}

