/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.query.h2.opt.H2PlainRowFactory;
import org.apache.ignite.internal.processors.query.h2.twostep.AbstractReducer;
import org.apache.ignite.internal.processors.query.h2.twostep.UnsortedBaseReducer;
import org.gridgain.internal.h2.index.Cursor;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.result.SearchRow;
import org.gridgain.internal.h2.value.Value;

public class UnsortedReducer
extends UnsortedBaseReducer {
    public UnsortedReducer(GridKernalContext ctx) {
        super(ctx);
    }

    @Override
    protected Cursor findInStream(SearchRow first, SearchRow last) {
        return new FetchingCursor(new Iterator<Row>(){

            @Override
            public boolean hasNext() {
                UnsortedReducer.this.iter = UnsortedReducer.this.pollNextIterator(UnsortedReducer.this.queue, UnsortedReducer.this.iter);
                return UnsortedReducer.this.iter.hasNext();
            }

            @Override
            public Row next() {
                return H2PlainRowFactory.create((Value[])UnsortedReducer.this.iter.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        });
    }

    private class FetchingCursor
    implements Cursor {
        private Iterator<Row> stream;
        private List<Row> rows;
        private int cur;

        FetchingCursor(Iterator<Row> stream) {
            assert (stream != null);
            this.rows = UnsortedReducer.this.fetched;
            this.stream = stream;
            --this.cur;
        }

        private void fetchRows() {
            this.rows = UnsortedReducer.this.fetched.lastBlock();
            this.cur = this.rows.size();
            if (this.stream.hasNext()) {
                Row r = Objects.requireNonNull(this.stream.next());
                if (UnsortedReducer.this.memTracker != null) {
                    UnsortedReducer.this.memTracker.reserve((long)r.getMemory());
                }
                UnsortedReducer.this.fetched.add(r);
                if (UnsortedReducer.this.fetched.size() == AbstractReducer.MAX_FETCH_SIZE) {
                    UnsortedReducer.this.onBlockEvict(UnsortedReducer.this.fetched.evictFirstBlock());
                    assert (UnsortedReducer.this.fetched.size() < AbstractReducer.MAX_FETCH_SIZE);
                }
            }
            if (this.cur == this.rows.size()) {
                this.cur = Integer.MAX_VALUE;
            }
        }

        public boolean next() {
            if (this.cur == Integer.MAX_VALUE) {
                return false;
            }
            if (++this.cur == this.rows.size()) {
                this.fetchRows();
            }
            return this.cur < Integer.MAX_VALUE;
        }

        public Row get() {
            return this.rows.get(this.cur);
        }

        public SearchRow getSearchRow() {
            return this.get();
        }

        public boolean previous() {
            throw DbException.getUnsupportedException((String)"previous");
        }
    }
}

