/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.query.QueryRetryException;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheContextInfo;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.query.QueryTable;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.QueryField;
import org.apache.ignite.internal.processors.query.h2.H2TableDescriptor;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.IndexRebuildPartialClosure;
import org.apache.ignite.internal.processors.query.h2.database.H2IndexType;
import org.apache.ignite.internal.processors.query.h2.database.H2TreeIndex;
import org.apache.ignite.internal.processors.query.h2.database.H2TreeIndexBase;
import org.apache.ignite.internal.processors.query.h2.database.IndexInformation;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2IndexBase;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2ProxyIndex;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2ProxySpatialIndex;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.H2CacheRow;
import org.apache.ignite.internal.processors.query.h2.opt.H2TableScanIndex;
import org.apache.ignite.internal.processors.query.h2.opt.QueryContext;
import org.apache.ignite.internal.processors.query.h2.opt.TableStatistics;
import org.apache.ignite.internal.processors.query.schema.SchemaOperationException;
import org.apache.ignite.internal.processors.query.stat.ObjectStatistics;
import org.apache.ignite.internal.processors.query.stat.StatisticsKey;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.spi.indexing.IndexingQueryCacheFilter;
import org.apache.ignite.spi.indexing.IndexingQueryFilter;
import org.gridgain.internal.h2.command.ddl.CreateTableData;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.engine.SysProperties;
import org.gridgain.internal.h2.index.HashJoinIndex;
import org.gridgain.internal.h2.index.Index;
import org.gridgain.internal.h2.index.IndexType;
import org.gridgain.internal.h2.index.SpatialIndex;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.result.SearchRow;
import org.gridgain.internal.h2.schema.SchemaObject;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.IndexColumn;
import org.gridgain.internal.h2.table.Table;
import org.gridgain.internal.h2.table.TableBase;
import org.gridgain.internal.h2.table.TableType;
import org.jetbrains.annotations.Nullable;

public class GridH2Table
extends TableBase {
    private static final long EXCLUSIVE_LOCK = -1L;
    private static final AtomicIntegerFieldUpdater<GridH2Table> rebuildFromHashInProgressFieldUpdater = AtomicIntegerFieldUpdater.newUpdater(GridH2Table.class, "rebuildFromHashInProgress");
    private static final int FALSE = 0;
    private static final int TRUE = 1;
    private static final double STATS_UPDATE_THRESHOLD = 0.1;
    private final GridCacheContextInfo cacheInfo;
    private final GridH2RowDescriptor desc;
    private final GridH2IndexBase shadowedAffIndex;
    private volatile ArrayList<Index> idxs;
    private final int pkIndexPos;
    private final int sysIdxsCnt;
    private final Map<String, GridH2IndexBase> tmpIdxs = new HashMap<String, GridH2IndexBase>();
    private final ReentrantReadWriteLock lock;
    private final boolean hasHashIndex;
    private volatile boolean destroyed;
    private final ConcurrentMap<Session, SessionLock> sessions = new ConcurrentHashMap<Session, SessionLock>();
    private final IndexColumn affKeyCol;
    private final boolean affKeyColIsKey;
    private final LongAdder size = new LongAdder();
    private volatile int rebuildFromHashInProgress = 0;
    private final QueryTable identifier;
    private final String identifierStr;
    private volatile boolean rmIndex;
    private volatile Column[] safeColumns;
    private final AtomicLong ver = new AtomicLong();
    private volatile TableStatistics tblStats;
    @GridToStringExclude
    private IgniteLogger log;

    public GridH2Table(CreateTableData createTblData, GridH2RowDescriptor desc, H2TableDescriptor tblDesc, GridCacheContextInfo cacheInfo) {
        super(createTblData);
        assert (tblDesc != null);
        this.desc = desc;
        this.cacheInfo = cacheInfo;
        this.affKeyCol = this.calculateAffinityKeyColumn();
        this.affKeyColIsKey = this.affKeyCol != null && desc.isKeyColumn(this.affKeyCol.column.getColumnId());
        this.identifier = new QueryTable(this.getSchema().getName(), this.getName());
        this.identifierStr = this.identifier.schema() + "." + this.identifier.table();
        this.idxs = tblDesc.createSystemIndexes(this, this.log);
        assert (this.idxs != null);
        ArrayList<Index> clones = new ArrayList<Index>(this.idxs.size());
        for (Index index : this.idxs) {
            Index clone = this.createDuplicateIndexIfNeeded(index);
            if (clone == null) continue;
            clones.add(clone);
        }
        this.idxs.addAll(clones);
        boolean bl = this.hasHashIndex = this.idxs.size() >= 2 && this.index(0).getIndexType().isHash();
        if (this.hasHashIndex) {
            this.idxs.add(0, (Index)new H2TableScanIndex(this, this.index(1), this.index(0)));
        } else {
            this.idxs.add(0, (Index)new H2TableScanIndex(this, this.index(0), null));
        }
        this.pkIndexPos = this.hasHashIndex ? 2 : 1;
        Index affIdx = this.idxs.get(this.idxs.size() - 1);
        if (affIdx instanceof GridH2IndexBase && "AFFINITY_KEY".equals(affIdx.getName()) && tblDesc.isSystemAffinityIndexShadowed(this)) {
            this.shadowedAffIndex = (GridH2IndexBase)affIdx;
            this.idxs.remove(this.idxs.size() - 1);
        } else {
            this.shadowedAffIndex = null;
        }
        this.sysIdxsCnt = this.idxs.size();
        this.lock = new ReentrantReadWriteLock();
        if (cacheInfo.affinityNode()) {
            long totalTblSize = this.cacheSize(CachePeekMode.PRIMARY, CachePeekMode.BACKUP);
            this.size.add(totalTblSize);
        }
        this.tblStats = new TableStatistics(10000L, 10000L);
        if (desc != null && desc.context() != null) {
            GridKernalContext ctx = desc.context().kernalContext();
            this.log = ctx.log(((Object)((Object)this)).getClass());
        }
    }

    public List<IndexInformation> indexesInformation() {
        ArrayList<IndexInformation> res = new ArrayList<IndexInformation>();
        IndexColumn keyCol = this.indexColumn(0, 0);
        List<IndexColumn> wrappedKeyCols = H2Utils.treeIndexColumns(this.rowDescriptor(), new ArrayList<IndexColumn>(2), keyCol, this.affKeyCol);
        res.add(new IndexInformation(false, true, "_key_PK_hash", H2IndexType.HASH, H2Utils.indexColumnsSql(H2Utils.unwrapKeyColumns(this, wrappedKeyCols.toArray(H2Utils.EMPTY_COLUMNS))), null));
        res.add(new IndexInformation(false, false, "__SCAN_", H2IndexType.SCAN, null, null));
        for (Index idx : this.idxs) {
            if (idx instanceof H2TreeIndexBase) {
                res.add(new IndexInformation(idx.getIndexType().isPrimaryKey(), idx.getIndexType().isUnique(), idx.getName(), H2IndexType.BTREE, H2Utils.indexColumnsSql(H2Utils.unwrapKeyColumns(this, idx.getIndexColumns())), ((H2TreeIndexBase)idx).inlineSize()));
                continue;
            }
            if (!idx.getIndexType().isSpatial()) continue;
            res.add(new IndexInformation(false, false, idx.getName(), H2IndexType.SPATIAL, H2Utils.indexColumnsSql(idx.getIndexColumns()), null));
        }
        return res;
    }

    private IndexColumn calculateAffinityKeyColumn() {
        if (this.desc.type().customAffinityKeyMapper()) {
            return null;
        }
        String affKeyFieldName = this.desc.type().affinityKey();
        if (affKeyFieldName == null) {
            return this.indexColumn(0, 0);
        }
        if (!this.doesColumnExist(affKeyFieldName)) {
            return null;
        }
        int colId = this.getColumn(affKeyFieldName).getColumnId();
        if (this.desc.isKeyColumn(colId)) {
            return this.indexColumn(0, 0);
        }
        return this.indexColumn(colId, 0);
    }

    public boolean isPartitioned() {
        return this.desc != null && this.desc.cacheInfo().config().getCacheMode() == CacheMode.PARTITIONED;
    }

    @Nullable
    public IndexColumn getAffinityKeyColumn() {
        return this.affKeyCol;
    }

    @Nullable
    public IndexColumn getExplicitAffinityKeyColumn() {
        if (this.affKeyCol == null || this.affKeyColIsKey) {
            return null;
        }
        return this.affKeyCol;
    }

    public boolean isColumnForPartitionPruning(Column col) {
        return this.isColumnForPartitionPruning0(col, false);
    }

    public boolean isColumnForPartitionPruningStrict(Column col) {
        return this.isColumnForPartitionPruning0(col, true);
    }

    private boolean isColumnForPartitionPruning0(Column col, boolean strict) {
        if (this.affKeyCol == null) {
            return false;
        }
        int colId = col.getColumnId();
        if (colId == this.affKeyCol.column.getColumnId()) {
            return true;
        }
        return (this.affKeyColIsKey || !strict) && this.desc.isKeyColumn(colId);
    }

    public boolean isCustomAffinityMapper() {
        return this.desc.type().customAffinityKeyMapper();
    }

    public long getDiskSpaceUsed() {
        return 0L;
    }

    public GridH2RowDescriptor rowDescriptor() {
        return this.desc;
    }

    public String cacheName() {
        return this.cacheInfo.name();
    }

    public int cacheId() {
        return this.cacheInfo.cacheId();
    }

    public GridCacheContextInfo cacheInfo() {
        return this.cacheInfo;
    }

    public boolean isCacheLazy() {
        return this.cacheInfo.cacheContext() == null;
    }

    public ObjectStatistics tableStatistics() {
        GridCacheContext cacheContext = this.cacheInfo.cacheContext();
        if (cacheContext == null) {
            return null;
        }
        IgniteH2Indexing indexing = (IgniteH2Indexing)cacheContext.kernalContext().query().getIndexing();
        return indexing.statsManager().getLocalStatistics(new StatisticsKey(this.identifier.schema(), this.identifier.table()));
    }

    @Nullable
    public GridCacheContext cacheContext() {
        return this.cacheInfo.cacheContext();
    }

    public boolean lock(Session ses, boolean exclusive, boolean force) {
        SessionLock sesLock = (SessionLock)this.sessions.get(ses);
        if (sesLock != null) {
            if (sesLock.isExclusive()) {
                return true;
            }
            if (this.ver.get() != sesLock.version()) {
                throw new QueryRetryException(this.getName());
            }
            return false;
        }
        this.lock(exclusive, true);
        if (this.destroyed) {
            this.unlock(exclusive);
            throw new IllegalStateException("Table " + this.identifierString() + " already destroyed.");
        }
        this.sessions.put(ses, exclusive ? SessionLock.exclusiveLock() : SessionLock.sharedLock(this.ver.longValue()));
        ses.addLock((Table)this);
        return false;
    }

    public void unlock(Session ses) {
        SessionLock sesLock = (SessionLock)this.sessions.remove(ses);
        if (sesLock == null) {
            this.log.warning("Requested session ses=[" + ses + "] was already removed from active sessions list.");
            return;
        }
        if (sesLock.locked) {
            this.unlock(sesLock.isExclusive());
        }
    }

    private void readLockInternal(Session ses) {
        SessionLock sesLock = (SessionLock)this.sessions.get(ses);
        assert (sesLock != null && !sesLock.isExclusive()) : "Invalid table lock [name=" + this.getName() + ", lock=" + sesLock == null ? "null" : Long.valueOf(sesLock.ver + 93L);
        if (!sesLock.locked) {
            this.lock(false);
            sesLock.locked = true;
        }
    }

    private void unlockReadInternal(Session ses) {
        SessionLock sesLock = (SessionLock)this.sessions.get(ses);
        assert (sesLock != null && !sesLock.isExclusive()) : "Invalid table unlock [name=" + this.getName() + ", lock=" + sesLock == null ? "null" : Long.valueOf(sesLock.ver + 93L);
        if (sesLock.locked) {
            sesLock.locked = false;
            this.unlock(false);
        }
    }

    private void lock(boolean exclusive) {
        this.lock(exclusive, false);
    }

    private void lock(boolean exclusive, boolean interruptibly) {
        Lock l = exclusive ? this.lock.writeLock() : this.lock.readLock();
        try {
            if (!exclusive) {
                if (interruptibly) {
                    l.lockInterruptibly();
                } else {
                    l.lock();
                }
            } else {
                while (!l.tryLock(200L, TimeUnit.MILLISECONDS)) {
                    Thread.yield();
                }
                this.ver.incrementAndGet();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IgniteInterruptedException("Thread got interrupted while trying to acquire table lock.", e);
        }
    }

    private void unlock(boolean exclusive) {
        Lock l = exclusive ? this.lock.writeLock() : this.lock.readLock();
        l.unlock();
    }

    private void checkVersion(Session ses) {
        SessionLock sesLock = (SessionLock)this.sessions.get(ses);
        assert (sesLock != null && !sesLock.isExclusive()) : "Invalid table check version  [name=" + this.getName() + ", lock=" + sesLock.ver + ']';
        if (this.ver.longValue() != sesLock.version()) {
            throw new QueryRetryException(this.getName());
        }
    }

    public QueryTable identifier() {
        return this.identifier;
    }

    public String identifierString() {
        return this.identifierStr;
    }

    private void ensureNotDestroyed() {
        if (this.destroyed) {
            throw new IllegalStateException("Table " + this.identifierString() + " already destroyed.");
        }
    }

    public void close(Session ses) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChildrenAndResources(Session ses) {
        this.lock(true);
        try {
            super.removeChildrenAndResources(ses);
            while (this.idxs.size() > this.sysIdxsCnt) {
                Index idx = this.idxs.get(this.sysIdxsCnt);
                if (idx.getName() == null || idx.getSchema().findIndex(ses, idx.getName()) != idx) continue;
                this.database.removeSchemaObject(ses, (SchemaObject)idx);
                if (!(idx instanceof GridH2IndexBase)) continue;
                ((GridH2IndexBase)idx).destroy(this.rmIndex);
            }
            if (SysProperties.CHECK) {
                for (SchemaObject obj : this.database.getAllSchemaObjects(1)) {
                    Index idx = (Index)obj;
                    if (idx.getTable() != this) continue;
                    DbException.throwInternalError((String)("index not dropped: " + idx.getName()));
                }
            }
            this.database.removeMeta(ses, this.getId());
            this.invalidate();
        }
        finally {
            this.unlock(true);
        }
    }

    public void destroy() {
        this.lock(true);
        try {
            this.ensureNotDestroyed();
            this.destroyed = true;
            if (this.shadowedAffIndex != null) {
                this.shadowedAffIndex.destroy(this.rmIndex);
            }
            int len = this.idxs.size();
            for (int i = 1; i < len; ++i) {
                if (!(this.idxs.get(i) instanceof GridH2IndexBase)) continue;
                this.index(i).destroy(this.rmIndex);
            }
        }
        finally {
            this.unlock(true);
        }
    }

    public void setRemoveIndexOnDestroy(boolean rmIndex) {
        this.rmIndex = rmIndex;
    }

    private GridH2IndexBase index(int idx) {
        return (GridH2IndexBase)this.idxs.get(idx);
    }

    private GridH2IndexBase pk() {
        return (GridH2IndexBase)this.idxs.get(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(CacheDataRow row, @Nullable CacheDataRow prevRow, boolean prevRowAvailable) throws IgniteCheckedException {
        assert (this.desc != null);
        H2CacheRow row0 = this.desc.createRow(row);
        H2CacheRow prevRow0 = prevRow != null ? this.desc.createRow(prevRow) : null;
        row0.prepareValuesCache();
        if (prevRow0 != null) {
            prevRow0.prepareValuesCache();
        }
        IgniteCheckedException err = null;
        try {
            this.lock(false);
            try {
                boolean replaced;
                this.ensureNotDestroyed();
                if (prevRowAvailable && this.rebuildFromHashInProgress == 0) {
                    replaced = this.pk().putx(row0);
                } else {
                    prevRow0 = this.pk().put(row0);
                    boolean bl = replaced = prevRow0 != null;
                }
                if (!replaced) {
                    this.size.increment();
                }
                int len = this.idxs.size();
                for (int i = this.pkIndexPos + 1; i < len; ++i) {
                    Index idx = this.idxs.get(i);
                    if (!(idx instanceof GridH2IndexBase)) continue;
                    err = this.addToIndex((GridH2IndexBase)idx, row0, prevRow0, err);
                }
                if (!this.tmpIdxs.isEmpty()) {
                    for (GridH2IndexBase idx : this.tmpIdxs.values()) {
                        err = this.addToIndex(idx, row0, prevRow0, err);
                    }
                }
            }
            finally {
                this.unlock(false);
            }
        }
        finally {
            this.updateStatistics(row0.key());
            row0.clearValuesCache();
            if (prevRow0 != null) {
                prevRow0.clearValuesCache();
            }
        }
        if (err != null) {
            throw err;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(CacheDataRow row) throws IgniteCheckedException {
        H2CacheRow row0 = this.desc.createRow(row);
        boolean res = false;
        this.lock(false);
        try {
            this.ensureNotDestroyed();
            boolean pkRmv = this.pk().removex((SearchRow)row0);
            int len = this.idxs.size();
            for (int i = this.pkIndexPos + 1; i < len; ++i) {
                boolean scndRmv;
                Index idx = this.idxs.get(i);
                if (!(idx instanceof GridH2IndexBase) || (scndRmv = ((GridH2IndexBase)idx).removex((SearchRow)row0)) == pkRmv) continue;
                this.log.warning("SQL index inconsistency detected:\nwasInPk=" + pkRmv + ",\nwasInSecIdx=" + scndRmv + ",\ntblName=" + this.getName() + ",\nsecIdxName=" + idx.getName() + ",\nrow=" + row0 + ",\nrowKeyHex=0x" + IgniteUtils.byteArray2HexString((byte[])this.rowKeyBytes(row0)) + ",\nrowValueHex=0x" + IgniteUtils.byteArray2HexString((byte[])this.rowValueBytes(row0)));
            }
            if (!this.tmpIdxs.isEmpty()) {
                for (GridH2IndexBase idx : this.tmpIdxs.values()) {
                    idx.removex((SearchRow)row0);
                }
            }
            if (pkRmv) {
                this.size.decrement();
            }
            res = pkRmv;
        }
        finally {
            this.unlock(false);
        }
        this.updateStatistics(row0.key());
        return res;
    }

    private IgniteCheckedException addToIndex(GridH2IndexBase idx, H2CacheRow row, H2CacheRow prevRow, IgniteCheckedException err) {
        try {
            boolean replaced = idx.putx(row);
            if (!replaced && prevRow != null) {
                idx.removex((SearchRow)prevRow);
            }
            return err;
        }
        catch (Throwable t) {
            IgniteSQLException ex = (IgniteSQLException)X.cause((Throwable)t, IgniteSQLException.class);
            if (ex != null && ex.statusCode() == 5006) {
                if (err != null) {
                    err.addSuppressed(t);
                    return err;
                }
                return new IgniteCheckedException("Error on add row to index '" + this.getName() + '\'', t);
            }
            throw t;
        }
    }

    public void collectIndexesForPartialRebuild(IndexRebuildPartialClosure clo, boolean force) {
        for (int i = 0; i < this.idxs.size(); ++i) {
            Index idx = this.idxs.get(i);
            if (!(idx instanceof H2TreeIndex)) continue;
            H2TreeIndex idx0 = (H2TreeIndex)idx;
            if (!force && !idx0.rebuildRequired()) continue;
            clo.addIndex(this, idx0);
        }
    }

    public boolean checkIfIndexesRebuildRequired() {
        for (int i = 0; i < this.idxs.size(); ++i) {
            H2TreeIndex idx0;
            Index idx = this.idxs.get(i);
            if (!(idx instanceof H2TreeIndex) || !(idx0 = (H2TreeIndex)idx).rebuildRequired()) continue;
            return true;
        }
        return false;
    }

    public void markRebuildFromHashInProgress(boolean value) {
        assert (!value || this.idxs.size() >= 2 && this.index(1).getIndexType().isHash()) : "Table has no hash index.";
        if (rebuildFromHashInProgressFieldUpdater.compareAndSet(this, value ? 0 : 1, value ? 1 : 0)) {
            this.lock.writeLock().lock();
            try {
                this.incrementModificationCounter();
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    public boolean rebuildFromHashInProgress() {
        return this.rebuildFromHashInProgress == 1;
    }

    public Index addIndex(Session ses, String idxName, int idxId, IndexColumn[] cols, IndexType idxType, boolean create, String idxComment) {
        return this.commitUserIndex(ses, idxName);
    }

    private void checkEquivalentFieldsIndexIsPresent(Index curIdx) {
        IndexColumn[] curColumns = curIdx.getIndexColumns();
        Index registredIdx = null;
        for (Index idx : this.idxs) {
            if (!(idx instanceof H2TreeIndex)) continue;
            IndexColumn[] idxColumns = idx.getIndexColumns();
            for (int i = 0; i < Math.min(idxColumns.length, curColumns.length); ++i) {
                IndexColumn idxCol = idxColumns[i];
                IndexColumn curCol = curColumns[i];
                if (curCol.column.getColumnId() == 0 && registredIdx != null) continue;
                if (H2Utils.equals(idxCol, curCol) && idxCol.sortType == curCol.sortType) {
                    registredIdx = idx;
                    continue;
                }
                registredIdx = null;
                break;
            }
            if (registredIdx == null) continue;
            String idxCols = Stream.of(registredIdx.getIndexColumns()).map(k -> k.columnName).collect(Collectors.joining(", "));
            U.warn((IgniteLogger)this.log, (Object)("Index with the given set or subset of columns already exists (consider dropping either new or existing index) [cacheName=" + this.cacheInfo.name() + ", schemaName=" + this.getSchema().getName() + ", tableName=" + this.getName() + ", newIndexName=" + curIdx.getName() + ", existingIndexName=" + registredIdx.getName() + ", existingIndexColumns=[" + idxCols + "]]"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void proposeUserIndex(Index idx) throws IgniteCheckedException {
        assert (idx instanceof GridH2IndexBase);
        this.lock(true);
        try {
            this.ensureNotDestroyed();
            for (Index idx0 : this.idxs) {
                if (!F.eq((Object)idx.getName(), (Object)idx0.getName())) continue;
                throw new SchemaOperationException(7, idx.getName());
            }
            this.checkEquivalentFieldsIndexIsPresent(idx);
            Index oldTmpIdx = (Index)this.tmpIdxs.put(idx.getName(), (GridH2IndexBase)idx);
            assert (oldTmpIdx == null);
        }
        finally {
            this.unlock(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Index commitUserIndex(Session ses, String idxName) {
        this.lock(true);
        try {
            this.ensureNotDestroyed();
            Index idx = (Index)this.tmpIdxs.remove(idxName);
            assert (idx != null);
            Index cloneIdx = this.createDuplicateIndexIfNeeded(idx);
            ArrayList<Index> newIdxs = new ArrayList<Index>(this.idxs.size() + (cloneIdx == null ? 1 : 2));
            newIdxs.addAll(this.idxs);
            newIdxs.add(idx);
            if (cloneIdx != null) {
                newIdxs.add(cloneIdx);
            }
            this.idxs = newIdxs;
            this.database.addSchemaObject(ses, (SchemaObject)idx);
            if (cloneIdx != null) {
                this.database.addSchemaObject(ses, (SchemaObject)cloneIdx);
            }
            this.incrementModificationCounter();
            Index index = idx;
            return index;
        }
        finally {
            this.unlock(true);
        }
    }

    public void rollbackUserIndex(String idxName) {
        this.lock(true);
        try {
            this.ensureNotDestroyed();
            GridH2IndexBase rmvIdx = this.tmpIdxs.remove(idxName);
            assert (rmvIdx != null);
            rmvIdx.destroy(true);
        }
        finally {
            this.unlock(true);
        }
    }

    @Nullable
    public Index userIndex(String idxName) {
        for (int i = 2; i < this.idxs.size(); ++i) {
            Index idx = this.idxs.get(i);
            if (!idx.getName().equalsIgnoreCase(idxName)) continue;
            return idx;
        }
        return null;
    }

    public void removeIndex(Index h2Idx) {
        throw DbException.getUnsupportedException((String)"must use removeIndex(session, idx)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIndex(Session session, Index h2Idx) {
        this.lock(true);
        try {
            this.ensureNotDestroyed();
            ArrayList<Index> idxs = new ArrayList<Index>(this.idxs);
            Index targetIdx = h2Idx instanceof GridH2ProxyIndex ? ((GridH2ProxyIndex)h2Idx).underlyingIndex() : h2Idx;
            int i = this.pkIndexPos;
            while (i < idxs.size()) {
                Index idx = idxs.get(i);
                if (idx == targetIdx || idx instanceof GridH2ProxyIndex && ((GridH2ProxyIndex)idx).underlyingIndex() == targetIdx) {
                    GridCacheContext cctx0;
                    Index idx0 = idxs.remove(i);
                    if (idx0 instanceof GridH2ProxyIndex && idx.getSchema().findIndex(session, idx.getName()) != null) {
                        this.database.removeSchemaObject(session, (SchemaObject)idx);
                    }
                    if ((cctx0 = this.cacheInfo.cacheContext()) == null || !(idx0 instanceof GridH2IndexBase)) continue;
                    ((GridH2IndexBase)idx0).destroy(this.rmIndex);
                    continue;
                }
                ++i;
            }
            this.idxs = idxs;
        }
        finally {
            this.unlock(true);
        }
    }

    public void removeRow(Session ses, Row row) {
        throw DbException.getUnsupportedException((String)"removeRow");
    }

    public void truncate(Session ses) {
        throw DbException.getUnsupportedException((String)"truncate");
    }

    public void addRow(Session ses, Row row) {
        throw DbException.getUnsupportedException((String)"addRow");
    }

    public void checkSupportAlter() {
        throw DbException.getUnsupportedException((String)"alter");
    }

    public TableType getTableType() {
        return TableType.TABLE;
    }

    public Index getScanIndex(Session ses) {
        return this.getIndexes().get(0);
    }

    public Index getUniqueIndex() {
        if (this.rebuildFromHashInProgress == 1) {
            return this.index(1);
        }
        return this.index(2);
    }

    public ArrayList<Index> getIndexes() {
        if (this.rebuildFromHashInProgress == 0) {
            return this.idxs;
        }
        ArrayList<Index> idxs = new ArrayList<Index>(2);
        idxs.add(this.idxs.get(0));
        if (this.hasHashIndex) {
            idxs.add(this.idxs.get(1));
        }
        return idxs;
    }

    public boolean isLockedExclusively() {
        return false;
    }

    public boolean isLockedExclusivelyBy(Session ses) {
        return false;
    }

    public long getMaxDataModificationId() {
        return 0L;
    }

    public boolean isDeterministic() {
        return true;
    }

    public boolean canGetRowCount() {
        return true;
    }

    public boolean canDrop() {
        return true;
    }

    public long getRowCount(@Nullable Session ses) {
        return this.getUniqueIndex().getRowCount(ses);
    }

    public long getRowCountApproximation(Session ses) {
        if (!this.localQuery(H2Utils.context(ses))) {
            return 10000L;
        }
        this.refreshStatsIfNeeded();
        return this.tblStats.primaryRowCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareIndexesForRebuild(Session session) throws IgniteCheckedException {
        this.lock(true);
        try {
            Index idx;
            int i;
            ArrayList<Object> newIdxs = new ArrayList<Object>(this.idxs.size());
            for (i = 0; i < this.sysIdxsCnt && !((idx = this.idxs.get(i)) instanceof GridH2ProxyIndex); ++i) {
                Index newIdx = idx instanceof H2TreeIndex ? this.recreateIndex((H2TreeIndex)idx) : idx;
                newIdxs.add(newIdx);
            }
            for (i = 1; i < this.sysIdxsCnt; ++i) {
                Index clone = this.createDuplicateIndexIfNeeded((Index)newIdxs.get(i));
                if (clone == null) continue;
                newIdxs.add(clone);
            }
            ArrayList<IgniteBiTuple> toReplace = new ArrayList<IgniteBiTuple>();
            for (int i2 = this.sysIdxsCnt; i2 < this.idxs.size(); ++i2) {
                Index idx2 = this.idxs.get(i2);
                if (idx2 instanceof GridH2ProxyIndex) continue;
                if (idx2 instanceof H2TreeIndex) {
                    H2TreeIndex newIdx = this.recreateIndex((H2TreeIndex)idx2);
                    newIdxs.add((Object)newIdx);
                    toReplace.add(new IgniteBiTuple((Object)idx2, (Object)newIdx));
                    Index clone = this.createDuplicateIndexIfNeeded((Index)newIdx);
                    if (clone == null) continue;
                    newIdxs.add(clone);
                    toReplace.add(new IgniteBiTuple(null, (Object)clone));
                    continue;
                }
                newIdxs.add(idx2);
                if (!(this.idxs.get(i2 + 1) instanceof GridH2ProxyIndex)) continue;
                newIdxs.add(this.idxs.get(++i2));
            }
            for (IgniteBiTuple oldToNew : toReplace) {
                this.replaceSchemaObject(session, (SchemaObject)oldToNew.get1(), (SchemaObject)oldToNew.get2());
            }
            if (this.hasHashIndex) {
                newIdxs.set(0, (Object)new H2TableScanIndex(this, (GridH2IndexBase)((Object)newIdxs.get(2)), (GridH2IndexBase)((Object)newIdxs.get(1))));
            } else {
                newIdxs.set(0, (Object)new H2TableScanIndex(this, (GridH2IndexBase)((Object)newIdxs.get(1)), null));
            }
            this.idxs = newIdxs;
            this.incrementModificationCounter();
        }
        finally {
            this.unlock(true);
        }
    }

    private H2TreeIndex recreateIndex(H2TreeIndex treeIdx) throws IgniteCheckedException {
        treeIdx.destroy0(true, true);
        GridCacheContext cctx = this.cacheContext();
        assert (cctx != null);
        return treeIdx.createCopy(cctx.dataRegion().pageMemory(), cctx.offheap());
    }

    private void replaceSchemaObject(Session session, @Nullable SchemaObject oldObj, @Nullable SchemaObject newObj) {
        assert (this.lock.writeLock().isHeldByCurrentThread()) : this.lock.writeLock();
        if (oldObj != null) {
            this.database.removeSchemaObject(session, oldObj);
        }
        if (newObj != null) {
            this.database.addSchemaObject(session, newObj);
        }
    }

    private boolean localQuery(QueryContext qctx) {
        assert (qctx != null);
        return qctx.local();
    }

    private void refreshStatsIfNeeded() {
        long curTotalRowCnt;
        TableStatistics stats = this.tblStats;
        long statsTotalRowCnt = stats.totalRowCount();
        if (GridH2Table.needRefreshStats(statsTotalRowCnt, curTotalRowCnt = this.size.sum()) && this.cacheInfo.affinityNode()) {
            CacheConfiguration ccfg = this.cacheContext().config();
            int backups = ccfg.getCacheMode() == CacheMode.REPLICATED ? 0 : this.cacheContext().config().getBackups();
            long localOwnerRowCnt = this.cacheSize(CachePeekMode.PRIMARY, CachePeekMode.BACKUP) / (long)(backups + 1);
            int owners = this.cacheContext().discovery().cacheNodes(this.cacheContext().name(), AffinityTopologyVersion.NONE).size();
            long totalRowCnt = (long)owners * localOwnerRowCnt;
            this.size.reset();
            this.size.add(totalRowCnt);
            this.tblStats = new TableStatistics(totalRowCnt, localOwnerRowCnt);
        }
    }

    private static boolean needRefreshStats(long statsRowCnt, long actualRowCnt) {
        double delta = U.safeAbs((long)(statsRowCnt - actualRowCnt));
        double relativeChange = delta / (double)(statsRowCnt + 1L);
        return relativeChange > 0.1;
    }

    private long cacheSize(CachePeekMode ... modes) {
        try {
            return this.cacheInfo.cacheContext().cache().localSizeLong(modes);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    @Nullable
    private IndexingQueryCacheFilter backupFilter() {
        IgniteH2Indexing indexing = this.rowDescriptor().indexing();
        AffinityTopologyVersion topVer = indexing.readyTopologyVersion();
        IndexingQueryFilter filter = indexing.backupFilter(topVer, null);
        return filter.forCache(this.cacheName());
    }

    public void checkRename() {
        throw DbException.getUnsupportedException((String)"rename");
    }

    public IndexColumn indexColumn(int col, int sorting) {
        IndexColumn res = new IndexColumn();
        res.column = this.getColumn(col);
        res.columnName = res.column.getName();
        res.sortType = sorting;
        return res;
    }

    private void updateStatistics(KeyCacheObject key) {
        block3: {
            GridCacheContext cacheCtx = this.cacheInfo.cacheContext();
            if (cacheCtx == null) {
                return;
            }
            IgniteH2Indexing indexing = (IgniteH2Indexing)cacheCtx.kernalContext().query().getIndexing();
            try {
                indexing.statsManager().onRowUpdated(this.identifier().schema(), this.identifier.table(), key.partition(), key.valueBytes((CacheObjectValueContext)this.cacheContext().cacheObjectContext()));
            }
            catch (IgniteCheckedException e) {
                if (!this.log.isDebugEnabled()) break block3;
                this.log.debug("Error while updating statistics obsolescence due to " + e.getMessage());
            }
        }
    }

    private Index createDuplicateIndexIfNeeded(Index target) {
        if (!(target instanceof H2TreeIndexBase) && !(target instanceof SpatialIndex)) {
            return null;
        }
        IndexColumn[] cols = target.getIndexColumns();
        ArrayList<IndexColumn> proxyCols = new ArrayList<IndexColumn>(cols.length);
        boolean modified = false;
        for (IndexColumn col : cols) {
            IndexColumn proxyCol = new IndexColumn();
            proxyCol.columnName = col.columnName;
            proxyCol.column = col.column;
            proxyCol.sortType = col.sortType;
            int altColId = this.desc.getAlternativeColumnId(proxyCol.column.getColumnId());
            if (altColId != proxyCol.column.getColumnId()) {
                proxyCol.column = this.getColumn(altColId);
                proxyCol.columnName = proxyCol.column.getName();
                modified = true;
            }
            proxyCols.add(proxyCol);
        }
        if (modified) {
            String proxyName = target.getName() + "_proxy";
            if (target.getIndexType().isSpatial()) {
                return new GridH2ProxySpatialIndex(this, proxyName, proxyCols, target);
            }
            return new GridH2ProxyIndex(this, proxyName, proxyCols, target);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addColumns(List<QueryField> cols, boolean ifNotExists) {
        assert (!ifNotExists || cols.size() == 1);
        this.lock(true);
        try {
            Column[] safeColumns0 = this.safeColumns;
            int pos = safeColumns0.length;
            Column[] newCols = new Column[safeColumns0.length + cols.size()];
            System.arraycopy(safeColumns0, 0, newCols, 0, safeColumns0.length);
            for (QueryField col : cols) {
                if (this.doesColumnExist(col.name())) {
                    if (ifNotExists && cols.size() == 1) {
                        return;
                    }
                    throw new IgniteSQLException("Column already exists [tblName=" + this.getName() + ", colName=" + col.name() + ']');
                }
                try {
                    Column c = new Column(col.name(), H2Utils.getTypeFromClass(Class.forName(col.typeName())));
                    c.setNullable(col.isNullable());
                    newCols[pos++] = c;
                }
                catch (ClassNotFoundException e) {
                    throw new IgniteSQLException("H2 data type not found for class: " + col.typeName(), (Throwable)e);
                }
            }
            this.setColumns(newCols);
            this.desc.refreshMetadataFromTypeDescriptor();
            this.incrementModificationCounter();
        }
        finally {
            this.unlock(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropColumns(List<String> cols, boolean ifExists) {
        assert (!ifExists || cols.size() == 1);
        this.lock(true);
        try {
            Column[] safeColumns0 = this.safeColumns;
            int size = safeColumns0.length;
            for (String name : cols) {
                if (!this.doesColumnExist(name)) {
                    if (ifExists && cols.size() == 1) {
                        return;
                    }
                    throw new IgniteSQLException("Column does not exist [tblName=" + this.getName() + ", colName=" + name + ']');
                }
                --size;
            }
            assert (size > 2);
            Column[] newCols = new Column[size];
            int dst = 0;
            for (int i = 0; i < safeColumns0.length; ++i) {
                Column column = safeColumns0[i];
                for (String name : cols) {
                    if (!F.eq((Object)name, (Object)column.getName())) continue;
                    column = null;
                    break;
                }
                if (column == null) continue;
                newCols[dst++] = column;
            }
            this.setColumns(newCols);
            this.desc.refreshMetadataFromTypeDescriptor();
            for (Index idx : this.getIndexes()) {
                if (!(idx instanceof GridH2IndexBase)) continue;
                ((GridH2IndexBase)idx).refreshColumnIds();
            }
            this.incrementModificationCounter();
        }
        finally {
            this.unlock(true);
        }
    }

    protected void setColumns(Column[] columns) {
        this.safeColumns = columns;
        super.setColumns(columns);
    }

    public Column[] getColumns() {
        return this.safeColumns;
    }

    private void incrementModificationCounter() {
        assert (this.lock.isWriteLockedByCurrentThread());
        this.setModified();
    }

    public static void unlockTables(Session s) {
        for (Table t : s.getLocks()) {
            if (!(t instanceof GridH2Table)) continue;
            ((GridH2Table)t).unlockReadInternal(s);
        }
    }

    public static void readLockTables(Session s) {
        for (Table t : s.getLocks()) {
            if (!(t instanceof GridH2Table)) continue;
            ((GridH2Table)t).readLockInternal(s);
        }
    }

    public static void checkTablesVersions(Session s) {
        for (Table t : s.getLocks()) {
            if (!(t instanceof GridH2Table)) continue;
            ((GridH2Table)t).checkVersion(s);
        }
    }

    public byte[] rowValueBytes(Object row) {
        if (!S.includeSensitive()) {
            return "<HIDDEN>".getBytes();
        }
        if (row instanceof H2CacheRow) {
            try {
                return ((H2CacheRow)row).value().valueBytes((CacheObjectValueContext)this.cacheContext().cacheObjectContext());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "<UNAVAILABLE>".getBytes();
    }

    public byte[] rowKeyBytes(Object row) {
        if (row instanceof H2CacheRow) {
            try {
                return ((H2CacheRow)row).key().valueBytes((CacheObjectValueContext)this.cacheContext().cacheObjectContext());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "<UNAVAILABLE>".getBytes();
    }

    @Nullable
    public Index getIndexSafe(String indexName) {
        ArrayList<Index> indexes = this.getIndexes();
        if ("HASH_JOIN_IDX".equalsIgnoreCase(indexName)) {
            return new HashJoinIndex((Table)this);
        }
        if (indexes != null) {
            for (Index index : indexes) {
                if (!index.getName().equals(indexName)) continue;
                return index;
            }
        }
        return null;
    }

    private static class SessionLock {
        final long ver;
        boolean locked;

        private SessionLock(long ver) {
            this.ver = ver;
            this.locked = true;
        }

        static SessionLock sharedLock(long ver) {
            return new SessionLock(ver);
        }

        static SessionLock exclusiveLock() {
            return new SessionLock(-1L);
        }

        boolean isExclusive() {
            return this.ver == -1L;
        }

        long version() {
            return this.ver;
        }
    }
}

