/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.util;

import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.cache.CacheException;
import javax.cache.event.CacheEntryEvent;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.query.ContinuousQuery;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.AbstractSchemaSelfTest;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.util.KillCommandsSQLTest;
import org.junit.Assert;

class KillCommandsTests {
    public static final String SVC_NAME = "my-svc";
    public static final String DEFAULT_CACHE_NAME = "default";
    public static final int PAGE_SZ = 5;
    public static final int TIMEOUT = 10000;

    KillCommandsTests() {
    }

    public static void doTestCancelSQLQuery(IgniteEx cli, Consumer<String> qryCanceler) {
        String qryStr = "SELECT * FROM \"default\".Integer";
        SqlFieldsQuery qry = new SqlFieldsQuery(qryStr).setPageSize(5);
        Iterator iter = AbstractSchemaSelfTest.queryProcessor((Ignite)cli).querySqlFields(qry, true).iterator();
        Assert.assertNotNull(iter.next());
        List<List<?>> sqlQries = KillCommandsSQLTest.execute((Ignite)cli, "SELECT * FROM SYS.SQL_QUERIES ORDER BY START_TIME", new Object[0]);
        Assert.assertEquals((long)2L, (long)sqlQries.size());
        String qryId = (String)sqlQries.get(0).get(0);
        Assert.assertEquals((Object)qryStr, sqlQries.get(0).get(1));
        qryCanceler.accept(qryId);
        for (int i = 0; i < 3; ++i) {
            Assert.assertNotNull(iter.next());
        }
        GridTestUtils.assertThrowsWithCause(iter::next, CacheException.class);
    }

    public static void doTestCancelContinuousQuery(IgniteEx cli, List<IgniteEx> srvs, BiConsumer<UUID, UUID> qryCanceler) throws Exception {
        int i;
        IgniteCache cache = cli.cache(DEFAULT_CACHE_NAME);
        ContinuousQuery cq = new ContinuousQuery();
        AtomicInteger cntr = new AtomicInteger();
        cq.setInitialQuery((Query)new ScanQuery());
        cq.setTimeInterval(1000L);
        cq.setPageSize(5);
        cq.setLocalListener(events -> {
            for (CacheEntryEvent e : events) {
                Assert.assertNotNull((Object)e);
                cntr.incrementAndGet();
            }
        });
        cache.query((Query)cq);
        for (int i2 = 0; i2 < 25; ++i2) {
            cache.put((Object)i2, (Object)i2);
        }
        boolean res = GridTestUtils.waitForCondition(() -> cntr.get() == 25, (long)10000L);
        Assert.assertTrue((boolean)res);
        List<List<?>> cqQries = KillCommandsSQLTest.execute((Ignite)cli, "SELECT NODE_ID, ROUTINE_ID FROM SYS.CONTINUOUS_QUERIES", new Object[0]);
        Assert.assertEquals((long)1L, (long)cqQries.size());
        UUID nodeId = (UUID)cqQries.get(0).get(0);
        UUID routineId = (UUID)cqQries.get(0).get(1);
        qryCanceler.accept(nodeId, routineId);
        long cnt = cntr.get();
        for (i = 0; i < 25; ++i) {
            cache.put((Object)i, (Object)i);
        }
        res = GridTestUtils.waitForCondition(() -> (long)cntr.get() > cnt, (long)10000L);
        Assert.assertFalse((boolean)res);
        for (i = 0; i < srvs.size(); ++i) {
            IgniteEx srv = srvs.get(i);
            res = GridTestUtils.waitForCondition(() -> KillCommandsSQLTest.execute((Ignite)srv, "SELECT ROUTINE_ID FROM SYS.CONTINUOUS_QUERIES", new Object[0]).isEmpty(), (long)10000L);
            Assert.assertTrue((String)srv.configuration().getIgniteInstanceName(), (boolean)res);
        }
    }
}

