/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.util;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.QueryMXBeanImpl;
import org.apache.ignite.mxbean.QueryMXBean;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.apache.ignite.util.KillCommandsTests;
import org.junit.Test;

public class KillCommandsMXBeanTest
extends GridCommonAbstractTest {
    public static final int NODES_CNT = 3;
    private static List<IgniteEx> srvs;
    private static IgniteEx startCli;
    private static IgniteEx killCli;
    private static QueryMXBean qryMBean;

    protected void beforeTestsStarted() throws Exception {
        this.startGridsMultiThreaded(3);
        srvs = new ArrayList<IgniteEx>();
        for (int i = 0; i < 3; ++i) {
            srvs.add(this.grid(i));
        }
        startCli = this.startClientGrid("startClient");
        killCli = this.startClientGrid("killClient");
        srvs.get(0).cluster().state(ClusterState.ACTIVE);
        IgniteCache cache = startCli.getOrCreateCache(new CacheConfiguration("default").setIndexedTypes(new Class[]{Integer.class, Integer.class}).setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL));
        for (int i = 0; i < 25; ++i) {
            cache.put((Object)i, (Object)i);
        }
        qryMBean = (QueryMXBean)KillCommandsMXBeanTest.getMxBean((String)killCli.name(), (String)"Query", (String)QueryMXBeanImpl.class.getSimpleName(), QueryMXBean.class);
    }

    @Test
    public void testCancelSQLQuery() {
        KillCommandsTests.doTestCancelSQLQuery(startCli, qryId -> qryMBean.cancelSQL(qryId));
    }

    @Test
    public void testCancelContinuousQuery() throws Exception {
        KillCommandsTests.doTestCancelContinuousQuery(startCli, srvs, (nodeId, routineId) -> qryMBean.cancelContinuous(nodeId.toString(), routineId.toString()));
    }

    @Test
    public void testCancelUnknownSQLQuery() {
        qryMBean.cancelSQL(srvs.get(0).localNode().id().toString() + "_42");
    }

    @Test
    public void testCancelUnknownContinuousQuery() {
        qryMBean.cancelContinuous(srvs.get(0).localNode().id().toString(), UUID.randomUUID().toString());
    }
}

