/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.sqllogic;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.Ignition;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.IgnitionEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.sqllogic.ScriptRunnerTestsEnvironment;
import org.apache.ignite.sqllogic.SqlScriptRunner;
import org.apache.ignite.testframework.junits.logger.GridTestLog4jLogger;
import org.apache.ignite.thread.IgniteThread;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;

public class ScriptTestRunner
extends Runner {
    private static final FileSystem FS;
    private static final TcpDiscoveryVmIpFinder sharedFinder;
    private static IgniteLogger log;
    private final Class<?> testCls;
    private final Path scriptsRoot;
    private final Pattern testRegex;
    private final int nodes;
    private final boolean restartCluster;
    private final long timeout;
    private Method afterCls;
    private Method beforeCls;

    public ScriptTestRunner(Class<?> testCls) {
        this.testCls = testCls;
        ScriptRunnerTestsEnvironment env = testCls.getAnnotation(ScriptRunnerTestsEnvironment.class);
        assert (!F.isEmpty((String)env.scriptsRoot()));
        this.nodes = env.nodes();
        this.scriptsRoot = FS.getPath(U.resolveIgnitePath((String)env.scriptsRoot()).getPath(), new String[0]);
        this.testRegex = F.isEmpty((String)env.regex()) ? null : Pattern.compile(env.regex());
        this.restartCluster = env.restart();
        this.timeout = env.timeout();
        this.readJUnitAnnotations(testCls);
    }

    private void readJUnitAnnotations(Class<?> cls) {
        String clsName = cls.getSimpleName();
        for (Method m : cls.getDeclaredMethods()) {
            if (m.isAnnotationPresent(BeforeClass.class)) {
                this.beforeCls = m;
            } else {
                if (!m.isAnnotationPresent(AfterClass.class)) continue;
                this.afterCls = m;
            }
            if (!Modifier.isPublic(m.getModifiers())) {
                throw new IllegalStateException("Method '" + clsName + '#' + m.getName() + "' must be public.");
            }
            if (!Modifier.isStatic(m.getModifiers())) {
                throw new IllegalStateException("Method '" + clsName + '#' + m.getName() + "' must be static.");
            }
            if (m.getParameterCount() == 0) continue;
            throw new IllegalStateException("Method " + clsName + '#' + m.getName() + " must have no arguments.");
        }
    }

    public Description getDescription() {
        return Description.createSuiteDescription((String)this.testCls.getName(), (Serializable)((Object)"scripts"), (Annotation[])new Annotation[0]);
    }

    public void run(RunNotifier notifier) {
        try {
            if (this.beforeCls != null) {
                this.beforeCls.invoke(null, new Object[0]);
            }
            Files.walk(this.scriptsRoot, new FileVisitOption[0]).sorted().forEach(p -> {
                if (p.equals(this.scriptsRoot)) {
                    return;
                }
                if (Files.isDirectory(p, new LinkOption[0])) {
                    if (!F.isEmpty((Collection)Ignition.allGrids()) && this.restartCluster) {
                        log.info(">>> Restart cluster");
                        Ignition.stopAll((boolean)false);
                    }
                    return;
                }
                this.runTest((Path)p, notifier);
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            Ignition.stopAll((boolean)false);
            if (this.afterCls != null) {
                try {
                    this.afterCls.invoke(null, new Object[0]);
                }
                catch (Throwable t) {
                    log.warning("Unable to execute '@afterClass' method " + this.afterCls.getName(), t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTest(Path test, RunNotifier notifier) {
        String dirName = test.getNameCount() - 1 > this.scriptsRoot.getNameCount() ? test.subpath(this.scriptsRoot.getNameCount(), test.getNameCount() - 1).toString() : this.scriptsRoot.subpath(this.scriptsRoot.getNameCount() - 1, this.scriptsRoot.getNameCount()).toString();
        String fileName = test.getFileName().toString();
        Description desc = Description.createTestDescription((String)dirName, (String)fileName, (Annotation[])new Annotation[0]);
        if (this.testRegex != null && !this.testRegex.matcher(test.toString()).find()) {
            return;
        }
        if (this.testRegex == null && !fileName.endsWith(".test") && !fileName.endsWith(".test_slow")) {
            if (fileName.endsWith(".test_ignore")) {
                notifier.fireTestIgnored(desc);
            }
            return;
        }
        this.beforeTest();
        notifier.fireTestStarted(desc);
        try {
            Ignite ign = (Ignite)F.first((List)Ignition.allGrids());
            SqlScriptRunner scriptTestRunner = new SqlScriptRunner(test, ((IgniteEx)ign).context().query(), log);
            log.info(">>> Start: " + dirName + "/" + fileName);
            this.runScript(scriptTestRunner);
        }
        catch (Throwable e) {
            notifier.fireTestFailure(new Failure(desc, e));
        }
        finally {
            log.info(">>> Finish: " + dirName + "/" + fileName);
            notifier.fireTestFinished(desc);
        }
    }

    private void beforeTest() {
        if (F.isEmpty((Collection)Ignition.allGrids())) {
            this.startCluster();
        } else {
            Ignite ign = (Ignite)F.first((List)Ignition.allGrids());
            for (String cacheName : ign.cacheNames()) {
                ign.destroyCache(cacheName);
            }
        }
    }

    private void startCluster() {
        for (int i = 0; i < this.nodes; ++i) {
            Ignition.start((IgniteConfiguration)new IgniteConfiguration().setIgniteInstanceName("srv" + i).setDiscoverySpi((DiscoverySpi)new TcpDiscoverySpi().setIpFinder((TcpDiscoveryIpFinder)sharedFinder)).setGridLogger(log));
        }
    }

    private void runScript(final SqlScriptRunner scriptRunner) throws Throwable {
        final AtomicReference ex = new AtomicReference();
        IgniteThread runner = new IgniteThread("srv0", "test-runner", new Runnable(){

            @Override
            public void run() {
                try {
                    scriptRunner.run();
                }
                catch (Throwable e) {
                    ex.set(e);
                }
            }
        });
        runner.start();
        runner.join(this.timeout);
        if (runner.isAlive()) {
            U.error((IgniteLogger)log, (Object)"Test has been timed out and will be interrupted");
            List nodes = IgnitionEx.allGridsx();
            for (Ignite node : nodes) {
                ((IgniteKernal)node).dumpDebugInfo();
            }
            U.dumpThreads(null);
            U.dumpThreads((IgniteLogger)log);
            for (int i = 0; i < 100 && runner.isAlive(); ++i) {
                U.interrupt((Thread)runner);
                U.sleep((long)10L);
            }
            U.join((Thread)runner, (IgniteLogger)log);
            Ignition.stopAll((boolean)true);
            this.startCluster();
            throw new TimeoutException("Test has been timed out");
        }
        Throwable t = (Throwable)ex.get();
        if (t != null) {
            throw t;
        }
    }

    static {
        block2: {
            FS = FileSystems.getDefault();
            sharedFinder = new TcpDiscoveryVmIpFinder().setShared(true);
            try {
                log = new GridTestLog4jLogger(U.resolveIgnitePath((String)"modules/core/src/test/config/log4j-test.xml"));
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                log = null;
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)"Cannot init logger");
            }
        }
    }
}

