/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.sql;

import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public class IgniteSQLColumnConstraintsTest
extends AbstractIndexingCommonTest {
    protected void beforeTestsStarted() throws Exception {
        this.startGrid(0);
        String mvccQry = this.mvccEnabled() ? " WITH \"atomicity=transactional_snapshot\"" : "";
        this.runSQL("CREATE TABLE varchar_table(id INT PRIMARY KEY, str VARCHAR(5))" + mvccQry, new Object[0]);
        this.execSQL("INSERT INTO varchar_table VALUES(?, ?)", 1, "12345");
        this.checkSQLResults("SELECT * FROM varchar_table WHERE id = 1", 1, "12345");
        this.runSQL("CREATE TABLE decimal_table(id INT PRIMARY KEY, val DECIMAL(4, 2))" + mvccQry, new Object[0]);
        this.execSQL("INSERT INTO decimal_table VALUES(?, ?)", 1, 12.34);
        this.checkSQLResults("SELECT * FROM decimal_table WHERE id = 1", 1, BigDecimal.valueOf(12.34));
        this.runSQL("CREATE TABLE char_table(id INT PRIMARY KEY, str CHAR(5))" + mvccQry, new Object[0]);
        this.execSQL("INSERT INTO char_table VALUES(?, ?)", 1, "12345");
        this.checkSQLResults("SELECT * FROM char_table WHERE id = 1", 1, "12345");
        this.runSQL("CREATE TABLE decimal_table_4(id INT PRIMARY KEY, field DECIMAL(4, 2))" + mvccQry, new Object[0]);
        this.runSQL("CREATE TABLE char_table_2(id INT PRIMARY KEY, field INTEGER)" + mvccQry, new Object[0]);
        this.runSQL("CREATE TABLE decimal_table_2(id INT PRIMARY KEY, field INTEGER)" + mvccQry, new Object[0]);
        this.runSQL("CREATE TABLE char_table_3(id INT PRIMARY KEY, field CHAR(5), field2 INTEGER)" + mvccQry, new Object[0]);
        this.runSQL("CREATE TABLE decimal_table_3(id INT PRIMARY KEY, field DECIMAL(4, 2), field2 INTEGER)" + mvccQry, new Object[0]);
        this.runSQL("CREATE TABLE char_table_4(id INT PRIMARY KEY, field CHAR(5))" + mvccQry, new Object[0]);
    }

    @Test
    public void testCreateTableWithTooLongCharDefault() throws Exception {
        this.checkSQLThrows("CREATE TABLE too_long_default(id INT PRIMARY KEY, str CHAR(5) DEFAULT '123456')", "50000", new Object[0]);
    }

    @Test
    public void testCreateTableWithTooLongScaleDecimalDefault() throws Exception {
        this.checkSQLThrows("CREATE TABLE too_long_decimal_default_scale(id INT PRIMARY KEY, val DECIMAL(4, 2) DEFAULT 1.345)", "50000", new Object[0]);
    }

    @Test
    public void testCreateTableWithTooLongDecimalDefault() throws Exception {
        this.checkSQLThrows("CREATE TABLE too_long_decimal_default(id INT PRIMARY KEY, val DECIMAL(4, 2) DEFAULT 123.45)", "50000", new Object[0]);
    }

    @Test
    public void testInsertTooLongDecimal() throws Exception {
        this.checkSQLThrows("INSERT INTO decimal_table VALUES(?, ?)", "23000", 2, 123.45);
        IgniteSQLColumnConstraintsTest.assertTrue((boolean)this.execSQL("SELECT * FROM  decimal_table WHERE id = ?", 2).isEmpty());
        this.checkSQLThrows("UPDATE decimal_table SET val = ? WHERE id = ?", "23000", 123.45, 1);
        this.checkSQLResults("SELECT * FROM decimal_table WHERE id = 1", 1, BigDecimal.valueOf(12.34));
        this.checkSQLThrows("MERGE INTO decimal_table(id, val) VALUES(?, ?)", "23000", 1, 123.45);
        this.checkSQLResults("SELECT * FROM decimal_table WHERE id = 1", 1, BigDecimal.valueOf(12.34));
    }

    @Test
    public void testInsertTooLongScaleDecimal() throws Exception {
        this.checkSQLThrows("INSERT INTO decimal_table VALUES(?, ?)", "23000", 3, 1.234);
        IgniteSQLColumnConstraintsTest.assertTrue((boolean)this.execSQL("SELECT * FROM  decimal_table WHERE id = ?", 3).isEmpty());
        this.checkSQLThrows("UPDATE decimal_table SET val = ? WHERE id = ?", "23000", 1.234, 1);
        this.checkSQLResults("SELECT * FROM decimal_table WHERE id = 1", 1, BigDecimal.valueOf(12.34));
        this.checkSQLThrows("MERGE INTO decimal_table(id, val) VALUES(?, ?)", "23000", 1, 1.234);
        this.checkSQLResults("SELECT * FROM decimal_table WHERE id = 1", 1, BigDecimal.valueOf(12.34));
    }

    @Test
    public void testInsertTooLongVarchar() throws Exception {
        this.checkSQLThrows("INSERT INTO varchar_table VALUES(?, ?)", "23000", 2, "123456");
        IgniteSQLColumnConstraintsTest.assertTrue((boolean)this.execSQL("SELECT * FROM  varchar_table WHERE id = ?", 2).isEmpty());
        this.checkSQLThrows("UPDATE varchar_table SET str = ? WHERE id = ?", "23000", "123456", 1);
        this.checkSQLResults("SELECT * FROM varchar_table WHERE id = 1", 1, "12345");
        this.checkSQLThrows("MERGE INTO varchar_table(id, str) VALUES(?, ?)", "23000", 1, "123456");
        this.checkSQLResults("SELECT * FROM varchar_table WHERE id = 1", 1, "12345");
    }

    @Test
    public void testInsertTooLongChar() throws Exception {
        this.checkSQLThrows("INSERT INTO char_table VALUES(?, ?)", "23000", 2, "123456");
        IgniteSQLColumnConstraintsTest.assertTrue((boolean)this.execSQL("SELECT * FROM  char_table WHERE id = ?", 2).isEmpty());
        this.checkSQLThrows("UPDATE char_table SET str = ? WHERE id = ?", "23000", "123456", 1);
        this.checkSQLResults("SELECT * FROM char_table WHERE id = 1", 1, "12345");
        this.checkSQLThrows("MERGE INTO char_table(id, str) VALUES(?, ?)", "23000", 1, "123456");
        this.checkSQLResults("SELECT * FROM char_table WHERE id = 1", 1, "12345");
    }

    @Test
    public void testCharConstraintsAfterAlterTable() throws Exception {
        this.execSQL("ALTER TABLE char_table_2 ADD COLUMN str CHAR(5) NOT NULL", new Object[0]);
        this.execSQL("INSERT INTO char_table_2(id, str) VALUES(?, ?)", 1, "1");
        this.checkSQLResults("SELECT * FROM char_table_2 WHERE id = 1", 1, null, "1");
        this.checkSQLThrows("INSERT INTO char_table_2(id, str) VALUES(?, ?)", "23000", 2, "123456");
        IgniteSQLColumnConstraintsTest.assertTrue((boolean)this.execSQL("SELECT * FROM decimal_table_2 WHERE id = ?", 2).isEmpty());
        this.checkSQLThrows("UPDATE char_table_2 SET str = ? WHERE id = ?", "23000", "123456", 1);
        this.checkSQLResults("SELECT * FROM char_table_2 WHERE id = 1", 1, null, "1");
        this.checkSQLThrows("MERGE INTO char_table_2(id, str) VALUES(?, ?)", "23000", 1, "123456");
        this.checkSQLResults("SELECT * FROM char_table_2 WHERE id = 1", 1, null, "1");
    }

    @Test
    public void testDecimalConstraintsAfterAlterTable() throws Exception {
        this.execSQL("ALTER TABLE decimal_table_2 ADD COLUMN val DECIMAL(4, 2) NOT NULL", new Object[0]);
        this.execSQL("INSERT INTO decimal_table_2(id, val) VALUES(?, ?)", 1, 12.34);
        this.checkSQLResults("SELECT * FROM decimal_table_2 WHERE id = 1", 1, null, BigDecimal.valueOf(12.34));
        this.checkSQLThrows("INSERT INTO decimal_table_2(id, val) VALUES(?, ?)", "23000", 2, 1234.56);
        IgniteSQLColumnConstraintsTest.assertTrue((boolean)this.execSQL("SELECT * FROM decimal_table_2 WHERE id = ?", 2).isEmpty());
        this.checkSQLThrows("UPDATE decimal_table_2 SET val = ? WHERE id = ?", "23000", 1234.56, 1);
        this.checkSQLResults("SELECT * FROM decimal_table_2 WHERE id = 1", 1, null, BigDecimal.valueOf(12.34));
        this.checkSQLThrows("MERGE INTO decimal_table_2(id, val) VALUES(?, ?)", "23000", 1, 12345.6);
        this.checkSQLResults("SELECT * FROM decimal_table_2 WHERE id = 1", 1, null, BigDecimal.valueOf(12.34));
        this.checkSQLThrows("INSERT INTO decimal_table_2(id, val) VALUES(?, ?)", "23000", 3, 1.234);
        this.checkSQLResults("SELECT * FROM decimal_table_2 WHERE id = 1", 1, null, BigDecimal.valueOf(12.34));
        this.checkSQLThrows("UPDATE decimal_table_2 SET val = ? WHERE id = ?", "23000", 1.234, 1);
        this.checkSQLResults("SELECT * FROM decimal_table_2 WHERE id = 1", 1, null, BigDecimal.valueOf(12.34));
        this.checkSQLThrows("MERGE INTO decimal_table_2(id, val) VALUES(?, ?)", "23000", 1, 1.234);
        this.checkSQLResults("SELECT * FROM decimal_table_2 WHERE id = 1", 1, null, BigDecimal.valueOf(12.34));
    }

    @Test
    public void testCharDropColumnWithConstraint() throws Exception {
        this.execSQL("INSERT INTO char_table_3(id, field, field2) VALUES(?, ?, ?)", 1, "12345", 1);
        this.checkSQLResults("SELECT * FROM char_table_3 WHERE id = 1", 1, "12345", 1);
        this.checkSQLThrows("INSERT INTO char_table_3(id, field, field2) VALUES(?, ?, ?)", "23000", 2, "123456", 1);
        IgniteSQLColumnConstraintsTest.assertTrue((boolean)this.execSQL("SELECT * FROM decimal_table_3 WHERE id = ?", 2).isEmpty());
        this.execSQL("ALTER TABLE char_table_3 DROP COLUMN field", new Object[0]);
        this.execSQL("INSERT INTO char_table_3(id, field2) VALUES(?, ?)", 3, 3);
        this.checkSQLResults("SELECT * FROM char_table_3 WHERE id = 3", 3, 3);
    }

    @Test
    public void testDecimalDropColumnWithConstraint() throws Exception {
        this.execSQL("INSERT INTO decimal_table_3(id, field, field2) VALUES(?, ?, ?)", 1, 12.34, 1);
        this.checkSQLResults("SELECT * FROM decimal_table_3 WHERE id = 1", 1, BigDecimal.valueOf(12.34), 1);
        this.checkSQLThrows("INSERT INTO decimal_table_3(id, field, field2) VALUES(?, ?, ?)", "23000", 2, 12.3456, 1);
        IgniteSQLColumnConstraintsTest.assertTrue((boolean)this.execSQL("SELECT * FROM decimal_table_3 WHERE id = ?", 2).isEmpty());
        this.execSQL("ALTER TABLE decimal_table_3 DROP COLUMN field", new Object[0]);
        this.execSQL("INSERT INTO decimal_table_3(id, field2) VALUES(?, ?)", 3, 3);
        this.checkSQLResults("SELECT * FROM decimal_table_3 WHERE id = 3", 3, 3);
    }

    @Test
    public void testCharSqlState() throws Exception {
        this.checkSQLThrows("INSERT INTO char_table_4(id, field) VALUES(?, ?)", "23000", 1, "123456");
        IgniteSQLColumnConstraintsTest.assertTrue((boolean)this.execSQL("SELECT * FROM decimal_table_4 WHERE id = ?", 1).isEmpty());
        this.execSQL("INSERT INTO char_table_4(id, field) VALUES(?, ?)", 2, "12345");
        this.checkSQLResults("SELECT * FROM char_table_4 WHERE id = 2", 2, "12345");
        this.checkSQLThrows("UPDATE char_table_4 SET field = ? WHERE id = ?", "23000", "123456", 2);
        this.checkSQLResults("SELECT * FROM char_table_4 WHERE id = 2", 2, "12345");
        this.checkSQLThrows("MERGE INTO char_table_4(id, field) VALUES(?, ?)", "23000", 2, "123456");
        this.checkSQLResults("SELECT * FROM char_table_4 WHERE id = 2", 2, "12345");
    }

    @Test
    public void testDecimalSqlState() throws Exception {
        this.checkSQLThrows("INSERT INTO decimal_table_4 VALUES(?, ?)", "23000", 1, BigDecimal.valueOf(1234.56));
        IgniteSQLColumnConstraintsTest.assertTrue((boolean)this.execSQL("SELECT * FROM decimal_table_4 WHERE id = ?", 1).isEmpty());
        this.checkSQLThrows("INSERT INTO decimal_table_4 VALUES(?, ?)", "23000", 1, BigDecimal.valueOf(1.345));
        IgniteSQLColumnConstraintsTest.assertTrue((boolean)this.execSQL("SELECT * FROM decimal_table_4 WHERE id = ?", 1).isEmpty());
        this.execSQL("INSERT INTO decimal_table_4 (id, field) VALUES(?, ?)", 2, 12.34);
        this.checkSQLResults("SELECT * FROM decimal_table_4 WHERE id = 2", 2, BigDecimal.valueOf(12.34));
        this.checkSQLThrows("UPDATE decimal_table_4 SET field = ? WHERE id = ?", "23000", BigDecimal.valueOf(1234.56), 2);
        this.checkSQLResults("SELECT * FROM decimal_table_4 WHERE id = 2", 2, BigDecimal.valueOf(12.34));
        this.checkSQLThrows("MERGE INTO decimal_table_4(id, field) VALUES(?, ?)", "23000", 2, BigDecimal.valueOf(1234.56));
        this.checkSQLResults("SELECT * FROM decimal_table_4 WHERE id = 2", 2, BigDecimal.valueOf(12.34));
        this.checkSQLThrows("UPDATE decimal_table_4 SET field = ? WHERE id = ?", "23000", BigDecimal.valueOf(1.345), 2);
        this.checkSQLResults("SELECT * FROM decimal_table_4 WHERE id = 2", 2, BigDecimal.valueOf(12.34));
        this.checkSQLThrows("MERGE INTO decimal_table_4(id, field) VALUES(?, ?)", "23000", 2, BigDecimal.valueOf(1.345));
        this.checkSQLResults("SELECT * FROM decimal_table_4 WHERE id = 2", 2, BigDecimal.valueOf(12.34));
    }

    protected void checkSQLThrows(String sql, String sqlStateCode, Object ... args) {
        IgniteSQLException err = (IgniteSQLException)GridTestUtils.assertThrowsWithCause(() -> {
            this.execSQL(sql, args);
            return 0;
        }, IgniteSQLException.class);
        IgniteSQLColumnConstraintsTest.assertEquals((String)err.sqlState(), (String)sqlStateCode);
    }

    protected List<?> execSQL(String sql, Object ... args) {
        return this.runSQL(sql, args);
    }

    protected List<?> runSQL(String sql, Object ... args) {
        SqlFieldsQuery qry = new SqlFieldsQuery(sql).setArgs(args);
        return this.grid(0).context().query().querySqlFields(qry, true).getAll();
    }

    protected void checkSQLResults(String sql, Object ... args) {
        List<?> rows = this.execSQL(sql, new Object[0]);
        IgniteSQLColumnConstraintsTest.assertNotNull(rows);
        IgniteSQLColumnConstraintsTest.assertTrue((!rows.isEmpty() ? 1 : 0) != 0);
        IgniteSQLColumnConstraintsTest.assertEquals((int)rows.size(), (int)1);
        List row = (List)rows.get(0);
        IgniteSQLColumnConstraintsTest.assertEquals((int)row.size(), (int)args.length);
        for (int i = 0; i < args.length; ++i) {
            IgniteSQLColumnConstraintsTest.assertTrue((String)(args[i] + " != " + row.get(i)), (boolean)Objects.equals(args[i], row.get(i)));
        }
    }

    protected boolean mvccEnabled() {
        return false;
    }
}

