/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat;

import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.stat.ColumnStatistics;
import org.apache.ignite.internal.processors.query.stat.IgniteStatisticsRepository;
import org.apache.ignite.internal.processors.query.stat.IgniteStatisticsStore;
import org.apache.ignite.internal.processors.query.stat.ObjectStatistics;
import org.apache.ignite.internal.processors.query.stat.ObjectStatisticsImpl;
import org.apache.ignite.internal.processors.query.stat.StatisticsKey;
import org.apache.ignite.internal.processors.query.stat.StatisticsStorageAbstractTest;
import org.apache.ignite.internal.processors.query.stat.StatisticsTarget;
import org.apache.ignite.internal.processors.query.stat.StatisticsUsageState;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public abstract class StatisticsStorageTest
extends StatisticsStorageAbstractTest {
    public void beforeTest() throws Exception {
        this.collectStatistics(SMALL_TARGET);
    }

    @Test
    public void clearAllTest() {
        IgniteStatisticsRepository statsRepo = this.statisticsMgr(0).statisticsRepository();
        IgniteStatisticsStore statsStore = statsRepo.statisticsStore();
        statsStore.clearAllStatistics();
        ObjectStatistics locStat = this.statisticsMgr(0).getLocalStatistics(SMALL_KEY);
        StatisticsStorageTest.assertNotNull((Object)locStat);
    }

    @Test
    public void testRecollection() throws Exception {
        this.updateStatistics(SMALL_TARGET);
        ObjectStatisticsImpl locStat = (ObjectStatisticsImpl)this.statisticsMgr(0).getLocalStatistics(SMALL_KEY);
        this.updateStatistics(SMALL_TARGET);
        ObjectStatisticsImpl locStat2 = (ObjectStatisticsImpl)this.statisticsMgr(0).getLocalStatistics(SMALL_KEY);
        for (ColumnStatistics c : locStat2.columnsStatistics().values()) {
            GridTestUtils.setFieldValue((Object)c, (String)"ver", (Object)0);
            GridTestUtils.setFieldValue((Object)c, (String)"createdAt", (Object)0);
        }
        for (ColumnStatistics c : locStat.columnsStatistics().values()) {
            GridTestUtils.setFieldValue((Object)c, (String)"ver", (Object)0);
            GridTestUtils.setFieldValue((Object)c, (String)"createdAt", (Object)0);
        }
        StatisticsStorageTest.assertEquals((Object)locStat, (Object)locStat2);
    }

    @Test
    public void testPartialRecollection() throws Exception {
        this.updateStatistics(new StatisticsTarget("PUBLIC", "SMALL", new String[]{"B"}));
        ObjectStatisticsImpl locStat = (ObjectStatisticsImpl)this.statisticsMgr(0).getLocalStatistics(new StatisticsKey("PUBLIC", "SMALL"));
        this.updateStatistics(new StatisticsTarget("PUBLIC", "SMALL", new String[]{"B"}));
        ObjectStatisticsImpl locStat2 = (ObjectStatisticsImpl)this.statisticsMgr(0).getLocalStatistics(new StatisticsKey("PUBLIC", "SMALL"));
        for (ColumnStatistics c : locStat2.columnsStatistics().values()) {
            GridTestUtils.setFieldValue((Object)c, (String)"ver", (Object)0);
            GridTestUtils.setFieldValue((Object)c, (String)"createdAt", (Object)0);
        }
        for (ColumnStatistics c : locStat.columnsStatistics().values()) {
            GridTestUtils.setFieldValue((Object)c, (String)"ver", (Object)0);
            GridTestUtils.setFieldValue((Object)c, (String)"createdAt", (Object)0);
        }
        StatisticsStorageTest.assertEquals((Object)locStat, (Object)locStat2);
    }

    @Test
    public void testDisableGet() throws Exception {
        StatisticsStorageTest.assertNotNull((Object)this.statisticsMgr(0).getLocalStatistics(SMALL_KEY));
        StatisticsStorageTest.assertNotNull((Object)this.statisticsMgr(1).getLocalStatistics(SMALL_KEY));
        this.statisticsMgr(0).usageState(StatisticsUsageState.NO_UPDATE);
        StatisticsStorageTest.assertNotNull((Object)this.statisticsMgr(0).getLocalStatistics(SMALL_KEY));
        StatisticsStorageTest.assertNotNull((Object)this.statisticsMgr(1).getLocalStatistics(SMALL_KEY));
        this.statisticsMgr(0).usageState(StatisticsUsageState.OFF);
        StatisticsStorageTest.assertNull((Object)this.statisticsMgr(0).getLocalStatistics(SMALL_KEY));
        StatisticsStorageTest.assertNull((Object)this.statisticsMgr(1).getLocalStatistics(SMALL_KEY));
        this.statisticsMgr(0).usageState(StatisticsUsageState.ON);
        StatisticsStorageTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> this.statisticsMgr(0).getLocalStatistics(SMALL_KEY) != null, (long)3000L));
        StatisticsStorageTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> this.statisticsMgr(1).getLocalStatistics(SMALL_KEY) != null, (long)3000L));
    }

    @Test
    public void testDoubleDeletion() throws Exception {
        this.statisticsMgr(0).dropStatistics(new StatisticsTarget[]{SMALL_TARGET});
        StatisticsStorageTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> null == this.statisticsMgr(0).getLocalStatistics(SMALL_KEY), (long)3000L));
        GridTestUtils.assertThrows((IgniteLogger)log, () -> this.statisticsMgr(0).dropStatistics(new StatisticsTarget[]{SMALL_TARGET}), IgniteSQLException.class, (String)"Statistic doesn't exist for [schema=PUBLIC, obj=SMALL]");
        Thread.sleep(3000L);
        ObjectStatisticsImpl locStat2 = (ObjectStatisticsImpl)this.statisticsMgr(0).getLocalStatistics(SMALL_KEY);
        StatisticsStorageTest.assertNull((Object)locStat2);
    }

    @Test
    public void testDoublePartialDeletion() throws Exception {
        this.statisticsMgr(0).dropStatistics(new StatisticsTarget[]{new StatisticsTarget("PUBLIC", "SMALL", new String[]{"B"})});
        StatisticsStorageTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> null == ((ObjectStatisticsImpl)this.statisticsMgr(0).getLocalStatistics(SMALL_KEY)).columnsStatistics().get("B"), (long)3000L));
        ObjectStatisticsImpl locStat = (ObjectStatisticsImpl)this.statisticsMgr(0).getLocalStatistics(SMALL_KEY);
        StatisticsStorageTest.assertNotNull((Object)locStat);
        StatisticsStorageTest.assertNotNull(locStat.columnsStatistics().get("A"));
        GridTestUtils.assertThrows((IgniteLogger)log, () -> this.statisticsMgr(0).dropStatistics(new StatisticsTarget[]{new StatisticsTarget("PUBLIC", "SMALL", new String[]{"B"})}), IgniteSQLException.class, (String)"Statistic doesn't exist for [schema=PUBLIC, obj=SMALL, col=B]");
        Thread.sleep(3000L);
        ObjectStatisticsImpl locStat2 = (ObjectStatisticsImpl)this.statisticsMgr(0).getLocalStatistics(SMALL_KEY);
        StatisticsStorageTest.assertNotNull((Object)locStat2);
        StatisticsStorageTest.assertNotNull(locStat.columnsStatistics().get("A"));
        StatisticsStorageTest.assertNull(locStat.columnsStatistics().get("B"));
    }
}

