/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat;

import java.util.Arrays;
import java.util.Collection;
import org.apache.ignite.Ignite;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.internal.processors.query.stat.StatisticsAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class PSUBasicValueDistributionTableStatisticsUsageTest
extends StatisticsAbstractTest {
    @Parameterized.Parameter(value=0)
    public CacheMode cacheMode;

    @Parameterized.Parameters(name="cacheMode={0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({CacheMode.REPLICATED}, {CacheMode.PARTITIONED});
    }

    @Override
    protected void beforeTestsStarted() throws Exception {
        Ignite node = this.startGridsMultiThreaded(2);
        node.getOrCreateCache("default");
    }

    protected void beforeTest() throws Exception {
        String sql;
        int i;
        this.sql("DROP TABLE IF EXISTS digital_distribution");
        this.sql("CREATE TABLE digital_distribution (ID INT PRIMARY KEY, col_a int, col_b int, col_c int, col_d int) WITH \"TEMPLATE=" + this.cacheMode + "\"");
        this.sql("CREATE INDEX digital_distribution_col_a ON digital_distribution(col_a)");
        this.sql("CREATE INDEX digital_distribution_col_b ON digital_distribution(col_b)");
        this.sql("CREATE INDEX digital_distribution_col_c ON digital_distribution(col_c)");
        this.sql("CREATE INDEX digital_distribution_col_d ON digital_distribution(col_d)");
        for (i = 0; i < 100; ++i) {
            sql = String.format("INSERT INTO digital_distribution(id, col_a, col_b, col_c, col_d) VALUES(%d, %d, %d, 1, null)", i, i, i + 200);
            this.sql(sql);
        }
        for (i = 100; i < 110; ++i) {
            sql = String.format("INSERT INTO digital_distribution(id, col_a, col_b, col_c) VALUES(%d, null, %d, 1)", i, i + 200);
            this.sql(sql);
        }
        this.sql("DROP TABLE IF EXISTS empty_distribution");
        this.sql("CREATE TABLE empty_distribution (ID INT PRIMARY KEY, col_a int) WITH \"TEMPLATE=" + this.cacheMode + "\"");
        this.sql("CREATE INDEX empty_distribution_col_a ON empty_distribution(col_a)");
        this.sql("DROP TABLE IF EXISTS empty_distribution_no_stat");
        this.sql("CREATE TABLE empty_distribution_no_stat (ID INT PRIMARY KEY, col_a int) WITH \"TEMPLATE=" + this.cacheMode + "\"");
        this.sql("CREATE INDEX empty_distribution_no_stat_col_a ON empty_distribution_no_stat(col_a)");
        this.collectStatistics("digital_distribution", "empty_distribution");
    }

    @Test
    public void selectOverhightBorder() {
        String sql = "select count(*) from digital_distribution i1 where col_a > 200 and col_b > 200";
        this.checkOptimalPlanChosenForDifferentIndexes(this.grid(0), new String[]{"DIGITAL_DISTRIBUTION_COL_A"}, sql, new String[1][]);
    }

    @Test
    public void selectOverflowBorder() {
        String sql = "select count(*) from digital_distribution i1 where col_a < 200 and col_b < 200";
        this.checkOptimalPlanChosenForDifferentIndexes(this.grid(0), new String[]{"DIGITAL_DISTRIBUTION_COL_B"}, sql, new String[1][]);
    }

    @Test
    public void selectAroundTwoBorder() {
        String sql = "select count(*) from digital_distribution i1 where col_c > -50 and col_c < 50 and col_a < 90";
        this.checkOptimalPlanChosenForDifferentIndexes(this.grid(0), new String[0], sql, new String[1][]);
    }

    @Test
    public void selectNull() {
        String sql = "select count(*) from digital_distribution i1 where col_a is null and col_b is null";
        this.checkOptimalPlanChosenForDifferentIndexes(this.grid(0), new String[]{"DIGITAL_DISTRIBUTION_COL_B"}, sql, new String[1][]);
    }

    @Test
    public void selectHigherFromSingleValue() {
        String sql = "select count(*) from digital_distribution i1 where col_c > 1";
        this.checkOptimalPlanChosenForDifferentIndexes(this.grid(0), new String[]{"DIGITAL_DISTRIBUTION_COL_C"}, sql, new String[1][]);
    }

    @Test
    public void selectLowerToSingleValue() {
        String sql = "select count(*) from digital_distribution i1 where col_c > 1";
        this.checkOptimalPlanChosenForDifferentIndexes(this.grid(0), new String[]{"DIGITAL_DISTRIBUTION_COL_C"}, sql, new String[1][]);
    }

    @Test
    public void selectNullFromNull() {
        String sql = "select count(*) from digital_distribution i1 where col_d is null";
        this.checkOptimalPlanChosenForDifferentIndexes(this.grid(0), new String[]{"DIGITAL_DISTRIBUTION_COL_D"}, sql, new String[1][]);
    }

    @Test
    public void selectGreaterFromNull() {
        String sql = "select count(*) from digital_distribution i1 where col_d > 0";
        this.checkOptimalPlanChosenForDifferentIndexes(this.grid(0), new String[]{"DIGITAL_DISTRIBUTION_COL_D"}, sql, new String[1][]);
    }

    @Test
    public void selectLessOrEqualFromNull() {
        String sql = "select count(*) from digital_distribution i1 where col_d <= 1000";
        this.checkOptimalPlanChosenForDifferentIndexes(this.grid(0), new String[]{"DIGITAL_DISTRIBUTION_COL_D"}, sql, new String[1][]);
    }

    @Test
    public void selectFromEmptyNoStatTable() {
        String sql = "select count(*) from empty_distribution_no_stat i1 where col_a <= 1000";
        this.checkOptimalPlanChosenForDifferentIndexes(this.grid(0), new String[]{"EMPTY_DISTRIBUTION_NO_STAT_COL_A"}, sql, new String[1][]);
    }

    @Test
    public void selectNullFromEmptyNoStatTable() {
        String sql = "select count(*) from empty_distribution_no_stat i1 where col_a is null";
        this.checkOptimalPlanChosenForDifferentIndexes(this.grid(0), new String[]{"EMPTY_DISTRIBUTION_NO_STAT_COL_A"}, sql, new String[1][]);
    }

    @Test
    public void selectNotNullFromEmptyNoStatTable() {
        String sql = "select count(*) from empty_distribution_no_stat i1 where col_a is not null";
        this.checkOptimalPlanChosenForDifferentIndexes(this.grid(0), new String[0], sql, new String[1][]);
    }

    @Test
    public void selectFromEmptyTable() {
        String sql = "select count(*) from empty_distribution i1 where col_a <= 1000";
        this.checkOptimalPlanChosenForDifferentIndexes(this.grid(0), new String[]{"EMPTY_DISTRIBUTION_COL_A"}, sql, new String[1][]);
    }

    @Test
    public void selectNullFromEmptyTable() {
        String sql = "select count(*) from empty_distribution i1 where col_a is null";
        this.checkOptimalPlanChosenForDifferentIndexes(this.grid(0), new String[]{"EMPTY_DISTRIBUTION_COL_A"}, sql, new String[1][]);
    }

    @Test
    public void selectNotNullFromEmptyTable() {
        String sql = "select count(*) from empty_distribution i1 where col_a is not null";
        this.checkOptimalPlanChosenForDifferentIndexes(this.grid(0), new String[0], sql, new String[1][]);
    }
}

