/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.junit.Test;

public class CreateTableWithDateKeySelfTest
extends AbstractIndexingCommonTest {
    private static final int NODES_COUNT = 1;
    private static Ignite ignite;
    private static IgniteCache<?, ?> initCache;

    protected void beforeTestsStarted() throws Exception {
        ignite = this.startGridsMultiThreaded(1, false);
        initCache = ignite.getOrCreateCache(new CacheConfiguration("default").setSqlSchema("PUBLIC"));
    }

    @Override
    protected void afterTestsStopped() throws Exception {
        ignite = null;
        initCache = null;
    }

    @Test
    public void testPassTableWithDateKeyCreation() {
        String creationQry = "CREATE TABLE %s (id DATE primary key, dateField DATE) WITH \"cache_name=%s, WRAP_VALUE=false\"";
        HashMap<Date, Date> ent = new HashMap<Date, Date>();
        ent.put(Date.valueOf("2018-09-01"), Date.valueOf("2018-09-02"));
        ent.put(Date.valueOf("2018-09-03"), Date.valueOf("2018-09-04"));
        this.checkInsertUpdateDelete("CREATE TABLE %s (id DATE primary key, dateField DATE) WITH \"cache_name=%s, WRAP_VALUE=false\"", "Tab1", ent);
    }

    @Test
    public void testPassTableWithTimeKeyCreation() {
        String creationQry = "CREATE TABLE %s (id TIME primary key, dateField TIME) WITH \"cache_name=%s, WRAP_VALUE=false\"";
        HashMap<Time, Time> ent = new HashMap<Time, Time>();
        ent.put(Time.valueOf(LocalTime.now()), Time.valueOf(LocalTime.now().minusHours(1L)));
        ent.put(Time.valueOf(LocalTime.now().minusHours(2L)), Time.valueOf(LocalTime.now().minusHours(3L)));
        this.checkInsertUpdateDelete("CREATE TABLE %s (id TIME primary key, dateField TIME) WITH \"cache_name=%s, WRAP_VALUE=false\"", "Tab2", ent);
    }

    @Test
    public void testPassTableWithTimeStampKeyCreation() {
        String creationQry = "CREATE TABLE %s (id TIMESTAMP primary key, dateField TIMESTAMP) WITH \"cache_name=%s, WRAP_VALUE=false\"";
        HashMap<Timestamp, Timestamp> ent = new HashMap<Timestamp, Timestamp>();
        ent.put(Timestamp.valueOf(LocalDateTime.now()), Timestamp.valueOf(LocalDateTime.now().minusHours(1L)));
        ent.put(Timestamp.valueOf(LocalDateTime.now().minusHours(2L)), Timestamp.valueOf(LocalDateTime.now().minusHours(3L)));
        this.checkInsertUpdateDelete("CREATE TABLE %s (id TIMESTAMP primary key, dateField TIMESTAMP) WITH \"cache_name=%s, WRAP_VALUE=false\"", "Tab3", ent);
    }

    /*
     * WARNING - void declaration
     */
    private <K, V> void checkInsertUpdateDelete(String creationQry, String tblName, Map<K, V> entries) {
        void var7_14;
        Throwable throwable;
        FieldsQueryCursor cur;
        String cacheName = "TABLE_CACHE_" + tblName;
        FieldsQueryCursor cur2 = initCache.query(new SqlFieldsQuery(String.format(creationQry, tblName, cacheName)));
        Object object = null;
        try {
            CreateTableWithDateKeySelfTest.assertNotNull((Object)cur2);
            List list = cur2.getAll();
            CreateTableWithDateKeySelfTest.assertEquals((int)1, (int)list.size());
            CreateTableWithDateKeySelfTest.assertEquals((Object)0L, ((List)list.get(0)).get(0));
        }
        catch (Throwable throwable2) {
            object = throwable2;
            throw throwable2;
        }
        finally {
            if (cur2 != null) {
                if (object != null) {
                    try {
                        cur2.close();
                    }
                    catch (Throwable throwable3) {
                        ((Throwable)object).addSuppressed(throwable3);
                    }
                } else {
                    cur2.close();
                }
            }
        }
        IgniteCache cache = ignite.getOrCreateCache(cacheName);
        for (Map.Entry entry : entries.entrySet()) {
            cur = cache.query(new SqlFieldsQuery("INSERT INTO " + tblName + " VALUES(?, ?)").setArgs(new Object[]{entry.getKey(), entry.getValue()}));
            throwable = null;
            try {
                CreateTableWithDateKeySelfTest.assertNotNull((Object)cur);
                List rows3 = cur.getAll();
                CreateTableWithDateKeySelfTest.assertEquals((int)1, (int)rows3.size());
                CreateTableWithDateKeySelfTest.assertEquals((Object)1L, ((List)rows3.get(0)).get(0));
            }
            catch (Throwable rows3) {
                throwable = rows3;
                throw rows3;
            }
            finally {
                if (cur == null) continue;
                if (throwable != null) {
                    try {
                        cur.close();
                    }
                    catch (Throwable rows3) {
                        throwable.addSuppressed(rows3);
                    }
                    continue;
                }
                cur.close();
            }
        }
        K key = null;
        Object var7_13 = null;
        for (Map.Entry<K, V> e : entries.entrySet()) {
            this.assertSelection(tblName, cache, e.getKey(), e.getValue());
            CreateTableWithDateKeySelfTest.assertEquals(e.getValue(), (Object)cache.get(e.getKey()));
            key = e.getKey();
            V v = e.getValue();
        }
        cache.remove(key);
        this.assertAbsence(tblName, cache, key);
        CreateTableWithDateKeySelfTest.assertFalse((boolean)cache.containsKey(key));
        cache.put(key, (Object)var7_14);
        CreateTableWithDateKeySelfTest.assertEquals((Object)var7_14, (Object)cache.get(key));
        this.assertSelection(tblName, cache, key, var7_14);
        cur = cache.query(new SqlFieldsQuery("DELETE FROM " + tblName + " WHERE id=?").setArgs(new Object[]{key}));
        throwable = null;
        try {
            CreateTableWithDateKeySelfTest.assertNotNull((Object)cur);
            List rows = cur.getAll();
            CreateTableWithDateKeySelfTest.assertEquals((int)1, (int)rows.size());
            CreateTableWithDateKeySelfTest.assertEquals((Object)1L, ((List)rows.get(0)).get(0));
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            if (cur != null) {
                if (throwable != null) {
                    try {
                        cur.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    cur.close();
                }
            }
        }
        this.assertAbsence(tblName, cache, key);
        CreateTableWithDateKeySelfTest.assertFalse((boolean)cache.containsKey(key));
    }

    private <K, V> void assertAbsence(String tblName, IgniteCache<K, V> cache, K key) {
        try (FieldsQueryCursor cur = cache.query(new SqlFieldsQuery("select * from " + tblName + " where id=?").setArgs(new Object[]{key}));){
            CreateTableWithDateKeySelfTest.assertNotNull((Object)cur);
            List rows = cur.getAll();
            CreateTableWithDateKeySelfTest.assertEquals((int)0, (int)rows.size());
        }
    }

    private <K, V> void assertSelection(String tblName, IgniteCache<K, V> cache, K key, V val) {
        try (FieldsQueryCursor cur = cache.query(new SqlFieldsQuery("select * from " + tblName + " where id=?").setArgs(new Object[]{key}));){
            CreateTableWithDateKeySelfTest.assertNotNull((Object)cur);
            List rows = cur.getAll();
            CreateTableWithDateKeySelfTest.assertEquals((int)1, (int)rows.size());
            CreateTableWithDateKeySelfTest.assertEquals(key, ((List)rows.get(0)).get(0));
            CreateTableWithDateKeySelfTest.assertEquals(val, ((List)rows.get(0)).get(1));
        }
    }
}

