/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.cache.CacheException;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.query.GridQueryMemoryMetricProvider;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.h2.H2MemoryTracker;
import org.apache.ignite.internal.processors.query.h2.QueryMemoryManager;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Before;
import org.junit.Test;

public class SqlQuerySystemViewsSelfTest
extends AbstractIndexingCommonTest {
    private static final String SELECT_RUNNING_QUERIES = "SELECT " + Arrays.stream(RunningQueriesViewField.values()).map(Enum::name).collect(Collectors.joining(", ")) + " FROM " + QueryUtils.sysSchemaName() + ".SQL_QUERIES ORDER BY START_TIME";

    private String systemSchemaName() {
        return QueryUtils.sysSchemaName();
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGrid(0);
    }

    @Before
    public void prepare() {
        this.grid(0).destroyCache("default");
    }

    private List<List<?>> execSql(Ignite ignite, String sql, Object ... args) {
        IgniteCache cache = ignite.cache("default");
        SqlFieldsQuery qry = new SqlFieldsQuery(sql);
        if (args != null && args.length > 0) {
            qry.setArgs(args);
        }
        return cache.query(qry).getAll();
    }

    private List<List<?>> execSql(String sql, Object ... args) {
        return this.execSql((Ignite)this.grid(), sql, args);
    }

    private void assertSqlError(final String sql) {
        Throwable t = GridTestUtils.assertThrowsWithCause((Callable)new Callable<Void>(){

            @Override
            public Void call() {
                SqlQuerySystemViewsSelfTest.this.execSql(sql, new Object[0]);
                return null;
            }
        }, IgniteSQLException.class);
        IgniteSQLException sqlE = (IgniteSQLException)X.cause((Throwable)t, IgniteSQLException.class);
        assert (sqlE != null);
        SqlQuerySystemViewsSelfTest.assertEquals((int)1002, (int)sqlE.statusCode());
    }

    @Test
    public void testQueryHistoryMetricsModes() {
        IgniteEx ignite = this.grid(0);
        String SCHEMA_NAME = "TEST_SCHEMA";
        long MAX_SLEEP = 500L;
        long MIN_SLEEP = 50L;
        long tsBeforeRun = System.currentTimeMillis();
        long base = 30L;
        final AtomicLong mul = new AtomicLong(1L);
        GridTestUtils.setFieldValue((Object)ignite.context().query().getIndexing(), (String)"memoryMgr", (Object)new QueryMemoryManager(ignite.context()){

            public GridQueryMemoryMetricProvider createQueryMemoryTracker(long maxQryMemory) {
                return new TestDummyMemoryMetricProvider(){

                    @Override
                    public long maxReserved() {
                        return 30L * mul.get();
                    }

                    @Override
                    public long maxWrittenOnDisk() {
                        return 30L * mul.get();
                    }

                    @Override
                    public long totalWrittenOnDisk() {
                        return 30L * mul.get();
                    }
                };
            }
        });
        IgniteCache cache = ignite.createCache(new CacheConfiguration("default").setIndexedTypes(new Class[]{Integer.class, String.class}).setSqlSchema("TEST_SCHEMA").setSqlFunctionClasses(new Class[]{GridTestUtils.SqlTestFunctions.class}));
        cache.put((Object)100, (Object)"200");
        String sql = "SELECT \"STRING\"._KEY, \"STRING\"._VAL FROM \"STRING\" WHERE _key=100 AND sleep_and_can_fail()>0";
        GridTestUtils.SqlTestFunctions.sleepMs = 50L;
        GridTestUtils.SqlTestFunctions.fail = false;
        cache.query(new SqlFieldsQuery(sql).setSchema("TEST_SCHEMA")).getAll();
        mul.incrementAndGet();
        GridTestUtils.SqlTestFunctions.sleepMs = 500L;
        GridTestUtils.SqlTestFunctions.fail = false;
        cache.query(new SqlFieldsQuery(sql).setSchema("TEST_SCHEMA")).getAll();
        mul.incrementAndGet();
        GridTestUtils.SqlTestFunctions.sleepMs = 50L;
        GridTestUtils.SqlTestFunctions.fail = true;
        GridTestUtils.assertThrows((IgniteLogger)log, () -> cache.query(new SqlFieldsQuery(sql).setSchema("TEST_SCHEMA")).getAll(), CacheException.class, (String)"Exception calling user-defined function");
        String sqlHist = "SELECT " + Arrays.stream(QueriesHistoryViewField.values()).map(Enum::name).collect(Collectors.joining(", ")) + " FROM " + this.systemSchemaName() + ".SQL_QUERIES_HISTORY ORDER BY LAST_START_TIME";
        cache.query(new SqlFieldsQuery(sqlHist).setLocal(true)).getAll();
        cache.query(new SqlFieldsQuery(sqlHist).setLocal(true)).getAll();
        List res = cache.query(new SqlFieldsQuery(sqlHist).setLocal(true)).getAll();
        SqlQuerySystemViewsSelfTest.assertTrue((res.size() >= 2 ? 1 : 0) != 0);
        long tsAfterRun = System.currentTimeMillis();
        List firstRow = (List)res.get(res.size() - 2);
        List secondRow = (List)res.get(res.size() - 1);
        SqlQuerySystemViewsSelfTest.assertEquals((Object)"TEST_SCHEMA", firstRow.get(QueriesHistoryViewField.SCHEMA_NAME.pos()));
        SqlQuerySystemViewsSelfTest.assertEquals((Object)"TEST_SCHEMA", secondRow.get(QueriesHistoryViewField.SCHEMA_NAME.pos()));
        SqlQuerySystemViewsSelfTest.assertEquals((Object)sql, firstRow.get(QueriesHistoryViewField.SQL.pos()));
        SqlQuerySystemViewsSelfTest.assertEquals((Object)sqlHist, secondRow.get(QueriesHistoryViewField.SQL.pos()));
        SqlQuerySystemViewsSelfTest.assertEquals((Object)false, firstRow.get(QueriesHistoryViewField.LOCAL.pos()));
        SqlQuerySystemViewsSelfTest.assertEquals((Object)true, secondRow.get(QueriesHistoryViewField.LOCAL.pos()));
        SqlQuerySystemViewsSelfTest.assertEquals((Object)3L, firstRow.get(QueriesHistoryViewField.EXECUTIONS.pos()));
        SqlQuerySystemViewsSelfTest.assertEquals((Object)2L, secondRow.get(QueriesHistoryViewField.EXECUTIONS.pos()));
        SqlQuerySystemViewsSelfTest.assertEquals((Object)1L, firstRow.get(QueriesHistoryViewField.FAILURES.pos()));
        SqlQuerySystemViewsSelfTest.assertEquals((Object)0L, secondRow.get(QueriesHistoryViewField.FAILURES.pos()));
        SqlQuerySystemViewsSelfTest.assertTrue(((Long)firstRow.get(QueriesHistoryViewField.DURATION_MIN.pos()) >= 50L ? 1 : 0) != 0);
        SqlQuerySystemViewsSelfTest.assertTrue(((Long)firstRow.get(QueriesHistoryViewField.DURATION_MIN.pos()) < (Long)firstRow.get(6) ? 1 : 0) != 0);
        SqlQuerySystemViewsSelfTest.assertTrue(((Long)firstRow.get(QueriesHistoryViewField.DURATION_MAX.pos()) >= 500L ? 1 : 0) != 0);
        SqlQuerySystemViewsSelfTest.assertFalse((boolean)((Timestamp)firstRow.get(QueriesHistoryViewField.LAST_START_TIME.pos())).before(new Timestamp(tsBeforeRun)));
        SqlQuerySystemViewsSelfTest.assertFalse((boolean)((Timestamp)firstRow.get(QueriesHistoryViewField.LAST_START_TIME.pos())).after(new Timestamp(tsAfterRun)));
        SqlQuerySystemViewsSelfTest.assertEquals((Object)30L, firstRow.get(QueriesHistoryViewField.MEMORY_MIN.pos()));
        SqlQuerySystemViewsSelfTest.assertEquals((Object)90L, secondRow.get(QueriesHistoryViewField.MEMORY_MIN.pos()));
        SqlQuerySystemViewsSelfTest.assertEquals((Object)90L, firstRow.get(QueriesHistoryViewField.MEMORY_MAX.pos()));
        SqlQuerySystemViewsSelfTest.assertEquals((Object)90L, secondRow.get(QueriesHistoryViewField.MEMORY_MAX.pos()));
        SqlQuerySystemViewsSelfTest.assertEquals((Object)30L, firstRow.get(QueriesHistoryViewField.DISK_ALLOCATION_MIN.pos()));
        SqlQuerySystemViewsSelfTest.assertEquals((Object)90L, secondRow.get(QueriesHistoryViewField.DISK_ALLOCATION_MIN.pos()));
        SqlQuerySystemViewsSelfTest.assertEquals((Object)90L, firstRow.get(QueriesHistoryViewField.DISK_ALLOCATION_MAX.pos()));
        SqlQuerySystemViewsSelfTest.assertEquals((Object)90L, secondRow.get(QueriesHistoryViewField.DISK_ALLOCATION_MAX.pos()));
        SqlQuerySystemViewsSelfTest.assertEquals((Object)30L, firstRow.get(QueriesHistoryViewField.DISK_ALLOCATION_TOTAL_MIN.pos()));
        SqlQuerySystemViewsSelfTest.assertEquals((Object)90L, secondRow.get(QueriesHistoryViewField.DISK_ALLOCATION_TOTAL_MIN.pos()));
        SqlQuerySystemViewsSelfTest.assertEquals((Object)90L, firstRow.get(QueriesHistoryViewField.DISK_ALLOCATION_TOTAL_MAX.pos()));
        SqlQuerySystemViewsSelfTest.assertEquals((Object)90L, secondRow.get(QueriesHistoryViewField.DISK_ALLOCATION_TOTAL_MAX.pos()));
    }

    @Test
    public void testRunningQueriesViewMemoryFields() {
        IgniteEx ignite = this.grid(0);
        long reserved = 42L;
        GridTestUtils.setFieldValue((Object)ignite.context().query().getIndexing(), (String)"memoryMgr", (Object)new QueryMemoryManager(ignite.context()){

            public GridQueryMemoryMetricProvider createQueryMemoryTracker(long maxQryMemory) {
                return new TestDummyMemoryMetricProvider(){

                    @Override
                    public long reserved() {
                        return 42L;
                    }

                    @Override
                    public long maxReserved() {
                        return 84L;
                    }
                };
            }
        });
        IgniteCache cache = ignite.createCache(new CacheConfiguration("default").setIndexedTypes(new Class[]{Integer.class, String.class}));
        List cur = cache.query(new SqlFieldsQuery(SELECT_RUNNING_QUERIES).setLocal(true)).getAll();
        SqlQuerySystemViewsSelfTest.assertEquals((int)1, (int)cur.size());
        List res0 = (List)cur.get(0);
        SqlQuerySystemViewsSelfTest.assertEquals((Object)42L, res0.get(RunningQueriesViewField.MEMORY_CURRENT.pos()));
        SqlQuerySystemViewsSelfTest.assertEquals((Object)84L, res0.get(RunningQueriesViewField.MEMORY_MAX.pos()));
    }

    @Test
    public void testRunningQueriesViewDiscAllocationFields() {
        IgniteEx ignite = this.grid(0);
        long written = 42L;
        GridTestUtils.setFieldValue((Object)ignite.context().query().getIndexing(), (String)"memoryMgr", (Object)new QueryMemoryManager(ignite.context()){

            public GridQueryMemoryMetricProvider createQueryMemoryTracker(long maxQryMemory) {
                return new TestDummyMemoryMetricProvider(){

                    @Override
                    public long writtenOnDisk() {
                        return 42L;
                    }

                    @Override
                    public long maxWrittenOnDisk() {
                        return 84L;
                    }

                    @Override
                    public long totalWrittenOnDisk() {
                        return 126L;
                    }
                };
            }
        });
        IgniteCache cache = ignite.createCache(new CacheConfiguration("default").setIndexedTypes(new Class[]{Integer.class, String.class}));
        List cur = cache.query(new SqlFieldsQuery(SELECT_RUNNING_QUERIES).setLocal(true)).getAll();
        SqlQuerySystemViewsSelfTest.assertEquals((int)1, (int)cur.size());
        List res0 = (List)cur.get(0);
        SqlQuerySystemViewsSelfTest.assertEquals((Object)42L, res0.get(RunningQueriesViewField.DISK_ALLOCATION_CURRENT.pos()));
        SqlQuerySystemViewsSelfTest.assertEquals((Object)84L, res0.get(RunningQueriesViewField.DISK_ALLOCATION_MAX.pos()));
        SqlQuerySystemViewsSelfTest.assertEquals((Object)126L, res0.get(RunningQueriesViewField.DISK_ALLOCATION_TOTAL.pos()));
    }

    @Test
    public void testRunningQueriesViewStartTimeDuration() {
        IgniteEx ignite = this.grid(0);
        IgniteCache cache = ignite.createCache(new CacheConfiguration("default").setIndexedTypes(new Class[]{Integer.class, String.class}));
        long before = System.currentTimeMillis();
        try (FieldsQueryCursor notClosedFieldQryCursor = cache.query(new SqlFieldsQuery(SELECT_RUNNING_QUERIES).setLocal(true));){
            List cur = cache.query(new SqlFieldsQuery(SELECT_RUNNING_QUERIES).setLocal(true)).getAll();
            long after = System.currentTimeMillis();
            SqlQuerySystemViewsSelfTest.assertEquals((int)2, (int)cur.size());
            long startTime = ((Date)((List)cur.get(0)).get(RunningQueriesViewField.START_TIME.pos())).getTime();
            long prevDuration = (Long)((List)cur.get(0)).get(RunningQueriesViewField.DURATION.pos());
            SqlQuerySystemViewsSelfTest.assertTrue((String)(after + " >= " + startTime), (after >= startTime ? 1 : 0) != 0);
            SqlQuerySystemViewsSelfTest.assertTrue((String)(prevDuration + " >= " + 0), (prevDuration >= 0L ? 1 : 0) != 0);
            for (int i = 0; i < 3; ++i) {
                cur = cache.query(new SqlFieldsQuery(SELECT_RUNNING_QUERIES).setLocal(true)).getAll();
                long actStartTime = ((Date)((List)cur.get(0)).get(RunningQueriesViewField.START_TIME.pos())).getTime();
                long currDuration = (Long)((List)cur.get(0)).get(RunningQueriesViewField.DURATION.pos());
                SqlQuerySystemViewsSelfTest.assertEquals((long)startTime, (long)actStartTime);
                long maxDuration = System.currentTimeMillis() - before;
                SqlQuerySystemViewsSelfTest.assertTrue((String)(maxDuration + " >= " + currDuration), (maxDuration >= currDuration ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testRunningQueriesViewMetaInfo() {
        IgniteEx ignite = this.grid(0);
        IgniteCache cache = ignite.createCache(new CacheConfiguration("default").setIndexedTypes(new Class[]{Integer.class, String.class}));
        try (FieldsQueryCursor notClosedFieldQryCursor = cache.query(new SqlFieldsQuery(SELECT_RUNNING_QUERIES).setLocal(true));){
            List cur = cache.query(new SqlFieldsQuery(SELECT_RUNNING_QUERIES).setLocal(true)).getAll();
            SqlQuerySystemViewsSelfTest.assertEquals((int)2, (int)cur.size());
            SqlQuerySystemViewsSelfTest.assertEquals((Object)SELECT_RUNNING_QUERIES, ((List)cur.get(0)).get(RunningQueriesViewField.SQL.pos()));
            SqlQuerySystemViewsSelfTest.assertEquals((Object)SELECT_RUNNING_QUERIES, ((List)cur.get(1)).get(RunningQueriesViewField.SQL.pos()));
            SqlQuerySystemViewsSelfTest.assertTrue((boolean)((Boolean)((List)cur.get(0)).get(RunningQueriesViewField.LOCAL.pos())));
            SqlQuerySystemViewsSelfTest.assertTrue((boolean)((Boolean)((List)cur.get(1)).get(RunningQueriesViewField.LOCAL.pos())));
            int lastQryNum = Integer.parseInt(((List)cur.get(1)).get(RunningQueriesViewField.QUERY_ID.pos()).toString().split("_")[1]);
            String nodeId = ignite.context().localNodeId().toString();
            for (int i = lastQryNum + 1; i < lastQryNum + 3; ++i) {
                cur = cache.query(new SqlFieldsQuery(SELECT_RUNNING_QUERIES).setLocal(true)).getAll();
                String qryId = ((List)cur.get(1)).get(RunningQueriesViewField.QUERY_ID.pos()).toString();
                SqlQuerySystemViewsSelfTest.assertEquals((String)("Exp: " + nodeId + "_" + i + "; Act: " + qryId), (String)(nodeId + "_" + i), (String)qryId);
            }
            SqlQuerySystemViewsSelfTest.assertEquals((int)2, (int)cache.query(new SqlFieldsQuery(SELECT_RUNNING_QUERIES)).getAll().size());
        }
        SqlQuerySystemViewsSelfTest.assertEquals((int)1, (int)cache.query(new SqlFieldsQuery(SELECT_RUNNING_QUERIES)).getAll().size());
        var4_4 = null;
        try (QueryCursor notClosedQryCursor = cache.query((Query)new SqlQuery(String.class, "_key=100"));){
            String expSqlQry = "SELECT \"default\".\"STRING\"._KEY, \"default\".\"STRING\"._VAL FROM \"default\".\"STRING\" WHERE _key=100";
            List cur = cache.query(new SqlFieldsQuery(SELECT_RUNNING_QUERIES)).getAll();
            SqlQuerySystemViewsSelfTest.assertEquals((int)2, (int)cur.size());
            SqlQuerySystemViewsSelfTest.assertEquals((Object)expSqlQry, ((List)cur.get(0)).get(RunningQueriesViewField.SQL.pos()));
            SqlQuerySystemViewsSelfTest.assertFalse((boolean)((Boolean)((List)cur.get(0)).get(RunningQueriesViewField.LOCAL.pos())));
            SqlQuerySystemViewsSelfTest.assertFalse((boolean)((Boolean)((List)cur.get(1)).get(RunningQueriesViewField.LOCAL.pos())));
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        String sql = "SELECT * FROM " + this.systemSchemaName() + ".SQL_QUERIES WHERE DURATION > 100000";
        SqlQuerySystemViewsSelfTest.assertTrue((boolean)cache.query(new SqlFieldsQuery(sql)).getAll().isEmpty());
        sql = "SELECT * FROM " + this.systemSchemaName() + ".SQL_QUERIES WHERE QUERY_ID='UNKNOWN'";
        SqlQuerySystemViewsSelfTest.assertTrue((boolean)cache.query(new SqlFieldsQuery(sql)).getAll().isEmpty());
    }

    private static class TestDummyMemoryMetricProvider
    implements GridQueryMemoryMetricProvider,
    H2MemoryTracker {
        private TestDummyMemoryMetricProvider() {
        }

        public void close() {
        }

        public boolean reserve(long size) {
            return true;
        }

        public void release(long size) {
        }

        public long reserved() {
            return 0L;
        }

        public long maxReserved() {
            return 0L;
        }

        public long writtenOnDisk() {
            return 0L;
        }

        public long maxWrittenOnDisk() {
            return 0L;
        }

        public long totalWrittenOnDisk() {
            return 0L;
        }

        public void spill(long size) {
        }

        public void unspill(long size) {
        }

        public void incrementFilesCreated() {
        }

        public H2MemoryTracker createChildTracker() {
            return null;
        }

        public void onChildClosed(H2MemoryTracker child) {
        }

        public boolean closed() {
            return false;
        }
    }

    static enum QueriesHistoryViewField {
        SCHEMA_NAME,
        SQL,
        LOCAL,
        EXECUTIONS,
        FAILURES,
        DURATION_MIN,
        DURATION_MAX,
        LAST_START_TIME,
        MEMORY_MIN,
        MEMORY_MAX,
        DISK_ALLOCATION_MIN,
        DISK_ALLOCATION_MAX,
        DISK_ALLOCATION_TOTAL_MIN,
        DISK_ALLOCATION_TOTAL_MAX;


        public int pos() {
            return this.ordinal();
        }
    }

    static enum RunningQueriesViewField {
        SQL,
        QUERY_ID,
        SCHEMA_NAME,
        LOCAL,
        START_TIME,
        DURATION,
        MEMORY_CURRENT,
        MEMORY_MAX,
        DISK_ALLOCATION_CURRENT,
        DISK_ALLOCATION_MAX,
        DISK_ALLOCATION_TOTAL;


        public int pos() {
            return this.ordinal();
        }
    }
}

