/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.Collection;
import java.util.List;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.SqlConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorTaskArgument;
import org.apache.ignite.internal.visor.query.VisorQueryDetailMetrics;
import org.apache.ignite.internal.visor.query.VisorQueryDetailMetricsCollectorTaskArg;
import org.apache.ignite.internal.visor.query.VisorQueryHistoryMetricsCollectorTask;
import org.apache.ignite.internal.visor.query.VisorQueryHistoryMetricsResetTask;
import org.junit.Test;

public class SqlMetricsOnWebConsoleSelfTest
extends AbstractIndexingCommonTest {
    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.cleanPersistenceDir();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    protected String systemSchemaName() {
        return "SYS";
    }

    protected IgniteConfiguration getConfiguration() throws Exception {
        return super.getConfiguration().setSqlConfiguration(new SqlConfiguration().setSqlQueryHistorySize(10));
    }

    @Test
    public void testQueryHistoryMetricsTasks() throws Exception {
        IgniteEx ignite = this.startGrid(0);
        String SCHEMA_NAME = "TEST_SCHEMA";
        IgniteCache cache = ignite.createCache(new CacheConfiguration("default").setIndexedTypes(new Class[]{Integer.class, String.class}).setQueryDetailMetricsSize(10).setSqlSchema("TEST_SCHEMA"));
        cache.put((Object)100, (Object)"200");
        String sqlHist = "SELECT SCHEMA_NAME, SQL, LOCAL, EXECUTIONS, FAILURES, DURATION_MIN, DURATION_MAX, LAST_START_TIME FROM " + this.systemSchemaName() + ".SQL_QUERIES_HISTORY ORDER BY LAST_START_TIME";
        cache.query(new SqlFieldsQuery(sqlHist).setLocal(true)).getAll();
        List cursors = ignite.context().query().querySqlFields(ignite.context().cache().cache("default").context(), new SqlFieldsQuery(sqlHist), null, true, false, null);
        cursors.forEach(IgniteUtils::closeQuiet);
        ScanQuery scanQry = new ScanQuery();
        QueryCursor scanCur = cache.query((Query)scanQry);
        scanCur.getAll();
        U.closeQuiet((AutoCloseable)scanCur);
        Collection res = (Collection)ignite.compute().execute(VisorQueryHistoryMetricsCollectorTask.class, (Object)new VisorTaskArgument(ignite.localNode().id(), (Object)new VisorQueryDetailMetricsCollectorTaskArg(-1L), false));
        SqlMetricsOnWebConsoleSelfTest.assertEquals((int)2, (int)res.size());
        for (VisorQueryDetailMetrics row : res) {
            if ("SQL_FIELDS".equals(row.getQueryType())) {
                SqlMetricsOnWebConsoleSelfTest.assertEquals((int)2, (int)row.getExecutions());
                continue;
            }
            SqlMetricsOnWebConsoleSelfTest.assertEquals((int)1, (int)row.getExecutions());
        }
        ignite.compute().execute(VisorQueryHistoryMetricsResetTask.class, (Object)new VisorTaskArgument(ignite.localNode().id(), null, false));
        res = (Collection)ignite.compute().execute(VisorQueryHistoryMetricsCollectorTask.class, (Object)new VisorTaskArgument(ignite.localNode().id(), (Object)new VisorQueryDetailMetricsCollectorTaskArg(-1L), false));
        SqlMetricsOnWebConsoleSelfTest.assertEquals((int)0, (int)res.size());
    }
}

