/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.List;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.h2.dml.UpdatePlanBuilder;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public class SqlIncompatibleDataTypeExceptionTest
extends AbstractIndexingCommonTest {
    private boolean oldAllowColumnsVal;

    protected void beforeTestsStarted() throws Exception {
        this.startGrid();
        super.beforeTestsStarted();
    }

    @Override
    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
        super.afterTestsStopped();
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.oldAllowColumnsVal = (Boolean)GridTestUtils.getFieldValue(UpdatePlanBuilder.class, UpdatePlanBuilder.class, (String)"ALLOW_KEY_VAL_UPDATES");
    }

    protected void afterTest() throws Exception {
        this.grid().destroyCaches(this.grid().cacheNames());
        GridTestUtils.setFieldValue(UpdatePlanBuilder.class, (String)"ALLOW_KEY_VAL_UPDATES", (Object)this.oldAllowColumnsVal);
        super.afterTest();
    }

    @Test
    public void testUseKeyField() {
        this.execSql("CREATE TABLE test_0 (id integer primary key, val varchar)", new Object[0]);
        this.execSql("INSERT INTO test_0 (_key, val) VALUES (?, ?)", 0, "0");
        this.execSql("MERGE INTO test_0 (_key, val) VALUES (?, ?)", 1, "1");
        this.execSql("CREATE TABLE test (id0 integer, id1 integer, val varchar, primary key (id0, id1))", new Object[0]);
        BinaryObjectBuilder bob = this.grid().binary().builder("key");
        bob.setField("id0", (Object)0);
        bob.setField("id1", (Object)1);
        GridTestUtils.assertThrows((IgniteLogger)log, () -> {
            this.execSql("INSERT INTO test (_key, val) VALUES (?, ?)", bob.build(), "asd");
            return null;
        }, IgniteSQLException.class, (String)"Update of composite key column is not supported");
        GridTestUtils.assertThrows((IgniteLogger)log, () -> {
            this.execSql("MERGE INTO test (_key, val) VALUES (?, ?)", bob.build(), "asd");
            return null;
        }, IgniteSQLException.class, (String)"Update of composite key column is not supported");
    }

    @Test
    public void testUseValField() {
        this.execSql("CREATE TABLE test_0 (id integer primary key, val varchar) WITH \"WRAP_VALUE=0\"", new Object[0]);
        this.execSql("INSERT INTO test_0 (id, _val) VALUES (?, ?)", 0, "0");
        this.execSql("MERGE INTO test_0 (id, _val) VALUES (?, ?)", 1, "1");
        this.execSql("UPDATE test_0 SET _val = ?", "upd");
        this.execSql("CREATE TABLE test (id integer primary key, val varchar)", new Object[0]);
        BinaryObjectBuilder bob = this.grid().binary().builder("val");
        bob.setField("val", (Object)"0");
        GridTestUtils.assertThrows((IgniteLogger)log, () -> {
            this.execSql("INSERT INTO test (id, _val) VALUES (?, ?)", 0, bob.build());
            return null;
        }, IgniteSQLException.class, (String)"Update of composite value column is not supported");
        GridTestUtils.assertThrows((IgniteLogger)log, () -> {
            this.execSql("MERGE INTO test (id, _val) VALUES (?, ?)", 0, bob.build());
            return null;
        }, IgniteSQLException.class, (String)"Update of composite value column is not supported");
        GridTestUtils.assertThrows((IgniteLogger)log, () -> {
            this.execSql("UPDATE test SET _val=?", bob.build());
            return null;
        }, IgniteSQLException.class, (String)"Update of composite value column is not supported");
    }

    @Test
    public void testUseKeyField_Allow() {
        GridTestUtils.setFieldValue(UpdatePlanBuilder.class, (String)"ALLOW_KEY_VAL_UPDATES", (Object)true);
        this.execSql("CREATE TABLE test (id0 integer, id1 integer, val varchar, primary key (id0, id1))", new Object[0]);
        BinaryObjectBuilder bob = this.grid().binary().builder("val");
        bob.setField("id0", (Object)0);
        bob.setField("id1", (Object)0);
        this.execSql("INSERT INTO test (_key, val) VALUES (?, ?)", bob.build(), 0);
        bob.setField("id0", (Object)1);
        bob.setField("id1", (Object)1);
        this.execSql("MERGE INTO test (_key, val) VALUES (?, ?)", bob.build(), 1);
    }

    @Test
    public void testUseValField_Allow() {
        GridTestUtils.setFieldValue(UpdatePlanBuilder.class, (String)"ALLOW_KEY_VAL_UPDATES", (Object)true);
        this.execSql("CREATE TABLE test (id integer primary key, val varchar)", new Object[0]);
        BinaryObjectBuilder bob = this.grid().binary().builder("val");
        bob.setField("val", (Object)"0");
        this.execSql("INSERT INTO test (id, _val) VALUES (?, ?)", 0, bob.build());
        this.execSql("MERGE INTO test (id, _val) VALUES (?, ?)", 0, bob.build());
        this.execSql("UPDATE test SET _val=?", bob.build());
    }

    private List<List<?>> execSql(Ignite ignite, String sql, Object ... args) {
        SqlFieldsQuery qry = new SqlFieldsQuery(sql);
        if (args != null && args.length > 0) {
            qry.setArgs(args);
        }
        return ((IgniteEx)ignite).context().query().querySqlFields(qry, false).getAll();
    }

    private List<List<?>> execSql(String sql, Object ... args) {
        return this.execSql((Ignite)this.grid(), sql, args);
    }
}

